// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: defstyle.h,v 3.3 2000/05/04 13:44:03 kudou Exp $
// definitions for class DefineStyleDialog

#ifndef DEFSTYLE_H
#define DEFSTYLE_H

#include "dlg.h"
#include "styles.h"

#define STYLENAMELEN StyleEntry::NAMELEN

class DefStyleDialog
  : public PModalDialog
{
private:
  char* caption;
  int style_type;
  int existing_style;
  char StyleName[STYLENAMELEN + 1];
  
protected:
  DefStyleDialog(char* suggestion, char* caption, int style_type);
  
  // virtual method
private:
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
  
public:
  char* GetStyleName();
  int GetExistingStyle();
};

inline int
DefStyleDialog::GetExistingStyle()
{
  return(this->existing_style);
}

inline char* 
DefStyleDialog::GetStyleName()
{
  return(this->StyleName);
}

class DefParaStyleDialog
  : public DefStyleDialog
{
public:
  DefParaStyleDialog(char* suggestion);
};

class DefTextStyleDialog
  : public DefStyleDialog
{
public:
  DefTextStyleDialog(char* suggestion);
};

#endif /* DEFSTYLE_H */
