// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: derivs.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// manage attribute derivation table

#include "pword.h"
#include "attribut.h"
#include "styles.h"
#include "atts.h"
#include "fonts.h"
#include "pstreams.h"
#include "derivs.h"

// private method
inline unsigned char NEAR
DerivEntry::GetHash()
{
  return((unsigned char) (this->at_index >> 8)
	  ^ (unsigned char) (this->at_index)
	  ^ (unsigned char) (this->base >> 8)
	  ^ (unsigned char) (this->base));
}

#define T DerivEntry
#define TABLE BaseDerivTable
#define SEG BaseDerivTableSeg
#define DO_READ_WRITE
#define NO_ENTRY_ADD_TO_INTERFACE
#include "tabletem.cpp"

DerivTable STATIC_NEAR GlobalDerivTable;

// When a style changes, we need to reresolve all the
// entries affected by it.  As a preparatory step for doing this, this routine
// marks all affected entries(using the "work" field).

void DerivTable::ResolveEntriesInheritingStyle(int base_style)
{
  Apply(&DerivEntry::ResolveInheritingStyle, (void*) base_style);
}

DerivEntry::DerivEntry()
{
  Init();
}

DerivEntry::DerivEntry(DerivEntry& entry)
{
  Init();
  
  at_index = entry.at_index;
  base =     entry.base;
}

DerivEntry::DerivEntry(int at_index, int base)
{
  Init();
  this->at_index = at_index;
  this->base     = base;
}

void DerivEntry::Init()
{
  at_index = 0;
  base = 0;
  result = 0;
};

void
DerivEntry::Mark()
{
  if (!this->GetMark())
  {
    this->SetMark();
    int a;
    if (VALID_ATTR_INDEX_P(a = this->at_index))
    {
      ::get_atts_entry(a) .Mark();
    }
    if (VALID_ATTR_INDEX_P(a = this->base))
    {
      ::get_style_entry(a) .Mark();
    }
  }
}

AttsEntry&
DerivEntry::GetAttsEntry()
{
  return(::get_atts_entry(this->at_index));
}

StyleEntry&
DerivEntry::GetStyleEntry()
{
  return(::get_style_entry(base));
}

AttsEntry&
DerivEntry::GetResultEntry()
{
  return(::get_atts_entry(this->result));
}

unsigned int
DerivEntry::Enter()
{
  Resolve();
  return GlobalDerivTable.MakeEntry(*this);
}

// mark entries in the derivation table affected by a style change.
// Later, such entries will be recalculated.

void
DerivEntry::ResolveInheritingStyle(unsigned int, void* base)
{
  unsigned int base_style = (unsigned int) Ptr2Long(base);
  
  // are we using the style in question?
  if (GetBase() == base_style) 
  {
    // mark this entry
    Resolve();
  }
}

// the new, slim Resolve

void
DerivEntry::xResolve(unsigned int, void*)
{
  this->Resolve();
}

void
DerivEntry::Resolve()
{
  AttsEntry& org = GetAttsEntry();
  AttsEntry nw(org);
  if (base)
  {
    nw.FillIn(this->GetStyleEntry() .GetAttsEntry());
  }
  nw.FillIn(::get_atts_entry(nw.type == AttsEntry::PARSTYLE
			       ? DefaultParAtts : DefaultCharAtts));
  result = nw.Enter();
}

// ApplyAttList is the most general routine here -- it takes
// a list of attribute specifications and applies them to an
// existing attribute, returning the result
// It handles both character attributes and paragraph attributes

uword
DerivEntry::ApplyAttList(AttSpecList* speclist)
{
  // you know, attribute sets really have both romaji and SHIFTJIS
  // fonts in them.  Even though the user from outside says
  // CA_facename, maybe he really means CA_facename2 if the
  // font he is asking for is a SHIFTJIS one
  
  AttsEntry& ae = GetAttsEntry();
  
  if (ae.type == AttsEntry::CHARSTYLE)
  {
    for (AttSpecList* asl=speclist; asl->attcode; asl++)
    {
      if (asl->attcode == CA_facename)
      {
	if (asl->attvalue && // 0 is "no romaji font"
	    ::get_font_entry(asl->attvalue) .IsShiftJISFont())
	{
	  asl->attcode = CA_facename2;
	}
      }
    }
  }
  
  AttsEntry default_ae(::get_atts_entry(ae.type == AttsEntry::CHARSTYLE
					  ? DefaultCharAtts : DefaultParAtts));
  if (base)
  {
    default_ae.CopyVals(GetStyleEntry() .GetAttsEntry());
  }
  
  AttsEntry new_at_entry(ae);
  
  while (speclist->attcode)
  {
    new_at_entry.vals[speclist->attcode] = speclist->attvalue;
    speclist++;
  }
  
  new_at_entry.Subtract(default_ae);
  
  // get the index of the new(maybe) entry in the attribute table
  int new_at_index = new_at_entry.Enter();
  
  // make a trial attribute derivation table entry, and insert it
  DerivEntry new_adt_entry(*this);
  new_adt_entry.SetAttsIndex(new_at_index);
  return new_adt_entry.Enter();
}

void
DerivEntry::WriteToStream(PStream* stream)
{
  stream->StartBlockOut(PStream::HDR_DERIVENTRY);
  CHECK;
  
  GlobalAttsTable.WriteEntry(stream, at_index);
  CHECK;
  
  GlobalStyleTable.WriteEntry(stream, base);
  CHECK;
  
  stream->EndBlockOut();
}

void
DerivEntry::ReadFromStream(PStream* stream)
{
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_DERIVENTRY, vers);
  CHECK;
  
  this->at_index = GlobalAttsTable.ReadEntry(stream);
  CHECK;
  
  this->base = GlobalStyleTable.ReadEntry(stream);
  CHECK;
  
  stream->EndBlockIn();
}


#ifndef NDEBUG

void
DerivEntry::DumpHeader(FILE* f)
{
  fprintf(f, 
	   "\nAttribute Derivation Table\n\n"
	   "NNNN ATTI BASE RSLT\n"
	 );
}

void
DerivEntry::Dump(unsigned int i, void* v)
{
  FILE* f = (FILE*) v;
  fprintf(f, "%4d %4d %4d %4d\n", i, at_index, base, result);
}

#endif /* NDEBUG */
