// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: derivs.h,v 3.3 2000/05/04 13:44:03 kudou Exp $
// define DerivTable class for attribute derivation table

#ifndef DERIVS_H
#define DERIVS_H

#include "generics.h"

class AttsEntry;
class StyleEntry;

class DerivEntry
  : public GenericEntry
{
  friend class BaseDerivTable;
  
private:
  int at_index;		// attribute information
  int base;		// base style, index into style name table
  int result;           // resulting attributes
  
public:
  DerivEntry();
  DerivEntry(DerivEntry&);
  DerivEntry(int at_index, int base);

private:
  unsigned char NEAR GetHash();
public:
  void Init();
  friend int operator == (DerivEntry&, DerivEntry&);
  unsigned int GetAttsIndex() { return at_index; }
  void SetAttsIndex(unsigned int _at_index) { at_index = _at_index; }
  unsigned int GetBase() { return base; }
  void SetBase(unsigned int _base) { base = _base; }
  uword GetResultIndex() { return result; }
  void SetResultIndex(uword result_index) { result = result_index; }
  AttsEntry& GetAttsEntry();
  StyleEntry& GetStyleEntry();
  AttsEntry& GetResultEntry();
  unsigned int Enter();
  void Mark();
  void ResolveInheritingStyle(unsigned int, void*);
  void WriteToStream(PStream*);
  void ReadFromStream(PStream*);
  // figure out what the attribute results in
  void Resolve();
  void xResolve(unsigned int, void*);
  uword ApplyAttList(AttSpecList* speclist);
#ifndef NDEBUG
  void Dump(unsigned int i, void*);
  static void DumpHeader(FILE* f);
#endif
};

inline int
operator == (DerivEntry& e1, DerivEntry& e2)
{
  return(e1.at_index == e2.at_index && e1.base == e2.base);
}

#define T DerivEntry
#define TABLE BaseDerivTable
#define SEG BaseDerivTableSeg
#define DO_READ_WRITE
#include "tabletem.h"

class DerivTable
  : public BaseDerivTable
{
public:
  void ResolveEntriesInheritingStyle(int base_style);
};

extern DerivTable STATIC_NEAR GlobalDerivTable;

#endif /* DERIVS_H */
