// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: dib.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Device independent bitmap Tools

#include "pword.h"
#include "dib.h"

static WORD DibNumColors(LPBITMAPINFOHEADER lpbi);

HANDLE
CopyHandle(HANDLE h)
{
  BYTE* lpCopy;
  BYTE* lp;
  HANDLE hCopy;
  DWORD  dwLen;

  dwLen = GlobalSize(h);
  if ((hCopy = (HANDLE) GlobalAlloc(GHND, dwLen)) != 0)
  {
    lpCopy = (BYTE *)GlobalLock(hCopy);
    lp     = (BYTE *)GlobalLock(h);
    huge_memcpy(lpCopy, 0, lp, 0, dwLen);
    GlobalUnlock(hCopy);
    GlobalUnlock(h);
  }
  return hCopy;
}

void
GetDibInfo(void* cf_dib, LPBITMAPINFOHEADER lpbi)
{
  *lpbi = *((LPBITMAPINFOHEADER)cf_dib);
  if (lpbi->biSize != sizeof(BITMAPCOREHEADER))
  {
    if (lpbi->biSizeImage == 0L)
    {
      lpbi->biSizeImage = WIDTHBYTES(lpbi->biWidth*lpbi->biBitCount) * lpbi->biHeight;
      if (lpbi->biClrUsed == 0L)
      {
	lpbi->biClrUsed = DibNumColors(lpbi);
      }
    }
  }
}

static WORD
DibNumColors(LPBITMAPINFOHEADER lpbi)
{
  int bits;
  if (lpbi->biSize != sizeof(BITMAPCOREHEADER))
  {
    if (lpbi->biClrUsed != 0)
    {
      return(WORD)lpbi->biClrUsed;
    }
    bits = lpbi->biBitCount;
  }
  else
  {
    LPBITMAPCOREHEADER lpbc = ((LPBITMAPCOREHEADER)(void FAR *)lpbi);
    bits = lpbc->bcBitCount;
  }
  switch (bits)
  {
  case 1:
    return 2;
  case 4:
    return 16;
  case 8:
    return 256;
  default:
    // A 24 bitcount DIB has no color table
    return 0;
  }
}

WORD
DibPaletteSize(LPBITMAPINFOHEADER lpbi)
{
  WORD NumColors = DibNumColors(lpbi);
  return ((lpbi->biSize == sizeof(BITMAPCOREHEADER)) ? 
	  NumColors * sizeof(RGBTRIPLE) :
	  NumColors * sizeof(RGBQUAD));
}

BOOL
StretchDibBlt(HDC hdc, int x, int y, int dx, int dy,
	      void* cf_dib, int x0, int y0, int dx0, int dy0, LONG rop)
{
  LPBITMAPINFOHEADER lpbi = (LPBITMAPINFOHEADER) cf_dib;
  LPSTR pBuf = (LPSTR)lpbi + (WORD)lpbi->biSize + DibPaletteSize(lpbi);
  return StretchDIBits(hdc, x, y, dx, dy, x0, y0, dx0, dy0,
		       pBuf, (LPBITMAPINFO)lpbi,
		       DIB_RGB_COLORS, rop);
}

void
DibBlt(HDC hdc, int x0, int y0, int dx, int dy,
       LPBITMAPINFOHEADER lpbi, int x1, int y1)
{
  LPSTR pbuf = (LPSTR)lpbi + (WORD)lpbi->biSize + DibPaletteSize(lpbi);
  SetDIBitsToDevice(hdc, x0, y0, dx, dy, x1, y1, x1, dy,
		    pbuf, (LPBITMAPINFO)lpbi, DIB_RGB_COLORS);
}

