// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: dlg.cpp,v 3.8 2000/05/04 13:44:03 kudou Exp $
// some simple dialogs.

#include "pword.h"
#include <stdarg.h>
#include "dlg.h"
#include "dialogs.h"
#include "mwindow.h"
#include "pime.h"
#include "pwordpre.h"
#include "ptimer.h"
#include "screen.h"
#include "xstr.h"
#include "pmenus.h"


// ------------------------------------------------------------
// class NoKanjiDialog

// public method
void
NoKanjiDialog::MaybeRestoreIME()
{
  if (this->open_status)
  {
    PIME::SetOpen();
  }
}

// public method
void
NoKanjiDialog::MaybeUnrestoreIME()
{
  if (this->open_status)
  {
    PIME::SetClosed();
  }
}

// public destructor
NoKanjiDialog::~NoKanjiDialog()
{
  this->MaybeRestoreIME();
}

// public constructor
NoKanjiDialog::NoKanjiDialog()
{
  this->open_status = PIME::GetOpen();
  this->MaybeUnrestoreIME();
}

// ------------------------------------------------------------
// class PDialog

// public method
void
PDialog::End(BOOL blah)
{
  ::EndDialog(this->GetHandle(), blah);
}

// public method
HWND
PDialog::GetItem(int id)
{
  return(::GetDlgItem(this->GetHandle(), id));
}

// public method
WORD
PDialog::GetItemInt(int id, BOOL* translated)
{
  int value;
  *translated = get_item_int(this->GetHandle(), id, &value) ? 1 : 0;
  return((WORD) value);
}
	
// public method
void
PDialog::SetItemInt(int id, UINT val)
{
  ::SetDlgItemInt(this->GetHandle(), id, val, 1);
}

// public method
int
PDialog::GetItemText(int id, LPSTR text, int blah)
{
  return(::GetDlgItemText(this->GetHandle(), id, text, blah));
}

// public method
void
PDialog::SetItemText(int id, LPSTR text)
{
  ::SetDlgItemText(this->GetHandle(), id, text);
}
	
// public method
LONG
PDialog::SendItemMessage(int id, MSG_T msg, WPARAM_T wParam, LPARAM_T lParam)
{
  return(::SendDlgItemMessage(this->GetHandle(), id, msg, wParam, lParam));
}
	
// public method
LONG
PDialog::SendItemMessage(int id, MSG_T msg, WPARAM_T wParam)
{
  return(this->SendItemMessage(id, msg, wParam, 0));
}
	
// public method
LONG
PDialog::SendItemMessage(int id, MSG_T msg)
{
  return(this->SendItemMessage(id, msg, 0));
}

int
PDialog::get_item_check(int id)
{
  return((int) this->SendItemMessage(id, BM_GETCHECK));
}

void
PDialog::set_item_check(int id)
{
  this->SendItemMessage(id, BM_SETCHECK, 1);
}

static PDialog* pdialog_pending_this = NULL;
static PDialog* pdialog_list = NULL;

LRESULT_T
PDialog::xWndProc_ (HWND hWnd,
		    MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam)
{
  PDialog* dialog = pdialog_list;
  for (;; dialog = dialog->chain)
  {
    if (dialog == NULL)
    {
      dialog = pdialog_pending_this;
      if (dialog == NULL)
      {
	return(0);
      }
      pdialog_pending_this = NULL;
      dialog->SetHandle(hWnd);
      dialog->chain = pdialog_list;
      pdialog_list = dialog;
      dialog->center_window();
      break;
    }
    if (dialog->GetHandle() == hWnd)
    {
      break;
    }
  }
  return(dialog->WndProc(iMessage, wParam, lParam));
}

// protected method
void
PDialog::before_go()
{
  assert(this->class_name != NULL);
  assert(pdialog_pending_this == NULL);
  pdialog_pending_this = this;
}

// protected method
void
PDialog::after_go()
{
  PDialog* *place = &pdialog_list;
  for (;;)
  {
    PDialog* dialog = *place;
    if (dialog == NULL)
    {
      break;
    }
    if (dialog == this)
    {
      *place = dialog->chain;
      break;
    }
    place = &dialog->chain;
  }
  this->chain = NULL;
}

// public constructor
PDialog::PDialog()
{
  this->class_name = NULL;
}

// public destructor
PDialog::~PDialog()
{
  this->after_go();
}

// ------------------------------------------------------------
// class PModelessDialog

int
PModelessDialog::Go()
{
  this->before_go();
  CreateDialog(PWordPresentation::hInstance,
		this->class_name,
		main_window_handle, (DLGPROC)PDialog::xWndProc);
  return(0);
}

// ------------------------------------------------------------
// class PModalDialog

int PModalDialog::depth = 0;

// Default window procedure for modal dialogs.  This method is called from
// window procedure of subclass, formed "SUPER_CLASS::WndProc(...)".
LRESULT_T
PModalDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    return(1);
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam) 
#endif /* _WIN32 */
    {
     case IDOK:
      End(1);
      return(1);
      
     case IDCANCEL:
      goto close;
    }
    break;
    
   case WM_CLOSE:
   close:
    End(0);
    return(1);
  }
  return(0);
}

// Go runs the dialog box.
int
PModalDialog::Go()
{
  if (PModalDialog::depth == 0)
  {
    PWordPresentation::EnableModeless(False);
  }

  static PModalDialog* parent = NULL;
  PModalDialog* old_parent = parent;
  parent = this;

  HWND parent_handle = NULL;
  if (old_parent != NULL)
  {
    parent_handle = old_parent->GetHandle();
  }
  if (parent_handle == 0)
  {
    parent_handle = main_window_handle;
  }
  
  ++PModalDialog::depth;
  this->before_go();
  int ret = ::DialogBox(PWordPresentation::hInstance,
			 this->class_name,
			 parent_handle, (DLGPROC) PDialog::xWndProc);
  this->after_go();
  --PModalDialog::depth;

  parent = old_parent;
  
#ifndef NDEBUG
  if (ret == -1)
  {
    syserr("Could not create dialog box '%s'", this->class_name);
  }
#endif
  
  if (PModalDialog::depth == 0)
  {
    PWordPresentation::EnableModeless(True);
  }
  return(ret);
}

// ------------------------------------------------------------
// class NoKanjiModalDialog

// Class NoKanjiModalDialog has no instance.  This is a nultiple
// inherited class.

// public destructor
NoKanjiModalDialog::~NoKanjiModalDialog()
{
  // call destructors of PModalDialog and NoKanjiDialog implicitly.
}

// public constructor
NoKanjiModalDialog::NoKanjiModalDialog()
{
  // call constructors of PModalDialog and NoKanjiDialog implicitly.
}

// ------------------------------------------------------------
// class AboutDialog

#undef SUPER_CLASS
#define SUPER_CLASS PModalDialog

#define ABOUTBOXTIMER 1
#define DISAPPEAR_SECONDS 5000	// milliseconds

// private method
void NEAR
AboutDialog::StartTimer()
{
  if (this->type == TIMER_ABOUT && 
      this->p_timer == NULL)
  {
    this->p_timer = new PTimer(this, ABOUTBOXTIMER, DISAPPEAR_SECONDS);
  }
}

// private method
void NEAR
AboutDialog::KillTimer()
{
  if (this->p_timer)
  {
    delete this->p_timer;
    this->p_timer = NULL;
  }
}

LRESULT_T
AboutDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
#if 1
   case WM_DRAWITEM:
    if (type == SPECIAL_ABOUT)
    {
      HBITMAP bitmap = ::LoadBitmap(PWordPresentation::hInstance, "cypac");
      if (bitmap != 0)
      {
	BITMAP bmp;
	::GetObject(bitmap, sizeof(BITMAP), (LPSTR) &bmp);
	LPDRAWITEMSTRUCT dis = (LPDRAWITEMSTRUCT) lParam;
	HDC hMem = ::CreateCompatibleDC(dis->hDC);
	HBITMAP old_bitmap = (HBITMAP)::SelectObject(hMem, bitmap);
	::SetBkMode(dis->hDC, TRANSPARENT);
	::BitBlt(dis->hDC,
		  dis->rcItem.left,
		  dis->rcItem.top,
		  bmp.bmWidth, bmp.bmHeight, hMem, 0, 0, SRCCOPY);
	::SelectObject(hMem, old_bitmap);
	::DeleteDC(hMem);
	::DeleteObject(bitmap);
      }
    }
    break;
#endif

   case WM_INITDIALOG:
    SetItemText(IDD_Version, S_app_version);
    this->StartTimer();
    return(1);
    
   case WM_TIMER:
    if (wParam == ABOUTBOXTIMER)
    {
      this->KillTimer();
      End(1);
      return(1);
    }
    break;
    
   case WM_COMMAND:		// OK button
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
     case IDCANCEL:
      this->KillTimer();
//      end_value = 1;
      break;
    case IDD_DevInfo:
      this->KillTimer();
      end_value = 2;
      End(1);
      break;
    case IDD_License:
      this->KillTimer();
      end_value = 3;
      End(1);
      break;
    }
    break;
    
   case WM_DESTROY:
    this->KillTimer();
    break;
  }
  return(SUPER_CLASS::WndProc(Msg, wParam, lParam));
}

// private constructor
NEAR
AboutDialog::AboutDialog(int type)
{
  this->type = type;
  end_value = 0;
  switch (type)
  {
   default:
   case SPECIAL_ABOUT:
    this->class_name = "PacifitechAbout";
    break;
    
   case TIMER_ABOUT:
   case NORMAL_ABOUT:
    this->class_name = "About";
    break;
    
   case CUSTOM_NOTE:
#ifdef BW3_SCEENCUST
    this->class_name = "ScreenCust";
#else /* BW3_SCEENCUST */
    this->class_name = "CustomizeNote";
#endif /* BW3_SCEENCUST */
    break;
  }
  this->p_timer = NULL;
}

// private destructor
NEAR
AboutDialog::~AboutDialog()
{
  this->KillTimer();
}

// static method
void
AboutDialog::About(int type)
{
  AboutDialog dialog(type);
  dialog.Go();
  
  switch (dialog.GetEndValue())
  {
  case 2:
    {
      AboutDialog pdialog(SPECIAL_ABOUT);
      pdialog.Go();
    }
    break;
  case 3:
    // call license help
#ifdef _WIN32
    main_window->SendMessage(WM_COMMAND, MAKELONG(IDM_Help_License, 0), 0);
#else /* _WIN32 */
    main_window->SendMessage(WM_COMMAND, IDM_Help_License, 0);
#endif /* _WIN32 */
    break;
  default:
    break;
  }
}

// ------------------------------------------------------------
// class BeatMsg

class BeatMsg
  : public NoKanjiModalDialog
{
private:
  char* msg;
  int flags;
  
public:
  BeatMsg(char* msg, int flags);

public:
  LRESULT_T WndProc(MSG_T msg, WPARAM_T wParam, LPARAM_T lParam);

private:
  void NEAR InitDialog();
};

// BeatMsg bitmap size
#define ICON_WIDTH 48
#define ICON_HEIGHT 64

static void NEAR
move_window(HWND handle, int x, int y, int width, int height)
{
  ::MoveWindow(handle, x, y, width, height, 0);
}

// private method
void NEAR
BeatMsg::InitDialog()
{
  // disable all buttons
  {
    static int STATIC_NEAR buttons[] = { IDOK, IDCANCEL, IDYES, IDNO, };
    for (int i = 0; i != NUMBER_OF(buttons); ++i)
    {
      ::ShowWindow(this->GetItem(buttons[i]), SW_HIDE);
    }
  }
  
  int nbut = 0;
  int ids [3];
  switch (this->flags & MB_TYPEMASK)
  {
   default:
    ids[nbut++] = IDOK;
    break;

   case MB_OKCANCEL:
    ids[nbut++] = IDOK;
    ids[nbut++] = IDCANCEL;
    break;
   
   case MB_YESNO:
    ids[nbut++] = IDYES;
    ids[nbut++] = IDNO;
    break;
   
   case MB_YESNOCANCEL:
    ids[nbut++] = IDYES;
    ids[nbut++] = IDNO;
    ids[nbut++] = IDCANCEL;
    break;
  }
  
  // get geometry for placing buttons
  RECT whole_r;
  this->GetClientRect(&whole_r);
  
  HWND shading = this->GetItem(IDD_BeatMsg_Shading);
  RECT shading_r;
  ::GetWindowRect(shading, &shading_r);
  ::ScreenToClient(this->GetHandle(), (LPPOINT) &(shading_r.left));
  ::ScreenToClient(this->GetHandle(), (LPPOINT) &(shading_r.right));
  
  HWND vdip = this->GetItem(IDD_BeatMsg_VDip);
  RECT vdip_r;
  ::GetWindowRect(vdip, &vdip_r);
  ::ScreenToClient(this->GetHandle(), (LPPOINT) &(vdip_r.left));
  ::ScreenToClient(this->GetHandle(), (LPPOINT) &(vdip_r.right));

  RECT button_r;
  ::GetWindowRect(this->GetItem(ids[0]), &button_r);
  ::ScreenToClient(this->GetHandle(), (LPPOINT) &(button_r.left));
  ::ScreenToClient(this->GetHandle(), (LPPOINT) &(button_r.right));
  
  int button_width = button_r.right - button_r.left;
  int button_height = button_r.bottom - button_r.top;
  
  int one_button_region = (whole_r.right - whole_r.left) / nbut;
  int start_x = one_button_region / 2 - button_width / 2;
  int button_y = button_r.top;
  
  for (int i=0; i<nbut; i++, start_x += one_button_region)
  {
    HWND button_handle = this->GetItem(ids[i]);
    move_window(button_handle,
		 start_x, button_y, button_width, button_height);
    ::ShowWindow(button_handle, SW_SHOW);
    if (i == 0)
    {
      ::SendMessage(button_handle, BM_SETSTYLE, (WORD)BS_DEFPUSHBUTTON, 0);
    }
  }
  
  // icon
  HWND icon_handle = this->GetItem(IDD_BeatMsg_Icon);
  move_window(icon_handle, 
	       (shading_r.left + vdip_r.left - ICON_WIDTH) / 2,
	       (shading_r.bottom - ICON_HEIGHT) / 2, ICON_WIDTH, ICON_HEIGHT);

  // message
  this->SetItemText(IDD_BeatMsg_Msg, this->msg);
}

LRESULT_T
BeatMsg::WndProc(MSG_T msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (msg)
  {
   case WM_DRAWITEM:
    {
      char* name = "BM_excl";
      switch (this->flags & MB_ICONMASK)
      {
       case MB_ICONHAND:
	name = "BM_stop";
	break;

       case MB_ICONQUESTION:
	name = "BM_ques";
	break;
      }
      HBITMAP bitmap = ::LoadBitmap(PWordPresentation::hInstance, name);
      if (bitmap != 0)
      {
	BITMAP bmp;
	::GetObject(bitmap, sizeof(BITMAP), (LPSTR) &bmp);
	LPDRAWITEMSTRUCT dis = (LPDRAWITEMSTRUCT) lParam;
	HDC hMem = ::CreateCompatibleDC(dis->hDC);
	HBITMAP old_bitmap = (HBITMAP)::SelectObject(hMem, bitmap);
	::SetBkMode(dis->hDC, TRANSPARENT);
	::BitBlt(dis->hDC,
		  dis->rcItem.left,
		  dis->rcItem.top,
		  bmp.bmWidth, bmp.bmHeight, hMem, 0, 0, SRCCOPY);
	::SelectObject(hMem, old_bitmap);
	::DeleteDC(hMem);
	::DeleteObject(bitmap);
      }
    }
    break;

   case WM_INITDIALOG:
    this->InitDialog();
    break;
    
   case WM_COMMAND:
#ifdef _WIN32
    if (LOWORD(wParam) != IDD_BeatMsg_Icon)
#else /* _WIN32 */
    if (wParam != IDD_BeatMsg_Icon)
#endif /* _WIN32 */
    {
#ifdef _WIN32
      End(LOWORD(wParam));
#else /* _WIN32 */
      End(wParam);
#endif /* _WIN32 */
      return(1);
    }
    break;
  }
  return(0);
}

BeatMsg::BeatMsg(char* msg, int flags)
{
  this->class_name = "BeatMsg";
  this->msg = msg;
  this->flags = flags;
}

int
Issue(char* msg, int flags)
{
  BeatMsg box(msg, flags);
  return(box.Go());
}

static int NEAR
VIssue(char* format, int flags, va_list ap)
{
  char buffer[256];
  wvsprintf(buffer, format, (VA_LIST) ap);
  return(Issue(buffer, flags));
}

int CDECL
IssueVA(char* format, int flags, ...)
{
  va_list ap;
  va_start(ap, flags);
  int result = VIssue(format, flags, ap);
  va_end(ap);
  return(result);
}


// ------------------------------------------------------------
// class VTPageNoDialog

#undef SUPER_CLASS
#define SUPER_CLASS NoKanjiModalDialog

// static slots
static int page_number_format = IDD_VTTime_Hankaku;

// virtual method based on class Window
LRESULT_T
VTPageNoDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    // Set format to last selected one.
    this->set_item_check(page_number_format);
    return(1);
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
      End(page_number_format);
      return(1);
      
     case IDD_VTTime_Hankaku:
     case IDD_VTTime_Zenkaku:
     case IDD_VTTime_Kansuu:
#ifdef _WIN32
      page_number_format = LOWORD(wParam);
#else /* _WIN32 */
      page_number_format = wParam;
#endif /* _WIN32 */
      break;
    }
    break;
  }
  return(SUPER_CLASS::WndProc(Msg, wParam, lParam));
}

// public constructor
VTPageNoDialog::VTPageNoDialog()
{
  this->class_name = "VTPageNo";
}

// ------------------------------------------------------------
// class NumberDialog

#undef SUPER_CLASS
#define SUPER_CLASS NoKanjiModalDialog

// private method
void NEAR
NumberDialog::fix_value()
{
  int value = this->value;
  SET_BOUND(value, this->min_value, this->max_value);
}

// private method
void NEAR
NumberDialog::update_value()
{
  this->fix_value();
  set_item_int_or_mm0(this->GetHandle(), IDD_Value, value, this->mm0);
}

// virtual method based on class Window
LRESULT_T
NumberDialog::WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (iMessage)
  {
   case WM_INITDIALOG:
    this->update_value();
    return(1);
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDD_Value:
      {
	int translated = get_item_int_or_mm0(this->GetHandle(),
					      IDD_Value,
					      &this->value, this->mm0);
	// at this point, translated tells us whether or not the thing was
	// a valid integer, so we can use it as the argument to
	// EnableWindow
	EnableWindow(GetItem(IDOK),
		      (translated
		       && this->min_value <= this->value
		       && this->value <= this->max_value));
      }
      return(0);
    }
    break;
  }
  return(SUPER_CLASS::WndProc(iMessage, wParam, lParam));
}

// public constructor
NumberDialog::NumberDialog(char* class_name,
			    int min_value, int max_value, int value)
{
  this->class_name = class_name;
  this->min_value = min_value;
  this->max_value = max_value;
  this->value = value;
  this->mm0 = False;
  this->fix_value();
}

// ------------------------------------------------------------
// class MessageDialog

#undef SUPER_CLASS
#define SUPER_CLASS NoKanjiModalDialog

// public method
void
MessageDialog::get_values(MessageDialogValues* values)
{
  memcpy(values, &this->values, sizeof(*values));
}

// private method
void NEAR
MessageDialog::check_values()
{
  if (!this->initializing_now)
  {
    for (int i = 0; i <= 5; i++)
    {
      if (get_item_check(IDD_Message_BASE + i))
      {
	this->values.where = i;
	break;
      }
    }
    this->values.guidep = get_item_check(IDD_Message_Guide);
  }
}

// private method
void NEAR
MessageDialog::init_values()
{
  this->initializing_now = True;
  this->set_item_check(IDD_Message_BASE + this->values.where);
  this->SendItemMessage(IDD_Message_Guide, BM_SETCHECK, this->values.guidep);
  this->initializing_now = False;
}

LRESULT_T
MessageDialog::WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (iMessage)
  {
   case WM_INITDIALOG:
    this->init_values();
    this->check_values();
    return(1);
    
   case WM_COMMAND:
    this->check_values();
    break;
  }
  return(SUPER_CLASS::WndProc(iMessage, wParam, lParam));
}

// public constructor
MessageDialog::MessageDialog(MessageDialogValues* values)
{
  this->class_name = "MessageDialog";
  this->initializing_now = False;
  memcpy(&this->values, values, sizeof(*values));
}


// ------------------------------------------------------------
// indent dialog

IndentDialog::IndentDialog(Iunit l1, Iunit l2, Iunit r)
{
  this->class_name = "IndentDialog";
  l1_mm0 = iu_to_mm0(l1);
  l2_mm0 = iu_to_mm0(l2);
  r_mm0 = iu_to_mm0(r);
}

LRESULT_T 
IndentDialog::WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (iMessage)
  {
   case WM_INITDIALOG:
    set_item_mm0(GetHandle(), IDD_Value + 0, l1_mm0);
    set_item_mm0(GetHandle(), IDD_Value + 1, l2_mm0);
    set_item_mm0(GetHandle(), IDD_Value + 2, r_mm0);
    break;

   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
      get_item_mm0(GetHandle(), IDD_Value + 0, &l1_mm0);
      get_item_mm0(GetHandle(), IDD_Value + 1, &l2_mm0);
      get_item_mm0(GetHandle(), IDD_Value + 2, &r_mm0);
      End(1);
      break;
      
     case IDCANCEL:
      End(0);
      break;
      
     default:
      return 0;
    }   
    break;
    
   case WM_CLOSE:
    End(0);
    break;
    
   default:
    return 0;
  }
  return 1;
}


// ------------------------------------------------------------
// tategaki dialog

bool HVSetDialog::change_frame_margin = True;

HVSetDialog::HVSetDialog(bool tate_p)
{
  this->class_name = "HVSetDialog";
  HVSetDialog::tate_p = tate_p;
}

LRESULT_T 
HVSetDialog::WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (iMessage)
  {
   case WM_INITDIALOG:
    {
      if (tate_p)
      {
	set_item_check(IDD_Value + 1);
      }
      else
      {
	set_item_check(IDD_Value);
      }
      if (change_frame_margin)
      {
	set_item_check(IDD_Value + 2);
      }
    }
    break;

   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
      tate_p =  (get_item_check(IDD_Value)) ? False : True;
      change_frame_margin = (bool)(get_item_check(IDD_Value + 2) != 0);
      End(1);
      break;
      
     case IDCANCEL:
      End(0);
      break;
      
     default:
      return 0;
    }   
    break;
    
   case WM_CLOSE:
    End(0);
    break;
    
   default:
    return 0;
  }
  return 1;
}
