// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: dli.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// DocLayoutIterator:	all document layout iterator

#include "pword.h"
#include "pmlist.h"
#include "pllist.h"
#include "dli.h"
#include "layoutin.h"
#include "panel.h"
#include "pagesize.h"
#include "docconte.h"

// constructor
DocLayoutIterator::DocLayoutIterator(DocumentContent* doc)
{
  DocLayoutIterator::doc = doc;
  stage = normal_page;
  pmli = new PMListIterator(doc->pm_list);
#if defined(BCC31)
  plli = new PLListIterator((AvlSearch*)* (doc->panels));
#else
  plli = new PLListIterator(* (doc->panels));
#endif
  pm = (*pmli) ();
  li = 0;
  pl = (*plli) ();
}

// desutructor
DocLayoutIterator::~DocLayoutIterator()
{
  delete pmli;
  delete plli;
}

// iterator
LayoutInstance* 
DocLayoutIterator::operator() ()
{
  switch (stage) 
  {
   case normal_page:
    {
      while (pm != 0) 
      {
	if (li != 0) 
	{
	  LayoutInstance* ret = li;
	  li = li->GetNextPageMapLayout();
	  return ret;
	}
	pm = (*pmli) ();
	li = pm->GetFirstLayout();
      }
      stage = table;
      li = 0;
    }
   case table:
    {
      while (pl != 0) 
      {
	LayoutInstance* ret = pl->GetLayout();
	pl = (*plli) ();
	if (ret != 0) 
	{
	  return ret;
	}
      }
      stage = zero_page;
    }
   case zero_page:
    {
      PageSize* ps = doc->GetPageSize();
      stage = end;
      if (ps != 0) 
      {
	LayoutInstance* ret = ps->GetLayout();
	return ret;
      }
    }
   case end:
   default:
    // error
    break;
  }
  return 0;
}

// revert
void 
DocLayoutIterator::Revert()
{
  delete pmli;
  delete plli;
  pmli = new PMListIterator(doc->pm_list);
#if defined(BCC31)
  plli = new PLListIterator((AvlSearch*)* (doc->panels));
#else
  plli = new PLListIterator(* (doc->panels));
#endif
  pm = (*pmli) ();
  li = 0;
  pl = (*plli) ();
}
