// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docconte.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implement DocumentContent class 
// The DocumentContent class defines objects which represent
// the contents of a document in pWord.

#include "pword.h"
#include "pmlist.h"
#include "pllist.h"
#include "tflist.h"
#include "docconte.h"
#include "attribut.h"
#include "marks.h"
#include "dialogs.h"
#include "statdlg.h"
#include "pundo.h"
#include "docprese.h"
#include "docwindo.h"
#include "document.h"
#include "docedit.h"
#include "rect.h"
#include "sjis.h"
#include "mcursor.h"
#include "pmenus.h"
#include "blueprin.h"
#include "frametem.h"
#include "frameins.h"
#include "layoutte.h"
#include "layoutin.h"
#include "pagemap.h"
#include "pagesize.h"
#include "panel.h"
#include "table.h"
#include "tablepnl.h"
#include "vtextpnl.h"
#include "lman.h"
#include "pstreams.h"
#include "bitstrin.h"
#include "mwindow.h"
#include "pwordpre.h"
#include "bufnew.h"
#include "interval.h"
#include "intlist.h"
#include "textflow.h"
#include "xstr.h"

#ifndef NDEBUG
#include "ddisplay.h"
#endif

const uword panel_code_max = 4000;

DocumentContent::DocumentContent(Document* _document)
 : document(_document)
{
  Init();
}

void DocumentContent::Init()
{
  width = 0;
  height = 0;
  textflow = 0;
  last_textflow = 0;
  pm_list = new PMList();
  pm_num = 0;
  undo = new PUndo(this);
  
  memo = 0;
  dirty = False;
#ifdef MSC7_FUNARG_BUG
  panels = new PLList((void*) Panel::Compare, (void*) Panel::KeyCompare);
#else
  panels = new PLList(Panel::Compare, Panel::KeyCompare);
#endif
  pnl_code_used = new BitString(panel_code_max + 1);
  pnl_code_used->Set(0, True);
  
  page_size = 0;
  shutting_down = False;
  format_needed_p = True;
  par_too_big_issued = False;
  no_more_panels_issued = False;
  zero_display_start_page = 1;
}

bool
DocumentContent::FormatOneStep()
{
  if (this->GetFormatNeededP())
  {
    TextFlow* old_last_flow = this->last_textflow;
    TextFlow* flow = this->GetFirstTextFlow();
    for (;;)
    {
      if (flow->GetFormatNeededP())
      {
	flow->FormatOneStep();
#if (0)
	// formatting multi-flow
	if (flow->GetFormatNeededP())
	{
	  return(True);
	}
#else
	return(True);
#endif
      }
      if (flow == old_last_flow)
      {
	break;
      }
      TextFlow* next_flow = flow->GetNext();
      TextFlow* last_flow = this->last_textflow;
      flow->SetPrev(last_flow);
      flow->SetNext(NULL);
      next_flow->SetPrev(NULL);
      last_flow->SetNext(flow);
      this->textflow = next_flow;
      this->last_textflow = flow;
      flow = next_flow;
    }
    this->SetFormatNeededP(False);
  }
  return(False);
}

void
DocumentContent::Format()
{
  if (this->GetFormatNeededP())
  {
    bool message_exists_p = False;
    for (TextFlow* flow = this->GetFirstTextFlow();
	 flow != NULL; flow = flow->GetNext())
    {
      if (flow->GetFormatNeededP())
      {
	if (!message_exists_p)
	{
	  MouseCursor::StartLongActivity();
	  message_exists_p = True;
	  StatusOutPermanent(S_Formatting);
	}
	flow->Format();
      }
    }
    if (message_exists_p)
    {
      StatusOut("");
      MouseCursor::EndLongActivity();
    }
    this->SetFormatNeededP(False);
  }
}

DocumentContent::~DocumentContent()
{
  Term();
}

// SafeDestruct -- remove all parts of the document from the user
// interface, without doing anything that might crash

void 
DocumentContent::SafeDestruct()
{
  ::GlobalMarkTable.RemoveMarksInDocument(GetDocument());
  LayoutManager::DocumentRemoved(this);
}

void 
DocumentContent::Term()
{
  shutting_down = True;
  
  // delete page-map
  PageMap* pm = 0;
  PMListIterator pmli(pm_list);
  while ((pm = pmli()) != 0)
  {
    pm->KillAllFrames();
  }
  while ((pm = GetPageMap(1)) != 0)
  {
    // next order is critical!
    // do not change.
    delete pm;
    RemovePageMap(pm);
  }
  if (page_size != NULL)
  {
    page_size->KillAllFrames();
    delete page_size;
  }
  
  LayoutManager::DocumentRemoved(this);
  
  delete pm_list;
  
  delete memo;
  delete undo;
  delete panels;
  delete pnl_code_used;
  
  assert(GetFirstTextFlow() == 0);
  GlobalMarkTable.RemoveMarksInDocument(GetDocument());
}

// reading and writing document contents to files

void 
DocumentContent::ReadASCIIFromStream(BufStream* stream, int break_type)
{
  TextFlow* tf = GetNonHeaderTextFlow();
  BufferPointer* bpp = tf->GetEndBufferPointer();
  bpp->InsertASCII(stream, break_type, False);  
  delete bpp;
  SetDirty(!GetDocument()->GetTextFormat());
}

void 
DocumentContent::WriteASCIIToStream(BufStream* stream)
{
  bool first = True;
  for (TextFlow* tf = GetFirstTextFlow(); 
       tf; tf = tf->GetNext())
  {
    if (!tf->OnTableP() && !tf->OnZeroPageP())
    {
      tf->WriteASCIIToStream(stream); CHECK;
      if (first)
      {
	first = False;
      }
      else 
      {
	stream->NewLine();
	CHECK;
      }
    }  
  }
  SetDirty(False);
}

void 
DocumentContent::WriteFormattedToStream(PStream* stream)
{
  VariableTextUpdateTime();
  
  stream->StartBlockOut(PStream::HDR_DOCCONT);
  CHECK;
  
  // write out memo
  stream->StartBlockOut(PStream::HDR_MEMO); 
  CHECK;
  stream->OutString(memo);
  stream->EndBlockOut();
  
  WritePageInfo(stream);
  CHECK;
  
  WriteFormattedTextFlowsToStream(stream); CHECK;
  SetDirty(False);
  
  GlobalMarkTable.WriteMarksInDocument(stream, GetDocument());
  CHECK;
  
  stream->EndBlockOut();
}

// WriteFormattedTextFlowsToStream writes out all the textflows

void 
DocumentContent::WriteFormattedTextFlowsToStream(PStream* stream)
{
  TextFlow* t;
  int n = 0;
  udword tfn = 0;
  for (t = GetFirstTextFlow();
       t; t=t->GetNext()) 
  {
    // table text flows are written along with the table itself
    if (!t->OnTableP())
    {
      n++;
    }
    t->SetSerial(++tfn);
  }
  
  stream->StartBlockOut(PStream::HDR_TEXTFLOWS); 
  if (stream->GetError() != SE_NOERROR)
  {
    return;
  }
  stream->OutUWord(n);
  if (stream->GetError() != SE_NOERROR)
  {
    return;
  }
  for (t = GetFirstTextFlow(); 
       t; t=t->GetNext()) 
  {
    // table text flows are written along with the table itself
    if (!t->OnTableP())
    {
      t->WriteFormattedToStream(stream);
      if (stream->GetError() != SE_NOERROR) return;
    }
  }
  stream->EndBlockOut(); 
}

void 
DocumentContent::MarkCookieConnections(PStream* stream)
{
  for (TextFlow* tf=GetFirstTextFlow(); tf; tf=tf->GetNext())
  {
    tf->MarkCookieConnections(stream);
  }
}

// READING DOCUMENT CONTENTS

void 
DocumentContent::ReadMemoFromStream(PStream* stream)
{
  word type;
  word vers;
  stream->StartBlockIn(type, vers);
  {
    if (stream->GetError() != SE_NOERROR) return;
    if (type!=PStream::HDR_MEMO) 
    {
      stream->SetError(SE_BADHEADER);
    }
    memo = stream->InString();
    if (stream->GetError() != SE_NOERROR) return;
  }
  stream->EndBlockIn();
}

void 
DocumentContent::ReadFormattedUntilMemo(PStream* stream)
{
  word type;
  word vers;
  stream->StartBlockIn(type, vers);
  {
    if (stream->GetError() != SE_NOERROR) return;
    if (type != PStream::HDR_DOCCONT)
    {
      stream->SetError(SE_BADHEADER);
    }
    ReadMemoFromStream(stream);
    CHECK;
  }
}

void 
DocumentContent::ReadFormattedFromStream(PStream* stream)
{
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_DOCCONT, vers);
  CHECK;
  
  ReadMemoFromStream(stream);
  CHECK;
  
  ReadPageInfo(stream);
  CHECK;
  
  ReadFormattedTextFlowsFromStream(stream); 
  CHECK;
  
  GeneratePage();
  
  GlobalMarkTable.ReadMarksInDocument(stream, GetDocument());
  if (stream->GetError() == SE_NOMORE)
  {
    stream->SetError(SE_NOERROR);
  }
  CHECK;
  
  stream->EndBlockIn();
  
  this->VariableTextUpdateFileName();
  this->SetDirty(False);
}

// ReadFormattedTextFlowsFromStream creates a whole bunch of
// text flows and then calls them to read themselves in

void 
DocumentContent::ReadFormattedTextFlowsFromStream(PStream* stream)
{
  // read header and check
  int count;
  word vers;
  
  stream->StartTypedBlockIn(PStream::HDR_TEXTFLOWS, vers);
  CHECK;
  
  count = stream->InUWord();
  CHECK;
  
  // read in each text flow
  TextFlow* tf = textflow;
  while (count--) 
  {
    tf->ReadFormattedFromStream(stream);
    CHECK;
    tf = tf->GetNext();
  }
  stream->EndBlockIn();
}

// this version is used for the "all" case
IntervalList* 
DocumentContent::FindText(sjis* what)
{
  IntervalList* result = NULL;
  for (TextFlow* tf = this->textflow; tf; tf = tf->GetNext())
  {
    result = IntervalList::Concat(result, tf->FindText(what));
  }
  return(result);
}

// page map interface

// setup page-map
// lt		: mapping layout-template
// page		: how many page
void 
DocumentContent::SetupPageMap(LayoutTemplate* lt, uword page)
{
  // generate page-map
  PageMap* pm = CreatePageMap(lt);
  
  // create text-flow and map
  uword gate_size = pm->GetGateSize();
  for (uword i = 1; i <= gate_size; i++) 
  {
    TextFlow* tf = new TextFlow(this);
    pm->Replace(i, tf);			// textflow - gate map
  }
  
  // initialize text-flow 
  TFListIterator tfli(pm->GetTFMap());
  TextFlow* tf;
  while ((tf = tfli()) != 0) 
  {
    tf->SeedParagraph();
  }
  
  // create layout instance
  pm->GenerateNPage(page);
}

// default frame setup, generate default page-map.
void 
DocumentContent::DefaultFrameSetup()
{
  bool old_dirty = this->GetDirty();
  page_size = new PageSize(this);
  LayoutTemplate* lt = new LayoutTemplate(this,
					   BluePrint::GetDefLayoutBluePrint(),
					   LayoutTemplate::RegularTemplate,
					   S_Standard);
  SetupPageMap(lt, 1);
  this->SetDirty(old_dirty);
}

// create page map
PageMap* 
DocumentContent::CreatePageMap(LayoutTemplate* lt)
{
  PageMap* pm = new PageMap(this, lt);
  AddPageMap(pm);
  return pm;
}

// add page map
void 
DocumentContent::AddPageMap(PageMap* fm)
{
  pm_list->Inject(fm);
  // update page map number
  pm_num = pm_list->Number();
}

// remove page map
void 
DocumentContent::RemovePageMap(PageMap* fm)
{
  pm_list->Delete(fm);
  // update page map number
  pm_num = pm_list->Number();
}

// get page map
PageMap* 
DocumentContent::GetPageMap(uword n)
{
  return pm_list->Access(n);
}

// insert page map
void 
DocumentContent::InsertPageMap(PageMap* prev, PageMap* pm)
{
  pm_list->Insert(prev, pm);
  // update page map number
  pm_num = pm_list->Number();
}

// get page map number
uword 
DocumentContent::GetPageMapNumber(PageMap* pm)
{
  for (uword i = 1; i <= pm_num; i++) 
  {
    if (pm_list->Access(i) == pm) 
    {
      return i;
    }
  }
  return 0;
}

// get total page
uword 
DocumentContent::GetTotalPage()
{
  uword page_num = 0;
  for (uword n = 1; n <= pm_num; n++) 
  {
    PageMap* pm = pm_list->Access(n);
    page_num += pm->GetPageNum();
  }
  return page_num;
}

// text-flow management

// get non header text-flow
TextFlow* 
DocumentContent::GetNonHeaderTextFlow()
{
  for (TextFlow* tf = GetFirstTextFlow();
       tf != 0;
       tf = tf->GetNext()) 
  {
    if (!tf->OnZeroPageP() && !tf->OnTableP())
    {
      return tf;
    }
  }
  return GetFirstTextFlow();
}

// add text-flow to document
void
DocumentContent::AddTextFlow(TextFlow* flow)
{
  this->SetFormatNeededP(True);
  TextFlow* old_last_flow = this->last_textflow;
  this->last_textflow = flow;
  flow->SetPrev(old_last_flow);
  flow->SetNext(NULL);
  if (old_last_flow == NULL)
  {
    // first text-flow
    this->textflow = flow;
  }
  else
  {
    old_last_flow->SetNext(flow);
  }
}

// remove text-flow from document
void 
DocumentContent::RemoveTextFlow(TextFlow* tf)
{
  TextFlow* prev = tf->GetPrev();
  if (prev != 0) 
  {
    prev->SetNext(tf->GetNext());
  }
  TextFlow* next = tf->GetNext();
  if (next != 0) 
  {
    next->SetPrev(tf->GetPrev());
  }
  if (tf == textflow) 
  {
    textflow = tf->GetNext();
  }
  if (tf == last_textflow) 
  {
    last_textflow = tf->GetPrev();
  }
}

// how meny text-flow in this document
uword 
DocumentContent::GetTextFlowNum()
{
  uword n = 0;
  TextFlow* tf = textflow;
  while (tf != 0) 
  {
    n++;
    tf = tf->GetNext();
  }
  return n;
}

// get next page-map
PageMap* 
DocumentContent::GetNextPageMap(PageMap* pm)
{
  PMListIterator pmli(pm_list);
  PageMap* scan = 0;
  while ((scan = pmli()) != 0) 
  {
    if (scan == pm) 
    {
      return pmli();
    }
  }
  return 0;
}

// get previous page-map
PageMap* 
DocumentContent::GetPrevPageMap(PageMap* pm)
{
  PMListIterator pmli(pm_list);
  PageMap* prev = 0;
  PageMap* scan = 0;
  while ((scan = pmli()) != 0) 
  {
    if (scan == pm) 
    {
      return prev;
    }
    prev = scan;
  }
  return 0;
}

// get text-flow id
uword 
DocumentContent::GetTextFlowID(TextFlow* search_tf)
{
  uword n = 1;
  for (TextFlow* tf = textflow;
       tf != 0;
       tf = tf->GetNext()) 
  {
    if (tf == search_tf) 
    {
      return n;
    }
    n++;
  }
  return 0;	// can not find
}

// get text-flow from id
TextFlow* 
DocumentContent::GetTextFlow(uword text_flow_id)
{
  for (TextFlow* tf = textflow;
       tf != 0;
       tf = tf->GetNext()) 
  {
    if (--text_flow_id == 0) 
    {
      return tf;
    }
  }
  return 0;	// invalid ID
}

// get text-flow from serial number
TextFlow* 
DocumentContent::GetTextFlowBySerial(udword serial)
{
  for (TextFlow* tf = textflow;
       tf != 0;
       tf = tf->GetNext())
  {
    udword tf_serial;
    if (((tf_serial = tf->GetSerial()) == 0) || // old version
	(tf_serial == serial))
    {
      return tf;
    }
  }
  return 0;	// invalid serial
}

long 
DocumentContent::Dispatch(int command, int menu_state_p)
{
  int controlp = PWordPresentation::ControlKey();
  switch (command)
  {
   case IDM_Edit_UndoRun:
    if (!controlp)
    {
      return(undo->undo(menu_state_p, False));
    }
    // fall through
    
   case IDM_Edit_Undo:
    return(undo->undo(menu_state_p, True));
    
   case IDM_Edit_RedoRun:
    if (!controlp)
    {
      return(undo->redo(menu_state_p, False));
    }
    // fall through
    
   case IDM_Edit_Redo:
    return(undo->redo(menu_state_p, True));
  }
  return(0);
}

DocumentWindow* 
DocumentContent::GetFirstDocWindow()
{
  return(this->GetDocument() ->GetFirstDocWindow());
}

void
DocumentContent::RecalcLayouts()
{
  for (DocumentWindow* w = this->GetFirstDocWindow();
       w; w = w->GetNextDocWindow())
  {
    w->RecalcLayouts();
  }
}

#ifndef PAGES_ACROSS
// recalculate all layout logical position
void 
DocumentContent::RecalcAllLayoutLunit()
{
  if (GetFirstLayout() == 0) 
  {
    return;
  }
  Lunit x = 0;		// DocumentWindow::GetLayoutXMargin();
  Lunit y = 0;		// DocumentWindow::GetLayoutYMargin();
  Iunit y_incl = DocumentWindow::GetLayoutYMargin() + 
  page_size->GetHeight();
  
  x += page_size->GetAllLayoutsOffsetX();
  Lunit offset_y = page_size->GetAllLayoutsOffsetY();
  for (LayoutInstance* li = GetFirstLayout();
       li != 0;
       li = li->GetNextLayout()) 
  {
    li->SetLX(x);
    li->SetLY(y + offset_y);
    y += y_incl;
  }
  
  // update document width and height
  width  = page_size->GetWidth();
  height = y;
}
#else
// recalculate all layout logical position
void 
DocumentContent::RecalcAllLayoutLunit()
{
  int pages_across = Preferences::GetVal(Preferences::PV_PAGESACROSS);
  if (pages_across <= 0 || pages_across >=4 /*??*/)
  {
    pages_across = 1;
  }
  int cur_pages_across = pages_across;
  int filled_across = 0;
  
  if (GetFirstLayout() == 0) 
  {
    return;
  }
  Lunit x = 0;
  Lunit y = 0;
  
  Iunit y_incl = DocumentWindow::GetLayoutYMargin() + page_size->GetHeight();
  Iunit x_incl = DocumentWindow::GetLayoutXMargin() + page_size->GetWidth();
  
  Lunit offset_x = page_size->GetAllLayoutsOffsetX();
  Lunit offset_y = page_size->GetAllLayoutsOffsetY();
  
  for (LayoutInstance* li = GetFirstLayout();
       li != 0;
       li = li->GetNextLayout()) 
  {
    li->SetLX(x + offset_x);
    li->SetLY(y + offset_y);
    if (--cur_pages_across>0) // put more to right
    {
      x += x_incl;
    }
    else
    {
      filled_across = 1;
      cur_pages_across = pages_across;
      x = 0;
      y += y_incl;
    }
  }
  
  // update document width and height
  width  = filled_across ? x_incl * pages_across : x;
  height = cur_pages_across > 0 ? y + y_incl : y;
}
#endif

void
DocumentContent::control_scroll_bar()
{
  for (DocumentWindow* w = this->GetFirstDocWindow();
       w != NULL; w = w->GetNextDocWindow())
  {
    w->control_scroll_bar();
  }
}

// layout removed report
void
DocumentContent::LayoutRemoved()
{
  this->RecalcAllLayoutLunit();
  for (DocumentWindow* w = this->GetFirstDocWindow();
       w; w = w->GetNextDocWindow())
  {
    w->BreakBeginningLayout();
    if (w->GetBeginningLayout() == 0)
    {
      w->SetView(w->GetLX(), w->GetLY());
    }
  }
}

// find layout by Lunit
LayoutInstance* 
DocumentContent::FindLayout(Lunit x, Lunit y)
{
  if (x > GetFirstLayout()->GetWidth()) 
  {
    return 0;
  }
  // This implementation is liner way. But I'm going to
  // change it more fast way.
  Lunit l_height = GetFirstLayout()->GetHeight();
  for (LayoutInstance* li = GetFirstLayout();
       li != 0;
       li = li->GetNextLayout()) 
  {
    Lunit ly = li->GetLY();
    if ((y <= ly + l_height) && (y >= ly)) 
    {
      // find
      return li;
    }
  }
  return 0;
}

// find layout by layout-template
LayoutInstance* 
DocumentContent::FindFirstLayout(LayoutTemplate* lt)
{
  switch (lt->GetKind()) 
  {
   case LayoutTemplate::PageSizeTemplate:
    return GetZeroLayout();

   case LayoutTemplate::RegularTemplate:
    {
      PMListIterator pmli(pm_list);
      PageMap* scan = 0;
      while ((scan = pmli()) != 0) 
      {
	if (scan->GetLayoutTemplate() == lt)
	{
	  LayoutInstance* li = scan->GetFirstLayout();
	  if (li != 0) 
	  {
	    return li;
	  }
	}
      }
    }
    break;
    
   case LayoutTemplate::TableTemplate:
    {
      Panel* pnl = GetTablePanel(lt);
      return((TablePanel*)pnl)->GetLayout();
    }
  }
  return 0;
}

// get first layout
LayoutInstance* 
DocumentContent::GetFirstLayout()
{
  PMListIterator pmli(pm_list);
  PageMap* scan = 0;
  while ((scan = pmli()) != 0) 
  {
    LayoutInstance* li = scan->GetFirstLayout();
    if (li != 0) 
    {
      return li;
    }
  }
  return 0;
}

// get last layout
LayoutInstance* 
DocumentContent::GetLastLayout()
{
  PageMap* pm = GetPageMap(pm_num);	// get last page-map
  if (pm == 0) 
  {
    return 0;
  }
  return pm->GetLastLayout();
}

// get first frame
FrameInstance* 
DocumentContent::GetFirstTextFlowFrame(TextFlow* tf)
{
  //
  // regura page
  //
  PMListIterator pmli(pm_list);
  PageMap* pm = 0;
  while ((pm = pmli()) != 0) 
  {
    FrameInstance* fi = pm->GetFirstTextFlowFrame(tf);
    if (fi != 0) 
    {
      return fi;
    }
  }
  
  {
    //
    // zero page
    //
    PageMap* pm = (PageMap*)page_size; 
    FrameInstance* fi = pm->GetFirstTextFlowFrame(tf);
    if (fi != 0) 
    {
      return fi;
    }
  }
  
  {
    //
    // table text flow
    //
#if defined(BCC31)
    PLListIterator pli((AvlSearch*)*panels);
#else
    PLListIterator pli(*panels);
#endif
    for (Panel* pl = pli(); pl != 0; pl = pli()) 
    {
      if (pl->GetPanelID() == Panel::TablePanelID) 
      {
	Table* tbl = ((TablePanel*)pl)->GetTable();
	PageMap* pm = (PageMap*)tbl;
	FrameInstance* fi = pm->GetFirstTextFlowFrame(tf);
	if (fi != 0) 
	{
	  return fi;
	}
      }
    }
  }
  
  return 0;
}

// get layout by page number
LayoutInstance* 
DocumentContent::GetLayoutByLogicalPageNum(word n)
{
  return GetLayoutByPhysicalPageNum(GetPhysicalPageNum(n));
}

// get page number by layout
word 
DocumentContent::GetLogicalPageNum(LayoutInstance* li)
{
  return GetLogicalPageNum(GetPhysicalPageNum(li));
}

// page number convert
word 
DocumentContent::GetLogicalPageNum(uword n)
{
  return n + page_size->GetFirstPageNumber() - 1;
}

uword 
DocumentContent::GetPhysicalPageNum(word n)
{
  return n - page_size->GetFirstPageNumber() + 1;
}

// page number -> layout instance
LayoutInstance* 
DocumentContent::GetLayoutByPhysicalPageNum(uword n)
{
  uword sumup = 0;
  PMListIterator pmli(pm_list);
  PageMap* pm = 0;
  while ((pm = pmli()) != 0) 
  {
    if (sumup + pm->GetPageNum() >= n) 
    {
      // layout is in this page-map
      n -= sumup;
      for (LayoutInstance* li = pm->GetFirstLayout();
	   li != 0;
	   li = li->GetNextPageMapLayout()) 
      {
	if (--n == 0) 
	{
	  return li;
	}
      }
      return 0;	// may be error
    }
    sumup += pm->GetPageNum();
  }
  return 0;
}

// layout instance -> page number
uword 
DocumentContent::GetPhysicalPageNum(LayoutInstance* li)
{
  uword page_num = li->GetPageMapPageNumber();
  if (pm_num > 1) 
  {
    // add previous page-map page number
    PMListIterator pmli(pm_list);
    PageMap* pm = li->GetPageMap();
    PageMap* ppm = 0;
    while ((ppm = pmli()) != 0) 
    {
      if (ppm == pm) 
      {
	break;
      }
      page_num += ppm->GetPageNum();
    }
  }
  return page_num;
}

// ------------------------------------------------------------
// panel interface

// get uniq panel code
uword 
DocumentContent::GetUniqPanelCode()
{
  uword code = (uword)pnl_code_used->GetLeastClearBit();
  if (code <= panel_code_max) 
  {
    return code;
  }
  return 0;
}

// check panel num max
bool 
DocumentContent::CheckPanelNumMax()
{
  bool ret = (GetUniqPanelCode() == 0) ? False : True;
  if (!ret)
  {
    NoMorePanels();
  }
  return ret;
}

#if (!defined(NDEBUG) && defined(DEBUG_PANEL))
#define PANEL_LOG_FILE "panel.log"
#define LOG_PANEL(op, code) log_panel(op, code)
static void NEAR
log_panel(char* op, uword code)
{
  static int initializedp = False;
  
  FILE* stream = fopen(PANEL_LOG_FILE, "a");
  if (stream)
  {
    if (!initializedp)
    {
      initializedp = True;
      fprintf(stream, "**** panel log start\n");
    }
    fprintf(stream, "%10s: %u\n", op, code);
    fclose(stream);
  }
}
#else
#define LOG_PANEL(op, code)
#endif

// add panel
void 
DocumentContent::AddPanel(Panel* panel)
{
  uword code = panel->GetPanelCode();
  panels->Add(panel);
  pnl_code_used->Set(code, True);
  LOG_PANEL("add", code);
}

// remove panel
void 
DocumentContent::RemovePanel(Panel* panel)
{
  uword code = panel->GetPanelCode();
  panels->KeyRemove(&code);
  pnl_code_used->Set(code, False);
  LOG_PANEL("remove", code);
}

// get panel by index(1~)
Panel* 
DocumentContent::GetPanel(uword index)
{
  LOG_PANEL("get", index);
#if (!defined(NDEBUG))
  Panel* panel = this->panels->Search(&index);
  if (panel == NULL)
  {
    syserr("DocumentContent::GetPanel : NULL panel");
  }
  return(panel);
#else
  return panels->Search(&index);
#endif
}

// get table panel by layout-template
Panel* 
DocumentContent::GetTablePanel(LayoutTemplate* lt)
{
  PLListIterator pli(*panels);
  Panel* pl;
  while ((pl = pli()) != 0)
  {
    if (pl->GetPanelID() == Panel::TablePanelID)
    {
      Table* tpnl = ((TablePanel*)pl)->GetTable();
      if (tpnl->GetLayoutTemplate() == lt)
      {
	return pl;
      }
    }
  }
  return 0;
}

// get panel index(1~)
uword 
DocumentContent::GetPanelIndex(Panel* panel)
{
  return panel->GetPanelCode();
}

// get panel total number
uword 
DocumentContent::GetTotalPanelNumber()
{
  return panels->Number();
}

// get panel index
uword 
DocumentContent::GetPanelIndex(sjis code)
{
  return GetSpecialCode(code);
}

// get panel code from panel
sjis 
DocumentContent::GetPanelCode(Panel* pl)
{
  return MakePanelChar(GetPanelIndex(pl));
}

// get panel code from index
sjis 
DocumentContent::GetPanelCode(uword index)
{
  return MakePanelChar(index);
}

// get panel textflow number
uword 
DocumentContent::GetPanelTextFlowNumber()
{
#if defined(BCC31)
  PLListIterator pli((AvlSearch*)*panels);
#else
  PLListIterator pli(*panels);
#endif
  Panel* pnl;
  uword panel_flow_num = 0;
  while ((pnl = pli()) != 0) 
  {
    if (pnl->GetPanelID() == Panel::TablePanelID) 
    {
      panel_flow_num += ((TablePanel*)pnl)->GetTable()->GetGateSize();
    }
  }
  return panel_flow_num;
}

void 
DocumentContent::Count(Stats &stats)
{
  MouseCursor::StartLongActivity();
  Format();
  
  for (TextFlow* tf = GetFirstTextFlow(); tf; tf = tf->GetNext())
  {
    tf->Count(stats);
    stats.flow++;
  }
  stats.page = GetTotalPage();
  MouseCursor::EndLongActivity();
}

// get all layout
AllLayout* 
DocumentContent::GetAllLayout()
{
  return page_size ? page_size->GetAllLayout() : 0;
}

LayoutInstance* 
DocumentContent::GetZeroLayout()
{
  return page_size ? page_size->GetLayout() : 0;
}

// invalidate all document page
void 
DocumentContent::Invalidate()
{
  PMListIterator pmli(pm_list);
  for (PageMap* pm = pmli();
       pm != 0;
       pm = pmli()) 
  {
    pm->Invalidate();
  }
}

// invalidate pagemap to end
void 
DocumentContent::InvalidateToEnd(PageMap* from)
{
  PMListIterator pmli(pm_list);
  bool skip = True;
  for (PageMap* pm = pmli();
       pm != 0;
       pm = pmli()) 
  {
    if (pm == from) 
    {
      skip = False;
    }
    if (skip == False) 
    {
      pm->Invalidate();
    }
  }
}

// invalidate template
void 
DocumentContent::Invalidate(LayoutTemplate* lt)
{
  PMListIterator pmli(pm_list);
  for (PageMap* pm = pmli();
       pm != 0;
       pm = pmli()) 
  {
    if (pm->GetLayoutTemplate() == lt) 
    {
      pm->Invalidate();
    }
  }
}

// private method
void NEAR
DocumentContent::VariableTextUpdate(VText::VTextID id)
{
  MouseCursor::StartLongActivity();
  bool any_updated = False;
#ifdef BCC3
  PLListIterator pli((AvlSearch*) *panels);
#else
  PLListIterator pli(*panels);
#endif
  for (Panel* pl = pli(); pl != 0; pl = pli())
  {
    if (pl->GetPanelID() == Panel::VTextPanelID)
    {
      VTextPanel* vtp = pl->CastToVTextPanel();
      if (vtp->GetVText() ->GetVTextID() == id)
      {
	if (vtp->Evaluate(0))
	{
	  any_updated = True;
	}
	vtp->DelayFormat();
      }
    }
  }
  if (any_updated)
  {
    SetDirty();
  }
  DocumentWindow::touch_caret();
  MouseCursor::EndLongActivity();
}

void 
DocumentContent::VariableTextUpdateTime()
{
  VariableTextUpdate(VText::TimeVTextID);
}

void 
DocumentContent::VariableTextUpdateFileName()
{
  VariableTextUpdate(VText::FileNameVTextID);
}

void 
DocumentContent::VariableTextUpdatePageNo()
{
  VariableTextUpdate(VText::PageNoVTextID);
}

void 
DocumentContent::SetFirstPageNumber(int i)
{
  this->GetPageSize()->SetFirstPageNumber(i);
  this->VariableTextUpdatePageNo();
}

int 
DocumentContent::GetFirstPageNumber()
{
  return this->GetPageSize()->GetFirstPageNumber();
}

void 
DocumentContent::ParTooBig()
{
  if (!par_too_big_issued)
  {
    par_too_big_issued = True;
    Issue(S_ParTooBigMsg, MB_OK | MB_ICONSTOP);
  }
}

void 
DocumentContent::NoMorePanels()
{
  if (!no_more_panels_issued)
  {
    no_more_panels_issued = True;
    Issue(S_NoMorePanelsMsg, MB_OK | MB_ICONSTOP);
  }
}
