// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docconte.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// DocumentContent class
// The DocumentContent class defines objects which represent
// the contents of a document in pWord.

#ifndef DOCCONTE_H
#define DOCCONTE_H

class UniqLTList;
class Panel;
#ifndef PMLIST_DEFINED
class PMList;
#endif
#ifndef PLLIST_DEFINED
class PLList;
#endif

class AllLayout;
#include "pagesize.h"
#include "vtext.h"

class DocumentContent
{
  friend class DocLayoutIterator;
  friend class DocPageMapIterator;

public:
  // of which this is the content
  Document* document;
  
  // top text-flow
  TextFlow* textflow;
  
private:
  // last text-flow
  TextFlow* last_textflow;
  
  // page map list
  PMList* pm_list;
  
  // page map number
  uword pm_num;
  
  bool dirty;
  
  // undo information
  PUndo* undo;
  
  // document size
  Lunit width;
  Lunit height;
  
  // memo
  char* memo;
  
  // panel list
  PLList* panels;
  
  // panel code used flags
  BitString* pnl_code_used;
  
  // page size and zero page layout
  PageSize* page_size;
  
  // save page infomation version
  enum 
  {
    bw1_save_page_version = 1,
    bw2_save_page_version = 2,
  };
  
  // shutting it down?
  bool shutting_down;
  
  bool format_needed_p;
  
  bool par_too_big_issued;
  bool no_more_panels_issued;
  
  // zero page display start page
  word zero_display_start_page;

public:
  DocumentContent(Document*);
  ~DocumentContent();

private:
  void NEAR VariableTextUpdate(VText::VTextID id);

public:
  void SafeDestruct();
  void Init();
  void Term();
  
  // get document
  Document* GetDocument() 
  {
    return document;
  }
  
  DocumentWindow* GetFirstDocWindow();
  
  // get undo
  PUndo* GetUndo() 
  {
    return undo;
  }
  
  bool GetFormatNeededP();
  bool FormatOneStep();
  void Format();
  void SetFormatNeededP(bool format_needed_p);
  
  // search
  IntervalList* FindText(sjis* what);
  
  // ------------------------------
  // reading and writing document contents
  void ReadASCIIFromStream(BufStream*, int break_type);
  void WriteASCIIToStream(BufStream*);
  void ReadFormattedFromStream(PStream*);
  void ReadHeaderFromStream(PStream*);
  void ReadFormattedUntilMemo(PStream*);
  void ReadMemoFromStream(PStream*);
  void ReadFormattedTextFlowsFromStream(PStream*);
  void WriteFormattedToStream(PStream*);
  void WriteFormattedTextFlowsToStream(PStream*);
  void MarkCookieConnections(PStream*);
  
  long Dispatch(int command, int menu_state_p);

  // ------------------------------
  // memo
  char* GetMemo()
  {
    return memo;
  }
  
  void SetMemo(char* m)
  {
    delete memo;
    memo = m;
  }
  
  void SetShuttingDown(bool sd)
  {
    shutting_down = sd;
  }
  
  bool GetShuttingDown()
  {
    return shutting_down;
  }
  
  // ------------------------------
  // text-flow management
public:
  // get first text-flow
  TextFlow* GetFirstTextFlow() 
  {
    return textflow;
  }
  
  // get last text-flow
  TextFlow* GetLastTextFlow() 
  {
    return last_textflow;
  }
  
  // get non header text-flow
  TextFlow* GetNonHeaderTextFlow();
  
  // add text-flow to document
  void AddTextFlow(TextFlow* tf);
  
  // remove text-flow from document
  void RemoveTextFlow(TextFlow* tf);
  
  // how meny text-flow in this document
  uword GetTextFlowNum();
  
  // get text-flow id
  // tf		: search text-flow
  // return	: text-flow ID, 0 means error
  uword GetTextFlowID(TextFlow* tf);
  
  // get text-flow from id
  // return	: text-flow, 0 means invalid ID
  TextFlow* GetTextFlow(uword text_flow_id);
  
  // get text-flow from its serial number
  // return	: text-flow, 0 means invalid ID
  TextFlow* GetTextFlowBySerial(udword serial);
  
  // -- page map interface
  
  // default layout setup
  void DefaultFrameSetup();
  
  // used when paragraph styles change
  void RedisplayParagraphsAffected();
  
private:
  // setup page-map
  // lt			: mapping layout-template
  // page		: how many page
  void SetupPageMap(LayoutTemplate* lt, uword page);
  
  // generate page map
  // lt			: layout template
  PageMap* CreatePageMap(LayoutTemplate* lt);
  
  // add page map
  // pm			: addendum page-map
  void AddPageMap(PageMap* pm);
  
public:
  // get page-map list
  PMList* GetPMList() 
  {
    return pm_list;
  }
  
  // insert page map
  // prev		: prev. page map.
  //                	if prev == null, pm is the first page-map.
  // pm			: inserting page map
  void InsertPageMap(PageMap* prev, PageMap* pm);
  
  // get page map size
  // return		: page map size
  uword GetPageMapSize() 
  {
    return pm_num;
  }
  
  // get page map
  // n			: page map index(1~)
  PageMap* GetPageMap(uword n);
  
  // get page map number
  // return		: page-map number. if 0, can't find page-map.
  uword GetPageMapNumber(PageMap* pm);
  
  // get total page
  // return		: total page number
  uword GetTotalPage();
  
  // get next page-map
  // return		: next
  PageMap* GetNextPageMap(PageMap* pm);
  
  // get previous page-map
  // return		: prev
  PageMap* GetPrevPageMap(PageMap* pm);
  
  // remove page map
  // pm			: removeing page-map
  void RemovePageMap(PageMap* pm);
  
  bool GetDirty()
  {
    return dirty;
  }
  
  void SetDirty(bool d=True)
  {
    dirty = d;
  }
  
  // returns content's width and height depend on layout-instances
  Lunit GetLWidth() 
  {
    return width;
  }
  
  Lunit GetLHeight() 
  {
    return height;
  }
  
  // layout removed report
  void LayoutRemoved();
  
  // recalculate all layout logical position
  void RecalcAllLayoutLunit();
  void RecalcLayouts();
  void control_scroll_bar();
  
  // find layout by Lunit
  LayoutInstance* FindLayout(Lunit x, Lunit y);
  
  // find layout by layout-template
  LayoutInstance* FindFirstLayout(LayoutTemplate* lt);
  
  // get first layout
  LayoutInstance* GetFirstLayout();
  
  // get last layout
  LayoutInstance* GetLastLayout();
  
  // get first frame
  FrameInstance* GetFirstTextFlowFrame(TextFlow* tf);
  
  // write page infomation
  // This method saves it template and page-map infomations.
  void WritePageInfo(PStream*);
  
  // read page infomation
  // This method restore layout templates, page-maps, layouts and frames.
  void ReadPageInfo(PStream*);
  
private:
  // write layout template infomations.
  void WriteLayoutTemplateInfo(PStream*, UniqLTList*);
  
  // write page-map infomations.
  void WritePageMapInfo(PStream*, UniqLTList*);
  
  // read layout template infomations.
  void ReadLayoutTemplateInfo(PStream*, UniqLTList*);
  
  // read page-map infomations.
  void ReadPageMapInfo(PStream*, UniqLTList*);
  
  // generate page
  void GeneratePage();
  
public:
  // ------------------------------
  // page number interface
  // logical page number  : user page number(include first page offset)
  // physical page number : real lage page number
  
  // get layout by page number
  LayoutInstance* GetLayoutByLogicalPageNum(word n);
  LayoutInstance* GetLayoutByPhysicalPageNum(uword n);
  
  // get page number by layout
  word  GetLogicalPageNum(LayoutInstance* li);
  uword GetPhysicalPageNum(LayoutInstance* li);
  
  // page number convert
  word  GetLogicalPageNum(uword n);
  uword GetPhysicalPageNum(word n);
  
  // set first page no
  void SetFirstPageNumber(int n);
  int GetFirstPageNumber();
  
  // ------------------------------
  // panel interface
  
  // get panel list
  PLList* GetPanelList() 
  {
    return panels;
  }
  
  // get uniq panel code
  uword GetUniqPanelCode();
  
  // check panel num max
  // return	: False: no any panel code space
  bool CheckPanelNumMax();
  
  // add panel
  void AddPanel(Panel* panel);
  
  // remove panel
  void RemovePanel(Panel* panel);
  
  // get panel by index(1~)
  Panel* GetPanel(uword index);
  
  // get table panel by layout-template
  Panel* GetTablePanel(LayoutTemplate* lt);
  
  // get panel total number
  uword GetTotalPanelNumber();
  
  // get panel index(1~)
  uword GetPanelIndex(Panel* panel);
  
  // get panel index
  uword GetPanelIndex(sjis code);
  
  // get panel code from panel
  sjis GetPanelCode(Panel* pl);
  
  // get panel code from index
  sjis GetPanelCode(uword index);
  
  // get panel textflow number
  uword GetPanelTextFlowNumber();
  
  // count
  void Count(Stats &stats);
  
  // report dead text flow
  void ReportDeadTextFlow(TextFlow* tf, BufferPointer* bp);

  // ------------------------------
  // page size management
private:
  
public:
  // get all layout
  AllLayout* GetAllLayout();
  
  // pagesize
  PageSize* GetPageSize() 
  {
    return page_size;
  }
  
  // get zero page layout
  LayoutInstance* GetZeroLayout();
  
  // update variable text
  void VariableTextUpdateTime();
  void VariableTextUpdateFileName();
  void VariableTextUpdatePageNo();

  // ------------------------------
  // invalidate

  // invalidate all document page
  void Invalidate();
  
  // invalidate pagemap to end
  void InvalidateToEnd(PageMap* from);
  
  // invalidate template
  void Invalidate(LayoutTemplate* lt);
  
  void ParTooBig();
  void NoMorePanels();

public:
  word GetZeroDisplayStartPage()
  {
    return zero_display_start_page;
  }
  
  void SetZeroDisplayStartPage(word p)
  {
    zero_display_start_page = p;
  }
};

inline bool
DocumentContent::GetFormatNeededP()
{
  return(this->format_needed_p);
}

inline void
DocumentContent::SetFormatNeededP(bool format_needed_p)
{
  this->format_needed_p = format_needed_p;
}

#endif /* DOCCONTE_H */
