// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docedit.cpp,v 3.5 1999/05/12 00:22:16 kudou Exp $
// implement DocumentEdit class for handling
// editing of documents.

#include "pword.h"
#include "ftlist.h"
#include "pmenus.h"
#include "abbrevs.h"
#include "again.h"
#include "attribut.h"
#include "bufnew.h"
#include "clip.h"
#include "docchar.h"
#include "docconte.h"
#include "docmouse.h"
#include "docprese.h"
#include "docsel.h"
#include "document.h"
#include "docwindo.h"
#include "eca.h"
#include "editpage.h"
#include "epa.h"
#include "fileopen.h"
#include "fileutil.h"
#include "interval.h"
#include "intlist.h"
#include "makenum.h"
#include "mcursor.h"
#include "menu.h"
#include "mwindow.h"
#include "pime.h"
#include "pref.h"
#include "pundo.h"
#include "pstreams.h"
#include "pwordbas.h"
#include "pwordpre.h"
#include "regabb.h"
#include "sjis.h"
#include "textindl.h"
#include "textflow.h"
#include "vtextpnl.h"
#include "vtext.h"
#include "xstr.h"
#include "docedit.h"
#ifdef _WIN32
#include <io.h>
#include <fcntl.h>
#endif /* _WIN32 */

DocumentEdit::DocumentEdit(DocumentWindow* dw)
{
  Init(dw);
  
  mouse		  = DocumentMouse::MakeInstance(this);
  clip		  = new DocumentClip	 (this);
  edit_char_atts  = new EditCharAtts	 (this);
  edit_par_atts	  = new EditParAtts	 (this);
  char_editor     = new DocumentChar(this);
  selection       = new DocumentSelection(this);
  
  GoToBeginning();
}

DocumentEdit::DocumentEdit(DocumentWindow* dw, PStream* stream)
{
  Init(dw);
  
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_DOCEDIT, vers);
  CHECK;
  
  mouse		  = DocumentMouse::MakeInstance(this);
  clip		  = new DocumentClip	 (this);
  edit_char_atts  = new EditCharAtts	 (this);
  edit_par_atts	  = new EditParAtts	 (this);
  char_editor     = new DocumentChar(this);
  selection       = new DocumentSelection(this, stream);
  
  stream->EndBlockIn();
}

void
DocumentEdit::Init(DocumentWindow* dw)
{
  document_window = dw;
  mouse = 0;
  clip = 0;
  edit_par_atts = 0;
  edit_char_atts = 0;
  selection = 0;
}

DocumentEdit::~DocumentEdit()
{
  DocumentMouse::KillInstance(this->mouse);
  delete clip;
  delete edit_char_atts;
  delete edit_par_atts;
  delete char_editor;
  delete selection;
}

void
DocumentEdit::Reset()
{
  THIS_CHECK;
  if (selection)
  {
    selection->Reset();
    mouse->Reset();
  }
  GoToBeginning();
}

Document* 
DocumentEdit::GetDocument()
{
  THIS_CHECK;
  return(this->document_window->GetPresentation() ->GetDocument());
}

DocumentContent* 
DocumentEdit::GetDocumentContent()
{
  THIS_CHECK;
  Document* d = GetDocument();
  return(d == NULL ? NULL : d->GetDocumentContent());
}

IntervalList* 
DocumentEdit::GetSelection()
{
  THIS_CHECK;
  DocumentSelection* ds = this->GetSelectionStack();
  return(ds == NULL ? NULL : ds->GetSelection());
}

Interval* 
DocumentEdit::PrimarySelection()
{
  THIS_CHECK;
  IntervalList* il = this->GetSelection();
  return(il == NULL ? NULL : il->GetHead());
}

void
DocumentEdit::GoToBeginning()
{
  THIS_CHECK;
  WillMove();
  {
    BPP bpp=GetDocumentContent()->GetNonHeaderTextFlow()->GetStartBufferPointer();
    IntervalList* il = GetSelection();
    Interval* i = il->GetHead();
    if (i)
    {
      i->SetBP0(bpp);
    }
    else
    {
      il->AddInterval(new Interval(bpp));
    }
    il->InferAttributes();
    delete bpp;
  }
  DidMove();
}

void
DocumentEdit::GoToEnd()
{
  THIS_CHECK;
  this->WillMove();
  {
    BP* bp = (this
	      ->GetDocumentContent()
	      ->GetFirstTextFlow() ->GetEndBufferPointer());
    Interval* i = this->PrimarySelection();
    if (i != NULL)
    {
      i->SetBP0(bp);
    }
    else
    {
      this->GetSelection() ->AddInterval(new Interval(bp));
    }
    delete bp;
  }
  this->DidMove();
}

// public method
// called from ECA::Style_Search and EPA::Style_Search.
#ifdef BW3_DISPATCH
LRESULT_T
DocumentEdit::Style_Search(bool menu_state_p, Menu_Type menu_type, char* dialog_title)
#else /* BW3_DISPATCH */
long
DocumentEdit::Style_Search(int menu_state_p,
			    Menu_Type menu_type, char* dialog_title)
#endif /* BW3_DISPATCH */
{
  if (!Menu::item_exists_p(menu_type))
  {
    return(disabled_command(menu_state_p));
  }
  if (!menu_state_p)
  {
    int style = Menu::go_dialog(menu_type, dialog_title);
    if (0 <= style)
    {
      IntervalList* il = this->GetDocument() ->FindStyle(style);
      if (il != NULL)
      {
	this->GetSelectionStack() ->InstallSelection(il);
      }
      else
      {
	::MessageBeep(0);
      }
    }
  }
  // 0 == MF_ENABLED
  return(0);
}

// private method
// Handle Edit/Tategaki menu.
long NEAR
DocumentEdit::handle_edit_tategaki()
{
  Interval* i = this->PrimarySelection();
  HVSetDialog dialog(i->GetTextFlow() ->tategaki_flow_p());
  if (dialog.Go())
  {
    int tategakip = dialog.TateP();
    for (; (i != NULL
	    && !(i->GetTextFlow() ->tategaki_flow_p()) == !tategakip);
	 i = i->GetNext())
    {
    }
    if (i != NULL)
    {
      this->WillEdit();
      bool change_fmgn_p = dialog.ChangeFrameMarginP();
      FTList ftl;
      for (i = this->PrimarySelection(); i != NULL; i = i->GetNext())
      {
	TextFlow* flow = i->GetTextFlow();
	if (!flow->tategaki_flow_p() != !tategakip)
	{
	  flow->set_tategaki_flow_p(tategakip);
	  flow->DelayFormat();
	  if (change_fmgn_p)
	  {
	    FrameInstance* fi = flow->GetFirstFrame();
	    FrameTemplate* ft = 0;
	    FrameTemplate* prev_ft = 0;
	    while (fi)
	    {
	      prev_ft = ft;
	      ft = fi->GetFrameTemplate();
	      if (ft != prev_ft)
	      {
		if (!ft->FrameMarginExchangeP())
		{
		  // exchange margin
		  Margin m = ft->GetMargin(); 
		  Margin new_m;
		  if (tategakip)
		  {
		    new_m.Set(m.GetLeft(), 
			       m.GetRight(),
			       m.GetBottom(),
			       m.GetTop());
		  }
		  else
		  {
		    new_m.Set(m.GetRight(),
			       m.GetLeft(),
			       m.GetTop(),
			       m.GetBottom());
		  }
		  ft->SetMargin(new_m);
		  ft->SetFrameMarginExchangeP(True);
		  ftl.Inject(ft);
		}
	      }
	      fi = fi->GetNextTextFrame();
	    }
	  }
	}
      }
      if (change_fmgn_p)
      {
	FTListIterator ftli(ftl);
	FrameTemplate* ft;
	while ((ft = ftli()) != 0)
	{
	  ft->SetFrameMarginExchangeP(False);
	}
      }
      this->DidEdit();
      DocumentWindow::force_touch_caret();
    }
  }
  return(0);
}


#ifdef BW3_DISPATCH
LRESULT_T
DocumentEdit::Dispatch(WORD command, WORD notify_code, HWND hwnd)
#else /* BW3_DISPATCH */
long
DocumentEdit::Dispatch(uword command, long lParam)
#endif /* BW3_DISPATCH */
{
  THIS_CHECK;
#ifdef BW3_DISPATCH
  bool menu_state_p = MENU_STATE_P(notify_code);
  // MF_ENABLED is a 0.
  LRESULT_T result = 0;
#else /* BW3_DISPATCH */
  int menu_state_p = MENU_STATE_P(lParam);
  // MF_ENABLED is a 0.
  long result = 0;
#endif /* BW3_DISPATCH */
  
  if (this->document_window->mouse.activep)
  {
    return(disabled_command(menu_state_p));
  }
  
  switch (command)
  {
   case IDM_Location_SearchQuickly:
    {
      char* hint = this->PrimarySelection() ->GetHint();
      if (hint[0] == '\0')
      {
	result = disabled_command(menu_state_p);
      }
      else if (!menu_state_p)
      {
	this->GetDocument() ->search_string(hint, False, False);
      }
      delete hint;
    }
    break;
    
   case IDM_Edit_Tategaki:
    if (!menu_state_p)
    {
      this->handle_edit_tategaki();
    }
    break;
    
   case IDM_Location_Top:
   case IDM_Location_Bot:
   case IDM_Location_GotoPage:
   case IDM_Location_NextSelection:
   case IDM_Location_PrevLocation:
    result = selection->Dispatch(menu_state_p, command);
    break;
    
   case IDM_Location_MakeMark:
    if (!menu_state_p)
    {
      WillEdit();
      result = selection->Dispatch(menu_state_p, command);
      DidEdit();
    }
    break;
    
   case IDM_Location_AllFlow:
   case IDM_Location_All:
    if (!menu_state_p)
    {
      All(command == IDM_Location_AllFlow);
    }
    break;
    
   case IDM_Disp_ScrollUp:
    result = GetDocumentWindow()->SendMessage(WM_VSCROLL, SB_PAGEUP);
    break;
    
   case IDM_Disp_ScrollDown:
    result = GetDocumentWindow()->SendMessage(WM_VSCROLL, SB_PAGEDOWN);
    break;
    
   case IDM_Edit_NewLine:
    {
      sjis foo = NLC;
      // instead of having "again" mean another CR, we add it to the text
      // buffer
      Again::CantDoAgain();
      InsertText(&foo, 1);
    }
    break;
    
   case IDM_Edit_NewPar:
    Mitose();
    break;
    
#ifndef NDEBUG
   case IDM_CTRLS:
   case IDM_CTRLQ:
   case IDM_CTRLY:
#endif
   case IDM_InputText:
   case IDM_Edit_DeleteWord:
   case IDM_Edit_DeleteLine:
   case IDM_Edit_DeletePara:
   case IDM_Edit_DeleteRight:
   case IDM_Edit_DeleteRightWord:
   case IDM_Edit_Back:
   case IDM_Edit_EuroCombo:
#ifdef BW3_DISPATCH
    result = char_editor->Dispatch(command, notify_code, hwnd);
#else /* BW3_DISPATCH */
    result = char_editor->Dispatch(command, lParam);
#endif /* BW3_DISPATCH */
    break;
    
   case IDM_Edit_VText_PageNumber:
    if (!menu_state_p)
    {
      this->VariableTextPageNo();
    }
    break;
    
   case IDM_Edit_VText_FileName:
    if (!menu_state_p)
    {
      VariableTextFileName();
    }
    break;
    
   case IDM_Edit_VText_Freeze:
#ifdef BW3_DISPATCH
    result = VariableTextFreeze(command, notify_code, hwnd);
#else /* BW3_DISPATCH */
    result = VariableTextFreeze(lParam);
#endif /* BW3_DISPATCH */
    break;
    
   case IDM_Edit_VText_Update:
    {
      IntervalList* il = GetSelection();
      if (il->PointP())
      {
	if (menu_state_p)
	{
	  result = MF_GRAYED;
	}
      }
      else if (!menu_state_p)
      {
	int total_changed = 0;
	for (Interval* i = il->GetHead(); i != NULL; i = i->GetNext())
	{
	  total_changed += i->VariableTextUpdate();
	}
	if (total_changed > 0)
	{
	  ::StatusOut(S_VTUpdated, total_changed);
	}
	else
	{
	  ::MessageBeep(0);
	}
      }
    }
    break;
    
#ifdef BW2_ABBREV
   case IDM_Edit_Abbrev_Register:
    if (this->GetSelection() ->PointP())
    {
      result = disabled_command(menu_state_p);
    }
    else if (!menu_state_p)
    {
      char* hint = this->PrimarySelection() ->GetHint();
      RegAbbDialog dialog(hint);
      if (dialog.Go())
      {
	RegisterAbbrev(dialog.GetName());
      }
      delete hint;
    }
    break;
#endif /* BW2_ABBREV */

   case IDM_Edit_IMERegister:
    if (!menu_state_p)
    {
      // we assume the user has selected the word he wants to register.
      // otherwise, he will get the word following the cursor.
      char* moji = this->PrimarySelection()->GetHint();
      PIME::WordRegister(moji, 0);
      delete moji;
    }
    break;

    // we have to resort to this craziness because in pword delete both
    // means delete selection and delete right char when there is no
    // selection.  but the menu display on the Edit menu is grayed when
    // there is no selection.  This means Windows never gives us the
    // message at all.  Thus we invent a new command, not on any menu,
    // and control where to dispatch it to ourselves.
   case IDM_Edit_DeleteNotOnMenu:
   case IDM_Edit_Cut:
   case IDM_Edit_Delete:
   case IDM_Edit_Paste:
   case IDM_Edit_Copy:
#ifdef BW3_DISPATCH
    result = clip->Dispatch(menu_state_p, command);
#else /* BW3_DISPATCH */
    result = clip->Dispatch(command, menu_state_p);
#endif /* BW3_DISPATCH */
    break;
    
   case IDM_Edit_InsertFile:
    if (!menu_state_p)
    {
      this->InsertFile();
    }
    break;
    
#ifndef NDEBUG
   case IDM_Test_3:
    ::DumpAtts();
    break;
#endif
    
#ifndef NDEBUG
#ifdef BW2_VERBOSE
   default:
    syserr("Docedit::Dispatch -- unknown msg 0x%x", command);
    break;
#endif
#endif
  }
  return(result);
}

// Arrow keys remove all selections but the first
void
DocumentEdit::Navigate(uword command)
{
  THIS_CHECK;
  Again::CantDoAgain();
  WillMove();
  {
    IntervalList* il = GetSelection();
    Interval* head = il->GetHead();
    int can_move_p = (head->GetNext() != NULL);
    Interval old_interval(head);
    il->DeleteSecondaryIntervals();
    il->GetHead()->Navigate(command);
    if (Pref_beep_if_cannot_move
	&& !can_move_p && il->GetHead() ->EQ(old_interval))
    {
      ::MessageBeep(0);
    }
  }
  DidMove();
}

// private method
void NEAR
DocumentEdit::All(int all_flows)
{
  THIS_CHECK;
  MouseCursor::StartLongActivity();
  Interval* i = this->PrimarySelection();
  
  GetSelectionStack()
  ->InstallSelectionNoCaret
  (all_flows ? new IntervalList(i->GetDocumentContent())
   : new IntervalList(new Interval(i->GetTextFlow())));
  
  MouseCursor::EndLongActivity();
}


void
DocumentEdit::WillEdit()
{
  THIS_CHECK;
  GetSelectionStack()->WillEdit();
}

void
DocumentEdit::DidEdit()
{
  THIS_CHECK;
  GetSelectionStack()->DidEdit();
  GetDocumentContent()->SetDirty();
  if (GetSelection()->PointP())
  {
    DocumentWindow::force_touch_caret();
    DocumentWindow::control_ime();
  }
  else
  {
    DocumentWindow::touch_caret();
  }
}

void
DocumentEdit::DidEditNoCaret()
{
  THIS_CHECK;
  GetSelectionStack()->DidEdit();
  GetDocumentContent()->SetDirty();
  PWordPresentation::Update();
}

void
DocumentEdit::WillMove()
{
  THIS_CHECK;
  GetSelectionStack()->WillMove();
}

void
DocumentEdit::DidMove()
{
  THIS_CHECK;
  this->PrimarySelection() ->InferAttributes();
  DocumentWindow::force_touch_caret();
  Again::ClearInput();
  GetDocumentContent()->GetUndo()->SetMoved();
}

void
DocumentEdit::WillMouseMove()
{
  THIS_CHECK;
  GetSelectionStack()->WillMove();
  DocumentWindow::untouch_caret();
}

void
DocumentEdit::DidMouseMove()
{
  THIS_CHECK;
  
  Again::ClearInput();
  GetDocumentContent()->GetUndo()->SetMoved();
  
  IntervalList* il = GetSelection();
  il->GetHead()->InferAttributes();
  if (il->PointP())
  {
    DocumentWindow::force_touch_caret();
  }
  else
  {
    DocumentWindow::unforce_touch_caret();
  }
}

void
DocumentEdit::Mitose()
{
  Inserter inserter(this, PUndo::UD_Input);
  do
  {
    inserter.Before();
    
    Interval* i = inserter.GetInterval();
    i->Mitose();
    i->DelayFormat();
    
    inserter.After();
  }
  while (inserter.Next());
}

void
DocumentEdit::InsertText(sjis* stuff, unsigned int count)
{
  if (!Again::GetDoingAgain()) 
  {
    Again::SetInput(stuff, count);
  }
  InsertStuff(stuff, count, PUndo::UD_Input);
}

void
DocumentEdit::InsertStuff(sjis* stuff, unsigned int count, PUndo::UndoDesc desc)
{
  Inserter inserter(this, desc);
  do
  {
    inserter.Before();
    inserter.GetInterval()->InsertText(stuff, count);
    inserter.After();
  }
  while (inserter.Next());
}

void
DocumentEdit::InsertAscii(char* stuff, unsigned int how_much)
{
  int foo_len;
  sjis* foo = jis_spread(stuff, how_much, &foo_len);
  InsertText(foo, foo_len);
  delete foo;
}

// insert one of Kudo's tables

void
DocumentEdit::InsertTable(sjis panel_code, BufferPointer* where)
{
  DocumentContent* dc = GetDocumentContent();
  Panel* p = dc->GetPanel(::GetSpecialCode(panel_code));
  assert(p->GetPanelID() == Panel::TablePanelID);
  IntervalList* il = GetSelection();
  
  WillEdit();
  Interval* i_where = new Interval(where);
  IntervalList* new_il = new IntervalList(i_where);
  GetSelectionStack()->InstallSelection(new_il);
  
  PUndo* undo = GetDocumentContent()->GetUndo();
  
  undo->StartAtom(il, PUndo::UD_InsertTable);
  InsertPanel(p, i_where);
  undo->Register(i_where, PUndo::UF_Insert);
  new_il->GotoEndPoint();
  undo->EndAtom(new_il);
  
  DidEdit();
}

void
DocumentEdit::WriteToStream(PStream* stream)
{
  stream->StartBlockOut(PStream::HDR_DOCEDIT);
  CHECK;
  
  selection->WriteToStream(stream);
  CHECK;
  
  stream->EndBlockOut();
  CHECK;
}

void
DocumentEdit::VariableTextPageNo()
{
  uword format;
  {
    VTPageNoDialog dlg;
    format = dlg.Go();
  }
  if (format == 0) //cancelled
  {
    return;
  }
  
  DocumentContent* dc = this->GetDocumentContent();
  Document* doc = dc->GetDocument();
  
  Inserter inserter(this, PUndo::UD_InsertVText);
  do 
  {
    inserter.Before();
    
    if (!dc->CheckPanelNumMax())
    {
      break;
    }
    VText* vtext = new VTextPageNo(doc, format);
    Interval* i = inserter.GetInterval();
    VTextPanel* vtp = new VTextPanel(dc, i->GetLeft(), vtext);
    this->InsertPanel(vtp, i);
    
    inserter.After();
  } while (inserter.Next());  
}

void
DocumentEdit::InsertPanel(Panel* p, Interval* i)
{
  sjis foo = this->GetDocumentContent()->GetPanelCode(p);
  i->InsertText(&foo, 1);
  assert(EQ(i->GetLeft(), p->GetRightBP()));
  p->GetRightBP()->Set(i->GetRight());
}

void
DocumentEdit::VariableTextFileName()
{
  DocumentContent* dc = this->GetDocumentContent();
  Document* doc = dc->GetDocument();
  
  Inserter inserter(this, PUndo::UD_InsertVText);
  
  do
  {
    inserter.Before();
    
    if (!dc->CheckPanelNumMax())
    {
      break;
    }
    Interval* i = inserter.GetInterval();
    VText* vtext = new VTextFileName(doc);
    VTextPanel* vtp = new VTextPanel(dc, i->GetLeft(), vtext);
    InsertPanel(vtp, i);
    
    inserter.After();
  }
  while (inserter.Next());
}

void
DocumentEdit::VariableTextTime(int what, int how)
{
  DocumentContent* dc = this->GetDocumentContent();
  Inserter inserter(this, PUndo::UD_InsertVText);
  
  do
  {
    inserter.Before();
    
    if (!dc->CheckPanelNumMax())
    {
      break;
    }
    
    VText* vtext = new VTextTime(what, how);
    Interval* i = inserter.GetInterval();
    VTextPanel* vtp = new VTextPanel(dc, i->GetLeft(), vtext);
    InsertPanel(vtp, i);
    
    inserter.After();
  }
  while (inserter.Next());
}

#ifdef BW3_DISPATCH
LRESULT_T
DocumentEdit::VariableTextFreeze(WORD command, WORD notify_code, HWND hwnd)
#else /* BW3_DISPATCH */
long
DocumentEdit::VariableTextFreeze(LONG lParam)
#endif /* BW3_DISPATCH */
{
  IntervalList* il = GetSelection();
  if (il->PointP())
  {
#ifdef BW3_DISPATCH
    if (MENU_STATE_P(notify_code))
#else /* BW3_DISPATCH */
    IF_MENU_STATE
#endif /* BW3_DISPATCH */
    {
      return MF_GRAYED;
    }
    else return 0;
  }
  MENU_STATE_ENABLED

  int count = 0;
  PUndo* undo = GetDocumentContent()->GetUndo();
  IntervalList* frozen_all = new IntervalList;
  DocumentContent* dc = GetDocumentContent(); 
  for (Interval* i = il->GetHead(); i != NULL; i = i->GetNext())
  {
    IntervalList* vtil = i->FindVText();
    if (vtil != NULL)
    {
      if (count == 0)
      {
	WillEdit();
	undo->StartAtom(il, PUndo::UD_FreezeVText);
      }
      count += vtil->Count();
      for (Interval* ii = vtil->GetHead(); ii != NULL; ii = ii->GetNext())
      {
	// get everything we need BEFORE deleting the character, Bob
#ifndef NDEBUG
	bool success = ii->GetLeft()->Decrement();
	assert(success);
#else
	ii->GetLeft()->Decrement();
#endif
	sjis c = ii->GetLeft()->GetRightChar();
	attr a = ii->GetLeft()->GetRightAttr();
	assert(IsPanel(c));
	VTextPanel* v = dc->GetPanel(::GetSpecialCode(c))->CastToVTextPanel();
	sjis* stuff = v->GetWideString();
	int count;
	sjis* my_stuff = new sjis[count=jislen(stuff)];
	if (my_stuff == NULL)
	{
	  break;
	}
	memcpy(my_stuff, stuff, sizeof(sjis)*count);
	
	// delete
	undo->Register(ii, PUndo::UF_Delete);
	ii->Cut();
	
	// replace
	ii->SetAtts(a);
	ii->InsertText(my_stuff, count);
	delete my_stuff;
	undo->Register(ii, PUndo::UF_Insert);
      }
      frozen_all = IntervalList::Concat(frozen_all, vtil);
    }
  }
  if (count > 0)
  {
    GetSelectionStack()->InstallSelection(frozen_all);
    undo->EndAtom(frozen_all);
    DidEdit();
    ::StatusOut(S_VTFrozen, count);
  }
  else
  {
    ::MessageBeep(0);
    delete frozen_all;
  }
  return 0;
}

// private method
void NEAR
DocumentEdit::InsertFile()
{
  // get the filename
  char filename[MAX_PATH + 1];
  strcpy(filename, S_AllWildCard);
#ifdef BW3_FILEDLG
  if (!PWordBase::FileOpenDlg(filename, S_AllWildCard2, True) // Insert File
#else /* BW3_FILEDLG */
  if (!PWordBase::FileOpenDlg(filename, True) // Insert File
#endif /* BW3_FILEDLG */
      || filename[0] == '\0')
  {
    return;
  }
  main_window->Update();	// clear screen
  
  // open the file
  if (!CheckFileAccess(filename, True))
  {
    return;
  }
  
  int handle;
  
  FILE* f = NULL;
#ifdef _WIN32
  handle = open(filename, O_RDONLY | O_BINARY);
#else /* _WIN32 */
  OFSTRUCT open_buff;
  handle = OpenFile(filename, &open_buff, OF_READ | OF_SHARE_DENY_WRITE);
#endif /* _WIN32 */
  if (handle != -1)
  {
    f = fdopen(handle, "rb");
  }
  if (f == NULL)
  {
    ::MessageBeep(0);
    ReportOpenError(filename);
    return;
  }
  
  {
    PStream astream(f, PStream::WW_FILE);
    PStream* stream = &astream;
    stream->InitIn();
    
    if (stream->GetError() == SE_NOERROR) // Beatword format file
    {
      Issue(S_CantInsertFile, MB_OK | MB_ICONSTOP);
      stream->TermIn();
      return;
    }    
  }
  
  // find the user's preferred form
  TextFormDialog dlg;
  int break_type = dlg.Go();
  if (!break_type)
  {
    return; // dialog was cancelled
  }
  
  
  // get ready to read in
  main_window->Update(); // get rid of dialog box!
  ::ShowFileName(FileUtil::GetFileNameOnly(filename), S_Reading); 
  MouseCursor::StartLongActivity();
  
  // do the actual insertion.
  Inserter inserter(this, PUndo::UD_InsertFile);
  do
  {
    inserter.Before();
    fseek(f, 0, 0); // reset to beginning 
    BufStream astream(f), *stream=&astream;
    Interval* i = inserter.GetInterval();
    i->GetLeft()->InsertASCII(stream, break_type, False); 
    inserter.GetInterval()->GetLeft()->InsertASCII(stream, break_type, False); 
    i->DelayFormat();
    stream->TermIn();
    if (stream->GetError() != SE_NOERROR)
    {
      ::ReportReadError();
      MouseCursor::EndLongActivity();
      return;
    }
    inserter.After();
  } while (inserter.Next());
  
  // clean up
  if (f)
  {
    fclose(f);
  }
  else if (handle!=-1) 
  {
    _lclose(handle);
  }
  StatusOut("");  
  MouseCursor::EndLongActivity();
}

#ifdef BW2_ABBREV
// ------------------------------------------------------------
// registering abbreviations

static bool
maxproc()
{
  return True;
}
      
void
DocumentEdit::RegisterAbbrev(char* name)
{
  const int maxbytes = 30000;
  VMem* vmem = VMem::Make(6);
  Interval i(this->PrimarySelection());
  assert(!i.PointP());

  BufStream stream(vmem);
  stream.SetMax(maxbytes, maxproc);
  i.WriteASCIIToStream(&stream);
  if (stream.GetError() == SE_TOOBIG)
  {
    stream.SetMax(maxbytes+10, 0); // space for terminator
    stream.SetError(SE_NOERROR);
  }
  if (stream.GetError() != SE_NOERROR)
  {
    stream.TermOut();
    return;
  }

  stream.PutByte('\0'); 
  stream.TermOut();
  int len = strlen((char*) (vmem->GetStuff())) + 1;
  char* ans = new char[len];
  ::copy_string(ans, (char*) (vmem->GetStuff()), len);
    
  delete vmem;
  
  WillEdit();
  GlobalAbbrevTable.MakeAbbrev(name, ans, this->GetDocument());
  DidEdit();
}

void
DocumentEdit::InsertAbbrev(int i)
{
  char* abbrev = GlobalAbbrevTable.GetAbbrevData(i);
  assert(abbrev != 0);

  // abbreviations are kept as regular character strings
  int foo_len;
  sjis* foo = jisz_spread(abbrev, &foo_len);
  this->InsertStuff(foo, foo_len, PUndo::UD_InsertAbbrev);
  delete foo;
}
#endif /* BW2_ABBREV */

// ------------------------------------------------------------
// the Inserter

#define NO_NO_OVERWRITE 

Inserter::Inserter(DocumentEdit* editor, PUndo::UndoDesc desc)
{
  (this->editor = editor) -> WillEdit();
  this->undo = editor->GetDocumentContent()->GetUndo();
#ifdef NO_NO_OVERWRITE
  this->no_overwrite_p = False;
#else
  this->no_overwrite_p = PREF_FLAG(PREF_NOOVERWRITE);
#endif

  this->il = editor->GetSelection();
  il->RemoveNested();
  undo->StartAtom(il, desc);

  this->i = il->GetHead();
}

void
Inserter::Before()
{
  this->point_p = i->PointP();

  if (!this->point_p)
  {
#ifdef NO_NO_OVERWRITE
    if (!this->no_overwrite_p)
    {
#endif
      this->cur_end = new BP(this->i->GetRight());
#ifdef NO_NO_OVERWRITE
    }
#endif
    this->i->GotoBeginningPoint();
  }
}
  
void
Inserter::After()
{
  this->undo->Register(i, PUndo::UF_Insert);
  
  if (!this->point_p)
  {
    Interval* cut_me = new Interval(this->i->GetRight(), this->cur_end);
    delete this->cur_end;
#ifdef NO_NO_OVERWRITE
    if (!this->no_overwrite_p)
    {
#endif
      this->undo->Register(cut_me, PUndo::UF_Delete);
      cut_me->Cut();
#ifdef NO_NO_OVERWRITE
    }
    else
    {
      cut_me->TurnOff();
    }
#endif
    delete cut_me;
  }
  this->i->GotoEndPoint();
}

bool
Inserter::Next()
{
  return((i = i->GetNext()) != NULL);
}

Inserter::~Inserter()
{
  this->undo->EndAtom(il);
  this->editor->DidEdit();
}
