// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docedit.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// define class to handle editing of a document

#ifndef DOCEDIT_H
#define DOCEDIT_H

#include "menu.h"
#include "pundo.h"

class DocumentEdit 
{
private:
  // parent owning this DocumentEdit object
  DocumentWindow* document_window;
  
  // these guys are not really objects, they are collections
  // of subfunctionality
  DocumentMouse* mouse;
  DocumentClip* clip;
  EditCharAtts* edit_char_atts;
  EditParAtts* edit_par_atts;
  DocumentSelection* selection;
  DocumentChar* char_editor;
  
public:
  DocumentEdit(DocumentWindow*);
  DocumentEdit(DocumentWindow* , PStream*);
  ~DocumentEdit();
  
private:
  long NEAR handle_edit_tategaki();
  void NEAR All(int all_flows);
  void NEAR InsertFile();

public:
  void Init(DocumentWindow*);
#ifdef BW3_DISPATCH
  LRESULT_T Style_Search(bool menu_state_p, Menu_Type menu_type, char* dialog_title);
#else /* BW3_DISPATCH */
  long Style_Search(int menu_state_p, Menu_Type menu_type, char* dialog_title);
#endif /* BW3_DISPATCH */
  // reset the editing environment; primarily resets the selection
  void Reset();
  
  // accessors
  DocumentWindow* GetDocumentWindow()
  {
    return document_window;
  }
  
  EditCharAtts* GetEditCharAtts()
  {
    return edit_char_atts;
  }
  
  EditParAtts* GetParAtts()
  {
    return edit_par_atts;
  }
  
  DocumentChar* GetDocumentChar()
  {
    return char_editor;
  }
  
  DocumentMouse* GetDocMouse() {return(this->mouse);}
  
  Document* GetDocument();
  DocumentContent* GetDocumentContent();
  
  IntervalList* GetSelection();
  
  DocumentSelection* GetSelectionStack() { return selection; }
  Interval* PrimarySelection();
  
  // navigation
  
  void GoToBeginning();
  void GoToEnd();
  void GotoMark(IntervalList*);
  void Navigate(uword);
  void Mitose();
  
  // dispatcher
#ifdef BW3_DISPATCH
  LRESULT_T Dispatch(WORD command, WORD notify_code, HWND hwnd);
#else /* BW3_DISPATCH */  
  long Dispatch(uword, long);
#endif /* BW3_DISPATCH */
  
  void WillEdit();
  void DidEdit();
  void DidEditNoCaret();
  void WillMove();
  void DidMove();
  void WillMouseMove();
  void DidMouseMove();
  
  void InsertText(sjis* stuff, unsigned int count);
  void InsertStuff(sjis* stuff, unsigned int count, PUndo::UndoDesc);
  void InsertAscii(char* stuff, unsigned int how_much);
  void InsertTable(sjis, BufferPointer*);
  void InsertPanel(Panel* , Interval*);

#ifdef BW3_DISPATCH
  LRESULT_T VariableTextFreeze(WORD command, WORD notify_code, HWND hwnd);
#else /* BW3_DISPATCH */
  long VariableTextFreeze(LONG);
#endif /* BW3_DISPATCH */

  void VariableTextPageNo(); 
  void VariableTextFileName(); 
  void VariableTextTime(int, int); 
#ifdef BW2_ABBREV
  void RegisterAbbrev(char*);
  void InsertAbbrev(int i);
#endif /* BW2_ABBREV */
  void WriteToStream(PStream*);
};

class Inserter 
{
private:
  IntervalList* il;
  Interval* i;
  PUndo* undo;
  DocumentEdit* editor;
  // must be INT, not BOOL(for preference value)
  int no_overwrite_p;
  bool point_p;
  BP* cur_end;
  
public:
  Inserter(DocumentEdit* editor, PUndo::UndoDesc desc);
  ~Inserter();
  void Before();
  void After();
  bool Next();
  
  Interval* GetInterval()
  {
    return i;
  }
};

#endif /* DOCEDIT_H */
