// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docmouse.cpp,v 3.3 1999/05/23 17:26:08 kudou Exp $
// class implementation for DocumentMouse
// The DocumentMouse class defines mouse behavior in a document window.

#include "pword.h"
#include "docmouse.h"
#include "docedit.h"
#include "docconte.h"
#include "docsel.h"
#include "docwindo.h"
#include "mcursor.h"
#include "frametem.h"
#include "frameins.h"
#include "layoutte.h"
#include "layoutin.h"
#include "bufnew.h"
#include "interval.h"
#include "intlist.h"
#include "rect.h"
#include "textflow.h"

// ------------------------------------------------------------
// constructor, destructor

DocumentMouse::DocumentMouse(DocumentEdit* editor)
{
  Init();
  this->editor = editor;
}

void 
DocumentMouse::Init()
{
  this->button_down_point = NULL;
  this->multi_cell_start_frame = NULL;
  this->shift_state = 0;
  this->double_clicking = False;
  this->cancelling_selection = False;
  this->multi_cell_p = False;
  this->Clean();
}

void
DocumentMouse::Reset()
{
  Init();
}

DocumentMouse::~DocumentMouse()
{
  this->Clean();
}

DocumentMouse* 
DocumentMouse::MakeInstance(DocumentEdit* editor)
{
  return(new DocumentMouse(editor));
}

void
DocumentMouse::KillInstance(DocumentMouse* mouse)
{
  delete mouse;
}

// ------------------------------------------------------------
// private methods

void
DocumentMouse::Clean()
{
  if (this->button_down_point != NULL)
  {
    delete this->button_down_point;
    this->button_down_point = NULL;
  }
}

// `SetupSelection' is called when a selection is starting.  It does
// not consume the bp.
void
DocumentMouse::SetupSelection(BP* bp)
{
  this->editor->WillMouseMove();
  
  if ((this->shift_state & MK_CONTROL) == 0)
  {
    // no control
    if (!(this->shift_state & MK_SHIFT))  // shift leaves old sels
    {
      (this->editor->GetSelection())->Collapse();
    }
  }
  else // control
  {
    if (!this->double_clicking)
    {
      if ((this->editor->GetSelection())->DeleteIntervalContaining(bp))
      {
	this->cancelling_selection = True;
      }
    }
    (this->editor->GetSelection())->AddInterval(bp, bp);
  }

  if ((this->shift_state & MK_SHIFT) == 0)
  {
    // no shift
    if (!this->double_clicking)
    {
      (this->editor->PrimarySelection())->Set(bp);
    }
    else
    {
      BP* x = (this->editor->PrimarySelection())->GetBP0();
      x->ForwardWord(1);
      x->ForwardWord(-1);
      // BP1 = BP0,  see Interval::IncDefRegion and Interval::Diff. (konno)
      ((this->editor->PrimarySelection())->GetBP1())->Set(x);
    }
  }
  (this->editor->GetSelection())->InferAttributes();
}


// ConfirmSelection -- the selection has ended.  Move the Defining Interval
// into the intervals list
void
DocumentMouse::ConfirmSelection()
{
  IntervalList* il = this->editor->GetSelection();
  
  if (this->button_down_point != NULL)
  {
    // if the user was cancelling a selection(by control-clicking
    // within a selection) the standard thing to do is get rid of the
    // selection started with the cancelling click.  There are two
    // cases when we can't do this, however: one is when he dragged
    // after the control-click; this is defined as creating a new
    // selection.  (This selection is currently at the head of the
    // list, so we implement this feature by simply not deleting it.)
    // The other is when there are no other selections.

    if (this->cancelling_selection)
    {
      if (!il->SingleP() && (il->GetHead())->PointP())
      {
	il->CutOffHead();
      }
      this->cancelling_selection = False;
    }
    il->MergeWithFirst();   // merge overlapping selections
    il->GetHead()->TurnOffBlueOnYellow();
  }
  (this->editor->GetSelection())->InferAttributes();
}

// ------------------------------------------------------------
// multiple cell selection

void
DocumentMouse::InvalidateFrame(FrameInstance* frame)
{
  assert(Selected_Window != NULL);
  
  if ((this->button_down_point->GetTextFlow())->OnZeroPageP())
  {
    Selected_Window->InvalidateZeroPage(frame);
  }
  else
  {
    Lrect lrect[1];
    frame->get_lrect(lrect);
    Selected_Window->Invalidate(lrect);
  }
}

void
DocumentMouse::SelectMultiCell(Lpoint* lp)
{
  Lrect zone_lrect[1];
  Lrect lrect[1];
  this->multi_cell_start_frame->get_lrect(zone_lrect);
  SET_RECT(lrect,
	    POINT_X(lp), POINT_Y(lp), POINT_X(lp) + 1, POINT_Y(lp) + 1);
  lrect_or(zone_lrect, lrect);
  for (FrameInstance* frame = (this
			       ->multi_cell_start_frame
			       ->GetLayout() ->GetFirstFrame());
       frame != NULL; frame = frame->GetNextLFI())
  {
    frame->get_lrect(lrect);
    bool primary = false;
    bool secondary = false;
    if (lrect_insidep(lrect, lp))
    {
      primary = true;
    }
    else if (lrect_intersectp(lrect, zone_lrect))
    {
      secondary = true;
    }

    if (!!frame->PrimaryBackgroundP() != primary
	|| !!frame->SecondaryBackgroundP() != secondary)
    {
      frame->SetPrimaryBackground(primary);
      frame->SetSecondaryBackground(secondary);
      this->InvalidateFrame(frame);
    }
  }
}

IntervalList* 
DocumentMouse::ClearMultiCell()
{
  IntervalList* list = new IntervalList;
  LayoutInstance* layout = this->multi_cell_start_frame->GetLayout();
  for (FrameInstance* frame = layout->GetFirstFrame();
       frame != NULL; frame = frame->GetNextLFI())
  {
    if (frame->PrimaryBackgroundP() || frame->SecondaryBackgroundP())
    {
      TextFlow* flow = frame->GetTextFlow();
      list->AddIntervalAtHead(new Interval(flow));
      for (FrameInstance* f = flow->GetFirstFrame();
	   f != NULL; f = f->GetNextTextFrame())
      {
	if (frame->PrimaryBackgroundP() || frame->SecondaryBackgroundP())
	{
	  frame->SetPrimaryBackground(False);
	  frame->SetSecondaryBackground(False);
	  this->InvalidateFrame(frame);
	}
      }
    }
  }
  return(list);
}

// ------------------------------------------------------------
// public methods

void
DocumentMouse::WndProc(MSG_T message, WPARAM_T wParam, LPARAM_T lParam)
{
  DocumentWindow* window = this->editor->GetDocumentWindow();
  Lpoint lp[1];
  SET_POINT(lp,
	     window->LunitX(LPARAM_TO_X(lParam)),
	     window->LunitY(LPARAM_TO_Y(lParam)));
  BP* button_down_point = this->button_down_point;
  switch (message)
  {
   case WM_LBUTTONDBLCLK:
   case WM_LBUTTONDOWN:
    this->Clean();
    this->shift_state = wParam;
    this->multi_cell_p = False;
    this->double_clicking = (message == WM_LBUTTONDBLCLK);
    this->cancelling_selection = False;
    button_down_point = window->navigate_bp(lp,
					     NULL,
					     &this->multi_cell_start_frame);
    if (button_down_point == NULL)
    {
      ::MessageBeep(0);
    }
    else
    {
      TextFlow* flow = button_down_point->GetTextFlow();
      if (!flow->OnTableP())
      {
	this->multi_cell_start_frame = NULL;
      }
      if (flow->OnZeroPageP())
      {
	LayoutInstance* top = LayoutInstance::GetZeroMappedLayout();
	if (top == NULL
	    || !top->VisibleZeroPage()
	    || !top->GetZeroPageLayout() ->VisibleZeroPage()
	    || top->GetDocumentContent() ->GetLogicalPageNum(top) <= 0)
	{
	  delete button_down_point;
	  ::MessageBeep(0);
	  break;
	}
	window->SetZeroCaretLayout(top);
      }
      this->button_down_point = button_down_point;
      this->SetupSelection(button_down_point);
      ((this->editor->PrimarySelection())
       ->IncDefRegion(button_down_point, (bool)(this->double_clicking != 0)));
    }
    break;
    
   case WM_MOUSEMOVE:
    if (window != Selected_Window)
    {
      MouseCursor::Arrow();
    }
    else if (button_down_point == NULL)
    {
      LayoutInstance* layout = window->navigate_layout1(lp);
      FrameInstance* frame = layout->navigate_frame1(lp);
      if (frame != NULL)
      {
	int tategakip = frame->GetFastTextFlow() ->tategaki_flow_p();
	if (layout->GetTemplate() ->IsZeroPage())
	{
	  if (tategakip)
	  {
	    MouseCursor::VFooter();
	  }
	  else
	  {
	    MouseCursor::Footer();
	  }
	}
	else
	{
	  if (tategakip)
	  {
	    MouseCursor::HBeam();
	  }
	  else
	  {
	    MouseCursor::IBeam();
	  }
	}
      }
      else
      {
	MouseCursor::Arrow();
      }
    }
    else
    {
      if (!this->multi_cell_p && this->multi_cell_start_frame != NULL)
      {
	FrameInstance* other_frame;
	BP* bp = window->navigate_bp(lp, NULL, &other_frame);
	if (bp != NULL
	    && other_frame != NULL
	    && bp->GetTextFlow() != button_down_point->GetTextFlow()
	    && (other_frame->GetLayout()
		== this->multi_cell_start_frame->GetLayout()))
	{
	  this->multi_cell_p = True;
	}
	delete bp;
      }
      if (this->multi_cell_p)
      {
	this->SelectMultiCell(lp);
      }
      else
      {
	BP* bp = window->navigate_bp(lp, button_down_point, NULL);
	if (bp != NULL)
	{
	  button_down_point->Set(bp);
	  (this
	   ->editor
	   ->PrimarySelection() ->IncDefRegion(bp, (bool)(this->double_clicking != 0)));
	  delete bp;
	}
      }
    }
    break;

   case WM_LBUTTONUP:
    if (window == Selected_Window && button_down_point != NULL)
    {
      if (this->multi_cell_p)
      {
	IntervalList* list = this->ClearMultiCell();
	(this->editor->GetSelectionStack())->InstallSelection(list);
      }
      else
      {
	BP* bp = window->navigate_bp(lp, button_down_point, NULL);
	if (bp != NULL)
	{
	  button_down_point->Set(bp);
	  ((this->editor->PrimarySelection())
	   ->IncDefRegion(bp, (bool)(this->double_clicking != 0)));
	  delete bp;
	}
	this->ConfirmSelection();
      }
      this->Clean();
      this->editor->DidMouseMove();
    }
    break;
  }
}
