// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docprese.h,v 3.3 2000/05/04 13:44:04 kudou Exp $
// define DocumentPresentation class
// The DocumentPresentation class categorizes user-visible aspects
// of an open document -- primarily their windows.

#ifndef DOCPRESE_H
#define DOCPRESE_H

#include "frametem.h"
#include "frameins.h"

// declare parameterized list types for lists of document windows

class DocumentPresentation
{
private:
  // of which this is presentation
  Document* document;
  // document window list
  DocumentWindow* first_docwindow;
  bool request_caret_control;
  bool error;

public:
  DocumentPresentation(Document* dw);
  ~DocumentPresentation();

public:
  void AddDocumentWindow(DocumentWindow* dw);
  void RemoveDocumentWindow(DocumentWindow* dw);
  
  void SafeDestruct();
  void Init();
  void Reset();
  
  Document* GetDocument() { return document; }
  DocumentWindow* GetFirstDocWindow();
  void SetFirstDocWindow(DocumentWindow* w);
  bool GetRequestCaretControl()
  {
    return(this->request_caret_control);
  }
  void RequestCaretControl()
  {
    this->request_caret_control = True;
  }
  void CheckCaret();
  void ControlCaret();
  void Open();
  void Close();
  DocumentWindow* NewDocumentWindow(bool pref_size);
  void Activate();
  
  // close one of the presentation's windows(maybe)
  void CloseWindow(DocumentWindow*);
  
  // redraw document window
  void RedrawWindows();
  void Invalidate(Lrect* r);
  void InvalidateZeroPage(FrameInstance* frame);
  
  // get first layout
  // * You shuld better to call DocumentContent's GetFirstLayout()
  // when you know the pointer to DocumentContent.
  LayoutInstance* GetFirstLayout();
  
  // get last layout
  // * You shuld better to call DocumentContent's GetFirstLayout()
  // when you know the pointer to DocumentContent.
  LayoutInstance* GetLastLayout();
  
  // write to stream
  void WriteFormattedToStream(PStream*);
  void ReadFormattedFromStream(PStream*);
};

inline DocumentWindow* 
DocumentPresentation::GetFirstDocWindow()
{
  return(this->first_docwindow);
}

// set first doc-window
inline void
DocumentPresentation::SetFirstDocWindow(DocumentWindow* w)
{
  this->first_docwindow = w;
}

#endif /* DOCPRESE_H */
