// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docsel.cpp,v 3.5 2000/05/03 05:11:42 kudou Exp $
// implement DocumentSelection class, for
// managing a stack of current selections.

#include "pword.h"
#include "pmenus.h"
#include "attribut.h"
#include "marks.h"
#include "setmark.h"
#include "document.h"
#include "docedit.h"
#include "docwindo.h"
#include "docconte.h"
#include "pundo.h"
#include "mcursor.h"
#include "pstreams.h"
#include "again.h"
#include "bound.h"
#include "bufnew.h"
#include "intlist.h"
#include "interval.h"
#include "layoutin.h"
#include "frameins.h"
#include "pagemap.h"
#include "panel.h"
#include "table.h"
#include "textflow.h"
#include "tablepnl.h"
#include "docsel.h"

// private method
void NEAR
DocumentSelection::Term(int leave_first)
{
  for (int i = (leave_first ? 1 : 0); i < PREV_LOC_STACK_SIZE; i++)
  {
    if (intervals_stack[i])
    {
      delete intervals_stack[i];
      intervals_stack[i] = NULL;
    }
  }
}

// private method
void NEAR
DocumentSelection::Init(DocumentEdit* e)
{
  editor = e;
  for (int i = 1; i < PREV_LOC_STACK_SIZE; i++)
  {
    intervals_stack[i] = NULL;
  }
  intervals_stack[0] = new IntervalList;
  did_something_here = False;
}

DocumentSelection::~DocumentSelection()
{
  Term(False);
}

// constructor for DocumentSelection -- create a new selection stack
// the first entry is a new interval list, with no head yet.
// other entries are null.
DocumentSelection::DocumentSelection(DocumentEdit* e)
{
  Init(e);
}

DocumentSelection::DocumentSelection(DocumentEdit* e, PStream* stream)
{
  Init(e);
  
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_DOCSEL, vers);
  CHECK;
  
  BoundIntervalList* bil = new BoundIntervalList;
  bil->ReadFromStream(stream); 
  CHECK;
  
  IntervalList* il = bil->Unbind(editor->GetDocumentContent());
  delete bil;
  intervals_stack[0] = il;
  il->InferAttributes();
  
  stream->EndBlockIn();
  CHECK;
}

void
DocumentSelection::Reset()
{
  Term(False);
  Init(editor);
}

// INTERVAL STACK MANAGEMENT

// ShiftUp is a utility used by PushStack and InstallInterval.
// It moves the stack back to make room for a new entry at the start.
void NEAR
DocumentSelection::ShiftUp()
{
  if (intervals_stack[PREV_LOC_STACK_SIZE-1])
  delete intervals_stack[PREV_LOC_STACK_SIZE-1];
  
  for (int i=PREV_LOC_STACK_SIZE-1; i>=1; i--)
  intervals_stack[i] = intervals_stack[i-1];
}

// ShiftStackDown shifts the stack down and tells you where the new back
// of the stack is
IntervalList** NEAR
DocumentSelection::ShiftDown()
{
  for (int i = 0; i < PREV_LOC_STACK_SIZE; i++)
  {
    intervals_stack[i] = intervals_stack[i + 1];
    if (intervals_stack[i] == NULL)
    {
      return(&intervals_stack[i]);
    }
  }
  intervals_stack[PREV_LOC_STACK_SIZE - 1] = NULL;
  return(&intervals_stack[PREV_LOC_STACK_SIZE - 1]);
}


// PushStack is used right before some action which is going
// to cause the location to change when we want to remember
// the old one.  It leaves you with a copy of the current 
// interval set as the current one.  No need to turn on and off.
void NEAR
DocumentSelection::Push()
{
  ShiftUp();
  intervals_stack[0] = new IntervalList(intervals_stack[1]);
}


// InstallSelection does NOT copy your list of intervals, just
// installs it.  This is used by FindText after searching, for
// example.

void
DocumentSelection::InstallSelection(IntervalList* il)
{
  if (il)
  {
    InstallSelectionNoCaret(il);
    GetEditor() ->GetDocumentWindow() ->ForceTouchCaret();
  }
}

void
DocumentSelection::InstallSelectionNoCaret(IntervalList* il)
{
  if (!il)
  {
    return;
  }
  IntervalList* old_il = GetSelection();
  if (!old_il)
  {
    return;
  }
  old_il->TurnOff();
  ShiftUp();
  intervals_stack[0] = il;
  il->TurnOn();
  il->InferAttributes();
  
  DocumentEdit* editor = GetEditor();
  editor->GetDocumentWindow() ->UnforceTouchCaret();
  editor->GetDocumentContent() ->GetUndo() ->SetMoved();
}

void
DocumentSelection::GotoMark(IntervalList* i)
{
  InstallSelection(new IntervalList(i));
}

BP* NEAR 
DocumentSelection::GetPageBP(TextFlow* tf, word page)
{
  while (tf->OnTableP())
  {
    FrameInstance* fi = tf->GetFirstFrame();
    if (fi)
    {
      Table* tb = (Table*)fi->GetLayoutInstance() ->GetPageMap();
      tf = tb->GetPanel() ->GetTextFlow();
    }
    else
    {
      break;
    }
  }
  
  LayoutInstance* li = (editor->GetDocumentContent()
			->GetLayoutByLogicalPageNum(page));
  assert(li != 0);
  BP* bp = 0;
  LayoutInstance* zero_li = li->GetZeroPageLayout();
  for (int n = 0; n < 4; n++)
  {
    FrameInstance* fi;
    switch (n)
    {
     case 0:      // search normal page frame
      fi = li->FindFIByFT(li->GetPageMap() ->GetGateFT(tf));
      break;
     case 1:      // search zero page frame
      fi = zero_li->FindFIByFT(zero_li->GetPageMap() ->GetGateFT(tf));
      break;
     case 2:	  // any normal page frame
     case 3:      // any zero page frame
      {
	LayoutInstance* s_li = (n == 2) ? li : zero_li;
	uword gn = s_li->GetPageMap() ->GetGateSize();
	for (uword g = 1; g <= gn; g++)
	{
	  fi = s_li->FindFIByFT(s_li->GetPageMap() ->GetGateFT(g));
	  if (fi)
	  {
	    break;
	  }
	}
      }
      break;
    }
    if (fi)
    {
      bp = fi->GetFirstBP();
      if (fi != bp->FindFrame())
      {
	bp = 0;
      }
    }
    if (bp)
    {
      break;
    }
  }
  return bp;
}

#ifdef BW3_DISPATCH
LRESULT_T NEAR
DocumentSelection::GotoTopBot(bool menu_state_p, int top)
#else /* BW3_DISPATCH */
long NEAR 
DocumentSelection::GotoTopBot(int menu_state_p, int top)
#endif /* BW3_DISPATCH */
{
  Interval* head = this->GetSelection() ->GetHead();
  BP bp(head->GetBP0());
  if (head->GetNext() == NULL
      && head->PointP() && !(bp.GetTextFlow() ->OnTableP()))
  {
    if ((top && bp.BeginningOfTextP()) || (!top && bp.EndOfTextP()))
    {
      return(disabled_command(menu_state_p));
    }
  }
  if (!menu_state_p)
  {
    Again::CantDoAgain();
    for (;;)
    {
      TextFlow* flow = bp.GetTextFlow();
      if (!flow->OnTableP())
      {
	break;
      }
      bp.Set(flow
	      ->GetFirstFrame() ->GetLayout() ->GetPanel() ->GetRightBP());
    }
    if (top)
    {
      bp.BeginningOfText();
    }
    else
    {
      bp.EndOfText();
    }
    InstallSelection(new IntervalList(new Interval(&bp)));
  }
  // MF_ENABLE == 0
  return 0;
}

#ifdef BW3_DISPATCH
LRESULT_T NEAR
DocumentSelection::GotoPage(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
DocumentSelection::GotoPage(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (!menu_state_p)
  {
    DocumentContent* doc_conte = editor->GetDocumentContent();
    DocumentWindow* doc_win = editor->GetDocumentWindow();
    LayoutInstance* first_li = doc_conte->GetFirstLayout();
    int first_pageno = doc_conte->GetLogicalPageNum(first_li);
    int total_page_num = doc_conte->GetTotalPage();
    int current_page_num = doc_win->GetCaretPageNum();
    NumberDialog dialog("PageJumpDialog", first_pageno, 
			first_pageno + total_page_num - 1,
			current_page_num);
    if (dialog.Go())
    {
      int jump_page = dialog.get_value();
      LayoutInstance* li = (doc_conte->
			    GetLayoutByLogicalPageNum((word)jump_page));
      if (li)
      {
	// set view page
	doc_win->SetViewOnLayout(li);
	// set caret position
	BP* bp = GetPageBP(doc_win->GetCaretTextFlow(), jump_page);
	if (bp)
	{
	  InstallSelection(new IntervalList(new Interval(bp)));
	}
      }
    }
  }
  // MF_ENABLE == 0
  return 0;
}

#ifdef BW3_DISPATCH
LRESULT_T
DocumentSelection::Dispatch(bool menu_state_p, WORD command)
#else /* BW3_DISPATCH */
long 
DocumentSelection::Dispatch(int menu_state_p, int command)
#endif /* BW3_DISPATCH */
{
  // MF_ENABLED is a 0.
#ifdef BW3_DISPATCH
  LRESULT_T result = 0;
#else /* BW3_DISPATCH */
  long result = 0;
#endif /* BW3_DISPATCH */
  switch (command)
  {
   case IDM_Location_Top:
    result = GotoTopBot(menu_state_p, True);
    break;
    
   case IDM_Location_Bot:
    result = GotoTopBot(menu_state_p, False);
    break;
    
   case IDM_Location_GotoPage:
    result = GotoPage(menu_state_p);
    break;
    
   case IDM_Location_NextSelection:
   case IDM_Location_PrevSelection:
    if (this->GetSelection() ->GetHead() ->GetNext() == NULL)
    {
      result = disabled_command(menu_state_p);
    }
    else if (!menu_state_p)
    {
      Again::CantDoAgain();
      GetEditor() ->WillMove();
      GetSelection() ->Cycle(command == IDM_Location_NextSelection ? 1 : -1);
      GetEditor() ->DidMove();
    }
    break;
    
   case IDM_Location_PrevLocation:
    if (intervals_stack[1] == NULL)
    {
      result = disabled_command(menu_state_p);
    }
    else if (!menu_state_p)
    {
      Again::CantDoAgain();
      GetSelection() ->TurnOff();
      IntervalList* i = intervals_stack[0];
      IntervalList** stack_back = ShiftDown();
      *stack_back = i;
      GetSelection() ->TurnOn();
      GetEditor() ->DidMove();
      did_something_here = True;
    }
    break;
    
   case IDM_Location_MakeMark:
    if (!menu_state_p)
    {
      char* hint = this->GetSelection() ->GetHead() ->GetHint();
      SetMarkDialog setmark_dialog(hint);
      if (setmark_dialog.Go()) 
      {
	MakeMark(setmark_dialog.GetMarkName());
      }
      delete hint;
    }
    break;
  }
  return result;
}

void 
DocumentSelection::MakeMark(char* name)
{
  WillEdit();
  GlobalMarkTable.MakeMark(name, 
			    GetEditor() ->GetDocument(), 
			    new IntervalList(GetSelection()));
  DidEdit();
}

void
DocumentSelection::WillEdit()
{
  if ((this->big_p = this->GetSelection() ->BigP()) != 0)
  {
    MouseCursor::StartLongActivity();
  }
}

void
DocumentSelection::DidEdit()
{
  did_something_here = True;
  if (this->big_p)
  {
    MouseCursor::EndLongActivity();
  }
}

// WillMove is called right BEFORE the user
// does something that will result in his going to a different place,
// to that we can remember the location

void
DocumentSelection::WillMove()
{
  if (did_something_here)
  {
    did_something_here = False;
    Push();
  }
}

void
DocumentSelection::DidMove()
{
}

void
DocumentSelection::ReportDeadTextFlow(TextFlow* tf, BufferPointer* bp)
{
  IntervalList*& il = intervals_stack[0];
  Term(True /* leave first interval */);
  il->WeedDeadTextFlow(tf);
  if (!il->GetHead())
  {
    if (bp)
    {
      Interval* i;
      il->AddInterval(i = new Interval(bp));
      i->InferAttributes();
    }
    else 
    {
      // assert(closing document);
    }
  }
#if (0)
  DocumentEdit* ed = GetEditor();
  
  if (il->GetHead() && !ed->GetDocumentContent() ->GetShuttingDown())
  {
    ed->GetDocumentWindow() ->UnforceTouchCaret();
  }
#endif
}

void
DocumentSelection::WriteToStream(PStream* stream)
{
  stream->StartBlockOut(PStream::HDR_DOCSEL);
  CHECK;
  
  BoundIntervalList bil;
  bil.Copy(GetSelection());
  bil.WriteToStream(stream); CHECK;
  
  stream->EndBlockOut();
  CHECK;
}
