// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docsel.h,v 3.3 1999/05/12 00:22:16 kudou Exp $
// define DocumentSelection class, for managing
// selections on documents.
// The main job of this class is to manage a stack of "previous"
// locations.  It is not allowed to DO anything with the selections
// it manages except shuffle them around.

#ifndef DOCSEL_H
#define DOCSEL_H

class DocumentSelection
{
  enum { PREV_LOC_STACK_SIZE = 3 };
  
  IntervalList* intervals_stack[PREV_LOC_STACK_SIZE];
  bool did_something_here;
  DocumentEdit* editor;
  bool big_p;
  
public:
  DocumentSelection(DocumentEdit* e);
  DocumentSelection(DocumentEdit* e, PStream* stream);
  ~DocumentSelection();

private:
  BP* NEAR GetPageBP(TextFlow* advise_tf, word page);
  IntervalList** NEAR ShiftDown();
#ifdef BW3_DISPATCH
  LRESULT_T NEAR GotoPage(bool menu_state_p);
  LRESULT_T NEAR GotoTopBot(bool menu_state_p, int top);
#else /* BW3_DISPATCH */
  long NEAR GotoPage(int menu_state_p);
  long NEAR GotoTopBot(int menu_state_p, int top);
#endif /* BW3_DISPATCH */
  void NEAR Init(DocumentEdit*);
  void NEAR Push();
  void NEAR ShiftUp();
  void NEAR Term(int leave_first);

public:
  DocumentEdit* GetEditor();
  IntervalList* GetSelection();
#ifdef BW3_DISPATCH
  LRESULT_T Dispatch(bool menu_state_p, WORD command);
#else /* BW3_DISPATCH */
  long Dispatch(int menu_state_p, int command);
#endif /* BW3_DISPATCH */
  void DidEdit();
  void DidMove();
  void GotoMark(IntervalList* i);
  void InstallSelection(IntervalList*);
  void InstallSelectionNoCaret(IntervalList* il);
  void MakeMark(char*);
  void ReportDeadTextFlow(TextFlow* , BufferPointer* bp);
  void Reset();
  void WillEdit();
  void WillMove();
  void WriteToStream(PStream*);
};

inline IntervalList* 
DocumentSelection::GetSelection()
{
  return(intervals_stack[0]);
}

inline DocumentEdit* 
DocumentSelection::GetEditor()
{
  return(editor);
}

#endif /* DOCSEL_H */
