// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: document.cpp,v 3.15 2000/05/03 16:52:36 kudou Exp $
// implement Document class

#include "pword.h"
#include <time.h>
#ifndef _WIN32
#include <drivinit.h>
#endif /* _WIN32 */
#include "pmenus.h"
#include "attribut.h"
#include "marks.h"
#include "atts.h"
#include "mcursor.h"
#include "pwordbas.h"
#include "pref.h"
#include "mwindow.h"
#include "abortpri.h"
#include "fileopen.h"
#include "printdlg.h"
#include "saveasdl.h"
#include "searchdl.h"
#include "bufnew.h"
#include "intlist.h"
#include "interval.h"
#include "textflow.h"
#include "fileutil.h"
#include "rect.h"
#include "layoutte.h"
#include "layoutin.h"
#include "vdisplay.h"
#include "editpage.h"
#include "lman.h"
#include "document.h"
#include "docsel.h"
#include "docprese.h"
#include "docconte.h"
#include "docedit.h"
#include "docwindo.h"
#include "editfram.h"
#include "printeri.h"
#include "xstr.h"

#ifndef NDEBUG
#include "ddisplay.h"
#endif

bool printing_now_p = False;

#if (_MSC_VER == 1200)
// disable 'this' pointer usage waring
#pragma warning (disable:4355)
#endif
Document::Document() 
 : content(* (new DocumentContent(this))),
   presentation(* (new DocumentPresentation(this))),
   frame_editor(* (new EditFrame(this))),
   page_editor(* (new EditPage(this)))
{
  error = 0;
  next_document = 0;
  *name = *path_name = '\0';
  text_format = 0;
  saving = False;
#ifdef BW3_FILEVERSIONSAVE
  file_version = BW_FILE_SAVE_VERSION;
  file_miner_version = BW_FILE_SAVE_MINER_VERSION;
  file_beta_version = BW_FILE_SAVE_BETA_VERSION;
  file_miner_beta_version = BW_FILE_SAVE_MINER_BETA_VERSION;
#endif /* BW3_FILEVERSIONSAVE */
}

// create new documents
Document*
Document::MakeNew()
{
  Document*d = new Document;
  if (d != NULL)
  {
    d->SetUntitledName();  
    d->NewFile();
    if (!d->error) {
      d->presentation.Open();
      if (d->GetFirstDocWindow() == NULL)
      {
	d->error = 1;
	Issue(S_CantOpenWindowMsg, MB_OK | MB_ICONEXCLAMATION);
      }
    }
    if (d->error != 0)
    {
      // do not delete!  Delete will probably cause crash
      // delete d;
      d->SafeDestruct();
      d = 0;
    }
  }
  return d;
}

// make from file, just up to memo
Document* 
Document::MakeForMemo(char* name)
{
  Document* d = new Document;
  d->SetPathName(name);
  d->ReadInFileUntilMemo();
  if (d->error)
  {
    d->SafeDestruct();
    d = NULL;
  }
  return(d);
}

// constructor for existing documents
Document* 
Document::MakeFromFile(char* name)
{
  Document* d = new Document;
  d->SetPathName(name);
  d->ReadInFile();
  if (!d->error)
  {
    d->presentation.Open();
    d->CheckWindow();
  }
  if (d->error != 0)
  {
    d->SafeDestruct();
    d = NULL;
  }
  return(d);
}

// constructor for reverting
Document* 
Document::MakeForRevert(Document* prev)
{
  Document* d = new Document;
  d->text_format = prev->text_format;
  d->crtype = prev->crtype;
  d->SetPathName(prev->GetPathName());
  d->ReadInFile(True);
  if (!d->error) 
  {
    d->presentation.Open();
    d->CheckWindow();
  }
  if (d->error != 0)
  {
    d->SafeDestruct();
    d = NULL;
  }
  return(d);
}

void
Document::CheckWindow()
{
  if (this->GetFirstDocWindow() == NULL)
  {
    this->error = 1;
    Issue(S_CantOpenWindowMsg, MB_OK | MB_ICONEXCLAMATION);
  }
}

void
Document::SetUntitledName()
{
  SetPathName("");
}

Document::~Document()
{
  // if we don't close down the presentation first,
  // something like trying to delete a document window
  // might activate another window which would try to
  // do stuff even though important other pieces, such
  // as the content, had gotten destroyed already.
  // The call below closes all the windows.
  
  MouseCursor::StartLongActivity();
  if (Selected_Document==this)
  {
    Selected_Document = 0;
  }
  presentation.Close();
  delete &content;
  delete &presentation;
  delete &frame_editor;
  delete &page_editor;
  if (Selected_Document == this)
  {
    Selected_Document = 0;
  }
  MouseCursor::EndLongActivity();
}

void
Document::SafeDestruct()
{
  GetDocumentContent() -> SafeDestruct();
  GetDocumentPresentation() -> SafeDestruct();
}

// NAMEpXƂĐݒ肷B܂ANAMEhLg߁A
// ݒ肷BANAME󕶎ȂΖhLgƂ݂ȂB
// private method
void NEAR
Document::SetPathName(char* path_name)
{
  ::copy_string(this->path_name, path_name, DOCNAMELEN);
  char* name = (path_name[0] == '\0' ? S_Untitled
		: FileUtil::GetFileNameOnly(path_name));
  char* buffer = (char*) xmalloc(strlen(name) + sizeof("<0123456789>"));
  strcpy(buffer, name);
  int count = 1;
  for (;;)
  {
    Document* d = PWordBase::GetFirstDocument();
    for (; d != NULL; d = d->next_document)
    {
      if (d != this && strcmp(d->name, buffer) == 0)
      {
	break;
      }
    }
    if (d == NULL)
    {
      break;
    }
    ++count;
    wsprintf(buffer, "%s<%d>", name, count);
  }
  ::copy_string(this->name, buffer, DOCNAMELEN);
  xfree(buffer);
  for (DocumentWindow* dw = this->GetFirstDocWindow();
       dw != NULL; dw = dw->GetNextDocWindow())
  {
    dw->SetName(this->name);
  }
  content.VariableTextUpdateFileName();
}

char*
Document::GetName()
{
  return name;
}

void
Document::NewBufSetup()
{
  content.DefaultFrameSetup();
}

DocumentWindow* 
Document::GetFirstDocWindow()
{
  return(this->GetDocumentPresentation() ->GetFirstDocWindow());
}

// Dispatch -- dispatch WM_COMMAND like messages
//
// Commands come here because the dispatcher in MainWindow sent them
// here.

// private method
void
Document::search_string(char* s, int reverse, int all)
{
  PWordPresentation::GetSearchDialog() ->set_string(s);
  sjis* sj = jisz_spread(s, NULL);
  IntervalList* il = this->FindText(sj, (bool)(reverse != 0), (bool)(all != 0));
  delete sj;
  if (il == NULL)
  {
    StatusOut(S_Search_Failed);
    ::MessageBeep(0);
  }
  else 
  {
    if (all)
    {
      StatusOut(S_Search_Succeeded, il->Count());
    }
    Selected_Window->SetFocus();
  }
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
Document::SearchAgain(bool menu_state_p, int reverse)
#else /* BW3_DISPATCH */
long NEAR
Document::SearchAgain(int reverse, int menu_state_p)
#endif /* BW3_DISPATCH */
{
  SearchDialog* s = PWordPresentation::GetSearchDialog();
  if (s == NULL || (s->String()) [0] == '\0')
  {
    return(disabled_command(menu_state_p));
  }
  if (menu_state_p)
  {
    return(MF_ENABLED);
  }
  this->search_string(s->String(), reverse, False);
  return(0);
}

#ifdef BW3_DISPATCH
LRESULT_T
Document::Dispatch(bool menu_state_p, WORD command)
#else /* BW3_DISPATCH */
long
Document::Dispatch(int command, int menu_state_p)
#endif /* BW3_DISPATCH */
{
  switch (command)
  {
   case IDM_File_Close:
    if (!menu_state_p)
    {
      Close();			// might or might not...
    }
    break;
    
   case IDM_Location_FindGo:
    if (!menu_state_p)
    {
      SearchDialog* s = PWordPresentation::GetSearchDialog();
      this->search_string(s->String(), s->Reverse(), s->All());
    }
    break;
    
   case IDM_Location_SearchForward:
#ifdef BW3_DISPATCH
    return(this->SearchAgain(menu_state_p, False));
#else /* BW3_DISPATCH */
    return(this->SearchAgain(False, menu_state_p));
#endif /* BW3_DISPATCH */
    
   case IDM_Location_SearchBackward:
#ifdef BW3_DISPATCH
    return(this->SearchAgain(menu_state_p, True));
#else /* BW3_DISPATCH */
    return(this->SearchAgain(True, menu_state_p));
#endif /* BW3_DISPATCH */
    
   case IDM_File_Revert:
    if (!GetDocumentContent() ->GetDirty() || !*path_name)
    {
      return(disabled_command(menu_state_p));
    }
    if (!menu_state_p)
    {
      if (IssueVA(S_ConfirmRevertMsg, MB_ICONQUESTION | MB_YESNO, name)
	== IDYES)
      {
	PWordBase::RevertDocument(this);
      }
    }
    break;
    
   case IDM_File_Save:
    if (!(GetDocumentContent() ->GetDirty())
	|| this->saving || PWordBase::GetLobotomized())
    {
      return(disabled_command(menu_state_p));
    }
    if (menu_state_p)
    {
      break;
    }
    if (*path_name != '\0') 
    {
      this->saving = True;
      WriteOutFile();
      int res = !this->error;
      this->saving = False;
      this->error = False;
      return res;
    }
    // fall through
    
   case IDM_File_SaveAs:
    {
      if (this->saving || PWordBase::GetLobotomized())
      {
	return(disabled_command(menu_state_p));
      }
      if (menu_state_p)
      {
	break;
      }
      
      char filename[MAX_PATH + 1];
      ::copy_string(filename,
		     path_name[0] == '\0' ? S_WildCard : path_name, MAX_PATH);
      this->saving = True;
#ifdef BW3_FILEDLG
      int saved = this->SaveAsDlg(filename, S_WildCard2, text_format);
#else /* BW3_FILEDLG */
      int saved = this->SaveAsDlg(filename, text_format);
#endif /* BW3_FILEDLG */
      if (saved) 
      {
	main_window->Update();
	this->SetPathName(filename);
	this->WriteOutFile();
	saved = !this->error;
	this->error = False;
	GlobalMarkTable.NewDocumentName(this);
#ifdef BW3_RECENTOPEN
	PWordBase::RegisterRecentOpenFileName(filename);
#endif /* BW3_RECENTOPEN */
      }
      this->saving = False;
      
      return(saved);
    }
    
   case IDM_File_Print:
    if (!menu_state_p)
    {
      HDC hDC = GetPrinterInfo() ->CreateDC();
      if (!hDC)
      {
	Issue(S_NoPrinterAttachedMsg, MB_ICONEXCLAMATION | MB_OK);
      }
      else
      {
	DocumentContent* dc = GetDocumentContent();
	dc->Format();
	
	int n = dc->GetTotalPage();
	int first = dc->GetFirstPageNumber();
	int from = 0;
	int to = 0;
	int copies = 0;
	bool from_default = False;
	bool to_default = False;
	bool copies_default = False;
	bool sel_only = False;
	bool status = False;
	bool reverse_print_p = False;
	{
	  PrintDialog dialog(GetPrinterInfo() ->GetDeviceName(),
			      GetPrinterInfo() ->GetPortName(),
			 (!Selected_Window
			       ->GetEditor() ->GetSelection() ->PointP()),
			      first, first+n-1);
	  status = (bool)(dialog.Go() != 0);
	  if (status)
	  {
	    dialog.GetValues(sel_only, 
			      from_default, from, 
			      to_default, to, 
			      copies_default, copies);
	    reverse_print_p = dialog.ReversePrintP();
	  }
	}
	if (status)
	{
	  if (from_default)
	  {
	    from = first;
	  }
	  else if (from < first)
	  {
	    from = first;
	  }
	  if (to_default)
	  {
	    to = first+n-1;
	  }
	  else if (to > first+n-1)
	  {
	    to = first+n-1;
	  }
	  if (copies_default)
	  {
	    copies = 1;
	  }
	  else if (copies<1)
	  {
	    copies = 1;
	  }
	  
	  MouseCursor::StartLongActivity();
	  
	  main_window->Update();
	  
	  GetDocumentContent() ->VariableTextUpdateTime();
	  GetDocumentContent() ->VariableTextUpdateFileName();
	  
	  // printing without screen update
	  printing_now_p = True;
	  Print(sel_only, from, to, copies, reverse_print_p);
	  printing_now_p = False;
	  
	  // redraw all windows
	  for (Document* d = PWordBase::GetFirstDocument();
	       d; d = d->GetNextDocument()) 
	  {
	    d->GetDocumentPresentation() ->RedrawWindows();
	  }
	  
	  MouseCursor::EndLongActivity();
	}
      }
      DeleteDC(hDC);
    }
    break;
    
#ifndef NDEBUG
   default:
    syserr("unknown msg %x in Document::WndProc", command);
#endif
  }
  // MF_ENABLED == 0
  return(0);
}

#ifdef BW3_FILEDLG
int
Document::SaveAsDlg(char* filename, char* filter_str, bool& format)
#else /* BW3_FILEDLG */
int
Document::SaveAsDlg(char* filename, bool& format)
#endif /* BW3_FILEDLG */
{
#ifdef BW3_FILEDLG
  SaveAsDialog saveas_dlg(filename, filter_str, format);
#else /* BW3_FILEDLG */
  SaveAsDialog saveas_dlg(this, filename, format);
#endif /* BW3_FILEDLG */
  int result = saveas_dlg.Go();
  if (result)
  {
    strcpy(filename, saveas_dlg.GetResult());
    format = saveas_dlg.GetSaveAsText();
  }
  return result;
}

IntervalList*
Document::FindText(sjis* what)
{
  return content.FindText(what);
}

void
Document::GotoMark(IntervalList* i)
{
  presentation.Activate();
  Selected_Window->GetEditor() ->GetSelectionStack() ->GotoMark(i);
}

int
Document::QueryEndSession(int local, int confirm)
{
  if (! content.GetDirty())
  {
    return(True);
  }
  
  switch (!confirm ? IDYES
	  : IssueVA(S_SaveChangesFormat,
		     (local ? (MB_APPLMODAL | MB_ICONQUESTION | MB_YESNOCANCEL)
		      : (MB_SYSTEMMODAL | MB_ICONQUESTION | MB_YESNOCANCEL)),
		     GetName()))
  {
   case IDYES:
    // the FileSave message returns a 0 if it failed,
    // including the case, for instance, where the user 
    // pressed cancel on the Save As box for an untitled
    // document.  We can therefore use its result 
    // directly as the result for this query.
#ifdef BW3_DISPATCH
    return (int)Dispatch(false, IDM_File_Save);
#else /* BW3_DISPATCH */
    return (int)Dispatch(IDM_File_Save, 0);
#endif /* BW3_DISPATCH */
    
   case IDNO:
    return(True);
  }
  return(False);
}


void
Document::Close()
{
  if (QueryEndSession(True /*local*/, True /* confirm */))
  {
    PWordBase::RemoveDocument(this);
  }
}

IntervalList*
Document::FindText(sjis* what, bool reverse, bool all) 
{
  MouseCursor::StartLongActivity();
  
  // if searching for all, ask the document to cycle through
  // its list of textflows
  
  IntervalList* result = NULL;
  
  if (all) 
  {
    result = this->FindText(what);
  }
  
  // otherwise ask the buffer pointer to look for the string after itself
  
  else {
    Interval* head = ::Selected_Window->GetEditor() ->GetSelection() ->GetHead();
    BufferPointer* bpp = reverse ? head->GetLeft() : head->GetRight();
    result = bpp->FindText(what, reverse);
    
    // search other flows
    TextFlow* starting_flow = head->GetTextFlow();
    TextFlow* flow = starting_flow;
    bpp = NULL;
    while (result == NULL)
    {
      if (reverse)
      {
	flow = flow->GetPrev();
	if (flow == NULL)
	{
	  flow = this->GetDocumentContent() ->GetLastTextFlow();
	}
	bpp = flow->GetEndBPCreate();
      }
      else
      {
	flow = flow->GetNext();
	if (flow == NULL)
	{
	  flow = this->GetDocumentContent() ->GetFirstTextFlow();
	}
	bpp = flow->GetBeginningBPCreate();
      }
      result = bpp->FindText(what, reverse);
      delete bpp;
      if (flow == starting_flow)
      {
	break;
      }
    }
  }
  
  // Update the display to reflect point at matching text
  Selected_Window
  ->GetEditor() ->GetSelectionStack() ->InstallSelection(result);
  
  MouseCursor::EndLongActivity();
  return result;
}

void
Document::DelayFormat()
{
  for (TextFlow* flow = (this->GetDocumentContent()) ->GetFirstTextFlow();
       flow != NULL; flow = flow->GetNext())
  {
    flow->DelayFormat();
  }
}

void
Document::Activate()
{
  presentation.Activate();
}

PrinterInfo*
Document::GetPrinterInfo()
{
  // right now, we just use the global one. 
  // Later, we might save this information for each document.
  return Printer_Info;
}


#if (VERSION_OF_WINDOWS_H < 31)
// from sdk31/include/print.h
typedef struct tagBANDINFOSTRUCT
{
  BOOL    fGraphics;
  BOOL    fText;
  RECT    rcGraphics;
} BANDINFOSTRUCT, FAR* LPBI;
#endif

static bool NEAR
escape_supported_p(HDC dc, int code)
{
  return (bool)(::Escape(dc, QUERYESCSUPPORT, sizeof(int), (LPSTR) &code, NULL) != 0);
}

// private method
void NEAR
Document::Print(int sel_only, int from, int to, int copies, int reversep)
{ 
  assert(Selected_Window != NULL);
  assert(from <= to);
  assert(0 < copies);
  
  int ok = 1;
  
  DocumentContent* conte = &this->content;
  PrinterInfo* printer_info = this->GetPrinterInfo();
  
  conte->Format();
  
#ifdef _WIN32
  bool device_support_copies_p = printer_info->DeviceSupportCopiesP();
  if (copies != 1 && device_support_copies_p)
  {
    printer_info->SetCopiesNum(copies);
  }
#endif /* _WIN32 */

  HDC dc = printer_info->CreateDC();
  if (dc == 0)
  {
    ok = -1;
  }
  
  int npages = 0;
  bool* page_map = NULL;
  
  if (!sel_only)
  {
    npages = to - from + 1;
  }
  
  else
  // if the user has asked us to print only the selection, we go through
  // the current selections marking a "page map" to tell us later
  // which pages to print
  
  {
    int total_pages = conte->GetTotalPage();
    page_map = new bool[total_pages + 1];
    memset(page_map, 0, sizeof(bool) * (total_pages + 1));
    
    IntervalList* il = Selected_Window->GetEditor() ->GetSelection();
    BaseIntervalListTraversor it(il);
    Interval* i;
    while ((i= (Interval*)++it) != NULL)
    {
      // this marking is physical page base
      
      BufferPointer* left = i->GetLeft();
      if (left->GetTextFlow() ->OnZeroPageP())
      {
	LayoutInstance* layout = Selected_Window->GetZeroCaretLayout();
	if (layout)
	{
	  int page = conte->GetPhysicalPageNum(layout);
	  if (!page_map[page])
	  {
	    page_map[page] = True;
	    npages++;
	  }
	}
      }
      else
      {
	int start = conte->GetPhysicalPageNum(left->FindTopLevelLayout());
	int end = conte->GetPhysicalPageNum(i
					     ->GetRight()
					     ->FindTopLevelLayout());
	assert(1 <= end && end <= total_pages);
	assert(1 <= start && start <= total_pages);
	for (int j = start; j <= end; j++)
	{
	  if (!page_map[j])
	  {
	    page_map[j] = True;
	    npages++;
	  }
	}
      }
    }
  }
  
  int npages_times_copies = npages * copies;
  int total_pages_out = 0;
  
  // Create an abort dialog and connect it to printer context
  
  AbortPrintDialog dialog(GetName(), printer_info->GetDeviceName());
  if (ok>0)
  {
    main_window->Enable(0);
#ifdef _WIN32
    ok = ::SetAbortProc(dc, (ABORTPROC)AbortPrintDialog::AbortProc);
#else /* _WIN32 */
    ok = Escape(dc,
		 SETABORTPROC,
		 NULL, (LPSTR) AbortPrintDialog::AbortProc, (LPSTR) NULL);
#endif /* _WIN32 */
  }
  
  // Diddle the printer 
  bool started_p = False;

#ifdef _WIN32
  DOCINFO di;
  di.cbSize = sizeof(DOCINFO);
  di.lpszDocName = GetName();	// Document Name
  di.lpszOutput = NULL;
  di.lpszDatatype = NULL;
  di.fwType = NULL;

  // DON'T set BANDING
  // Many Windows95 printer driver doesn't support banding. (kudou)
  // This flag cause printer Version 3.0 Beta-4 printing bug.
  // di.fwType = DI_APPBANDING;

  bool banding_need_p = false;
  if (Pref_printer_banding)
  {
    int cap = ::GetDeviceCaps(dc, RASTERCAPS);
    if (cap & RC_BANDING)
    {
      banding_need_p = true;
      di.fwType = DI_APPBANDING;
    }
  }
  
#endif /* _WIN32 */

  if (ok>0)
  {
#ifdef _WIN32
    ok = ::StartDoc(dc, &di);
#else /* _WIN32 */
    ok = ::Escape(dc, STARTDOC, lstrlen(name), name, 0);
#endif /* _WIN32 */
    started_p = True;
  }
  
  if (ok>0)
  {
    dialog.Go();
    dialog.SetDonePages(0);
    dialog.SetNPages(npages_times_copies);
  }
  
  View view;
  view.SetDeviceType(PRINTER);
  view.SetDC(dc);
  
  while (ok > 0 && 
	 copies > 0 &&
	 !dialog.GetAborted())
  {
#ifdef _WIN32
    int actual_copies = device_support_copies_p ? copies : 1;
    copies -= actual_copies;
#else /* _WIN32 */
    // number of copies management.  We try to get the device to automatically
    // print multiple copies, but it may not be able to(return 0) or
    // may not be able to print as many as we want.
    
    int actual_copies = 0;
    int can = 0;
    if (!Pref_interleave_output)
    {
      can = ::Escape(dc, SETCOPYCOUNT, sizeof(int), (LPSTR)&copies, 
		    (LPSTR)&actual_copies);
      // workaround for bug in some postscript drivers::
      // ignore "actual_copies" returned, assume all copies can be printed
      actual_copies = copies;
    }
    if (!can) // escape not supported
    {
      actual_copies = 1;
    }
    copies -= actual_copies;
#endif /* _WIN32 */
    
    // loop across document pages
    bool* page_map_entry = page_map + 1;
    int page = GetDocumentContent() ->GetFirstPageNumber();
    LayoutInstance* layout = presentation.GetFirstLayout();
    int firstp = True;
    if (reversep)
    {
      for (;;)
      {
	LayoutInstance* next_layout = layout->GetNextLayout();
	if (next_layout == NULL)
	{
	  break;
	}
	layout = next_layout;
	++page;
	++page_map_entry;
      }
    }
    while (0 < ok && !dialog.GetAborted())
    {
      if (firstp)
      {
	firstp = False;
      }
      else
      {
	if (reversep)
	{
	  layout = layout->GetPrevLayout();
	  --page;
	  --page_map_entry;
	}
	else
	{
	  layout = layout->GetNextLayout();
	  ++page;
	  ++page_map_entry;
	}
      }
      if (layout == NULL)
      {
	break;
      }
      if ((sel_only && !*page_map_entry) || page < from || to < page)
      {
	continue;
      }
      
      int offset_x, offset_y;
      printer_info->GetPrintingOffsets(offset_x, offset_y);
      
      Lrect lrect[1];
      layout->get_zero_page_lrect(lrect);
      view.SetLX(RECT_TOP_X(lrect)
		  + (offset_x * IU_PER_INCH) / view.GetDeviceDPIX()
		  - mm0_to_iu(Pref_printer_x_offset));
      view.SetLY(RECT_TOP_Y(lrect)
		  + (offset_y * IU_PER_INCH) / view.GetDeviceDPIY()
		  - mm0_to_iu(Pref_printer_y_offset));
      RECT rect[1];
      view.lrect_to_drect(lrect, CastWindowsRECTToDrect(rect));
      HRGN region = ::CreateRectRgnIndirect(rect);
      
#ifdef _WIN32
      ok = ::StartPage(dc);

      // SDK32 PVJ3047 - 96/05: Win32 should not use NEXTBAND and
      // BANDINFO printer escape. BANDING isn't needed by Win32.
      // Although, Petzold wrote some BANDING documentations.
      if (banding_need_p)
      {
	RECT band_rect[1];
	while (!dialog.GetAbortReported() && 
	       0 < (ok = ::ExtEscape(dc, NEXTBAND, 0, NULL,
				     sizeof(band_rect), (LPSTR)band_rect)))
	{
	  if (band_rect->right <= band_rect->left || 
	      band_rect->bottom <= band_rect->top)
	  {
	    break;
	  }
	  HRGN band_region = ::CreateRectRgnIndirect(band_rect);
	  if (::CombineRgn(band_region, band_region, region, RGN_AND)
	      != NULLREGION)
	  {
	    ::SelectClipRgn(dc, band_region);
	    layout->RedisplayTopLevel(&view, band_region);
	  }
	  ::DeleteObject(band_region);
	}
	if (!dialog.GetAbortReported())
	{
	  ok = ::EndPage(dc);
	  if (ok < 0)
	  {
	    // SDK Article ID:Q118873 EndPage returns -1 when banding.
	    // ignore error.
	    ok = 1;
	  }
	}
      }
      else
      {
	// not banding
	::SelectClipRgn(dc, region);
#if 1
	layout->RedisplayTopLevel(&view, region);
#else
	// for print debug
	::MoveToEx(dc, rect->left, rect->top, NULL);
	::LineTo(dc, rect->right, rect->bottom);
	::MoveToEx(dc, rect->right, rect->top, NULL);
	::LineTo(dc, rect->left, rect->bottom);
#endif
	if (!dialog.GetAbortReported())
	{
	  ok = ::EndPage(dc);
	}
      }

#else /* _WIN32 */
      if (escape_supported_p(dc, NEXTBAND))
      {
	bool bandinfo_supported_p = escape_supported_p(dc, BANDINFO);
	RECT band_rect[1];
	BANDINFOSTRUCT band_info;
	band_info.fGraphics = True;
	band_info.fText = False;
	band_info.rcGraphics = *rect;
	while (!dialog.GetAbortReported()
	       && 0 < (ok = ::Escape(dc,
				      NEXTBAND, 0, NULL, (LPSTR) band_rect)))
	{
	  if (band_rect->right <= band_rect->left
	      || band_rect->bottom <= band_rect->top)
	  {
	    break;
	  }
	  if (bandinfo_supported_p)
	  {
	    ok = ::Escape(dc,
			 BANDINFO,
			 sizeof(BANDINFOSTRUCT),
			 (LPSTR) &band_info, (LPSTR) &band_info);
	    if (ok < 0)
	    {
	      break;
	    }
	  }
	  if (band_info.fGraphics)
	  {
	    HRGN band_region = ::CreateRectRgnIndirect(band_rect);
	    if (::CombineRgn(band_region, band_region, region, RGN_AND)
		!= NULLREGION)
	    {
	      ::SelectClipRgn(dc, band_region);
	      layout->RedisplayTopLevel(&view, band_region);
	    }
	    ::DeleteObject(band_region);
	  }
	}
      }
      else
      {
	// not banding
	::SelectClipRgn(dc, region);
	layout->RedisplayTopLevel(&view, region);
	if (!dialog.GetAbortReported())
	{
	  ok = ::Escape(dc, NEWFRAME, 0, 0, 0);
	}
      }
#endif /* _WIN32 */
      ::DeleteObject(region);
      dialog.SetDonePages(total_pages_out += actual_copies);
    }
  }
  main_window->Enable(1);
  
  if (started_p && !dialog.GetAbortReported())
  {
#ifdef _WIN32
    int end_ok = ::EndDoc(dc);
#else /* _WIN32 */
    int end_ok = Escape(dc, ENDDOC, 0, 0, 0);
#endif /* _WIN32 */
    if (0 < ok)
    {
      ok = end_ok;
    }
  }
  
  if (dc != 0)
  {
    DeleteDC(dc);
  }
  delete page_map;
}

IntervalList* 
Document::FindStyle(uword style)
{
  DocumentContent* conte = this->GetDocumentContent();
  return(::GetStyleType(style) == AttsEntry::CHARSTYLE
	  ? Buffer::GreatFindCharStyle(conte, style)
	  : Buffer::GreatFindParaStyle(conte, style));
}

void
Document::StyleChange(uword style)
{
  IntervalList* il = this->FindStyle(style);
  if (il != NULL)
  {
    il->DelayFormat();
    delete il;
    GetDocumentContent() ->SetDirty();
  }
}

// this routine is called when a paragraph style is redefined and the
// old and new char atts on the paragraph style are different.
void
Document::ParCharAtts(uword style)
{
  assert(style != 0 && ::GetStyleType(style) == AttsEntry::PARSTYLE);
  
  IntervalList* il = this->FindStyle(style);
  if (il == NULL)
  {
    return;
  }
  
  DocumentContent* dc = GetDocumentContent();
  PUndo* undo = dc->GetUndo();
  undo->StartAtom(0, PUndo::UD_ParCharAtts);
  BaseIntervalListTraversor ilt(il);
  Interval* i;
  while ((i= (Interval*)ilt.GetNext()) != NULL)
  {
    undo->Register(i, PUndo::UF_CharAtt);
    i->SetParCharAtts();
  }
  undo->EndAtom(0);
  il->DelayFormat();
  delete il;
  dc->SetDirty();
}
