// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: docwindo.cpp,v 3.13 2000/05/04 13:44:04 kudou Exp $
// implement DocumentWindow class
// The DocumentWindow class is a type of MDIChild which is used
// to present parts of a document to the user.  A list of
// DocumentWindow pointers is maintained by a Document object.

#include "pword.h"
#include "docwindo.h"

#if defined(BCC3) || defined(BCC31)
// depend on bc3(gettime)
#  include <dos.h>
#endif
#include "attribut.h"
#include "borderli.h"
#include "rats.h"
#include "docchar.h"
#include "docconte.h"
#include "docedit.h"
#include "docmouse.h"
#include "docprese.h"
#include "document.h"
#include "dlg.h"
#include "editfram.h"
#include "mcursor.h"
#include "pmenus.h"
#include "frametem.h"
#include "frameins.h"
#include "layoutte.h"
#include "layoutin.h"
#include "line.h"
#include "panel.h"
#include "table.h"
#include "pstreams.h"
#include "again.h"
#include "pref.h"
#include "pwordbas.h"
#include "pwordpre.h"
#include "mdiclien.h"
#include "mwindow.h"
#include "textflow.h"
#include "bufnew.h"
#include "interval.h"
#include "intlist.h"
#include "rect.h"
#include "caret.h"
#include "pime.h"
#include "screen.h"
#include "sjis.h"
#include "wstdio.h"
#include "foiterat.h"
#include "tablepnl.h"
#include "xstr.h"

// ------------------------------------------------------------
// scrolling-related constants

#define SCROLLMAX 1024

// BW2_NEW_LINE_SCROLL -- With definition of this symbol, BeatWord scrolls
// immediate pixels when a scroll button pressed.  Pixel count of
// scrolling come from preferences(Pref_scroll_step_x,
// Pref_scroll_step_y).   (konno)
#define BW2_NEW_LINE_SCROLL

#ifdef BW2_NEW_LINE_SCROLL
// hanging on the horiz scroll button moves in increments of 1/n pages
#define LINE_SCROLL_DENOMINATOR_H 8

// hanging on the vert scroll button moves in increments of 1/n screens
// lower is faster and rougher
#define LINE_SCROLL_DENOMINATOR_V 4
#endif /* BW2_NEW_LINE_SCROLL */

// when auto scrolling because mouse is down outside window, scroll
// in units of 1/n pages
#define AUTO_SCROLL_DENOMINATOR 4

// Scroll-bar setting.
#define SCROLL_TYPE_AUTO 0
#define SCROLL_TYPE_SHOWN 1
#define SCROLL_TYPE_HIDDEN 2

Enum_Desc scroll_bar_desc[] =
{
  { S_scroll_type_auto,		SCROLL_TYPE_AUTO, },
  { S_scroll_type_shown,	SCROLL_TYPE_SHOWN, },
  { S_scroll_type_hidden,	SCROLL_TYPE_HIDDEN, },
  { S_scroll_type2_auto,	SCROLL_TYPE_AUTO, },
  { S_scroll_type2_shown,	SCROLL_TYPE_SHOWN, },
  { S_scroll_type2_hidden,	SCROLL_TYPE_HIDDEN, },
  { NULL,			SCROLL_TYPE_AUTO, },
};

static int disable_scrollbar_control = False;

// end of scrolling constants
// ------------------------------------------------------------

// Aliases for tategaki
#define index_top index_x
#define index_bot index_y
#define index_width index_x
#define index_height index_y
#define index_horizontal index_x
#define index_vertical index_y

Lpoint STATIC_NEAR DocumentWindow::recent_caret_lp[1];
Lrect STATIC_NEAR DocumentWindow::recent_frame_drawing_lrect;
bool STATIC_NEAR DocumentWindow::recent_has_caret = False;
bool STATIC_NEAR DocumentWindow::IME_sends_open_window = False;
int STATIC_NEAR DocumentWindow::recent_tategaki_flow_p = False;

// layout x margin
word STATIC_NEAR DocumentWindow::layout_x_margin = Inch_to_iu(0.25);

// layout y margin
word STATIC_NEAR DocumentWindow::layout_y_margin = Inch_to_iu(0.25);

// ------------------------------------------------------------
// caret control

LayoutInstance* 
DocumentWindow::GetZeroCaretLayout()
{
  LayoutInstance* layout = this->zero_caret_layout;
  if (layout == NULL)
  {
    layout = this->GetBeginningLayout();
    if (layout == NULL)
    {
      layout = this->GetContent() ->GetFirstLayout();
    }
    this->SetZeroCaretLayout(layout);
  }
  return(layout);
}

// private method
BufferPointer* 
DocumentWindow::GetCaretBP()
{
  DocumentEdit* edit = this->GetEditor();
  if (edit != NULL)
  {
    IntervalList* il = edit->GetSelection();
    if (il != NULL)
    {
      bool selection;
      return(il->PointForCaret(selection));
    }
  }
  return(NULL);
}

word 
DocumentWindow::GetCaretPageNum()
{
  BP* bp = GetCaretBP();
  word page = 0;
  if (bp)
  {
    LayoutInstance* li = bp->FindTopLevelLayout();
    if (li)
    {
      page = GetContent()->GetLogicalPageNum(li);
    }
  }
  return page;
}

TextFlow* 
DocumentWindow::GetCaretTextFlow()
{
  BP* bp = GetCaretBP();
  return((bp) ? bp->GetTextFlow() : 0);
}

void
DocumentWindow::ControlCaret()
{
  if (!this->request_caret_control)
  {
    return;
  }
  this->request_caret_control = False;
  
  bool request_caret = (bool)(this->request_caret != 0);
  bool request_force_caret = (bool)(this->request_force_caret != 0);
  if (!request_caret && !request_force_caret)
  {
    return;
  }
  DocumentEdit* edit = this->GetEditor();
  if (edit == NULL)
  {
    return;
  }
  IntervalList* il = edit->GetSelection();
  if (il == NULL)
  {
    return;
  }
  bool selection;
  BufferPointer* bp = il->PointForCaret(selection);
  if (bp == NULL)
  {
    return;
  }
  
  HWND handle = this->GetHandle();
  
  bool overflowp = False;
  if (!bp->FormattedP() && ! (overflowp = bp->GetTextFlow() ->OverflowP()))
  {
    Caret::Reset(handle);
    return;
  }
  
  if (overflowp)
  {
    selection = False;
  }
  
  this->request_caret = False;
  this->request_force_caret = False;
  
  if (this != Selected_Window && !request_force_caret)
  {
    Caret::Reset(handle);
    return;
  }
  
  Lpoint caret_lp[1];
  Lrect frame_lr[1];
  current_top_level_layout = this->GetZeroCaretLayout();
  Line* line = bp->maybe_find_line_and_lpoint(caret_lp, this);
  FrameInstance* frame = line->GetFrame();
  frame->get_lrect(frame_lr);
  Iunit line_descent = line->GetDescent();
  
  int tategaki_flow_p = bp->GetTextFlow() ->tategaki_flow_p();
  int index_x = tategaki_flow_p ? INDEX_Y : INDEX_X;
  int index_y = REVERSED_INDEX(index_x);
  attr attrib = il->GetHead() ->GetAtts();
  FontMetric* fm = get_font_metric(attrib, ROMAJIFONT, tategaki_flow_p);
  int ascent = this->lu_to_du(fm->GetAscent(), index_height);
  int descent = 0;
  int width = 0;
  switch (Pref_caret_type)
  {
   case CARET_TYPE_FRAME:
   case CARET_TYPE_BOX:
    {
      sjis ch = bp->GetRightChar();
      if (USE_KANJI_FONT(ch))
      {
	fm = get_font_metric(attrib, JISFONT, tategaki_flow_p);
	ascent = this->lu_to_du(fm->GetAscent(), index_height);
      }
      width = this->lu_to_du(fm->GetWidth(ch), index_width);
      descent = this->lu_to_du(fm->GetDescent(), index_height);
    }
    break;
  }
  if (width <= 0)
  {
    width = this->lu_to_du(fm->GetAverageWidth(), index_width);
  }
  int flags = 0;
  if (tategaki_flow_p)
  {
    flags |= Caret::TATEGAKI;
  }
  if (overflowp)
  {
    flags |= Caret::OVERFLOW;
  }
  else
  {
    int* atts = get_atts(attrib);
    if (atts[CA_bold])
    {
      flags |= Caret::BOLD;
    }
    if (atts[CA_italic])
    {
      flags |= Caret::ITALIC;
    }
    if (atts[CA_hidden])
    {
      flags |= Caret::HIDDEN;
    }
    if (atts[CA_strikeout])
    {
      flags |= Caret::STRIKEOUT;
    }
    int border = atts[CA_lines];
    if (border != 0 && BorderLine::Get(border) ->underlinep())
    {
      flags |= Caret::UNDERLINE;
    }
  }
  
  if (RECT_UNIT(frame_lr, INDEX_BOT, index_x)
      <= POINT_UNIT(caret_lp, index_x))
  {
    POINT_UNIT(caret_lp, index_x) = RECT_UNIT(frame_lr, INDEX_BOT, index_x);
    flags |= Caret::LINERIGHT;
  }
  
  CaretMetric caret = Caret::GetCaretMetric(width, ascent, descent, flags);
  
  Lrect r[1];
  Lrect c[1];
  this->get_lrect(r);
  SET_RECT(c,
	    (POINT_X(caret_lp)
	     - this->ScaleLunitX(caret.lwidth) - line_descent),
	    (POINT_Y(caret_lp)
	     - this->ScaleLunitY(caret.ascent) - line_descent),
	    (POINT_X(caret_lp)
	     + this->ScaleLunitX(caret.rwidth) + line_descent),
	    (POINT_Y(caret_lp)
	     + this->ScaleLunitY(caret.descent) + line_descent));
  bool has_caret = (bool)(lrect_includep(r, c) != 0);
  if (!has_caret && request_force_caret)
  {
    Lunit new_x = RECT_TOP_X(r);
    Lunit new_y = RECT_TOP_Y(r);
    Lrect caret_lr[1];
    *caret_lr = *c;
    {
      int num_chars = line->GetNumDrawingChars();
      if (num_chars)
      {
	LineCharInfo* info = line->GetInfo();
	int i = (bp->GetLogicalOffset()
		 - line->GetFirstBP() ->GetLogicalOffset());
	for (int n = 0; n < num_chars; ++n)
	{
	  if (i <= info[n].i)
	  {
	    break;
	  }
	}
	if (i)
	{
	  Lunit foo = RECT_UNIT(frame_lr, INDEX_TOP, index_x) + info[i - 1].x;
	  SET_MIN(RECT_UNIT(caret_lr, INDEX_TOP, index_x), foo);
	}
	if (i < num_chars)
	{
	  Lunit foo = RECT_UNIT(frame_lr, INDEX_TOP, index_x) + info[i + 1].x;
	  SET_MAX(RECT_UNIT(caret_lr, INDEX_BOT, index_x), foo);
	}
	line->ReleaseInfo(info);
      }
    }
    Lrect bound_lr[1];
    frame->GetLayout() ->get_lrect(bound_lr);
    if (RECT_TOP_X(c) < RECT_TOP_X(r) || RECT_BOT_X(r) < RECT_BOT_X(c))
    {
      Lunit window_width = this->GetLWidth();
      Lunit unit = this->LXUnit();
      RECT_TOP_X(bound_lr) -= unit;
      RECT_BOT_X(bound_lr) += unit;
      if (window_width
	  < (RECT_BOT_X(caret_lr) - RECT_TOP_X(caret_lr) + unit) * 3)
      {
	new_x = POINT_X(caret_lp) - window_width / 2;
      }
      else if (RECT_TOP_X(caret_lr) < RECT_TOP_X(r))
      {
	new_x = RECT_TOP_X(caret_lr) - unit;
	if (RECT_BOT_X(caret_lr) < RECT_BOT_X(bound_lr)
	    && RECT_TOP_X(bound_lr) < new_x
	    && RECT_BOT_X(bound_lr) < new_x + window_width)
	{
	  Lunit a = RECT_BOT_X(bound_lr) - window_width;
	  SET_MAX(a, RECT_TOP_X(bound_lr));
	  SET_MIN(new_x, a);
	}
      }
      else
      {
	new_x = RECT_BOT_X(caret_lr) - window_width + unit;
	if (RECT_TOP_X(bound_lr) < RECT_TOP_X(caret_lr)
	    && new_x < RECT_TOP_X(bound_lr)
	    && new_x + window_width < RECT_BOT_X(bound_lr))
	{
	  Lunit a = RECT_BOT_X(bound_lr) - window_width;
	  SET_MIN(a, RECT_TOP_X(bound_lr));
	  SET_MAX(new_x, a);
	}
      }
    }
    if (RECT_TOP_Y(c) < RECT_TOP_Y(r) || RECT_BOT_Y(r) < RECT_BOT_Y(c))
    {
      Lunit window_height = this->GetLHeight();
      Lunit unit = this->LYUnit();
      RECT_TOP_Y(bound_lr) -= unit;
      RECT_BOT_Y(bound_lr) += unit;
      if (window_height
	  < (RECT_BOT_Y(caret_lr) - RECT_TOP_Y(caret_lr) + unit) * 3)
      {
	new_y = POINT_Y(caret_lp) - window_height / 2;
      }
      else if (RECT_TOP_Y(caret_lr) < RECT_TOP_Y(r))
      {
	new_y = RECT_TOP_Y(caret_lr) - unit;
	if (RECT_BOT_Y(caret_lr) < RECT_BOT_Y(bound_lr)
	    && RECT_TOP_Y(bound_lr) < new_y
	    && RECT_BOT_Y(bound_lr) < new_y + window_height)
	{
	  Lunit a = RECT_BOT_Y(bound_lr) - window_height;
	  SET_MAX(a, RECT_TOP_Y(bound_lr));
	  SET_MIN(new_y, a);
	}
      }
      else
      {
	new_y = RECT_BOT_Y(caret_lr) - window_height + unit;
	if (RECT_TOP_Y(bound_lr) < RECT_TOP_Y(caret_lr)
	    && new_y < RECT_TOP_Y(bound_lr)
	    && new_y + window_height < RECT_BOT_Y(bound_lr))
	{
	  Lunit a = RECT_BOT_Y(bound_lr) - window_height;
	  SET_MIN(a, RECT_TOP_Y(bound_lr));
	  SET_MAX(new_y, a);
	}
      }
    }
    this->SetView0(new_x, new_y, True);
    this->get_lrect(r);
    has_caret = (bool)(lrect_includep(r, c) != 0);
  }
  
  if (this != Selected_Window)
  {
    Caret::Reset(handle);
    return;
  }
  
  int wx = this->DunitX(POINT_X(caret_lp));
  int wy = this->DunitY(POINT_Y(caret_lp));
  
  *DocumentWindow::recent_caret_lp = *caret_lp;
  DocumentWindow::recent_has_caret = has_caret;
  DocumentWindow::recent_tategaki_flow_p = tategaki_flow_p;
  frame->get_drawing_lrect(&recent_frame_drawing_lrect);
  
  if (has_caret && !selection)
  {
    Caret::Set(handle,
		wx - caret.lwidth,
		wy - caret.ascent, width, ascent, descent, flags);
  }
  else
  {
    Caret::Kill();
  }
  if (!IME_sends_open_window || PIME::GetPending())
  {
    DocumentWindow::control_ime();
  }
  PWordPresentation::Update();
}

void
DocumentWindow::ControlIME()
{
  if (this == NULL)
  {
    return;
  }
  DocumentEdit* edit = this->GetEditor();
  if (edit == NULL)
  {
    return;
  }
  IntervalList* il = edit->GetSelection();
  if (il == NULL)
  {
    return;
  }
  bool selection;
  BufferPointer* bp = il->PointForCaret(selection);
  if (bp == NULL)
  {
    return;
  }
  
  int ascent = 0;
  if (!PIME::GetIgnoreFont())
  {
    LOGFONT logfont[1];
    TEXTMETRIC tm[1];
    (get_font_metric(il->GetHead() ->GetAtts(),
		      JISFONT, recent_tategaki_flow_p)
     ->SimulatedLogfont(logfont, this));
    if (recent_tategaki_flow_p)
    {
      logfont->lfEscapement = 270 * 10;
      logfont->lfOrientation = 270 * 10;
    }
    HFONT font = CreateFontIndirect(logfont);
    HFONT old_font = (HFONT)::SelectObject(Screen::dc, font);
    GetTextMetrics(Screen::dc, tm);
    SelectObject(Screen::dc, old_font);
    PIME::SetFont(font);
    ascent = tm->tmAscent;
  }
  
  // see if the point is visible in the main window
  int visible = False;
  if (!Pref_ime_system_line && this->recent_has_caret && size != SIZEICONIC)
  {
    // caret position
    Dpoint caret_dp[1];
    this->lpoint_to_dpoint(recent_caret_lp, caret_dp);
    
    // rectangle of document window
    Lrect this_lr[1];
    Drect this_dr[1];
    this->get_lrect(this_lr);
    this->lrect_to_drect(this_lr, this_dr);
    
    // rectangle of top-level window
    // use the mdi client, NOT main window.  This takes the scroll bars
    // into account.
    Drect main_dr[1];
    HWND handle = this->GetHandle();
    HWND client = MainWindow::GetMDIClient() ->GetHandle();
    ::GetClientRect(client, CastDrectToWindowsRECT(main_dr));
    ::ClientToScreen(client, CastDpointToWindowsPOINT(RECT_TOP(main_dr)));
    ::ClientToScreen(client, CastDpointToWindowsPOINT(RECT_BOT(main_dr)));
    ::ScreenToClient(handle, CastDpointToWindowsPOINT(RECT_TOP(main_dr)));
    ::ScreenToClient(handle, CastDpointToWindowsPOINT(RECT_BOT(main_dr)));
    
    // IME clipping rectangle
    // clip the IME rectangle to the pword window or the document window,
    // whichever is smaller.  some IME's like WX2 are too stupid to do
    // this themselves.
    Drect clip_dr[1];
    this->lrect_to_drect(&recent_frame_drawing_lrect, clip_dr);
    drect_and(clip_dr, this_dr);
    drect_and(clip_dr, main_dr);
    
    if (drect_insidep(clip_dr, caret_dp))
    {
      PIME::RectConvertWin(handle,
			    clip_dr,
			    caret_dp, ascent, recent_tategaki_flow_p);
      visible = True;
    }
  }
  if (!visible)
  {
    PIME::DefaultConvertWin();
  }
}

void
DocumentWindow::CheckCaret()
{
  if (!this->request_caret_control
      && (this->request_caret || this->request_force_caret))
  {
    BufferPointer* bp = this->GetCaretBP();
    if (bp != NULL
	&& (bp->FormattedP() || bp->GetTextFlow() ->OverflowP()))
    {
      this->request_caret_control = True;
      this->presentation->RequestCaretControl();
    }
  }
}

void
DocumentWindow::UnforceTouchCaret()
{
  if (this != NULL)
  {
    this->request_caret = True;
    this->request_force_caret = False;
    this->request_caret_control = True;
    this->ControlCaret();
  }
}

void
DocumentWindow::ForceTouchCaret()
{
  if (this != NULL)
  {
    this->request_force_caret = True;
    this->request_caret_control = True;
    this->ControlCaret();
  }
}

void
DocumentWindow::TouchCaret()
{
  if (this != NULL)
  {
    this->request_caret = True;
    this->request_caret_control = True;
    this->ControlCaret();
  }
}

void
DocumentWindow::UntouchCaret()
{
  if (this != NULL)
  {
    this->request_caret = False;
    this->request_force_caret = False;
    Caret::Reset(this->GetHandle());
  }
}

// static method
void
DocumentWindow::control_ime()
{
  Selected_Window->ControlIME();
}

// static method
void
DocumentWindow::touch_caret()
{
  Selected_Window->TouchCaret();
}

// static method
void
DocumentWindow::force_touch_caret()
{
  Selected_Window->ForceTouchCaret();
}

// static method
void
DocumentWindow::unforce_touch_caret()
{
  Selected_Window->UnforceTouchCaret();
}

// static method
void
DocumentWindow::untouch_caret()
{
  Selected_Window->UntouchCaret();
}

// ------------------------------------------------------------
// view control

void
DocumentWindow::control_scroll_bar()
{
  // On Windows 3.0, when we call ::ShowScrollBar(), WM_SIZE message will
  // come to this window.  In this case, main-window's menu is broken. 
  // RE_ENTERED_P control this situation to safe. (konno)
  
  static int re_entered_p = False;
  HWND handle = this->GetHandle();
  if (handle != 0
      && this->size != SIZEICONIC
      && !disable_scrollbar_control && !re_entered_p)
  {
    re_entered_p = True;
    int horizontal_shown_p = True;
    int vertical_shown_p = True;
    DocumentContent* conte = this->GetContent();
    switch (Pref_scroll_bar_horizontal)
    {
     case SCROLL_TYPE_SHOWN:
      break;
      
     case SCROLL_TYPE_HIDDEN:
      horizontal_shown_p = False;
      break;
      
     default:
      if (this->GetLX() <= 0
	  && conte->GetLWidth() <= this->GetLX() + this->GetLWidth())
      {
	horizontal_shown_p = False;
      }
      break;
    }
    switch (Pref_scroll_bar_vertical)
    {
     case SCROLL_TYPE_SHOWN:
      break;
      
     case SCROLL_TYPE_HIDDEN:
      vertical_shown_p = False;
      break;
      
     default:
      if (this->GetLY() <= 0
	  && conte->GetLHeight() <= this->GetLY() + this->GetLHeight())
      {
	vertical_shown_p = False;
      }
      break;
    }
    if (this->hscroll_shown_p != horizontal_shown_p)
    {
      this->hscroll_shown_p = horizontal_shown_p;
      ::ShowScrollBar(handle, SB_HORZ, horizontal_shown_p);
    }
    if (this->vscroll_shown_p != vertical_shown_p)
    {
      this->vscroll_shown_p = vertical_shown_p;
      ::ShowScrollBar(handle, SB_VERT, vertical_shown_p);
    }
    re_entered_p = False;
  }
}

void
DocumentWindow::UpdateScrollPos()
{
  DocumentContent* conte = this->GetContent();
  Lunit max_x = conte->GetLWidth() - this->GetLWidth();
  Lunit max_y = conte->GetLHeight() - this->GetLHeight();
  Lunit lx = this->GetLX();
  Lunit ly = this->GetLY();
  HWND handle = this->GetHandle();
  
  int x = (int) (((double) lx * SCROLLMAX) / max_x);
  SET_BOUND(x, 0, SCROLLMAX);
  if (x != ::GetScrollPos(handle, SB_HORZ))
  {
    ::SetScrollPos(handle, SB_HORZ, x, True);
  }
  
  int y = (int) (((double) ly * SCROLLMAX) / max_y);
  SET_BOUND(y, 0, SCROLLMAX);
  if (y != ::GetScrollPos(handle, SB_VERT))
  {
    ::SetScrollPos(handle, SB_VERT, y, True);
  }
  this->control_scroll_bar();
}

static long NEAR
get_layout_top(DocumentWindow* w, LayoutInstance* layout)
{
  return(w->LongDunitY(layout->GetZeroPageLayout() ->GetLY()) - 1);
}

static long NEAR
get_layout_bot(DocumentWindow* w, LayoutInstance* layout)
{
  layout = layout->GetZeroPageLayout();
  return(w->LongDunitY(layout->GetLY() + layout->GetHeight()) + 2);
}

void
DocumentWindow::RecalcLayouts()
{
  THIS_CHECK;
  
  RECT this_rect[1];
  ::GetClientRect(this->GetHandle(), this_rect);
  
  LayoutInstance* layout;
  if ((layout = this->beginning_layout) != NULL
      || (layout = this->presentation->GetFirstLayout()) != NULL)
  {
    LayoutInstance* prev;
    while (0 < get_layout_top(this, layout)
	   && (prev = layout->GetPrevLayout()) != NULL)
    {
      layout = prev;
    }
    
    while (layout != NULL && get_layout_bot(this, layout) <= 0)
    {
      layout = layout->GetNextLayout();
    }
    
    this->beginning_layout = layout;
    LayoutInstance* last_visible = layout;
    while (layout != NULL
	   && get_layout_top(this, layout) < this_rect->bottom)
    {
      last_visible = layout;
      layout = layout->GetNextLayout();
    }
    this->end_layout = (last_visible == NULL
			? NULL : last_visible->GetNextLayout());
    this->UpdateScrollPos();
  }
}

void
DocumentWindow::BreakBeginningLayout()
{
  this->beginning_layout = NULL;
  this->RecalcLayouts();
}

void
DocumentWindow::BreakLayout(LayoutInstance* layout)
{
  if (layout == this->zero_caret_layout)
  {
    this->SetZeroCaretLayout(NULL);
  }
}

void
DocumentWindow::SetView0(Lunit x, Lunit y, bool do_all)
{
  DocumentContent* conte = this->GetContent();
  Lunit max_x = conte->GetLWidth() - this->GetLWidth();
  Lunit max_y = conte->GetLHeight() - this->GetLHeight();
  
  SET_MAX(max_x, 0);
  SET_MAX(max_y, 0);
  
  SET_MAX(x, 0);
  SET_MAX(y, 0);
  
  RECT this_rect[1];
  ::GetClientRect(this->GetHandle(), this_rect);
  
  int x_unit = this->LXUnit();
  int y_unit = this->LYUnit();
  int stupid_scaling_p = False;
  
  if (x_unit <= (this_rect->right - this_rect->left) / 2)
  {
    x = x_unit * ((x + x_unit / 2) / x_unit);
    max_x = x_unit * ((max_x + x_unit - 1) / x_unit);
  }
  else
  {
    stupid_scaling_p = True;
  }
  
  if (y_unit <= (this_rect->bottom - this_rect->top) / 2)
  {
    y = y_unit * ((y + y_unit / 2) / y_unit);
    max_y = y_unit * ((max_y + y_unit - 1) / y_unit);
  }
  else
  {
    stupid_scaling_p = True;
  }
  
  SET_MIN(x, max_x);
  SET_MIN(y, max_y);
  
  bool changed = False;
  if (!do_all || x != this->GetLX() || y != this->GetLY())
  {
    Lrect old_rect[1];
    this->get_lrect(old_rect);
    Dunit wx = DunitX(x);
    Dunit wy = DunitY(y);
    this->SetLX(x);
    this->SetLY(y);
    if (do_all)
    {
      Lrect new_rect[1];
      this->get_lrect(new_rect);
      if (!stupid_scaling_p && lrect_intersectp(old_rect, new_rect))
      {
	::ScrollWindow(this->GetHandle(), -wx, -wy, NULL, NULL);
	if (Pref_scroll_flush)
	{
	  RECT r[1];
	  if (wx != 0)
	  {
	    *r = *this_rect;
	    if (0 < wx)
	    {
	      r->left = r->right - wx;
	    }
	    else
	    {
	      r->right = r->left - wx;
	    }
	    ::FillRect(this->GetDC(), r, Screen::white_brush);
	  }
	  if (wy != 0)
	  {
	    *r = *this_rect;
	    if (0 < wy)
	    {
	      r->top = r->bottom - wy;
	    }
	    else
	    {
	      r->bottom = r->top - wy;
	    }
	    ::FillRect(this->GetDC(), r, Screen::white_brush);
	  }
	}
      }
      else
      {
	this->InvalidateAll();
	if (Pref_scroll_flush)
	{
	  ::FillRect(this->GetDC(), this_rect, Screen::white_brush);
	}
      }
    }
    changed = True;
  }
  
  // `this->GetBeginningLayout() == NULL' means first case.
  if (changed || this->GetBeginningLayout() == NULL)
  {
    this->RecalcLayouts();
  }
}

void
DocumentWindow::SetView(Lunit x, Lunit y)
{
  this->SetView0(x, y, True);
  this->UnforceTouchCaret();
}

// set view on default position
void
DocumentWindow::SetViewOnLayout(LayoutInstance* layout)
{
  if (layout != NULL)
  {
    this->SetView(layout->GetLX(), layout->GetLY());
  }
}

void
DocumentWindow::SetViewOnLayout(LayoutInstance* li, Iunit x, Iunit y)
{
  this->SetView(li->GetLX() + x, li->GetLY() + y);
}

void
DocumentWindow::SetViewOnDunitRelative(int x_diff, int y_diff)
{
  int x_unit = this->WXUnit();
  int xsign = 1;
  if (x_diff < 0)
  {
    xsign = -1;
    x_diff = -x_diff;
  }
  long lx_diff = (xsign
		  * (long) this->LXUnit()
		  * ((x_diff + x_unit - 1) / x_unit));
  
  int y_unit = this->WYUnit();
  int ysign = 1;
  if (y_diff < 0)
  {
    ysign = -1;
    y_diff = -y_diff;
  }
  long ly_diff = (ysign
		  * (long) this->LYUnit()
		  * ((y_diff + y_unit - 1) / y_unit));
  
  this->SetView(this->GetLX() + lx_diff, this->GetLY() + ly_diff);
}

void
DocumentWindow::Recenter(bool horizontal_only)
{
  this->InvalidateAll();
  
  Lunit lx = this->GetLX();
  Lunit ly = this->GetLY();
  Lunit width = this->GetLWidth();
  Lunit height = this->GetLHeight();
  
  if (!horizontal_only)
  {
    BufferPointer* bp = this->GetCaretBP();
    if (bp != NULL && bp->FormattedP())
    {
      Lpoint caret_lp[1];
      bp->maybe_find_line_and_lpoint(caret_lp, this);
      lx = POINT_X(caret_lp) - width / 2;
      ly = POINT_Y(caret_lp) - height / 2;
    }
  }
  SET_MAX(lx, 0);
  SET_MAX(ly, 0);
  
  this->SetView0(lx, ly, False);
  
  if (this->end_layout == NULL && this->beginning_layout != NULL)
  {
    LayoutInstance* layout = this->beginning_layout;
    for (;;)
    {
      LayoutInstance* next_layout = layout->GetNextLayout();
      if (next_layout == NULL)
      {
	break;
      }
      layout = next_layout;
    }
    layout = layout->GetZeroPageLayout();
    ly = layout->GetLY() + layout->GetHeight() - height;
    if (ly < this->GetLY())
    {
      SET_MAX(ly, 0);
      this->SetView0(this->GetLX(), ly, False);
    }
  }
  
  if (this->beginning_layout != NULL)
  {
    LayoutInstance* layout = this->beginning_layout->GetZeroPageLayout();
    lx = layout->GetLX() + layout->GetWidth() - width;
    if (lx < this->GetLX())
    {
      SET_MAX(lx, 0);
      this->SetView0(lx, this->GetLY(), False);
    }
  }
  
  this->TouchCaret();
}

// ------------------------------------------------------------
// visible layout control

LayoutInstance* 
DocumentWindow::GetTopLevelLayout(LayoutInstance* layout)
{
  for (;;)
  {
    if (layout == NULL)
    {
      return(NULL);
    }
    Panel* panel = layout->GetPanel();
    if (panel == NULL)
    {
      break;
    }
    BufferPointer* panel_bp = panel->GetOwnedRealBP();
    layout = panel_bp->FindLayout();
    delete panel_bp;
  }
  return((layout->GetTemplate())->IsZeroPage()
	  ? this->GetZeroCaretLayout() : layout);
}

// get caret layout-instance
LayoutInstance* 
DocumentWindow::GetCaretLayoutInstance()
{
  BufferPointer* bp = this->GetCaretBP();
  return(bp == NULL ? NULL : this->GetTopLevelLayout(bp->FindLayout()));
}

bool
DocumentWindow::GetCaretPageAndLine(int* page_return, int* line_return, bool* ghost_return)
{
  bool found = False;
  int page_no = 0;
  int line_no = 0;
  bool ghost = False;
  
  do // dummy loop
  {
    BufferPointer* bp = this->GetCaretBP();
    if (bp == NULL)
    {
      break;
    }
    Line* line = bp->FindLine();
    if (line == NULL)
    {
      break;
    }
    LayoutInstance* li = line->GetLayout();
    LayoutInstance* layout = this->GetTopLevelLayout(li);
    if (layout == NULL)
    {
      break;
    }
    found = True;
    page_no = (layout->GetDocumentContent())->GetLogicalPageNum(layout);
    if (li->GetLayoutTemplate()->IsTable())
    {
      PageMap* pm = li->GetPageMap();
      Table* t = (Table*)pm;
      ghost = t->GetLayout() != li;
    }
    if (!ghost)
    do
    {
      ++line_no;
    } while (! (line = line->GetPrevImmediately())->NilP());
  } while (0);
  
  *page_return = page_no;
  *line_return = line_no;
  *ghost_return = ghost;
  return(found);
}

// ------------------------------------------------------------

DocumentContent* 
DocumentWindow::GetContent()
{
  return(& (this->presentation->GetDocument())->content);
}

// private method
int NEAR
DocumentWindow::check_names(Document* d, char* name)
{
  for (DocumentWindow* dw = d->GetFirstDocWindow();
       dw != NULL; dw = dw->next_docwindow)
  {
    if (dw != this && dw->name != NULL && strcmp(dw->name, name) == 0)
    {
      return(True);
    }
  }
  return(False);
}

// public method
void
DocumentWindow::SetName(char* name)
{
  char* buffer = (char*) xmalloc(strlen(name) + sizeof("[0123456789]"));
  strcpy(buffer, name);
  int count = 1;
  for (;;)
  {
    int matchp = False;
    for (Document* d = PWordBase::GetFirstDocument();
	 !matchp && d != NULL; d = d->next_document)
    {
      matchp = this->check_names(d, buffer);
    }
    if (!matchp
	&& !this->check_names(this->presentation->GetDocument(), buffer))
    {
      break;
    }
    ++count;
    wsprintf(buffer, S_ExtWinName, name, count);
  }
  xfree(this->name);
  this->name = dup_string(buffer);
  xfree(buffer);
  SetText(this->name);
}

// GotoPage is mainly called from PageBox when the user types in a
// page she wants to go to.  It returns a non-zero value for success.
int
DocumentWindow::GotoPage(int page_num, int /* line */)
{
  DocumentContent* dc = presentation->GetDocument()->GetDocumentContent(); 
  LayoutInstance* li = dc->GetLayoutByLogicalPageNum(page_num);
  if (li == 0) 
  {
    LayoutInstance* first_li = dc->GetFirstLayout();
    int first_pageno = dc->GetLogicalPageNum(first_li);
    li = (first_pageno > page_num) ? first_li : dc->GetLastLayout();
  }
  SetViewOnLayout(li->GetZeroPageLayout());
  return 1;
}

void
DocumentWindow::get_lrect(Lrect* lr)
{
  SET_RECT(lr,
	    this->GetLX(),
	    this->GetLY(),
	    this->GetLX() + this->GetLWidth(),
	    this->GetLY() + this->GetLHeight());
}

bool
DocumentWindow::LayoutIsVisibleP(LayoutInstance* layout)
{
  Lrect this_rect[1];
  this->get_lrect(this_rect);
  
  Lrect rect[1];
  layout->get_lrect(rect);
  
  return (bool)(lrect_intersectp(this_rect, rect) != 0);
}

void
DocumentWindow::IncScroll(int xdir, int ydir)
{
#ifdef BW2_NEW_LINE_SCROLL
  // Simple and beauty scrolling.  (konno)
  int x_delta = Pref_scroll_step_horizontal;
  int y_delta = Pref_scroll_step_vertical;
  int x_unit = this->WXUnit();
  int y_unit = this->WYUnit();
  this->SetViewOnDunitRelative(MAX(x_delta, x_unit) * xdir,
				MAX(y_delta, y_unit) * ydir);
#else /* not BW2_NEW_LINE_SCROLL */
  RECT r;
  ::GetClientRect(this->GetHandle(), &r);
  this->SetViewOnDunitRelative((((r.right - r.left)
				 / LINE_SCROLL_DENOMINATOR_H)
				 * xdir),
				(((r.bottom - r.top)
				  / LINE_SCROLL_DENOMINATOR_V)
				 * ydir));
#endif /* not BW2_NEW_LINE_SCROLL */
}

void
DocumentWindow::Activate()
{
  if (size == SIZEICONIC)
  {
    ::SendMessage(client->GetHandle(), WM_MDIRESTORE, (WPARAM_T)GetHandle(), 0);
  }
  ::SendMessage(client->GetHandle(), WM_MDIACTIVATE, (WPARAM_T)GetHandle(), 0);
}


// ------------------------------------------------------------
// from docinit.cpp

char STATIC_NEAR DocumentWindow::szClassName[] = DOCWINDOW_CLASS_NAME;

void
DocumentWindow::Register()
{
  WNDCLASS Wc;
  Wc.style = CS_DBLCLKS;
  Wc.lpfnWndProc = mWndProc;
  Wc.cbWndExtra = sizeof(DocumentWindow*);
  Wc.cbClsExtra = 0;
  Wc.hInstance = PWordPresentation::hInstance;
  Wc.hIcon = LoadIcon(PWordPresentation::hInstance, "DocumentIcon");
  Wc.hCursor = NULL;
  Wc.hbrBackground = NULL;
  Wc.lpszMenuName = NULL;
  Wc.lpszClassName = szClassName;
  RegisterClass(&Wc);
}


void
DocumentWindow::Init(DocumentPresentation* _presentation)
{
  this->name = NULL;
  this->editor = 0;
  this->presentation = _presentation;
  this->beginning_layout = NULL;
  this->end_layout = NULL;
  this->scaling = 100;
  this->next_docwindow = 0;
  this->mouse.work_lx = 0;
  this->mouse.work_ly = 0;
  this->mouse.activep = False;
  this->mouse.movedp = False;
  this->request_caret = True;
  this->request_force_caret = True;
  this->request_caret_control = False;
  this->editor = 0;
  this->zero_caret_layout = NULL;
  this->only_requested_line_p = False;
}

// public constructor
DocumentWindow::DocumentWindow(DocumentPresentation* _presentation,
				char* name, bool pref_size)
{
  PWordBase::CheckWindowCount();
  Init(_presentation);
  this->editor = new DocumentEdit(this);
  
  MDICREATESTRUCT Mdi;
  
  Mdi.x       = CW_USEDEFAULT;
  Mdi.y       = CW_USEDEFAULT;
  Mdi.cx      = CW_USEDEFAULT;
  Mdi.cy      = CW_USEDEFAULT;
  Mdi.style   = 0;
  
  Make(Mdi, name, pref_size);
}

void
DocumentWindow::Make(MDICREATESTRUCT& Mdi, char* name, bool pref_size)
{
  Mdi.szClass = szClassName;
  Mdi.szTitle = "";
  Mdi.hOwner  = PWordPresentation::hInstance;
  Mdi.style |= WS_VSCROLL | WS_HSCROLL | WS_CLIPSIBLINGS;
  if (pref_size && Pref_maximized_new_window)
  {
    Mdi.style |= WS_MAXIMIZE;
  }
  
  Mdi.lParam  = (LONG) this;
  
  ::StatusOut("");
  
  // 2 != True && 2 != False
  this->hscroll_shown_p = 2;
  this->vscroll_shown_p = 2;
  
  this->presentation->AddDocumentWindow(this);
  disable_scrollbar_control = True;
  this->SetHandle(MainWindow::GetMDIClient() ->MakeChildWindow(Mdi));
  disable_scrollbar_control = False;
  
  if (this->GetHandle() != 0)
  {
    SetScrollRange(GetHandle(), SB_VERT, 0, SCROLLMAX, FALSE);
    SetScrollRange(GetHandle(), SB_HORZ, 0, SCROLLMAX, FALSE);
    this->control_scroll_bar();
    
    SetName(name);
    Show();
    SetView(0, 0);
    SetFocus();
    ::SendMessage(client->GetHandle(), WM_MDIACTIVATE, (WPARAM_T)GetHandle(), 0); 
  }
  else
  {
    this->presentation->RemoveDocumentWindow(this);
    MessageBeep(0); // the best we can do?
  }
}

// public destructor
DocumentWindow::~DocumentWindow()
{
  this->Destroy();
  delete this->editor;
  xfree(this->name);
}


void
DocumentWindow::Destroy()
{
  for (Interval* i = this->GetEditor() ->GetSelection() ->GetHead();
       i; i = i->GetNext())
  {
    // do not invalidate
    i->TurnOnOff(IV_ALLMASK, 0, False);
  }
  this->ReleaseDC();
  if (Selected_Window == this)
  {
    Selected_Window = 0;
    PWordPresentation::Update();
  }
  MDIChild::Destroy();
}


void
DocumentWindow::Reset()
{
  editor->Reset();
  RecalcLayouts();
}

// public constructor
DocumentWindow::DocumentWindow(DocumentPresentation* docprese,
				char* name, PStream* stream)
{
  Init(docprese);
  
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_DOCWIN, vers);
  CHECK;
  
  MDICREATESTRUCT Mdi;
  Mdi.style   = 0;
  Mdi.x       = CW_USEDEFAULT;
  Mdi.y       = CW_USEDEFAULT;
  Mdi.cx      = CW_USEDEFAULT;
  Mdi.cy      = CW_USEDEFAULT;
  
  scaling = stream->InUWord();
  
  // size handling
  size = stream->InUWord();
  
  Mdi.style = 0;
  switch (size)
  {
   case SIZEFULLSCREEN:
    Mdi.style |= WS_MAXIMIZE;
    break;
   case SIZEICONIC:
    Mdi.style |= WS_MINIMIZE;
    break;
  }
  
  this->normal_position.left =  stream->InWord();
  this->normal_position.top =  stream->InWord();
  this->normal_position.right = stream->InWord();
  this->normal_position.bottom = stream->InWord();
  
  if (Pref_restore_window_position)
  {
    Mdi.x = this->normal_position.left;
    Mdi.y = this->normal_position.top;
    Mdi.cx = this->normal_position.right;
    Mdi.cy = this->normal_position.bottom;
  }
  
  editor = new DocumentEdit(this, stream);
  Make(Mdi, name, False);
  stream->EndBlockIn();
}


void
DocumentWindow::WriteToStream(PStream* stream)
{
  stream->StartBlockOut(PStream::HDR_DOCWIN);
  {
    stream->OutUWord(scaling);
    stream->OutUWord(size);
    
    // window position

    // WIN32: Windows positions may not exceed 'word' max. (kudou)
    stream->OutWord((word)this->normal_position.left);
    stream->OutWord((word)this->normal_position.top);
    stream->OutWord((word)this->normal_position.right);
    stream->OutWord((word)this->normal_position.bottom);
    
    editor->WriteToStream(stream);
  }
  stream->EndBlockOut();
}

// ------------------------------------------------------------
// from docwndpr.cpp

// for redisplay text
bool painting_selected_window = False;

HDC
DocumentWindow::GetTrueDC()
{
  return(::GetDC(this->GetHandle()));
}

void
DocumentWindow::ReleaseTrueDC(HDC dc)
{
  ::ReleaseDC(this->GetHandle(), dc);
}

HWND
DocumentWindow::MaybeGetWindowHandle()
{
  return(this->GetHandle());
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
DocumentWindow::NewWindow(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
DocumentWindow::NewWindow(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  // ???
  if (Selected_Window == NULL)
  {
    return(menu_state_p ? MF_GRAYED : 0);
  }
  if (menu_state_p)
  {
    return(MF_ENABLED);
  }
  
  DocumentWindow* nw = presentation->NewDocumentWindow(False);
  if (nw == NULL)
  {
    Issue(S_CantOpenWindowMsg, MB_OK | MB_ICONEXCLAMATION);
  }
  else
  {
    // iconize all windows except the current one and the new one
    for (Document* d = PWordBase::GetFirstDocument();
	 d != NULL; d = d->GetNextDocument())
    {
      for (DocumentWindow* dw = d->GetFirstDocWindow();
	   dw != NULL; dw = dw->GetNextDocWindow())
      {
	if (dw != this && dw != nw)
	{
	  dw->SendMessage(WM_SYSCOMMAND, SC_MINIMIZE);  // this way?
	}
      }
    }
    nw->SetView(this->GetLX(), this->GetLY());
    nw->SetFocus();
    
    ::SendMessage(MainWindow::GetMDIClient()->GetHandle(), WM_MDITILE, 0, 0);
  }
  return(0);
}

// private method
void NEAR
DocumentWindow::Zoom(int new_scaling)
{
  if (new_scaling == scaling)
  {
    ::MessageBeep(0);
  }
  else
  {
    ::StatusOut(S_WindowSize, new_scaling);
    scaling = new_scaling;
    this->SetScaling(new_scaling);
    {
      RECT rect[1];
      ::GetClientRect(this->GetHandle(), rect);
      this->Width = this->ScaleLunitX(rect->right - rect->left);
      this->Height = this->ScaleLunitY(rect->bottom - rect->top);
    }
    this->Recenter(True);
  }
}

// This method handles IDM_Disp_ZoomWindow_Inc and IDM_Disp_ZoomWindow_Dec
// commands.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
DocumentWindow::ZoomWindow_Inc_Dec(bool menu_state_p, int delta, int other_command)
#else /* BW3_DISPATCH */
long NEAR
DocumentWindow::ZoomWindow_Inc_Dec(int menu_state_p, int delta, int other_command)
#endif /* BW3_DISPATCH */
{
  // Be careful,  this table must match `scaling_table' in View::SetScaling.
  static int winsizes[] = { 25, 33, 50, 67, 100, 150, 200, 300, 0 };
  
  int new_scaling = StepSize(scaling, delta, winsizes);
  if (menu_state_p)
  {
    return(new_scaling == scaling ? MF_GRAYED : MF_ENABLED);
  }
  Again::ToDoAgainInOtherDirection(other_command);
  this->Zoom(new_scaling);
  return(0);
}

#ifdef BW3_DISPATCH
LRESULT_T NEAR
DocumentWindow::ZoomWindow(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
DocumentWindow::ZoomWindow(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (menu_state_p)
  {
    return MF_ENABLED;
  }
  if (!dispatch_inc_dec(IDM_Disp_ZoomWindow_Inc, IDM_Disp_ZoomWindow_Dec))
  {
    int new_scaling;
    // Control dialog life.
    {
      NumberDialog dialog("Zoom", 25, 300, scaling);
      if (!dialog.Go())
      {
	Again::CantDoAgain();
	return(0);
      }
      new_scaling = dialog.get_value();
    }
    this->Zoom(new_scaling);
  }
  return(0);
}

#ifdef BW3_DISPATCH
LRESULT_T
DocumentWindow::Dispatch(WORD command, WORD notify_code, HWND hwnd)
#else /* BW3_DISPATCH */
long
DocumentWindow::Dispatch(int command, long lParam)
#endif /* BW3_DISPATCH */
{
#ifdef BW3_DISPATCH
  bool menu_state_p = MENU_STATE_P(notify_code);
#else /* BW3_DISPATCH */
  int menu_state_p = MENU_STATE_P(lParam);
#endif /* BW3_DISPATCH */
  switch (command)
  {
  case IDM_Disp_ZoomWindow:
    return ZoomWindow(menu_state_p);
    
  case IDM_Disp_ZoomWindow_Inc:
    return ZoomWindow_Inc_Dec(menu_state_p, 1, IDM_Disp_ZoomWindow_Dec);
    
  case IDM_Disp_ZoomWindow_Dec:
    return ZoomWindow_Inc_Dec(menu_state_p, -1, IDM_Disp_ZoomWindow_Inc);
    
  case IDM_Disp_Refresh:
    this->Recenter(False);
    return(0);
    
  case IDM_Disp_NextWindow:
    return this->SendMessage(WM_SYSCOMMAND, SC_NEXTWINDOW);
    
  case IDM_Disp_PrevWindow:
    return this->SendMessage(WM_SYSCOMMAND, SC_PREVWINDOW);
    
  case IDM_Disp_NewWindow:
    return this->NewWindow(menu_state_p);
    
  default:
#ifdef BW3_DISPATCH
    return this->GetEditor()->Dispatch(command, notify_code, hwnd);
#else /* BW3_DISPATCH */
    return this->GetEditor()->Dispatch(command, lParam);
#endif /* BW3_DISPATCH */
  }
}

// get edit frame
EditFrame* 
DocumentWindow::GetEditFrame()
{
  return(this->presentation->GetDocument() ->GetEditFrame());
}

// ------------------------------------------------------------
// window procedures

const int timer_frequency = 10;		// milliseconds
const int timer_number = 1;

//#define MOUSE_DELTA_DELTA 20
#define MOUSE_DELTA_DELTA	(Pref_mouse_min_move * Pref_mouse_min_move)

#ifdef FAKE_TIMERBASED_MOUSEMOVE
#ifdef _WIN32
void
#else /* _WIN32 */
WORD FAR PASCAL
#endif /* _WIN32 */
DocumentWindow::timer_handler_ (HWND hWnd,
				UINT /*wMsg*/, UINT nIDEvent, DWORD /*dwTime*/)
{
  if (nIDEvent == timer_number && Selected_Window != NULL)
  {
    long pt;
    GetCursorPos((LPPOINT) &pt);
    ::ScreenToClient(hWnd, (LPPOINT) &pt);
    ::SendMessage(hWnd, WM_FAKETIMERBASEDMOUSEMOVE, 0, pt);
  }
#ifdef _WIN32
#else /* _WIN32 */
  return(0);  // what are these things supposed to return?
#endif /* _WIN32 */
}
#endif /* FAKE_TIMERBASED_MOUSEMOVE */

void NEAR
DocumentWindow::HandleMouse(WORD Msg, WORD wParam, LONG lParam)
{
  HWND handle = this->GetHandle();
  switch (Msg)
  {
   case WM_LBUTTONDBLCLK:
   case WM_LBUTTONDOWN:
    if ((wParam & (MK_MBUTTON | MK_RBUTTON)) == 0)
    {
      SetCapture(handle);
      this->mouse.work_lx = (Lunit) LPARAM_TO_X(lParam);
      this->mouse.work_ly = (Lunit) LPARAM_TO_Y(lParam);
      this->mouse.activep = True;
      this->mouse.movedp = False;
    }
    break;
    
   case WM_LBUTTONUP:
    ReleaseCapture();
    KillTimer(handle, timer_number);
    this->mouse.activep = False;
    break;

#ifdef FAKE_TIMERBASED_MOUSEMOVE
   case WM_FAKETIMERBASEDMOUSEMOVE:
#else /* FAKE_TIMERBASED_MOUSEMOVE */
   case WM_MOUSEMOVE:
    if (this != Selected_Window)
    {
      return;
    }
#endif /* FAKE_TIMERBASED_MOUSEMOVE */

    {
#ifdef FAKE_TIMERBASED_MOUSEMOVE
      Msg = WM_MOUSEMOVE;
#endif /* FAKE_TIMERBASED_MOUSEMOVE */
      
      // automatic scroll
      RECT r;
      ::GetClientRect(handle, &r);
      int x = LPARAM_TO_X(lParam);
      int y = LPARAM_TO_Y(lParam);
      int scroll_x = 0;
      int scroll_y = 0;
      {
	POINT p = {x, y};
	::ClientToScreen(handle, &p);
	if (p.x <= 1)
	{
	  x = r.left - (r.right - r.left) / AUTO_SCROLL_DENOMINATOR;
	}
	else if (Screen::width - 2 <= p.x)
	{
	  x = r.right + (r.right - r.left) / AUTO_SCROLL_DENOMINATOR;
	}
	if (p.y <= 1)
	{
	  y = r.top - (r.bottom - r.top) / AUTO_SCROLL_DENOMINATOR;
	}
	else if (Screen::height - 2 <= p.y)
	{
	  y = r.bottom + (r.bottom - r.top) / AUTO_SCROLL_DENOMINATOR;
	}
      }
      if (x < r.left)
      {
	scroll_x = x - r.left;
	x = r.left;
      }
      else if (r.right < x)
      {
	scroll_x = x - r.right;
	x = r.right;
      }
      if (y < r.top)
      {
	scroll_y = y - r.top;
	y = r.top;
      }
      else if (r.bottom < y)
      {
	scroll_y = y - r.bottom;
	y = r.bottom;
      }
      if (scroll_x != 0 || scroll_y != 0)
      {
	this->SetViewOnDunitRelative(scroll_x, scroll_y);
      }
      lParam = MAKELONG(x, y);
    }
    // no break

#ifdef  FAKE_TIMERBASED_MOUSEMOVE
   case WM_MOUSEMOVE:
    if (this != Selected_Window)
    {
      return;
    }
#endif /* FAKE_TIMERBASED_MOUSEMOVE */
    
    if (this->mouse.activep)
    {
      int x = LPARAM_TO_X(lParam);
      int y = LPARAM_TO_Y(lParam);
      if (!this->mouse.movedp)
      {
	int diff_x = (int) this->mouse.work_lx - x;
	int diff_y = (int) this->mouse.work_ly - y;
	if (diff_x * diff_x + diff_y * diff_y < MOUSE_DELTA_DELTA)
	{
	  return;
	}
	this->mouse.movedp = True;
	this->mouse.work_lx = this->LunitX(x);
	this->mouse.work_ly = this->LunitY(y);
#ifdef FAKE_TIMERBASED_MOUSEMOVE
	// Win32 desn't need these type of hacking. (kudou)
	SetTimer(handle,
		  timer_number,
		  timer_frequency, (TIMERPROC) DocumentWindow::timer_handler);
#endif /* FAKE_TIMERBASED_MOUSEMOVE */
      }
      else
      {
	Lunit lx = this->LunitX(x);
	Lunit ly = this->LunitY(y);
	if (this->mouse.work_lx == lx && this->mouse.work_ly == ly)
	{
	  return;
	}
	this->mouse.work_lx = lx;
	this->mouse.work_ly = ly;
      }
    }
    break;
  }
  
  void(EditFrame::*fun) (DocumentWindow* , MSG_T, WPARAM_T, LPARAM_T) = NULL;
  switch (PWordPresentation::GetEditModeStatus())
  {
   case Cut_MODE:
    fun = &EditFrame::WndProcCut;
    break;
    
   case DrawLine_MODE:
    fun = &EditFrame::WndProcDrawLine;
    break;
    
   case MoveLine_MODE:
    fun = &EditFrame::WndProcMoveLine;
    break;
    
   case SelectFrame_MODE:
    fun = &EditFrame::WndProcSelectFrame;
    break;
    
   case SetFlow_MODE:
    fun = &EditFrame::WndProcSetFlow;
    break;
    
   case ExchFlow_MODE:
    fun = &EditFrame::WndProcExchFlow;
    break;
    
   case SetMargin_MODE:
    fun = &EditFrame::WndProcSetMargin;
    break;
    
   case MakeTable_MODE:
    fun = &EditFrame::WndProcMakeTable;
    break;
    
   case FrameMargin_MODE:
    fun = &EditFrame::WndProcFrameMargin;
    break;
  }
  
  if (fun)
  {
    (this->GetEditFrame() ->*fun) (this, Msg, wParam, lParam);
  }
  else
  {
    this->editor->GetDocMouse() ->WndProc(Msg, wParam, lParam);
  }
}

static void NEAR
fill_background_rect(HDC dc, HRGN region, RECT* rect, int left, int bottom)
{
  int top = rect->bottom;
  if (top < bottom)
  {
    rect->top = top;
    rect->bottom = bottom;
    if (left < rect->right)
    {
      rect->left = left;
      if (::RectInRegion(region, rect))
      {
	// background color
	::FillRect(dc, rect, Screen::stocked_gray_brush);
      }
    }
  }
}

HBITMAP STATIC_NEAR DocumentWindow::bitmap = 0;
int STATIC_NEAR DocumentWindow::bitmap_width = 0;
int STATIC_NEAR DocumentWindow::bitmap_height = 0;

// static method
void
DocumentWindow::KillBitmap()
{
  if (DocumentWindow::bitmap)
  {
    ::DeleteObject(DocumentWindow::bitmap);
    DocumentWindow::bitmap = 0;
    DocumentWindow::bitmap_width = 0;
    DocumentWindow::bitmap_height = 0;
  }
}

void NEAR
DocumentWindow::HandlePaint()
{
  painting_selected_window = this == Selected_Window;
  
  HWND handle = this->GetHandle();
  
  HRGN region;
  ::GetUpdateRgn(handle, region = ::CreateRectRgn(0, 0, 0, 0), False);
  
  PAINTSTRUCT ps[1];
  this->ReleaseDC();
  this->BeginPaint(ps);
  HDC this_dc = ps->hdc;
  this->SetDC(this_dc);
  
  RECT client_rect[1];
  ::GetClientRect(handle, client_rect);
  
  HRGN client_region = ::CreateRectRgnIndirect(client_rect);
  int combine_state = ::CombineRgn(region, region, client_region, RGN_AND);
  ::DeleteObject(client_region);
  
  extern bool printing_now_p;
  if (combine_state != NULLREGION && !printing_now_p)
  {
    int client_width = client_rect->right - client_rect->left;
    int client_height = client_rect->bottom - client_rect->top;
#ifdef INVALIDATE_LINE_ONLY
    if (Pref_flicker || OnlyRequestedLineP())
#else
    if (Pref_flicker)
#endif
    {
      if (DocumentWindow::bitmap != 0)
      {
	DocumentWindow::KillBitmap();
      }
    }
    else
    {
      if (DocumentWindow::bitmap_width < client_width
	  || DocumentWindow::bitmap_height < client_height)
      {
	int width = MAX(DocumentWindow::bitmap_width, client_width);
	int height = MAX(DocumentWindow::bitmap_height, client_height);
	DocumentWindow::KillBitmap();
	DocumentWindow::bitmap = ::CreateCompatibleBitmap(this_dc,
							   width, height);
	if (DocumentWindow::bitmap)
	{
	  DocumentWindow::bitmap_width = width;
	  DocumentWindow::bitmap_height = height;
	}
      }
    }
    
    View* view;
    View bitmap_view[1];
    HDC dc = 0;
    if (DocumentWindow::bitmap)
    {
      dc = ::CreateCompatibleDC(this_dc);
    }
    if (dc)
    {
      ::SelectObject(dc, DocumentWindow::bitmap);
      view = bitmap_view;
      bitmap_view->SetDC(dc);
      bitmap_view->SetDeviceType(SCREEN);
      bitmap_view->SetInternalDPI(this->GetInternalDPI());
      bitmap_view->SetLX(this->GetLX());
      bitmap_view->SetLY(this->GetLY());
    }
    else
    {
      DocumentWindow::KillBitmap();
      dc = this_dc;
      view = this;
    }
    ::SelectObject(dc, region);
    
    RECT clip_rect[1];
    ::GetRgnBox(region, clip_rect);
    
    RECT fill_rect[1];
    fill_rect->right = clip_rect->right;
    fill_rect->bottom = clip_rect->top;
    
    for (LayoutInstance* layout = this->GetBeginningLayout();
	 layout != this->GetEndLayout();
	 layout = layout->GetNextLayout())
    {
      Lrect layout_lrect[1];
      RECT zero_rect[1];
      RECT rim_rect[1];
      layout->get_zero_page_lrect(layout_lrect);
      view->lrect_to_drect(layout_lrect, CastWindowsRECTToDrect(zero_rect));
      rim_rect->left = zero_rect->left;
      rim_rect->right = zero_rect->right + 2;
      rim_rect->top = zero_rect->top - 1;
      rim_rect->bottom = zero_rect->bottom + 2;
      
      if (rim_rect->bottom <= clip_rect->top)
      {
	continue;
      }
      
      fill_background_rect(dc,
			    region,
			    fill_rect, clip_rect->left, rim_rect->top);
      
      if (clip_rect->bottom <= rim_rect->top)
      {
	break;
      }
      
      if (::RectInRegion(region, rim_rect))
      {
	fill_background_rect(dc,
			      region,
			      fill_rect, rim_rect->right, rim_rect->bottom);
	
	// redisplay outside frame of zero-page
	
	// top
	rim_rect->right = zero_rect->right;
	rim_rect->bottom = zero_rect->top;
	::FillRect(dc, rim_rect, Screen::stocked_black_brush);
	
	// bottom
	rim_rect->right = zero_rect->left + 1;
	rim_rect->top = zero_rect->bottom + 1;
	rim_rect->bottom = zero_rect->bottom + 2;
	::FillRect(dc, rim_rect, Screen::stocked_light_gray_brush);
	rim_rect->left = zero_rect->left + 1;
	rim_rect->right = zero_rect->right;
	::FillRect(dc, rim_rect, Screen::stocked_black_brush);
	rim_rect->left = zero_rect->left;
	rim_rect->top = zero_rect->bottom;
	rim_rect->bottom = zero_rect->bottom + 1;
	::FillRect(dc, rim_rect, Screen::stocked_black_brush);
	
	// right
	rim_rect->left = zero_rect->right + 1;
	rim_rect->right = zero_rect->right + 2;
	rim_rect->top = zero_rect->top - 1;
	rim_rect->bottom = zero_rect->top;
	::FillRect(dc, rim_rect, Screen::stocked_light_gray_brush);
	rim_rect->top = zero_rect->top;
	rim_rect->bottom = zero_rect->bottom + 2;
	::FillRect(dc, rim_rect, Screen::stocked_black_brush);
	rim_rect->left = zero_rect->right;
	rim_rect->right = zero_rect->right + 1;
	rim_rect->top = zero_rect->top - 1;
	::FillRect(dc, rim_rect, Screen::stocked_black_brush);
	
	if (clip_rect->bottom <= zero_rect->top)
	{
	  break;
	}
	layout->RedisplayTopLevel(view, region);
      }
    }
    fill_background_rect(dc,
			  region,
			  fill_rect, clip_rect->left, clip_rect->bottom);
    
    if (PWordPresentation::GetEditModeStatus() != InputText_MODE)
    {
      this->GetEditFrame() ->Redisplay(view);
    }
    
    if (DocumentWindow::bitmap)
    {
      ::BitBlt(this_dc,
		0, 0, client_width, client_height, dc, 0, 0, SRCCOPY);
      ::DeleteDC(dc);
    }
  }
  
  this->ResetDC();
  this->EndPaint(ps);
//  ::ValidateRgn(handle, region);
  ::DeleteObject(region);
  
  painting_selected_window = False;
  only_requested_line_p = False;
}

LRESULT_T
DocumentWindow::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  long result = 0;
  switch (Msg)
  {
   case WM_NCLBUTTONDOWN:
    Msg = Msg;
    goto default_proc;
    
   case WM_CLOSE:
    // this message gets here when the user clicks on the close box.
    // CAUTION !  Next statement kill `this'.  Must return soon.
    this->GetPresentation() ->CloseWindow(this);
    // RETURN IMMEDIATELY !!!
    return(0);
    
   case WM_MDIACTIVATE:
    {
#ifdef _WIN32
      // WM_MDIACTIVATE message specification was changed from
      // 16-bit windows. (kudou)
      HWND hwndChildAct = (HWND)lParam;
      HWND hwndChildDeact = (HWND)wParam;
      HWND me = this->GetHandle();
      if (me ==  hwndChildAct)
      {
	assert(Selected_Window != this);
	Selected_Window = this;
	Selected_Document = this->presentation->GetDocument();
	this->GetEditor() ->GetSelection() ->TurnOn();
	bool frame_sel = this->GetEditFrame() ->HasSelection();
	if (frame_sel)
	{
	  InvalidateAll();
	}
	DocumentWindow::touch_caret();
	DocumentWindow::control_ime();
	this->SetFocus();
      }
      else if (me == hwndChildDeact)
      {
	assert(this == Selected_Window);
	this->GetEditor() ->GetSelection() ->TurnOff();
	bool frame_sel = this->GetEditFrame() ->HasSelection();
	if (frame_sel)
	{
	  InvalidateAll();
	}
	this->UnforceTouchCaret();
	PIME::DefaultConvertWin();
	Again::ClearInput();
      }
#else /* _WIN32 */
      if (wParam)
      {
	assert(Selected_Window != this);
	Selected_Window = this;
	Selected_Document = this->presentation->GetDocument();
	this->GetEditor() ->GetSelection() ->TurnOn();
	bool frame_sel = this->GetEditFrame() ->HasSelection();
	if (frame_sel)
	{
	  InvalidateAll();
	}
	DocumentWindow::touch_caret();
	DocumentWindow::control_ime();
	this->SetFocus();
      }
      else
      {
	assert(this == Selected_Window);
	this->GetEditor() ->GetSelection() ->TurnOff();
	bool frame_sel = this->GetEditFrame() ->HasSelection();
	if (frame_sel)
	{
	  InvalidateAll();
	}
	this->UnforceTouchCaret();
	PIME::DefaultConvertWin();
	Again::ClearInput();
      }
#endif /* _WIN32 */
    }
    goto default_proc;
    
   case WM_PAINT:
    this->HandlePaint();
    break;
    
   case WM_SETCURSOR:
    if (!MouseCursor::WMSetCursor(this == Selected_Window, LOWORD(lParam)))
    {
      goto default_proc;
    }
    MDIChild::WMSetCursor();
    break;
    
   case WM_RBUTTONDBLCLK:
   case WM_RBUTTONDOWN:
    if (!this->mouse.activep)
    {
      break;
    }
    // fall through

#ifdef FAKE_TIMERBASED_MOUSEMOVE
   case WM_FAKETIMERBASEDMOUSEMOVE:
#endif /* FAKE_TIMERBASED_MOUSEMOVE */
   case WM_LBUTTONDBLCLK:
   case WM_LBUTTONDOWN:
   case WM_LBUTTONUP:
   case WM_MOUSEMOVE:
    if (size == SIZEICONIC)
    {
      goto default_proc;
    }
    this->HandleMouse(Msg, wParam, lParam);
    break;
    
   case WM_CHAR:
   case WM_IME_REPORT:
    if (!this->mouse.activep)
    {
      if (size == SIZEICONIC)
      {
	goto default_proc;
      }
      result = (this
		->GetEditor()
		->GetDocumentChar() ->WndProc(Msg, wParam, lParam));
    }
    break;
    
   case WM_VSCROLL:
    disable_scrollbar_control = True;
#ifdef _WIN32
    {
      int nScrollCode = (int) LOWORD(wParam);
      short int nPos = (short int)HIWORD(wParam);
#else /* _WIN32 */
      int nScrollCode = wParam;
      int nPos = LOWORD(lParam);
#endif /* _WIN32 */
#if 1 
      switch (nScrollCode)
      {
      case SB_LINEUP:
	IncScroll(0, -1);
	break;
      case SB_LINEDOWN:
	IncScroll(0, 1);
	break;
      case SB_THUMBPOSITION:
        {
	  Lunit max_y = (this->GetContent())->GetLHeight() - this->GetLHeight();
	  this->SetView(this->GetLX(),
			(Lunit) (((double) max_y * nPos) / SCROLLMAX));
	}
	break;
      case SB_PAGEDOWN:
	SetView(this->GetLX(), this->GetLY() + this->GetLHeight());
	break;
      case SB_PAGEUP:
	SetView(this->GetLX(), this->GetLY() - this->GetLHeight());
	break;
      }
    }
#else /* 1 */
    // old code
    if (wParam == SB_LINEUP)
    {
      IncScroll(0, -1);
    }
    else if (wParam == SB_LINEDOWN)
    {
      IncScroll(0, 1);
    }
    else if (wParam == SB_THUMBPOSITION)
    {
      Lunit max_y = (this->GetContent())->GetLHeight() - this->GetLHeight();
      this->SetView(this->GetLX(),
		     (Lunit) (((double) max_y * LOWORD(lParam)) / SCROLLMAX));
    }
    else if (wParam == SB_PAGEDOWN)
    {
      this->SetView(this->GetLX(), this->GetLY() + this->GetLHeight());
    }
    else if (wParam == SB_PAGEUP)
    {
      this->SetView(this->GetLX(), this->GetLY() - this->GetLHeight());
    }
#endif /* 1 */
    disable_scrollbar_control = False;
    break;
    
   case WM_HSCROLL:
    disable_scrollbar_control = True;
#ifdef _WIN32
    {
      int nScrollCode = (int) LOWORD(wParam);
      short int nPos = (short int)HIWORD(wParam);
#else /* _WIN32 */
      int nScrollCode = wParam;
      int nPos = LOWORD(lParam);
#endif /* _WIN32 */
#if 1 
      switch (nScrollCode)
      {
      case SB_LINEUP:
	IncScroll(-1, 0);
	break;
      case SB_LINEDOWN:
	IncScroll(1, 0);
	break;
      case SB_THUMBPOSITION:
      {
	Lunit max_x = (this->GetContent())->GetLWidth() - this->GetLWidth();
	this->SetView((Lunit) (((double) max_x * nPos) / SCROLLMAX),
		      this->GetLY());
      }
      break;
      case SB_PAGEDOWN:
	SetView(this->GetLX() + this->GetLWidth(), this->GetLY());
	break;
      case SB_PAGEUP:
	SetView(this->GetLX() - this->GetLWidth(), this->GetLY());
	break;
      }
    }
#else /* 1 */
    // old code
    if (wParam == SB_LINEUP)
    {
      IncScroll(-1, 0);
    }
    else if (wParam == SB_LINEDOWN)
    {
      IncScroll(1, 0);
    }
    else if (wParam == SB_THUMBPOSITION)
    {
      Lunit max_x = (this->GetContent())->GetLWidth() - this->GetLWidth();
      this->SetView((Lunit) (((double) max_x * LOWORD(lParam)) / SCROLLMAX),
		     this->GetLY());
    }
    else if (wParam == SB_PAGEDOWN)
    {
      this->SetView(this->GetLX() + this->GetLWidth(), this->GetLY());
    }
    else if (wParam == SB_PAGEUP)
    {
      this->SetView(this->GetLX() - this->GetLWidth(), this->GetLY());
    }
#endif /* 1 */
    disable_scrollbar_control = False;
    break;
    
   case WM_SIZE:
    if ((this->size = wParam) != SIZEICONIC)
    {
      this->Width = this->ScaleLunitX(LOWORD(lParam));
      this->Height = this->ScaleLunitY(HIWORD(lParam));
      this->SetView(this->GetLX(), this->GetLY());
      this->RecalcLayouts();
    }
    // fall through

   case WM_MOVE:
    if (this->size != SIZEICONIC && this->size != SIZEFULLSCREEN)
    {
      this->GetRect(&this->normal_position);
      ::ScreenToClient(client->GetHandle(),
			(POINT*) &this->normal_position.left);
      ::ScreenToClient(client->GetHandle(),
			(POINT*) &this->normal_position.right);
      this->normal_position.right -= this->normal_position.left;
      this->normal_position.bottom -= this->normal_position.top;
    }
    this->TouchCaret();
    this->ControlIME();
    goto default_proc;
    
   case WM_CREATE:
    this->GetDC();
    this->SetScaling(scaling);
    Show(SW_HIDE);
    break;
    
   case WM_DESTROY:
    break;
    
   case WM_SETFOCUS:
    this->TouchCaret();
    this->ControlIME();
    break;
    
   case WM_KILLFOCUS:
    this->UntouchCaret();
    break;
    
   case WM_KEYDOWN:
    if (size != SIZEICONIC)
    {
      switch (wParam)
      {
       case VK_PRIOR:
	SendMessage(WM_VSCROLL, SB_PAGEUP, 0);
	break;
       case VK_NEXT:
	SendMessage(WM_VSCROLL, SB_PAGEDOWN, 0);
	break;
       default:
	break;
      }
    }
    goto default_proc;
    
   default:
   default_proc:
    result = MDIChild::WndProc(Msg, wParam, lParam);
  }
  this->ReleaseDC();
  return(result);
}

// invalidate layout
void NEAR 
DocumentWindow::InvalidateLayout(LayoutInstance* li)
{
  Irect irec[1];
  RECT_TOP_X(irec) = 0;
  RECT_TOP_Y(irec) = 0;
  RECT_BOT_X(irec) = li->GetWidth();
  RECT_BOT_Y(irec) = li->GetHeight();
  Lrect lrec;
  li->irect_to_lrect(irec, &lrec);
  Invalidate(&lrec);
}

// invalidate only requested frame
void NEAR 
DocumentWindow::InvalidateRequestedFrame(LayoutInstance* li)
{
  FOIterator foi(li->GetLayoutTemplate()->GetFissionFrame());
  FrameObject* fo;
  while ((fo = foi()) != 0)
  {
    if (fo->RedisplayRequestedP())
    {
      Irect irec = fo->GetInternalIrect();
      Lrect lrec;
      li->irect_to_lrect(&irec, &lrec);
      Invalidate(&lrec);
    }
  }
}

// invalidate only requested line
void NEAR 
DocumentWindow::InvalidateRequestedLine(LayoutInstance* li)
{
  InvalidateLayout(li);
}

// invalidate layout
void NEAR 
DocumentWindow::Invalidate(LayoutInstance* li, invalidate_request ir)
{
  switch (ir)
  {
   case invalidate_all:
    InvalidateLayout(li);
    break;
   case invalidate_frame:
    InvalidateRequestedFrame(li);
    break;
   case invalidate_line:
    InvalidateRequestedLine(li);
    break;
  }
}

// invalidate layout
void NEAR 
DocumentWindow::Invalidate(LayoutTemplate* lt,
			    invalidate_request ir)
{
  switch (lt->GetKind())
  {
   case LayoutTemplate::RegularTemplate:
    {
      for (LayoutInstance* li = beginning_layout;
	   li != 0;
	   li = (li == end_layout) ? 0 : li->GetNextLayout())
      {
	if (li->GetLayoutTemplate() == lt)
	{
	  Invalidate(li, ir);
	}
      }
    }
    break;
   case LayoutTemplate::PageSizeTemplate:
    {
      for (LayoutInstance* li = beginning_layout;
	   li != 0;
	   li = (li == end_layout) ? 0 : li->GetNextLayout())
      {
	LayoutInstance* zero_li = li->GetZeroPageLayout();
	Invalidate(zero_li, ir);
      }
    }
    break;
   case LayoutTemplate::TableTemplate:
    {
      Panel* pl = GetContent()->GetTablePanel(lt);
      if (pl == 0)
      {
	// deleting frame now...
	break;
      }
      Table* table = ((TablePanel*)pl)->GetTable();
      LayoutInstance* table_li = table->GetLayout();
      TextFlow* flow = pl->GetRightBP()->GetTextFlow();;
      if (flow->OnZeroPageP())
      {
	// on zero page table
	// invalidate zero page frames which this table is positioned on.
	
	// find top level frame
	FrameInstance* top_fi = 0;
	while ((pl = table_li->GetPanel()) != 0)
	{
	  top_fi = pl->GetRightBP()->GetTextFlow()->GetFirstFrame();
	  assert(top_fi != 0);
	  table_li = top_fi->GetLayoutInstance();
	}
	assert(top_fi != 0);
	// invalidate these frame
	for (LayoutInstance* li = beginning_layout;
	     li != 0;
	     li = (li == end_layout) ? 0 : li->GetNextLayout())
	{
	  LayoutInstance* zero_li = li->GetZeroPageLayout();
	  Irect irec = top_fi->GetFrameTemplate()->GetInternalIrect();
	  Lrect lrec;
	  zero_li->irect_to_lrect(&irec, &lrec);
	  Invalidate(&lrec);
	}
      }
      else
      {
	// this table is on the regular page or on the table
	Invalidate(table_li, ir);
      }
    }
    break;
  }
}

// invalidate layout
void 
DocumentWindow::InvalidateLayout(LayoutTemplate* lt)
{
  Invalidate(lt, invalidate_all);
}

// invalidate only redisplay requested frame
void 
DocumentWindow::InvalidateRequestedFrame(LayoutTemplate* lt)
{
  Invalidate(lt, invalidate_frame);
}

// invalidate only redisplay requested line
void 
DocumentWindow::InvalidateRequestedLine(LayoutTemplate* lt)
{
  Invalidate(lt, invalidate_line);
  only_requested_line_p = True;
}
