// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: drawline.cpp,v 3.3 1999/05/23 17:26:08 kudou Exp $
// class EditFrame
// t[GfB^̐c[

#include "pword.h"
#include "editfram.h"
#include "allayout.h"
#include "borderli.h"
#include "docwindo.h"
#include "fission.h"
#include "frameown.h"
#include "layoutin.h"
#include "layoutte.h"
#include "mcursor.h"
#include "pagemap.h"
#include "pagesize.h"
#include "vdisplay.h"

void NEAR 
EditFrame::DrawLine_LDWN(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  // start fix
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  Fission* f = 0;
  if ((LockLayout(mpos) == 0) ||
      ((f = FindDrawFissionW(mpos)) == 0)) 
  {
    CancelDrawLine();
    return;
  }
  ShowDrawLinePos(f, mpos);
  line.SetStart(f, 
		 (f->GetDir() == Fission::Vertical) ? 
		 WtoIy(mpos.y) : WtoIx(mpos.x),
		 IsMarginLine(f));
  RedisplayDrawLine();
  MouseCursor::PenOn();
}

void NEAR 
EditFrame::DrawLine_MV(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  if (line.IsFixed() == False) 
  {
    // idle
    line.Reset();
    Fission* f = 0;
    VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
    if ((LockLayout(mpos) == 0) || 
	((f = FindDrawFissionW(mpos)) == 0)) 
    {
      ClearPosition();
      MouseCursor::PenOff();
    }
    else 
    {
      ShowDrawLinePos(f, mpos);
      MouseCursor::Pen();
    }
  }
  else 
  {
    // dragging
    VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
    Fission* f = 0;
    LayoutInstance* li = FindLayoutW(mpos);
    if (li != GetEditLI()) 
    {
      if (line.IsMarginLine() && 
	  IsMarginLineSwapCase(li)) 
      {
	// sawp zero layout and regular page layout
	// for margin line start position
	if (GetEditLT()->GetKind() == 
	    LayoutTemplate::RegularTemplate) 
	{
	  // regular to zero layout
	  // edit_li : regular 
	  // li      : zero page
	  PageSize* ps = (PageSize*)li->GetPageMap();
	  AllLayout* al = ps->GetAllLayout();
	  FissionFrame* ff = GetEditFF();
	  f = line.GetStartFission();
	  Iunit pos = line.GetPos();
	  if (f->GetDir() == Fission::Vertical) 
	  {
	    pos += ps->GetAllLayoutsOffsetY();
	  }
	  else 
	  {
	    pos += ps->GetAllLayoutsOffsetX();
	  }
	  
	  Fission* top;
	  Fission* bottom;
	  Fission* left;
	  Fission* right;
	  al->GetMarginFission(&top, &bottom, &left, &right);
	  if (ff->GetTop() == f) 
	  {
	    f = top;
	  }
	  else if (ff->GetBottom() == f) 
	  {
	    f = bottom;
	  }
	  else if (ff->GetLeft() == f) 
	  {
	    f = left;
	  }
	  else if (ff->GetRight() == f) 
	  {
	    f = right;
	  }
	  else 
	  {
	    assert(0);
	  }
	  RedisplayDrawLine();		// vanish
	  line.SetStart(f, pos, True);
	  LayoutInstance* old_edit_li = GetEditLI();
	  LockLayout(mpos);
	  if (GetEditLT()->IsZeroPage()) 
	  {
	    // suppress page change!
	    regular_li = old_edit_li;
	  }
	  RedisplayDrawLine();		// show
	}
	else 
	{
	  // zero to regular layout
	  // edit_li : zero page
	  // li      : regular
	  f = line.GetStartFission();
	  Iunit pos = line.GetPos();
	  PageSize* ps = (PageSize*)GetEditLI()->GetPageMap();
	  if (f->GetDir() == Fission::Vertical) 
	  {
	    pos -= ps->GetAllLayoutsOffsetY();
	  }
	  else 
	  {
	    pos -= ps->GetAllLayoutsOffsetX();
	  }
	  AllLayout* al = ps->GetAllLayout();
	  FissionFrame* ff = li->GetLayoutTemplate()
	  ->GetFissionFrame();
	  Fission* top;
	  Fission* bottom;
	  Fission* left;
	  Fission* right;
	  al->GetMarginFission(&top, &bottom, &left, &right);
	  if (top == f) 
	  {
	    f = ff->GetTop();
	  }
	  else if (bottom == f) 
	  {
	    f = ff->GetBottom();
	  }
	  else if (left == f) 
	  {
	    f = ff->GetLeft();
	  }
	  else if (right == f) 
	  {
	    f = ff->GetRight();
	  }
	  else 
	  {
	    assert(0);
	  }
	  RedisplayDrawLine();		// vanish
	  line.SetStart(f, pos, True);
	  LockLayout(mpos);
	  RedisplayDrawLine();		// show
	}
      }
      else 
      {
	MouseCursor::Pen();
	return;
      }
    }
    MouseCursor::PenOn();
    if ((f = FindDrawToFissionW(mpos, 
				 line.GetStartFission(), 
				 line.GetPos())) == 0) 
    {
      return;
    }
    
    if (f->GetDir() != line.GetEndFission()->GetDir()) 
    {
      return;
    }
    
    if (f != line.GetEndFission()) 
    {
      RedisplayDrawLine();	// vanish
      line.SetEnd(f);
      RedisplayDrawLine();	// draw
    }
  }
}

void NEAR 
EditFrame::DrawLine_LUP(WPARAM_T wParam, LPARAM_T lParam)
{
  if (!line.IsFixed()) 
  {
    CancelDrawLine(False);
    return;
  }
  
  DrawLine_MV(wParam, lParam);
  
  if ((line.GetStartFission() == 0) ||
      (line.GetEndFission() == 0) ||
      (line.GetStartFission() == line.GetEndFission())) 
  {
    CancelDrawLine();
    return;
  }
  MouseCursor::PenOff();
  RedisplayDrawLine();	// vanish
  
  uword border_index = ((GetEditLT()->IsTable()) ? 
			BorderLine::GetDefaultTableIndex() :
			BorderLine::GetDefaultFrameIndex());
  
  if (line.GetStartFission()->GetDir() == Fission::Vertical) 
  {
    if (((VFission*)line.GetStartFission())->X() < 
	((VFission*)line.GetEndFission())->X()) 
    {
      GetEditFF()->Divide(line.GetStartFission(), 
			    line.GetEndFission(), 
			    line.GetPos(), border_index);
    }
    else 
    {
      GetEditFF()->Divide(line.GetEndFission(), 
			    line.GetStartFission(), 
			    line.GetPos(), border_index);
    }
  }
  else 
  {
    if (((HFission*)line.GetStartFission())->Y() < 
	((HFission*)line.GetEndFission())->Y()) 
    {
      GetEditFF()->Divide(line.GetStartFission(), 
			    line.GetEndFission(), 
			    line.GetPos(), border_index);
    }
    else 
    {
      GetEditFF()->Divide(line.GetEndFission(), 
			    line.GetStartFission(), 
			    line.GetPos(), border_index);
    }
  }
  line.Reset();
  UnforceTouchCaret();
  RedrawWindows();
  SetDirty();
}

// draw line mode
void
EditFrame::WndProcDrawLine(DocumentWindow* window, 
			    MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  EditFrame::window = window;
  switch (Msg) 
  {
   case WM_LBUTTONDOWN:
    DrawLine_LDWN(wParam, lParam);
    break;

   case WM_MOUSEMOVE:
    DrawLine_MV(wParam, lParam);
    break;
    
   case WM_LBUTTONUP:
    DrawLine_LUP(wParam, lParam);
    break;
    
   case WM_RBUTTONDOWN:
    CancelDrawLine(False);
    break;
  }
}

void 
EditFrame::CancelDrawLine(bool beep)
{
  if (line.IsFixed() &&
      (line.GetStartFission() != 0) &&
      (line.GetEndFission() != 0)) 
  {
    RedisplayDrawLine();	// vanish
  }
  line.Reset();
  MouseCursor::PenOff();
  if (beep) 
  {
    ::MessageBeep(0);
  }
}

// display draw-line object
void 
EditFrame::RedisplayDrawLine()
{
  HWND hWnd = window->GetHandle();
  HDC hDC = GetDC(hWnd);
  RedisplayDrawLine(hDC);
  ReleaseDC(hWnd, hDC);
}

// display drawing line
void 
EditFrame::RedisplayDrawLine(VDisplay* vdsp)
{
  if (line.IsFixed()) 
  {
    RedisplayDrawLine(vdsp->GetDC());
  }
}

// display draw-line object
void 
EditFrame::RedisplayDrawLine(HDC hDC)
{
  VectW start;
  VectW end;
  if (line.GetStartFission()->GetDir() == Fission::Vertical) 
  {
    start = ItoWv(Vector(((VFission*)line.GetStartFission())->X(), 
                           line.GetPos()));
    end   = ItoWv(Vector(((VFission*)line.GetEndFission())->X(), 
                           line.GetPos()));
  }
  else 
  {
    start = ItoWv(Vector(line.GetPos(), 
                           ((HFission*)line.GetStartFission())->Y()));
    end   = ItoWv(Vector(line.GetPos(), 
                           ((HFission*)line.GetEndFission())->Y()));
  }
  DisplaySelectedLine(hDC, start, end);
}
