// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: easysetu.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// EasySetup class
// ȈՃZbgAbvNXBfobNp̃ZbgAbvɎg

#ifndef NDEBUG

#include "pword.h"
#include "easysetu.h"

// items on string
char* EasySetup::on_str = "on";

EasySetup::EasySetup(char* file_name)
  : ReadList(file_name)
{
}

EasySetup::~EasySetup()
{
}

char* 
EasySetup::Description(char* str)
{
  unsigned int num = GetNumber();
  uword str_size = strlen(str);
  for (unsigned int n = 0; n < num; n++)
  {
#ifndef NDEBUG
    char* debug = (*this)[n];
    debug = debug;
#endif
    if (strncmp(str, (*this)[n], str_size) == 0)
    {
      return(*this)[n];
    }
  }
  return 0;
}

bool 
EasySetup::ItemsMode(char* str)
{
  char* value = ItemsValue(str);
  if (value == 0) 
  {
    return False;
  }
  size_t on_str_len = strlen(on_str);
  if (strncmp(value, on_str, on_str_len) == 0) 
  {
    return True;
  }
  return False;
}

char* 
EasySetup::ItemsValue(char* str)
{
  char* dsc = Description(str);
  if (dsc == 0) 
  {
    // can not find item.
    return 0;
  }
  size_t len = strlen(str);
  dsc += len;
  for (;;) 
  {
    if (*dsc == '\0') 
    {
      // no value set
      return 0;
    }
    if (*dsc == ' ' || *dsc == '\t') 
    {
      // skip white space
      dsc++;
    }
    else 
    {
      // skip white space end.
      break;
    }
  }
  return dsc;
}

bool 
EasySetup::ItemsExistence(char* str)
{
  if (Description(str) == 0) 
  {
    return False;
  }
  return True;
}

#endif /* NDEBUG */
