// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: eca.cpp,v 3.4 1999/07/27 16:13:12 kudou Exp $
// implement the EditCharAtts class which handles editing of
// character attributes

#include "pword.h"
#include "eca.h"
#include "again.h"
#include "attribut.h"
#include "atts.h"
#include "border.h"
#include "borderli.h"
#include "bufnew.h"
#include "defstyle.h"
#include "derivs.h"
#include "dlg.h"
#include "docconte.h"
#include "docedit.h"
#include "docsel.h"
#include "document.h"
#include "docwindo.h"
#include "interval.h"
#include "intlist.h"
#include "pmenus.h"
#include "pundo.h"
#include "pwordbas.h"
#include "pwordpre.h"
#include "sizeadj.h"
#include "textflow.h"
#include "xstr.h"

#ifdef BW3_EXTCHARSIZEOPT
#include "pref.h"
#endif /*  BW3_EXTCHARSIZEOPT */

attr EditCharAtts::clipboard = 0;

// This array defines what is meant by "PLAIN".
static AttSpecList plain_vals[] =
{
  { CA_bold },
  { CA_italic },
  { CA_lines },
  { CA_strikeout },
  { CA_subscript },
  { CA_compressed },
  { CA_inverted },
  { 0 , 0 }
};

// virtual method base on class AttMan
char*
EditCharAtts::GetRedefinitionMessageString()
{
  return S_RedefineCharStyleMsg;
}

// ------------------------------------------------------------
// General Utilities

long
EditCharAtts::set_style(int menu_state_p, int style)
{
  if (menu_state_p)
  {
    return(GetBaseStyle(GetCurrentAtts()) == style
	    ? (MF_ENABLED | MF_CHECKED) : MF_ENABLED);
  }
  Apply(EditCharAtts::_SetStyle, 0, style, PUndo::UD_CharStyleApply);
  return(0);
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::SetPureStyle(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::SetPureStyle(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (!menu_state_p)
  {
    Apply(_SetPureStyle, 0, 0, PUndo::UD_PureCharStyle);
  }
  return(0);
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::CopyAttr(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::CopyAttr(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  attr common_atts = this->GetCommonAtts();
  if (common_atts == 0)
  {
    if (menu_state_p)
    {
      return(MF_GRAYED);
    }
    this->BitchAboutConflictingAtts();
  }
  else if (!menu_state_p)
  {
    EditCharAtts::clipboard = common_atts;
  }
  // MF_ENABLED == 0
  return(0);
}	

#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::PasteAttr(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::PasteAttr(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (EditCharAtts::clipboard == 0)
  {
    return(disabled_command(menu_state_p));
  }
  if (!menu_state_p)
  {
    Apply(AttMan::_SetDirect,
	   0, EditCharAtts::clipboard, PUndo::UD_PasteCharStyle);
  }
  // MF_ENABLED == 0
  return(0);
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::DefineStyle(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::DefineStyle(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (!menu_state_p)
  {
    attr common_atts = this->GetCommonAtts();
    if (common_atts == 0) 
    {
      this->BitchAboutConflictingAtts();
    }
    else
    {
      char buf[128];
      int style;
      if (GetNewStyleName(buf, style)) 
      {
	IntervalList* il = GetSelection();
	DocumentEdit* editor = GetEditor();
	PUndo* undo = editor->GetDocumentContent() ->GetUndo();
	if (style == 0)
	{
	  undo->StartAtom(il, PUndo::UD_CharStyleDefine);
	  style = ::DefineCharStyle(buf, common_atts);
	  undo->Register(0, PUndo::UF_StyleDefine, style);
	}
	else
	{
	  undo->StartAtom(il, PUndo::UD_CharStyleRedefine);
	  undo->Register(0, PUndo::UF_StyleRedefine, style);
	  ::RedefineCharStyle(style, common_atts);
	  PWordBase::StyleChange(style);
	}
	
	bool all_points = il->PointP();
	if (!all_points)
	{
	  editor->WillEdit();
	}
	
	Interval* head = il->GetHead();
	for (Interval* i = head; i != NULL; i = i->GetNext())
	{
	  undo->Register(i, PUndo::UF_CharAtt);
	  i->ApplyCharAtt(_SetStyle, 0, style);
	}
	
	undo->EndAtom(il);
	
	if (!all_points)
	{
	  GetEditor() ->DidEdit();
	}
	else
	{
	  GetEditor() ->GetDocumentWindow() ->ForceTouchCaret();    
	}
      }
    }
  }
  return(0);
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::RedefineStyle(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::RedefineStyle(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (!menu_state_p)
  {
    attr common_atts = GetCommonAtts();
    if (common_atts==0) 
    {
      BitchAboutConflictingAtts();
    }
    else
    {
      unsigned int style = ::GetBaseStyle(common_atts);
      if (style == 0) 
      {
	::StatusOut(S_CantRedefineStyleNone);
      }
      else
      {
	// put a message out and do it
	this->ReportStyleRedefinition(style);
	DocumentEdit* editor = this->GetEditor();
	
	editor->WillEdit();
	{
	  PUndo* undo = editor->GetDocumentContent() ->GetUndo();
	  IntervalList* il = GetSelection();
	  
	  undo->StartAtom(il, PUndo::UD_CharStyleRedefine);
	  {
	    undo->Register(0, PUndo::UF_StyleRedefine, style);
	    ::RedefineCharStyle(style, common_atts);
	    
	    // put the style on the selection again.  This causes underlying
	    // attributes to be changed.
	    for (Interval* i = il->GetHead(); i != NULL; i = i->GetNext())
	    {
	      undo->Register(i, PUndo::UF_CharAtt);
	      i->ApplyCharAtt(_SetStyle, 0, style);
	    }
	  }
	  undo->EndAtom(il);
	  PWordBase::StyleChange(style);
	}
	editor->DidEdit();
      }
    }
  }
  return(0);
}

long
EditCharAtts::specific_value(int menu_state_p, int attcode, int attvalue)
{
  int cur = GetAttValue(attcode);
  if (menu_state_p)
  {
    return(cur == attvalue ? (MF_ENABLED | MF_CHECKED) : MF_ENABLED);
  }
  Apply(EditCharAtts::_SetOne,
	 attcode,
	 attvalue, (PUndo::UndoDesc) (PUndo::UD_FirstCharAtt + attcode));
  return(0L);
}

// ------------------------------------------------------------
// Utility routines to get current attributes, common attributes
// for a selection, apply attributes, etc.

// virtual method based on class AttMan
attr
EditCharAtts::GetCurrentAtts()
{
  Interval* h = GetSelection() ->GetHead();
  return(h == NULL ? (attr) 0 : h->GetAtts());
}

attr
EditCharAtts::GetCommonAtts()
{
  IntervalList* il = GetSelection();
  if (il->PointP())
  {
    return il->GetHead() ->GetAtts();
  }
  
  attr common_att = 0;
  BaseIntervalListTraversor ilt(il);
  Interval* i;
  
  while ((i= (Interval*)ilt.GetNext()) != 0)
  {  
    attr cur_att;
    bool present = i->GetCommonCharAtt(cur_att);
    if (present)
    {
      if (common_att == 0) 
      {
	common_att = cur_att;
      }
      else if (common_att != cur_att) 
      {
	common_att = 0;
	break;
      }
    }
  }
  return common_att;
}

// private method
void NEAR
EditCharAtts::Apply
(
 attr(*func) (attr, int, int),
 int attcode, int attvalue,
 PUndo::UndoDesc desc
)
{
  ApplyIL(GetEditor() ->GetSelection(), func, attcode, attvalue, desc);
}

void
EditCharAtts::ApplyIL
(
 IntervalList* il,
 attr(*func) (attr, int, int),
 int attcode, int attvalue,
 PUndo::UndoDesc desc
)
{
  DocumentEdit* editor = GetEditor();
  
  bool all_points = il->PointP();
  
  if (!all_points)
  {
    editor->WillEdit();
  }
  
  Interval* head = il->GetHead();
  if (!head) return;
  
  PUndo* undo = head->GetDocumentContent() ->GetUndo();
  undo->StartAtom(il, desc);
  
  BaseIntervalListTraversor ilt(il);
  Interval* i;
  while ((i= (Interval*)ilt.GetNext()) != 0)
  {
    undo->Register(i, PUndo::UF_CharAtt);
    i->ApplyCharAtt(func, attcode, attvalue);
  }
  
  undo->EndAtom(il);
  
  if (!all_points)
  {
    editor->DidEdit();
  }
  
  else if (head->PointP())
  {
    GetEditor() ->GetDocumentWindow() ->ForceTouchCaret();    
  }
}

// ------------------------------------------------------------
// Routines for various types of attribute commands.  The normal
// pattern is to find the current value, mung it somehow, then
// call Go with an appropriate callback routine to carry out
// the attribute modification on each character.

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::Border(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::Border(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (!menu_state_p)
  {
    do // dummy loop
    {
      int cur_border = GetAttValue(CA_lines);
      unsigned int val = 0;
      if (Again::GetDoingAgain())
      {
	val = Again::GetOtherInfo();
      }
      else
      {
	TextBorderDialog border_dialog(cur_border);
	if (!border_dialog.Go())
	{
	  Again::CantDoAgain();
	  break;
	}
	val = border_dialog.GetValue();
	Again::SetOtherInfo(val);
      }
      Apply(AttMan::_SetOne,
	     CA_lines,
	     val, (PUndo::UndoDesc) (PUndo::UD_FirstCharAtt + CA_lines));
    } while (0);
  }
  return(0);
}

// private method
int NEAR
EditCharAtts::GetNewStyleName(char* buf, int& existing)
{
  char* suggestion = GetSelection() ->GetHead() ->GetHint();
  DefTextStyleDialog dlg(suggestion);
  int ret = dlg.Go();
  if (ret)
  {
    strcpy(buf, dlg.GetStyleName());
    existing = dlg.GetExistingStyle();
  }
  delete suggestion;
  return ret;
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::Subscript(bool menu_state_p, int delta)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::Subscript(int menu_state_p, int delta)
#endif /* BW3_DISPATCH */
{
  int cur_value = GetAttValue(CA_subscript);
  if (menu_state_p)
  {
    return(cur_value == delta ? (MF_ENABLED | MF_CHECKED) : MF_ENABLED);
  }
  if (cur_value == delta)
  {
    delta = 0;
  }
  Apply(AttMan::_SetOne,
	 CA_subscript,
	 delta, (PUndo::UndoDesc) (PUndo::UD_FirstCharAtt + CA_subscript));
  return(0);
}

// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::SizeAdjust(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::SizeAdjust(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (!menu_state_p)
  {
    int cur_char_size = GetAttValue(CA_size);
    int old_size = GetAttValue(CA_delta_size);
    int new_size;
    
    if (Again::GetDoingAgain())
    {
      new_size = Again::GetOtherInfo();
    }
    else
    {
      SizeAdjDialog sizeadj_dialog(cur_char_size, old_size);
      if (!sizeadj_dialog.Go()) 
      {
	Again::CantDoAgain();
	return 0;
      }
      else 
      {
	new_size = sizeadj_dialog.GetValue();
	Again::SetOtherInfo(new_size);
      }
    }
    
    Apply(AttMan::_SetOne, CA_delta_size, new_size, 
	   (PUndo::UndoDesc) (PUndo::UD_FirstCharAtt+CA_delta_size));
  }
  return(0);
}

// ------------------------------------------------------------

// This method toggle one attribute.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::Toggle(bool menu_state_p, int attcode)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::Toggle(int menu_state_p, int attcode)
#endif /* BW3_DISPATCH */
{
  int cur = GetAttValue(attcode);
  if (menu_state_p)
  {
    return(cur == 0 ? MF_ENABLED : (MF_ENABLED | MF_CHECKED));
  }
  Apply(EditCharAtts::_SetOne,
	 attcode, !cur, (PUndo::UndoDesc) (PUndo::UD_FirstCharAtt + attcode));
  return(0);
}

#define MIN_SPACING 0
#define MAX_SPACING 1000

// private method
void NEAR
EditCharAtts::set_spacing(int mm0, int do_message)
{
  int value = mm0_to_iu(mm0);
  if (do_message)
  {
    char* s = mm0_to_string(mm0);
    ::StatusOut(S_CharSpacing, s);
    delete s;
  }
  Apply(AttMan::_SetOne,
	 CA_compressed,
	 value, (PUndo::UndoDesc) (PUndo::UD_FirstCharAtt + CA_compressed));
}

// This method handles IDM_Char_Spacing_Inc and IDM_Char_Spacing_Dec
// commands.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::Spacing_Inc_Dec(bool menu_state_p, int delta, int other_command)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::Spacing_Inc_Dec(int menu_state_p, int delta, int other_command)
#endif /* BW3_DISPATCH */
{
  int old_mm0 = iu_to_mm0(GetAttValue(CA_compressed));
  int new_mm0 = old_mm0 + delta;
  SET_MAX(new_mm0, MIN_SPACING);
  SET_MIN(new_mm0, MAX_SPACING);
  if (menu_state_p)
  {
    return(new_mm0 == old_mm0 ? MF_GRAYED : MF_ENABLED);
  }
  if (new_mm0 == old_mm0)
  {
    MessageBeep(0);
  }
  else
  {
    set_spacing(new_mm0, True);
    Again::ToDoAgainInOtherDirection(other_command);
  }
  return(0);
}

// Spacing -- change character spacing
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::Spacing(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::Spacing(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (menu_state_p)
  {
    return(MF_ENABLED);
  }
  if (!dispatch_inc_dec(IDM_Char_Spacing_Inc, IDM_Char_Spacing_Dec))
  {
    int mm0 = iu_to_mm0(GetAttValue(CA_compressed));
    int do_message = False;
    if (Again::GetDoingAgain())
    {
      mm0 = Again::GetOtherInfo();
    }
    else
    {
      do_message = True;
      NumberDialog dialog("CompressDlg", MIN_SPACING, MAX_SPACING, mm0);
      dialog.set_mm0_mode(True);
      if (!dialog.Go())
      {
	Again::CantDoAgain();
	return(0);
      }
      mm0 = dialog.get_value();
      Again::SetOtherInfo(mm0);
    }
    set_spacing(mm0, do_message);
  }
  return(0);
}

// private method
void NEAR
EditCharAtts::set_size(int size)
{
  Apply(AttMan::_SetOne,
	 CA_size, size, (PUndo::UndoDesc) (PUndo::UD_FirstCharAtt + CA_size));
}

// public method
long
EditCharAtts::ChangeTextSize(int menu_state_p, int size)
{
  int old_size = GetAttValue(CA_size);
  if (menu_state_p)
  {
    return(size == old_size ? (MF_ENABLED | MF_CHECKED) : MF_ENABLED);
  }
  set_size(size);
  return(0);
}

// This method handles IDM_Char_Size_Inc and IDM_Char_Size_Dec commands.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::Size_Inc_Dec(bool menu_state_p, int delta, int other_command)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::Size_Inc_Dec(int menu_state_p, int delta, int other_command)
#endif /* BW3_DISPATCH */
{
  int oldsize = GetAttValue(CA_size);
  int newsize = StepTextSize(oldsize, delta);
  if (menu_state_p)
  {
    return(newsize == oldsize ? MF_GRAYED : MF_ENABLED);
  }
  if (newsize == oldsize)
  {
    MessageBeep(0);
  }
  else
  {
    ::StatusOut(S_TextSize, newsize);
  }
  set_size(newsize);
  Again::ToDoAgainInOtherDirection(other_command);
  return(0);
}

// This method handles IDM_Char_Size command.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::Size(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::Size(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (menu_state_p)
  {
    return(MF_ENABLED);
  }
  if (!dispatch_inc_dec(IDM_Char_Size_Inc, IDM_Char_Size_Dec))
  {
    int command;
    // Control dialog life.
    {
#ifdef BW3_EXTCHARSIZEOPT
      // upto 1024 point
      int size = Pref_over_128_point_char_size ? 255 : 128;
      NumberDialog dialog("TextSize", 1, size, GetAttValue(CA_size));
#else /* BW3_EXTCHARSIZEOPT */
      NumberDialog dialog("TextSize", 1, 128, GetAttValue(CA_size));
#endif /* BW3_EXTCHARSIZEOPT */
      if (!dialog.Go())
      {
	Again::CantDoAgain();
	return(0);
      }
      command = IDM_CharSize + dialog.get_value();
#ifdef BW3_EXTCHARSIZEOPT
      if (Pref_over_128_point_char_size &&
	  dialog.get_value() <= 255)
      {
	dispatch_simple_command(command);
      }
      else if (COMMAND_HIGH_CODE(command) != IDM_HIGH_CharSize)
      {
	MessageBeep(0);
      }
      else
      {
	dispatch_simple_command(command);
      }
    }
#else /* BW3_EXTCHARSIZEOPT */
    }
    if (COMMAND_HIGH_CODE(command) != IDM_HIGH_CharSize)
    {
      MessageBeep(0);
    }
    else
    {
      dispatch_simple_command(command);
    }
#endif /* BW3_EXTCHARSIZEOPT */
  }
  return(0);
}

// Underline -- called when user chooses "Underline" from Style submenu.
// This item is checked when there is any kind of underline present;
// choosing it then turns off underlining.  Choosing it in the absence of
// an underline turns on a default single underline.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::Underline(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::Underline(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  int present = BorderLine::Present(GetAttValue(CA_lines));
  if (menu_state_p)
  {
    return(present ? (MF_ENABLED | MF_CHECKED) : MF_ENABLED);
  }
  Apply(AttMan::_SetOne,
	 CA_lines,
	 (present ? 0 : (int) BorderLine::GetDefaultCharacterIndex()),
	 (PUndo::UndoDesc) (PUndo::UD_FirstCharAtt + CA_lines));
  return(0);
}

// implementation of  "Plain"
static attr
plain_callback(attr old, int, int)
{
  for (AttSpecList* spec = plain_vals; spec->attcode; ++spec)
  {
    spec->attvalue = 0;
  }
  return(::ApplyAttList(old, plain_vals));
}

// This method handles IDM_Char_Plain command.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::Plain(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::Plain(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  if (menu_state_p)
  {
    attr a = this->GetCurrentAtts();
    GetAttValueList(a, plain_vals);
    for (AttSpecList* spec = plain_vals; spec->attcode; ++spec)
    {
      // even one is enough...
      if (spec->attvalue)
      {
	// Special case of line: maybe there is a non-zero index, but
	// still no line
	if (spec->attcode == CA_lines)
	{
	  uword lines = ::GetAttValue(a, CA_lines);
	  if (lines != 0 && !BorderLine::Present(lines))
	  {
	    continue;
	  }
	}
	return(MF_ENABLED);
      }
    }
    // all spec is not set.  It's a PLAIN.
    return(MF_ENABLED | MF_CHECKED);
  }
  this->Apply(plain_callback, 0, 0, PUndo::UD_Plain);
  return(0);
}

// This method handles IDM_Char_Style_Search command.
// private method
#ifdef BW3_DISPATCH
LRESULT_T NEAR
EditCharAtts::Style_Search(bool menu_state_p)
#else /* BW3_DISPATCH */
long NEAR
EditCharAtts::Style_Search(int menu_state_p)
#endif /* BW3_DISPATCH */
{
  return(this
	  ->GetEditor()
	  ->Style_Search(menu_state_p,
			 Menu_Type_CHAR_STYLE, S_search_char_style_title));
}

// Dispatch dispatches a menu selection relating to character attributes.
// It is called from Dispatch in docedit.cpp
// public method
#ifdef BW3_DISPATCH
LRESULT_T
EditCharAtts::Dispatch(WORD command, WORD notify_code, HWND hwnd)
#else /* BW3_DISPATCH */
long
EditCharAtts::Dispatch(int command, long lParam)
#endif /* BW3_DISPATCH */
{
#ifdef BW3_DISPATCH
  bool menu_state_p = MENU_STATE_P(notify_code);
#else /* BW3_DISPATCH */
  int menu_state_p = MENU_STATE_P(lParam);
#endif /* BW3_DISPATCH */
  switch (command)
  {
   case IDM_Char_Plain:
    return(Plain(menu_state_p));
    
   case IDM_Char_Bold:
    return(Toggle(menu_state_p, CA_bold));
    
   case IDM_Char_Italic:
    return(Toggle(menu_state_p, CA_italic));
    
   case IDM_Char_Strikeout:
    return(Toggle(menu_state_p, CA_strikeout));
    
   case IDM_Char_Inverted:
    return(Toggle(menu_state_p, CA_inverted));
    
   case IDM_Char_Nonbreaking: 
    return(Toggle(menu_state_p, CA_unbreakable));
    
   case IDM_Char_Invisible:
    return(Toggle(menu_state_p, CA_hidden));
    
   case IDM_Char_Underline:
    return(Underline(menu_state_p));
    
   case IDM_Char_Lines:
    return(Border(menu_state_p));
    
   case IDM_Char_Superscript:
    return(Subscript(menu_state_p, 2));
    
   case IDM_Char_Superscript_Half:
    return(Subscript(menu_state_p, 1));
    
   case IDM_Char_Subscript_Half:
    return(Subscript(menu_state_p, -1));
    
   case IDM_Char_Subscript:
    return(Subscript(menu_state_p, -2));
    
   case IDM_Char_Tab_Left:
    return(specific_value(menu_state_p, CA_tab, TAB_left));
    
   case IDM_Char_Tab_Right:
    return(specific_value(menu_state_p, CA_tab, TAB_right));
    
   case IDM_Char_Tab_Center:
    return(specific_value(menu_state_p, CA_tab, TAB_center));
    
   case IDM_Char_Tab_Decimal:
    return(specific_value(menu_state_p, CA_tab, TAB_decimal));
    
   case IDM_Char_Size:
    return(Size(menu_state_p));
    
   case IDM_Char_Size_Inc:
    return(Size_Inc_Dec(menu_state_p, 1, IDM_Char_Size_Dec));
    
   case IDM_Char_Size_Dec:
    return(Size_Inc_Dec(menu_state_p, -1, IDM_Char_Size_Inc));
    
   case IDM_Char_SizeAdjust:
    return(SizeAdjust(menu_state_p));
    
   case IDM_Char_Spacing:
    return(Spacing(menu_state_p));
    
   case IDM_Char_Spacing_Inc:  
    return(Spacing_Inc_Dec(menu_state_p, 1, IDM_Char_Spacing_Dec));
    
   case IDM_Char_Spacing_Dec:
    return(Spacing_Inc_Dec(menu_state_p, -1, IDM_Char_Spacing_Inc));
    
   case IDM_Char_CopyAttr:
    return(CopyAttr(menu_state_p));
    
   case IDM_Char_PasteAttr:
    return(PasteAttr(menu_state_p));
    
   case IDM_Char_Style_Define:
    return(DefineStyle(menu_state_p));
    
   case IDM_Char_Style_Redefine:
    return(RedefineStyle(menu_state_p));
    
   case IDM_Char_Style_Pure:
    return(SetPureStyle(menu_state_p));
    
   case IDM_Char_Style_Search:
    return(Style_Search(menu_state_p));
    
#ifndef NDEBUG
   case IDM_Char_Test_1:
    ::AttStatusOut(GetCurrentAtts());
    return(0);
#endif
#ifndef NDEBUG
#ifdef BW2_VERBOSE
   default:
    syserr("unknown msg 0x%x in eca", command);
    break;
#endif
#endif
  }
  return(0);
}

// public constructor
EditCharAtts::EditCharAtts(DocumentEdit* de)
 : AttMan(de)
{
}
