// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: editfram.cpp,v 3.3 2000/05/13 16:28:59 kudou Exp $
// class EditFrame
// t[GfB^

#include "pword.h"
#include "cplist.h"
#include "editfram.h"
#include "allayout.h"
#include "docconte.h"
#include "docprese.h"
#include "document.h"
#include "docwindo.h"
#include "editmode.h"
#include "fission.h"
#include "frameown.h"
#include "layoutin.h"
#include "layoutte.h"
#include "linesele.h"
#include "mcursor.h"
#include "objectid.h"
#include "pagebox.h"
#include "pagemap.h"
#include "pagesize.h"
#include "pref.h"
#include "pwordpre.h"
#include "pwordpre.h"
#include "rect.h"
#include "screen.h"
#include "table.h"
#include "vdisplay.h"

bool EditFrame::now_set_flow = False;

// constructor
EditFrame::EditFrame(Document* doc)
#ifndef EDIT_MODE_BODY
  : cut(* (new EMCutLine())),
  line(* (new EMDrawLine())),
  move(* (new EMMoveLine())),
  selfrm(* (new EMSelectFrame())),
  flow(* (new EMSetFlow())),
  exch(* (new EMExchFlow())),
  setmgn(* (new EMSetMargin())),
  mktbl(* (new EMMakeTable())),
  fmgn(* (new EMFrameMargin()))
#endif
{
  EditFrame::doc = doc;
  window = 0;
  edit_li = 0;
  edit_lt = 0;
  edit_ff = 0;
  regular_li = 0;
  // work value
  lines = 0;
  // multi frame selection
  frames = new CPList();
  rect_rgn_cp1 = 0;
  rect_rgn_cp2 = 0;
  min_x_cp = 0;
  max_x_cp = 0;
  min_y_cp = 0;
  max_y_cp = 0;
  FissionFrame::SetNearFissionError(5);
  InitLineSelection();
  toolbox = PWordPresentation::GetEditModeStatus();
  mouse_offset.x = 0;
  mouse_offset.y = 0;
  effective = False;
}

// destructor
EditFrame::~EditFrame()
{
#ifndef EDIT_MODE_BODY
  delete &cut;
  delete &line;
  delete &move;
  delete &selfrm;
  delete &flow;
  delete &exch;
  delete &setmgn;
  delete &mktbl;
  delete &fmgn;
#endif
  EndLineSelection();
  delete frames;
}

// receive change tool box item message
void 
EditFrame::ReceiveChangeToolBoxItem(EditMode em)
{
  EditMode old = toolbox;
  if (em != old)
  {
    toolbox = em;
    this->Cancel();
    switch (old)
    {		// old mode setting
     case MoveLine_MODE:
      ClearLineSelection();
      break;
      
     case SelectFrame_MODE:
      ClearFrameSelection();
      break;
    }
  }
}

// change edit mode
void 
EditFrame::ChangeEditMode(EditMode em)
{
  switch (em)
  {
   case SelectFrame_MODE:
    SelectCaretFrames();
    break;
    
   default:
    // do nothing
    break;
  }
}

// cancel editting
void 
EditFrame::Cancel()
{
  switch (toolbox) 
  {
   case Cut_MODE:
    CancelCut(False);
    break;
   case DrawLine_MODE:
    CancelDrawLine(False);
    break;
   case SetFlow_MODE:
    CancelSetFlow(False);
    break;
   case ExchFlow_MODE:
    CancelExchFlow(False);
    break;
   case MakeTable_MODE:
    CancelMakeTable(False);
    break;
   case SetMargin_MODE:
    CancelMargin(False);
    break;
   case FrameMargin_MODE:
    CancelFrameMargin(False);
    break;
   case MoveLine_MODE:
    CancelMoveLine(False);
    break;
   case SelectFrame_MODE:
    CancelSelectFrame(False);
    break;
  }
}

void 
EditFrame::Reset()
{
  edit_li = 0;
  edit_lt = 0;
  edit_ff = 0;
  regular_li = 0;
}

void 
EditFrame::ReportBreakLayout()
{
  Cancel();
  Reset();
}

// report break layout
void 
EditFrame::ReportBreakLayout(LayoutTemplate* lt)
{
  // check line selection
  ClearLineSelection(lt);
  
  // clear frame selection
  if (frames != 0) 
  {
    CPListIterator cpi(frames);
    CrossPoint* cp;
    while ((cp = cpi()) != 0) 
    {
      if (cp->GetFissionFrame()->GetFrameOwner() == (FrameOwner*)lt) 
      {
	ClearFrameSelection();	 
	break;
      }
    }
  }
}

// report break layout
void
EditFrame::ReportBreakLayout(LayoutInstance* li)
{
  if (GetEditLI() == li)
  {
    this->ReportBreakLayout();
  }
}

// visible selection
void 
EditFrame::TurnOn()
{
  SetFrameSelectionBit();
  VisibleLineSelection();
  
  RedrawWindows();
}

// invisible selection
void 
EditFrame::TurnOff()
{
  ClearFrameSelectionBit();
  InvisibleLineSelection();
  
  RedrawWindows();
}

// set locked layout
void
EditFrame::SetLockedLayout(LayoutInstance* layout)
{
  this->edit_lt = NULL;
  this->edit_ff = NULL;
  this->regular_li = NULL;
  this->edit_li = layout;
  if (layout != NULL)
  {
    this->edit_lt = layout->GetLayoutTemplate();
    this->edit_ff = this->edit_lt->GetFissionFrame();
    if (this->edit_lt->IsZeroPage())
    {
      // get find mouse layout result
      this->regular_li = LayoutInstance::GetZeroMappedLayout();
      this->GetEditLI();	// set zero page position
    }
  }
}

// lock layout by window position
// return	: lock layout
LayoutInstance* 
EditFrame::LockLayout(VectW& wv)
{
  // doc, window, wv -> layout
  Dpoint dp[1];
  Lpoint lp[1];
  SET_POINT(dp, wv.x, wv.y);
  window->dpoint_to_lpoint(dp, lp);
  this->SetLockedLayout(window->navigate_layout(lp));
  return(this->edit_li);
}

// lock zero page layout
LayoutInstance* 
EditFrame::LockZeroPageLayout(LayoutInstance* reg_li)
{
  assert(reg_li->GetLayoutTemplate()->IsRegular());
  LayoutInstance* li = doc->GetDocumentContent()
  ->GetPageSize()->GetLayout();
  edit_li = li;
  edit_lt = li->GetLayoutTemplate();
  edit_ff = edit_lt->GetFissionFrame();
  regular_li = reg_li;
  return li;
}

// current edit layout-instance
LayoutInstance* 
EditFrame::GetEditLI()
{
  if ((regular_li != 0) && (edit_li != 0)) 
  {
    doc->GetDocumentContent()
    ->GetPageSize()
    ->SetLayoutPosition(regular_li->GetLX(), regular_li->GetLY());
  }
  return edit_li;
}

// find layout from window position
LayoutInstance* 
EditFrame::FindLayoutW(VectW& wv)
{
  Dpoint dp[1];
  Lpoint lp[1];
  SET_POINT(dp, wv.x, wv.y);
  window->dpoint_to_lpoint(dp, lp);
  LayoutInstance* li = window->navigate_layout(lp);
  if ((regular_li != 0) && (edit_li == li)) 
  {
    doc->GetDocumentContent()
    ->GetPageSize()
    ->SetLayoutPosition(regular_li->GetLX(), regular_li->GetLY());
  }
  return li;
}

// get mouse error length
Iunit 
EditFrame::GetMouseErrorLength()
{
  if (Pref_mouse_tolerance == -1)
  {
    return(Iunit) (window->ScaleLunitX(Screen::frame_width));
  }
  else
  {
    return(Iunit) (window->ScaleLunitX(Pref_mouse_tolerance));
  }
}

// get effective frame margin
Margin 
EditFrame::GetEffectiveFrameMargin(FrameObject* fo)
{
  Rect r = fo->GetInternalRect();
  Iunit height = r.y2 - r.y1;
  Iunit width = r.x2 - r.x1;
  Iunit top_m = fo->GetTopMargin();
  Iunit bot_m = fo->GetBottomMargin();
  Iunit lef_m = fo->GetLeftMargin();
  Iunit rig_m = fo->GetRightMargin();
  if (top_m + bot_m > height) 
  {
    Iunit ext = (((top_m <= height) ? top_m : height) +
		 ((bot_m <= height) ? bot_m : height) - height) / 2;
    if (top_m > height) 
    {
      top_m = height - ext;
    }
    else 
    {
      top_m -= ext;
    }
    if (bot_m > height) 
    {
      bot_m = height - ext;
    }
    else 
    {
      bot_m -= ext;
    }
  }
  if (lef_m + rig_m > width) 
  {
    Iunit ext = (((lef_m <= width) ? lef_m : width) +
		 ((rig_m <= width) ? rig_m : width) - width) / 2;
    if (lef_m > width) 
    {
      lef_m = width - ext;
    }
    else 
    {
      lef_m -= ext;
    }
    if (rig_m > width) 
    {
      rig_m = width - ext;
    }
    else 
    {
      rig_m -= ext;
    }
  }
  return Margin(top_m, bot_m, lef_m, rig_m);
}

inline Iunit 
diff(Iunit a, Iunit b)
{
  return((a - b) > 0) ? (a - b) : (b - a);
}

// find frame margin
// return		: 0:can't find, 1:top, 2:bottom, 3:left, 4:right
uword 
EditFrame::FindFrameMarginW(VectW& vw, CrossPoint* cp, Dunit& offset)
{
  Iunit err = GetMouseErrorLength();
  Vector pos = WtoIv(vw);
  
  // text frame only now
  if (cp->GetFrameObject()->GetObjectID() != IDTextObject) 
  {
    return 0;
  }
  
  FrameObject* fo = cp->GetFrameObject();
  Margin m = GetEffectiveFrameMargin(fo);
  Rect r = fo->GetInternalRect();
  Iunit m1 = diff(r.y1 + m.GetTop(), pos.y);
  Iunit m2 = diff(r.y2 - m.GetBottom(), pos.y);
  Iunit m3 = diff(r.x1 + m.GetLeft(), pos.x);
  Iunit m4 = diff(r.x2 - m.GetRight(), pos.x);
  Iunit min = (((m1 < m2) ? m1 : m2) < ((m3 < m4) ? m3 : m4)) ? 
  ((m1 < m2) ? m1 : m2) : ((m3 < m4) ? m3 : m4);
  if (min > err) 
  {
    offset = 0;
    return 0;
  }
  uword ret = 0;
  if (min == m1) 
  {
    // Next two lines depend on the mouse cursor design.
    if (((min == m2) && (pos.y - (r.y1 + m.GetTop()) > 0)) ||
	(r.y2 - m.GetBottom() <= r.y1)) 
    {
      ret = 2;
    }
    else 
    {
      ret = 1;
    }
  }
  else if (min == m2) 
  {
    if (r.y1 + m.GetTop() >= r.y2) 
    {
      ret = 1;
    }
    else 
    {
      ret = 2;
    }
  }
  else if (min == m3) 
  {
    // Next two lines depend on the mouse cursor design.
    if (((min == m4) && (pos.x - (r.x1 + m.GetLeft()) > 0)) ||
	(r.x2 - m.GetRight() <= r.x1)) 
    {
      ret = 4;
    }
    else 
    {
      ret = 3;
    }
  }
  else if (min == m4) 
  {
    if (r.x1 + m.GetLeft() >= r.x2) 
    {
      ret = 3;
    }
    else 
    {
      ret = 4;
    }
  }
  switch (ret) 
  {
   case 1:
    offset = vw.y - ItoWy(r.y1 + m.GetTop());
    break;
    
   case 2:
    offset = vw.y - ItoWy(r.y2 - m.GetBottom());
    break;
    
   case 3:
    offset = vw.x - ItoWx(r.x1 + m.GetLeft());
    break;
    
   case 4:
    offset = vw.x - ItoWx(r.x2 - m.GetRight());
    break;
    
   default:
    offset = 0;
    ret = 0;
    break;
  }
  return ret;
}

// find draw fission
Fission* 
EditFrame::FindDrawFissionW(VectW& vw)
{
  Vector pnt = WtoIv(vw);
  FissionFrame::SetNearFissionError(GetMouseErrorLength());
  return GetEditFF()->GetNearFission(pnt);
}

// find draw to fission
Fission* 
EditFrame::FindDrawToFissionW(VectW& vw, Fission* start, Iunit pos)
{
  Vector v = WtoIv(vw);
  LayoutInstance* li = FindLayoutW(vw);
  if (li == 0) 
  {
    return 0;
  }
  if (GetEditLT()->GetKind() == LayoutTemplate::PageSizeTemplate) 
  {
    if (li != GetEditLI()) 
    {
      return 0;
    }
  }
  if (li->GetLayoutTemplate()->GetKind() == 
      LayoutTemplate::PageSizeTemplate) 
  {
    //
    // check special region
    //
    PageSize* ps = (PageSize*)li->GetPageMap();
    AllLayout* al = ps->GetAllLayout();
    assert(al != 0);
    Rect rec = al->GetInternalRect();
    Iunit src_x, src_y;
    if (start->GetDir() == Fission::Vertical) 
    {
      src_x = start->GetPoint();
      src_y = pos;
    }
    else 
    {                // Fission::Horizontal
      src_x = pos;
      src_y = start->GetPoint();
    }
    // +--+---------+--+
    // |  |    1    |  |
    // +--+---------+--+
    // |  | regular |  |
    // |2 |   page  |3 |
    // |  |         |  |
    // +--+---------+--+
    // |  |    4    |  |
    // +--+---------+--+
    if ((src_x > rec.x1) && (src_x < rec.x2)) 
    {
      if (src_y <= rec.y1) 
      {
	// source region is [1].
	if (v.y > rec.y1) 
	{
	  // out of region
	  return 0;
	}
      }
      else if (src_y >= rec.y2) 
      {
	// source region is [4].
	if (v.y < rec.y2) 
	{
	  // out of region
	  return 0;
	}
      }
    }
    else if ((src_y > rec.y1) && (src_y < rec.y2)) 
    {
      if (src_x <= rec.x1) 
      {
	// source region is [2].
	if (v.x > rec.x1) 
	{
	  // out of region
	  return 0;
	}
      }
      else if (src_x >= rec.x2) 
      {
	// source region is [3].
	if (v.x < rec.x2) 
	{
	  // out of region
	  return 0;
	}
      }
    }
  }
  if (start->GetDir() == Fission::Vertical) 
  {
    v.y = pos;
  }
  else 
  {
    v.x = pos;
  }
  
  CrossPoint* cp = GetEditFF()->GetCell(v);
  if (cp != 0) 
  {
    Rect r = cp->GetInternalRect();
    Iunit m_error = GetMouseErrorLength();
    if (start->GetDir() == Fission::Vertical) 
    {
      Iunit left_diff  = v.x - r.x1;
      Iunit right_diff = r.x2 - v.x;
      Fission* lf = cp->GetVFission();
      Fission* rf = cp->GetCellRightCrossPoint()->GetVFission();
      if ((start == lf) && (left_diff > m_error))
      {
	return rf;
      }
      if ((start == rf) && (right_diff > m_error))
      {
	return lf;
      }
      if (left_diff < m_error)
      {
	return lf;
      }
      if (right_diff < m_error)
      {
	return rf;
      }
      if (v.x < start->GetPoint())
      {
	return lf;
      }
      else
      {
	return rf;
      }
    }
    else 
    {
      Iunit top_diff    = v.y - r.y1;
      Iunit bottom_diff = r.y2 - v.y;
      Fission* tf = cp->GetHFission();
      Fission* bf = cp->GetCellBottomCrossPoint()->GetHFission();
      if ((start == tf) && (top_diff > m_error))
      {
	return bf;
      }
      if ((start == bf) && (bottom_diff > m_error))
      {
	return tf;
      }
      if (top_diff < m_error)
      {
	return tf;
      }
      if (bottom_diff < m_error)
      {
	return bf;
      }
      if (v.y < start->GetPoint())
      {
	return tf;
      }
      else
      {
	return bf;
      }
    }
  }
  return 0;
}

// check margin line
// for draw line special case 
bool 
EditFrame::IsMarginLine(Fission* f)
{
  switch (GetEditLT()->GetKind()) 
  {
   case LayoutTemplate::RegularTemplate:
    if ((GetEditFF()->GetTop() == f) ||
	(GetEditFF()->GetBottom() == f) ||
	(GetEditFF()->GetLeft() == f) ||
	(GetEditFF()->GetRight() == f)) 
    {
      return True;
    }
    break;
   case LayoutTemplate::PageSizeTemplate:
    return IsMarginFission(f);
   case LayoutTemplate::TableTemplate:
    break;
  }
  return False;
}

// check lock layout swap for margin line
bool 
EditFrame::IsMarginLineSwapCase(LayoutInstance* li)
{
  if (li == 0) 
  {
    return False;
  }
  switch (GetEditLT()->GetKind()) 
  {
   case LayoutTemplate::RegularTemplate:
    if (li->GetLayoutTemplate()->GetKind() == 
	LayoutTemplate::PageSizeTemplate) 
    {
      return True;
    }
    break;
   case LayoutTemplate::PageSizeTemplate:
    if ((li->GetLayoutTemplate()->GetKind() == 
	 LayoutTemplate::RegularTemplate) &&
	(li == regular_li)) 
    {
      return True;
    }
    break;
   case LayoutTemplate::TableTemplate:
    return False;
  }
  return False;
}

// find move fission
Fission* 
EditFrame::FindMoveFissionW(VectW& vw)
{
  Vector pnt = WtoIv(vw);
  FissionFrame::SetNearFissionError(GetMouseErrorLength());
  Fission* f = GetEditFF()->GetNearFission(pnt);
  switch (GetEditLT()->GetKind()) 
  {
   case LayoutTemplate::PageSizeTemplate:
   case LayoutTemplate::RegularTemplate:
    return IsRimFission(f) ? 0 : f;
   case LayoutTemplate::TableTemplate:
    return f;
  }
  return 0;
}

// find cut fission
Fission* 
EditFrame::FindCutFissionW(VectW& vw)
{
  Vector pnt = WtoIv(vw);
  FissionFrame::SetNearFissionError(GetMouseErrorLength());
  Fission* f = GetEditFF()->GetNearFission(pnt);
  switch (GetEditLT()->GetKind()) 
  {
   case LayoutTemplate::PageSizeTemplate:
    return(IsRimFission(f) || IsMarginFission(f)) ? 0 : f;
   case LayoutTemplate::RegularTemplate:
   case LayoutTemplate::TableTemplate:
    return IsRimFission(f) ? 0 : f;
  }
  return 0;
}

// check rim fission
bool 
EditFrame::IsRimFission(Fission* f)
{
  if ((f == GetEditFF()->GetTop()) ||
      (f == GetEditFF()->GetBottom()) ||
      (f == GetEditFF()->GetLeft()) ||
      (f == GetEditFF()->GetRight())) 
  {
    return True;
  }
  return False;
}

// get margin fission
bool 
EditFrame::GetMarginFission(Fission** top, Fission** bottom, 
			     Fission** left, Fission** right)
{
  if (GetEditLT()->IsZeroPage() == False) 
  {
    top = 0;
    bottom = 0;
    left = 0;
    right = 0;
    return False;
  }
  PageSize* ps = (PageSize*)GetEditLI()->GetPageMap();
  AllLayout* al = ps->GetAllLayout();
  assert(al != 0);
  al->GetMarginFission(top, bottom, left, right);
  return True;
}

// check margin fission
bool 
EditFrame::IsMarginFission(Fission* f)
{
  Fission* top = 0;
  Fission* bottom = 0;
  Fission* left = 0;
  Fission* right = 0;
  if (GetMarginFission(&top, &bottom, &left, &right) == False) 
  {
    return False;
  }
  if ((f == top) ||
      (f == bottom) ||
      (f == left) ||
      (f == right)) 
  {
    return True;
  }
  return False;
}

// find segment
void 
EditFrame::FindSegmentW(Fission* f, VectW& vw, 
			 CrossPoint*& start, CrossPoint*& end)
{
  Vector i_pos = WtoIv(vw);
  start = f->GetStartCrossPoint();
  end   = f->GetEndCrossPoint();
  if (f->GetDir() == Fission::Vertical) 
  {
    if (start->GetVNext() != end) 
    {
      word y_pos = i_pos.y;
      for (;;) 
      {
	end = start->GetVNext();
	if (end == 0) 
	{
	  // may be hit error.
	  start = 0;
	  return;
	}
	if (y_pos <= end->Y()) 
	{
	  // ok.
	  return;
	}
	start = end;
      }
    }
  }
  else 
  {
    if (start->GetHNext() != end) 
    {
      word x_pos = i_pos.x;
      for (;;) 
      {
	end = start->GetHNext();
	if (end == 0) 
	{
	  // may be hit error.
	  start = 0;
	  return;
	}
	if (x_pos <= end->X()) 
	{
	  // ok.
	  return;
	}
	start = end;
      }
    }
  }
}

// find frame
FrameInstance* 
EditFrame::FindFrameW(VectW& vw)
{
  Vector pnt = WtoIv(vw);
  CrossPoint* cp = GetEditFF()->GetCell(pnt);
  
  if ((cp != 0) &&
      (cp->GetFrameObject()->GetObjectID() == IDTextObject)) 
  {
    return(FrameInstance*)cp->GetFrameObject();
  }
  return 0;
}

// find object
FrameObject* 
EditFrame::FindFrameObjectW(VectW& vw)
{
  Vector pnt = WtoIv(vw);
  CrossPoint* cp = GetEditFF()->GetCell(pnt);
  if (cp != 0) 
  {
    return cp->GetFrameObject();
  }
  return 0;
}

// find crosspoint
CrossPoint* 
EditFrame::FindCrossPointW(VectW& vw)
{
  Vector v = WtoIv(vw);
  return GetEditFF()->GetCell(v);
}

// clear freame object
bool 
EditFrame::ClearFrameObject(CrossPoint* cp)
{
  FrameObject* fo = cp->GetFrameObject();
  if (fo != 0) 
  {
    if (fo->CheckVanish() == False) 
    {
      return False;
    }
    delete fo;
  }
  return True;
}

// ------------------------------------------------------------
// coordinate converter

// convert Dunit x to Iunit
Iunit 
EditFrame::WtoIx(Dunit x)
{
  return((Iunit) (window->LunitX(x) - GetEditLI()->GetLX()));
}

// convert Dunit y to Iunit
Iunit 
EditFrame::WtoIy(Dunit y)
{
  return((Iunit) (window->LunitY(y) - GetEditLI()->GetLY()));
}

// convert Dunit vector to Iunit
Vector 
EditFrame::WtoIv(VectW& v)
{
  return Vector((Iunit) (window->LunitX(v.x) - GetEditLI()->GetLX()),
		 (Iunit) (window->LunitY(v.y) - GetEditLI()->GetLY()));
}

// convert Iunit x to Dunit
Dunit 
EditFrame::ItoWx(Iunit x)
{
  return window->DunitX(GetEditLI()->GetLX() + x);
}

// convert Iunit y to Dunit
Dunit 
EditFrame::ItoWy(Iunit y)
{
  return window->DunitY(GetEditLI()->GetLY() + y);
}

// convert Iunit vector to Dunit
VectW 
EditFrame::ItoWv(Vector v)
{
  return VectW(window->DunitX(GetEditLI()->GetLX() + v.x),
                window->DunitY(GetEditLI()->GetLY() + v.y));
}

VectW 
EditFrame::ItoWv(Vector v, LayoutInstance* li)
{
  return VectW(window->DunitX(li->GetLX() + v.x),
                window->DunitY(li->GetLY() + v.y));
}

VectL 
EditFrame::WtoLv(VectW& v)
{
  return VectL(window->LunitX(v.x), window->LunitY(v.y));
}

Dunit 
EditFrame::LtoWx(Lunit x)
{
  return window->DunitX(x);
}

Dunit 
EditFrame::LtoWy(Lunit y)
{
  return window->DunitY(y);
}

// ------------------------------------------------------------
// reformat

// redraw windows
void 
EditFrame::RedrawWindows()
{
  doc->GetDocumentPresentation()->RedrawWindows();
}

// unforce touch caret
void 
EditFrame::UnforceTouchCaret()
{
  window->UnforceTouchCaret();
}

// check panel num max
bool 
EditFrame::CheckPanelNumMax()
{
  return doc->GetDocumentContent()->CheckPanelNumMax();
}

// ------------------------------------------------------------
// display

// redisplay
void 
EditFrame::Redisplay(View* view)
{
  if (GetEditLI() == 0) 
  {
    return;
  }
  VDisplay vdsp(view, GetEditLI());
  switch (toolbox) 
  {
   case Cut_MODE:
    RedisplayCutLine(&vdsp);
    break;
   case DrawLine_MODE:
    RedisplayDrawLine(&vdsp);
    break;
   case MoveLine_MODE:
    RedisplayMoveLine(&vdsp);
    break;
   case SetFlow_MODE:
    RedisplaySetFlow(&vdsp);
    break;
   case ExchFlow_MODE:
    RedisplayExchange(&vdsp);
    break;
   case SetMargin_MODE:
    RedisplayMargin(&vdsp);
    break;
   case MakeTable_MODE:
    RedisplayMakeTable(&vdsp);
    break;
   case FrameMargin_MODE:
    RedisplayFrameMargin(&vdsp);
    break;
  }
}

// display selected line
// You must call this function with pixcel-map mode.
void 
EditFrame::DisplaySelectedLine(HDC hDC, VectW& from, VectW& to)
{
  HPEN hOldPen = (HPEN)SelectObject(hDC,
				    CreatePen(PS_SOLID,
					      (from.x == to.x
					       ? Screen::frame_width
					       : Screen::frame_height) / 2,
					      0L));
  SetROP2(hDC, R2_NOT);
#ifdef _WIN32
  MoveToEx(hDC, from.x, from.y, NULL);
#else /* _WIN32 */
  MoveTo(hDC, from.x, from.y);
#endif /* _WIN32 */
  LineTo(hDC, to.x, to.y);
  DeleteObject(SelectObject(hDC, hOldPen));
}

// set document dirty flag
void 
EditFrame::SetDirty()
{
  doc->GetDocumentContent()->SetDirty();
}

// check cut able
bool 
EditFrame::CanCut(Fission* f)
{
  return GetEditFF()->CheckVanish(f);
}

// scan sub tree fission
// return	: True: HIT!
bool 
EditFrame::CCS_ScanSubTree(Fission* root, Fission* f1, Fission* f2)
{
  bool vert = root->GetDir() == Fission::Vertical;
  CrossPoint* end = vert ? root->GetEndCrossPoint()->GetVPrev() :
  root->GetEndCrossPoint()->GetHPrev();
  for (CrossPoint* cp = vert ? root->GetStartCrossPoint()->GetVNext() :
       root->GetStartCrossPoint()->GetHNext();
       cp != 0;
       cp = vert ? cp->GetVNext() : cp->GetHNext()) 
  {
    if (vert ? (cp->GetKind() & (CrossPoint::HStart | CrossPoint::HEnd)) :
	(cp->GetKind() & (CrossPoint::VStart | CrossPoint::VEnd))) 
    {
      Fission* scan = vert ? (Fission*)cp->GetHFission() : 
      (Fission*)cp->GetVFission();
      if ((f1 == scan) ||
	  (f2 == scan)) 
      {
	return True;
      }
      if (CCS_ScanSubTree(scan, f1, f2)) 
      {
	return True;
      }
    }
    if (cp == end) 
    {
      break;
    }
  }
  return False;
}

// scan self dependency
bool 
EditFrame::CCS_ScanSelfDependency(Fission* scan, 
				   CrossPoint* scan_start,
				   CrossPoint* scan_end,
				   Fission* f_start, 
				   Fission* f_end)
{
  bool vert = scan->GetDir() == Fission::Vertical;
  for (CrossPoint* cp = scan_start;
       cp != 0;
       cp = vert ? cp->GetVNext() : cp->GetHNext()) 
  {
    if (vert ? (cp->GetKind() & (CrossPoint::HStart | CrossPoint::HEnd)) :
	(cp->GetKind() & (CrossPoint::VStart | CrossPoint::VEnd))) 
    {
      Fission* scan = vert ? (Fission*)cp->GetHFission() : 
      (Fission*)cp->GetVFission();
      if (CCS_ScanSubTree(scan, f_start, f_end)) 
      {
	return False;
      }
    }
    if (cp == scan_end) 
    {
      break;
    }
  }
  return True;
}

// check cut able segment
bool 
EditFrame::CanCutSegment(Fission* f, CrossPoint* start, CrossPoint* end)
{
  //
  // margin line check
  //
  if (IsMarginLine(f)) 
  {
    return False;
  }
  
  //
  // phisically cutable check
  //
  if (f->GetDir() == Fission::Vertical) 
  {
    if ((start->GetKind() & 
	 (CrossPoint::HStart | CrossPoint::HEnd)) ||
	(end->GetKind() & 
	 (CrossPoint::HStart | CrossPoint::HEnd))) 
    {
      // unable to cut segment
      return False;
    }
  }
  else 
  {               // Fission::Horizontal
    if ((start->GetKind() & 
	 (CrossPoint::VStart | CrossPoint::VEnd)) ||
	(end->GetKind() & 
	 (CrossPoint::VStart | CrossPoint::VEnd))) 
    {
      // unable to cut segment
      return False;
    }
  }
  
  //
  // check instance
  //
  Fission* start_f;
  Fission* end_f;
  if (f->GetDir() == Fission::Vertical) 
  {
    start_f = start->GetHFission();
    end_f   = end->GetHFission();
  }
  else 
  {          // Fission::Horizontal
    start_f = start->GetVFission();
    end_f   = end->GetVFission();
  }
  if (GetEditFF()->CheckVanishPart(f, start_f, end_f) == False) 
  {
    return False;
  }
  
  //
  // self dependency check
  //
  bool vert = (f->GetDir() == Fission::Vertical) ? True : False;
  if (f->GetStartFission() == start_f) 
  {
    //
    // cut start part
    //
    if (vert) 
    {
      return CCS_ScanSelfDependency(f, start->GetVNext(), 
				     f->GetEndCrossPoint()->GetVPrev(),
				     0, end_f);
    }
    else 
    {
      return CCS_ScanSelfDependency(f, start->GetHNext(), 
				     f->GetEndCrossPoint()->GetHPrev(),
				     0, end_f);
    }
  }
  else if (f->GetEndFission() == end_f) 
  {
    //
    // cut end part
    //
    if (vert) 
    {
      return CCS_ScanSelfDependency(f, 
				     f->GetStartCrossPoint()->GetVNext(), 
				     start->GetVPrev(),
				     start_f, 0);
    }
    else 
    {
      return CCS_ScanSelfDependency(f, 
				     f->GetStartCrossPoint()->GetHNext(),
				     start->GetHPrev(),
				     start_f, 0);
    }
  }
  else 
  {
    //
    // cut middle part
    //
    bool res = True;
    if (vert) 
    {
      res = CCS_ScanSelfDependency(f, 
				    f->GetStartCrossPoint()->GetVNext(), 
				    start->GetVPrev(),
				    start_f, end_f);
      if (!res) 
      {
	return False;
      }
      return CCS_ScanSelfDependency(f, 
				     end->GetVNext(), 
				     f->GetEndCrossPoint()->GetVPrev(),
				     start_f, end_f);
    }
    else 
    {
      res = CCS_ScanSelfDependency(f, 
				    f->GetStartCrossPoint()->GetHNext(),
				    start->GetHPrev(),
				    start_f, end_f);
      if (!res) 
      {
	return False;
      }
      return CCS_ScanSelfDependency(f, 
				     end->GetHNext(), 
				     f->GetEndCrossPoint()->GetHPrev(),
				     start_f, end_f);
    }
  }
}

void 
EditFrame::AdaptOffset(VectW& v)
{
  v -= mouse_offset;
}

#if defined(BW2_GRID)
bool EditFrame::grid_status = True;
Iunit EditFrame::grid_x_unit = 10;
Iunit EditFrame::grid_y_unit = 10;
Iunit EditFrame::grid_x_offset = 0;
Iunit EditFrame::grid_y_offset = 0;
EditFrame::GridOrg EditFrame::grid_org = 
(EditFrame::GridOrgTop | EditFrame::GridOrgLeft);

Iunit 
EditFrame::GridX(Iunit /*x*/)
{
  return 0;
}

Iunit 
EditFrame::GridY(Iunit /*y*/)
{
  return 0;
}
#endif
