// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: editmode.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// These classes replasent each edit-mode.
// class EMCutLine     : hasami
// class EMDrawLine    : draw line
// class EMMoveLine    : move line
// class EMSelectFrame : select frame
// class EMSetFlow     : set flow
// class EMExchFlow    : exchange flow
// class EMSetMargin   : set paragraph indent
// class EMMakeTable   : make table
// class EMFrameMargin : set frame margin

#ifndef EDITMODE_H
#define EDITMODE_H

// This header is included only from editfram.h

// ------------------------------------------------------------
// cut line edit mode

class EMCutLine 
{
  // find cut line
  bool find;
  
  // layout
  LayoutInstance* li;
  
  // cut fission
  Fission* f;
  
  // cut segment
  CrossPoint* start;
  CrossPoint* end;
  
public:
  // reset data
  void Reset() 
  {
    find = False;
    li = 0;
    f = 0;
    start = 0;
    end = 0;
  }
  
  // find cut line
  void FindCutLine(LayoutInstance* li, Fission* f, 
		    CrossPoint* start, CrossPoint* end)
  {
    EMCutLine::find = True;
    EMCutLine::li = li;
    EMCutLine::f = f;
    EMCutLine::start = start;
    EMCutLine::end = end;
  }
  
  // find
  bool IsFixed()
  {
    return find;
  }
  
  LayoutInstance* GetLI()
  {
    return li;
  }  
  
  Fission* GetFission()
  {
    return f;
  }
  
  CrossPoint* GetStart()
  {
    return start;
  }
  
  CrossPoint* GetEnd()
  {
    return end;
  }
  
  // constructor
  EMCutLine() 
  { 
    Reset();
  }
  
  // destructor
  ~EMCutLine() 
  { ; }
};

// ------------------------------------------------------------
// draw line edit mode

class EMDrawLine 
{
  // fix start posittion flag
  bool fix_start_pos;
  
  // line start fission
  Fission* start;
  
  // line end fission
  Fission* end;
  
  // line pos
  Iunit pos;
  
  // margin line special flag
  bool margin_line;
  
public:
  // reset data
  void Reset() 
  {
    start = 0;
    end = 0;
    pos = 0;
    fix_start_pos = False;
    margin_line = False;
  }
  
  // constructor
  EMDrawLine() 
  {
    Reset();
  }
  
  // destructor
  ~EMDrawLine() 
  { ; }
  
  // set start position
  void SetStart(Fission* f, Iunit p, bool margin) 
  {
    start = end = f;
    pos = p;
    fix_start_pos = True;
    margin_line = margin;
  }
  
  // set end position
  void SetEnd(Fission* f) 
  {
    end = f;
  }
  
  // line pos
  Iunit GetPos() 
  {
    return pos;
  }
  
  // get start fission
  Fission* GetStartFission() 
  {
    return start;
  }
  
  // get end fission
  Fission* GetEndFission() 
  {
    return end;
  }
  
  // get fix start pos
  bool IsFixed() 
  {
    return fix_start_pos;
  }
  
  // margin line
  bool IsMarginLine() 
  {
    return margin_line;
  }
};

// ------------------------------------------------------------
// move line edit mode

class EMMoveLine 
{
public:
  // edit mode
  enum MoveLineMode 
  {
    Idle,			// idle
    Move,			// move line mode
    SegMove,			// move segment mode
    SelLine,			// select line mode
    SelSeg,			// select segment mode
    ScaleTable,	      	// scale resize table
    ScaleOneDirTable,		// table resize one direction mode
    StretchTable,		// stretch table with no scale
    StretchOneDirTable,	// stretch one direction table with no scale
    MoveExpansion,            // move line and expand table
  };
private:
  // move line mode
  MoveLineMode mode;
  
  // move limit
  Iunit l_limit;
  Iunit u_limit;
  
  // scale limit
  Iunit scale_l_limit;
  Iunit scale_u_limit;
  
  // move position
  Iunit move_pos;
  
  // move fission
  Fission* move_f;
  
  // fix flag
  bool fix_flag;
  
  // select fission
  Fission* sel_f;
  
  // select segment
  CrossPoint* seg_start;
  CrossPoint* seg_end;
  
  // move position for scale table
  Vector scale_pos;
  
  // scale corner
  CrossPoint* scale_corner;
  
  // selection layout
  LayoutInstance* selected_li;
  
public:
  // reset work data
  void Reset() 
  {
    mode = Idle;
    move_f = 0;
    fix_flag = False;
    sel_f = 0;
    seg_start = 0;
    seg_end = 0;
    scale_corner = 0;
    selected_li = 0;
  }
  
  // constructor
  EMMoveLine() 
  {
    Reset();
  }
  
  // destructor
  ~EMMoveLine() 
  { ; }
  
  // move line mode
  MoveLineMode GetMoveLineMode() 
  {
    return mode;
  }
  
  void SetMoveLineMode(MoveLineMode m) 
  {
    mode = m;
  }
  
  // fixed check
  bool IsFixed() 
  {
    return fix_flag;
  }

  // ------------------------------
  // stretch table
  void StartStretchTable(CrossPoint* corner, Vector& pos)
  {
    scale_pos = pos;
    scale_corner = corner;
    fix_flag = True;
    mode = StretchTable;
  }
  
  void StartStretchOneDirTable(Fission* f, Iunit pos)
  {
    move_f = f;
    move_pos = pos;
    fix_flag = True;
    mode = StretchOneDirTable;
  }
  
  // ------------------------------
  // resize table
  void StartScaleOneDirTable(Fission* f, Iunit pos)
  {
    move_f = f;
    move_pos = pos;
    fix_flag = True;
    mode = ScaleOneDirTable;
  }
  
  // ------------------------------
  // scale table

  // start scale table
  void StartScaleTable(CrossPoint* corner, Vector& pos)
  {
    scale_pos = pos;
    scale_corner = corner;
    fix_flag = True;
    mode = ScaleTable;
  }
  
  void MoveScalePos(Vector& pos)
  {
    scale_pos = pos;
  }
  
  CrossPoint* GetScaleCorner() 
  {
    return scale_corner; 
  }
  
  Vector GetScalePos() 
  { 
    return scale_pos;
  }
  
  Iunit GetScaleLLimit() 
  {
    return scale_l_limit;
  }
  
  Iunit GetScaleULimit() 
  {
    return scale_u_limit;
  }

  // ------------------------------
  // move line

  // start move line
  void StartMoveLine(Fission* f, Iunit pos, Iunit llim, Iunit ulim,
                      Iunit scale_l_lim, Iunit scale_u_lim)
  {
    move_f = f;
    move_pos = pos;
    l_limit = llim;
    u_limit = ulim;
    fix_flag = True;
    scale_l_limit = scale_l_lim;
    scale_u_limit = scale_u_lim;
  }
  
  // move limit
  Iunit GetLowerLimit() 
  {
    return l_limit;
  }
  
  Iunit GetUpperLimit() 
  {
    return u_limit;
  }
  
  // move
  void ChangeLinePos(Iunit pos)
  {
    move_pos = pos;
  }
  
  Fission* GetMoveFission() 
  {
    return move_f;
  }
  
  Iunit GetMovePos() 
  {
    return move_pos;
  }
  
  // ------------------------------
  // select line

  // select line start
  void StartSelLine(Fission* f, LayoutInstance* li)
  {
    sel_f = f;
    selected_li = li;
  }
  
  // get selected fission
  Fission* GetSelectedFission() 
  {
    return sel_f;
  }
  
  // get selected layout
  LayoutInstance* GetSelectedLayout() 
  {
    return selected_li;
  }
  
  // ------------------------------
  // select segment line

  // select segment line start
  void StartSelSegLine(Fission* f, CrossPoint* start, CrossPoint* end, 
			LayoutInstance* li)
  {
    sel_f = f;
    seg_start = start;
    seg_end = end;
    selected_li = li;
  }
  
  // get segment corsspoint
  CrossPoint* GetSegStart() 
  {
    return seg_start;
  }
  
  CrossPoint* GetSegEnd() 
  {
    return seg_end;
  }
  
  // end selection
  void EndSelection()
  {
    sel_f = 0;
    seg_start = 0;
    seg_end = 0;
    selected_li = 0;
  }
  
  // ------------------------------
  // segment move

  // start 
  void StartSegMove(Fission* f, CrossPoint* start, CrossPoint* end,
                     Iunit pos, Iunit llim, Iunit ulim,
                     Iunit scale_l_lim, Iunit scale_u_lim)
  {
    move_f = f;
    seg_start = start;
    seg_end = end;
    move_pos = pos;
    l_limit = llim;
    u_limit = ulim;
    fix_flag = True;
    scale_l_limit = scale_l_lim;
    scale_u_limit = scale_u_lim;
  }
  
  // ------------------------------
  // move expansion
  void StartMoveExpansion(Fission* f, Iunit pos, Iunit llim, Iunit ulim,
			   Iunit scale_l_lim, Iunit scale_u_lim)
  {
    StartMoveLine(f, pos, llim, ulim, scale_l_lim, scale_u_lim);
  }
};

// ------------------------------------------------------------
// select frame mode

class EMSelectFrame 
{
  // set crosspoint
  CrossPoint* from;
  
  // to
  CrossPoint* to;
  
  // selected layout
  LayoutTemplate* lt;      /// this member will be vanished soon.
  
  // fix flag
  bool fix;
  
  // frame selected flag
  bool select;
  
  // shift selecting
  bool shift_select;
  
  // select operation, clear or set
  // True : set operation
  // False: clear operation
  bool select_op;
  
  // to vector
  Vector to_vec;
  
public:
  // reset
  void Reset() 
  {
    from = 0;
    to = 0;
    lt = 0;
    fix = False;
    select = False;
    shift_select = False;
    select_op = True;
    to_vec.x = 0;
    to_vec.y = 0;
  }
  
  // constructor
  EMSelectFrame() 
  {
    Reset();
  }
  
  // destructor
  ~EMSelectFrame() 
  { ; }
  
  // get drag start crosspoint
  CrossPoint* GetCrossPoint() 
  {
    return from;
  }

  // get drag end crosspoint
  CrossPoint* GetToCrossPoint() 
  {
    return to;
  }
  
  // get to vector
  Vector& GetToVector()
  {
    return to_vec;
  }

  // start selection
  void StartSelection(CrossPoint* pos, LayoutTemplate* l, Vector& v)
  {
    from = pos;
    to = pos;
    to_vec = v;
    lt = l;
    fix = True;
    select = False;
    shift_select = False;
  }
  
  void SelectFrame() 
  {
    fix = False;
    select = True;
    shift_select = False;
  }
  
  void Move(CrossPoint* pos, Vector& v) 
  {
    to = pos;
    to_vec = v;
  }
  
  bool IsFixed() 
  {
    return fix;
  }
  
  bool IsSelected() 
  {
    return select;
  }
  
  // for shift select mode
  void SetShiftSelect() 
  {
    shift_select = True;
  }
  
  bool IsShiftSelect() 
  {
    return shift_select;
  }
  
  // get 
  bool GetSelectOp()
  {
    return select_op;
  }
  
  void SetSelectOp(bool s)
  {
    select_op = s;
  }
};

// ------------------------------------------------------------
// set flow edit mode

class EMSetFlow 
{
  // source crosspoint
  CrossPoint* source;
  
  // destnation
  CrossPoint* dest;
  
  // from position
  Vector from;
  
  // to position
  VectL to;
  
  // fix start posittion flag
  bool fix_start_pos;
  
public:
  // reset work data
  void Reset() 
  {
    source = 0;
    dest = 0;
    fix_start_pos = False;
  }
  
  // constructor
  EMSetFlow() 
  {
    Reset();
  }
  
  // destructor
  ~EMSetFlow() 
  { ; }
  
  // set start position
  void SetStart(CrossPoint* src, VectL& vl, Vector& v) 
  {
    source = src;
    dest = 0;
    from = v;
    to = vl;
    fix_start_pos = True;
  }
  
  // set end position
  void SetEndPos(VectL& v) 
  {
    to = v;
  }
  
  // set destination
  void SetDestination(CrossPoint* cp)
  {
    dest = cp;
  }
  
  // get set-flow object pos.
  Iunit GetFromX() 
  {
    return from.x;
  }
  
  Iunit GetFromY() 
  {
    return from.y;
  }
  
  Lunit GetToLX() 
  {
    return to.x;
  }
  
  Lunit GetToLY() 
  {
    return to.y;
  }
  
  // start position
  bool IsFixed() 
  {
    return fix_start_pos;
  }
  
  // get source crosspoint
  CrossPoint* GetSource() 
  {
    return source;
  }
  
  CrossPoint* GetDestination() 
  {
    return dest;
  }
};

// ------------------------------------------------------------
// exchange flow mode

class EMExchFlow 
  : public EMSetFlow 
{
public:
  // constructor
  EMExchFlow() 
  { ; }
  
  // destructor
  ~EMExchFlow() 
  { ; }
};

// ------------------------------------------------------------
// set margin mode

class EMSetMargin
{
public:
  enum LockMargin 
  {
    Idle = 0,
    FirstMargin = 1,
    LeftMargin = 2,
    RightMargin = 3,
  };
  
private:
  // which margin
  LockMargin lm;
  
  // which paragraph
  Paragraph* ph;
  
  // which frame
  FrameInstance* fi;
  
  // which line
  Line* ln;
  
  // editting margin position
  Vector from;
  Vector to;
  
  // move limit
  Iunit l_limit;
  Iunit u_limit;
  
  // with first margin flag
  bool with_first;
  
#ifdef MARGIN_SET_WITH_LEFT
  // with left margin flag
  bool with_left;
#endif
  
  // with all margin flag
  bool with_all;
  
  // tate gaki paragraph
  bool tate_p;
  
public:
  // reset
  void Reset()
  {
    lm = Idle;
    ph = 0;
  }
  
  // constructor
  EMSetMargin() 
  {
    Reset();
  }
  
  // destructor
  ~EMSetMargin() 
  { ; }
  
  // start
  void Start(LockMargin lm, Paragraph* ph, FrameInstance* fi, Line* ln, 
              Vector& from, Vector& to, bool tate_p)
  {
    EMSetMargin::lm = lm;
    EMSetMargin::ph = ph;
    EMSetMargin::fi = fi;
    EMSetMargin::ln = ln;
    EMSetMargin::from = from;
    EMSetMargin::to = to;
    with_first = False;
#ifdef MARGIN_SET_WITH_LEFT
    with_left = False;
#endif
    with_all = False;
    EMSetMargin::tate_p = tate_p;
    tate_p = False;
  }
  
  Paragraph* GetParagraph() 
  {
    return ph;
  }
  
  FrameInstance* GetFrame() 
  {
    return fi;
  }
  
  Line* GetLine() 
  {
    return ln;
  }
  
  Vector& GetFromPos() 
  {
    return from;
  }
  
  Vector& GetToPos() 
  {
    return to;
  }
  
  void SetWithFirst() 
  {
    with_first = True;
  }
  
  bool GetWithFirst() 
  {
    return with_first;
  }
  
  void SetWithAll() 
  {
    with_all = True;
  }
  
#ifdef MARGIN_SET_WITH_LEFT
  bool GetWithLeft()
  {
    return with_left;
  }
  
  void SetWithLeft()
  {
    with_left = True;
  }
#endif
  
  bool GetWithAll() 
  {
    return with_all;
  }
  
  void SetLimit(Iunit l, Iunit u)
  {
    l_limit = l;
    u_limit = u;
  }
  
  Iunit GetLowerLimit() 
  {
    return l_limit;
  }
  
  Iunit GetUpperLimit() 
  {
    return u_limit;
  }
  
  // move
  void Move(Vector& from, Vector& to)
  {
    EMSetMargin::from = from;
    EMSetMargin::to   = to;
  }
  
  LockMargin GetLockMargin() 
  {
    return lm;
  }
  
  bool GetTateP()
  {
    return tate_p;
  }
  
  // fix check
  bool IsFixed() 
  {
    return ph != 0;
  }
};

// ------------------------------------------------------------
// make table mode

class EMMakeTable 
{
  // frame
  FrameObject* fo;
  
  // insert position
  BufferPointer* bp;
  
  // from
  Vector from_pos;
  
  // to
  Vector to_pos;
  
public:
  // reset
  void Reset()
  {
    fo = 0;
    bp = 0;
  }
  
  // constructor
  EMMakeTable() 
  { Reset(); }
  
  // destructor
  ~EMMakeTable() 
  { ; }
  
  void Start(FrameObject* fo, BufferPointer* bp, Vector& pos)
  {
    EMMakeTable::fo = fo;
    EMMakeTable::bp = bp;
    to_pos = from_pos = pos;
  }
  
  void Move(Vector& to)
  {
    to_pos = to;
  }
  
  Vector& GetFromPos() 
  {
    return from_pos;
  }
  
  Vector& GetToPos() 
  {
    return to_pos;
  }
  
  FrameObject* GetFrameObject() 
  {
    return fo;
  }
  
  BufferPointer* GetBufferPointer() 
  {
    return bp;
  }
  
  // start position
  bool IsFixed() 
  {
    return fo != 0;
  }
};

// ------------------------------------------------------------
// frame margin mode

class EMFrameMargin
{
  // frame crosspoint
  CrossPoint* cp;
  
  // margin number
  // 1: top
  // 2: bottom
  // 3: left
  // 4: right
  uword m;
  
  // move position
  Iunit move_pos;
  
  // move limit
  Iunit l_limit;
  Iunit u_limit;
  
  // fix flag
  bool fix;
  
  // work together flag
  bool wt;
  
public:
  // reset
  void Reset()
  {
    fix = False;
  }
  
  // constructor
  EMFrameMargin()
  {
    Reset();
  }
  
  // desutructor
  ~EMFrameMargin()
  { ; }
  
  // fix check
  bool IsFixed()
  {
    return fix;
  }
  
  // start
  void Start(CrossPoint* cp, uword m, 
              Iunit move_pos, Iunit l_limit, Iunit u_limit, bool wt = False)
  {
    fix = True;
    EMFrameMargin::cp = cp;
    EMFrameMargin::m = m;
    EMFrameMargin::move_pos = move_pos;
    EMFrameMargin::l_limit = l_limit;
    EMFrameMargin::u_limit = u_limit;
    EMFrameMargin::wt = wt;
  }
  
  CrossPoint* GetCrossPoint() 
  { return cp; }
  uword GetMarginNumber() 
  { return m; }
  
  // horizontal move check
  bool IsHorizontal()
  {
    return m <= 2;
  }
  
  // move position
  Iunit GetMovePos() 
  {
    return move_pos;
  }
  
  void SetMovePos(Iunit pos) 
  {
    move_pos = pos;
  }
  
  // limit
  Iunit GetLowerLimit() 
  {
    return l_limit;
  }
  
  Iunit GetUpperLimit() 
  {
    return u_limit;
  }
  
  bool GetWorkTogether() 
  {
    return wt;
  }
};

#endif /* EDITMODE_H */
