// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: editpage.cpp,v 3.5 2000/05/03 12:18:33 kudou Exp $
// EditPage class
// `j[̋@\񋟂邽߂̃NX

#include "pword.h"
#include "pmenus.h"
#include "tflist.h"
#include "cplist.h"
#include "folist.h"
#include "again.h"
#include "attribut.h"
#include "bufnew.h"
#include "docconte.h"
#include "docedit.h"
#include "docprese.h"
#include "docsel.h"
#include "document.h"
#include "docwindo.h"
#include "editfram.h"
#include "border.h"
#include "fileopen.h"
#include "fillobjc.h"
#include "fission.h"
#include "framedlg.h"
#include "frametem.h"
#include "grphobjc.h"
#include "interval.h"
#include "intlist.h"
#include "layoutdl.h"
#include "layoutin.h"
#include "layoutte.h"
#include "lman.h"
#include "metafile.h"
#include "mcursor.h"
#include "mfobject.h"
#include "mwindow.h"
#include "objectid.h"
#include "pagebox.h"
#include "pagemap.h"
#include "pagesize.h"
#include "panel.h"
#include "pclipboa.h"
#include "picture.h"
#include "pwordpre.h"
#include "rect.h"
#include "table.h"
#include "tablepnl.h"
#include "textflow.h"
#include "editpage.h"
#include "xstr.h"

#ifndef NDEBUG
#include "ddisplay.h"
#endif

// constructor
EditPage::EditPage(Document* doc)
{
  EditPage::doc = doc;
}

// destructor
EditPage::~EditPage()
{
  ;
}

// ------------------------------------------------------------
// internal use

// set current page-map and layout-instance
void NEAR
EditPage::SetCurrent()
{
  c_li = 0;
  c_pm = 0;
  // return;	// >>> test <<<
  
  // current layout-instance
  if (Selected_Window == 0)
  {
    return;
  }
  
  // find caret layout-instance
  c_li = Selected_Window->GetCaretLayoutInstance();
  if (c_li == 0)
  {
    // but can't find caret layout-instance, so
    c_li = Selected_Window->GetBeginningLayout();
    if (c_li == 0)
    {
      // there is a no layout in the window.
      // error
      assert(False);
      c_pm = 0;
      return;
    }
  }
  c_pm = c_li->GetPageMap();
  
  while (c_li->GetLayoutTemplate()->GetKind() != 
	 LayoutTemplate::RegularTemplate)
  {
    switch (c_li->GetLayoutTemplate()->GetKind())
    {
     case LayoutTemplate::RegularTemplate:
      break;
     case LayoutTemplate::TableTemplate:
      
      {
	BufferPointer* bp = (((Table*) c_pm)->GetPanel()
			     ->GetOwnedRealBP());
	c_li = bp->MaybeFindLayout();
	delete bp;
      }
      c_pm = c_li->GetPageMap();
      break;
     case LayoutTemplate::PageSizeTemplate:
     default:
      // what I shuld do?
      c_li = 0;
      c_pm = 0;
      return;
    }
  }
}

// redraw windows
void NEAR
EditPage::RedrawWindows()
{
  doc->GetDocumentPresentation()->RedrawWindows();
}

// invalidate to
void NEAR
EditPage::InvalidateToEnd(PageMap* pm)
{
  if (pm)
  {
    doc->GetDocumentContent()->InvalidateToEnd(pm);
  }
  else
  {
    RedrawWindows();
  }
}

// set document dirty flag
void NEAR
EditPage::SetDirty()
{
  doc->GetDocumentContent()->SetDirty();
}

// set zero-mapped-layout
void NEAR
EditPage::SetZeroMappedLayout(LayoutInstance* li)
{
  for (DocumentWindow* w = (doc->GetDocumentPresentation()
			    ->GetFirstDocWindow());
       w != 0; 
       w = w->GetNextDocWindow())
  {
    w->SetZeroCaretLayout(li);
  }
}

#if 0
// check layout sub menu
long NEAR
EditPage::CheckLayoutSubMenu(uword num, bool gate_size_match)
{
  if (c_pm == 0)
  {
    return MF_GRAYED;
  }
  
  LayoutTemplate* lt = LayoutManager::GetEntryLayout(num);
  if (c_pm->GetLayoutTemplate() == lt)
  {
    return MF_CHECKED;
  }
  
  if (gate_size_match)
  {
    uword ref_gate_num = c_pm->GetGateSize();
    uword lt_gate_num = LayoutManager::GetGateSize(num);
    uword empty = c_pm->GetErasableFlowNumber();
    if (ref_gate_num > lt_gate_num + empty)
    {
      return MF_GRAYED;
    }
  }
  return MF_UNCHECKED;
}
#endif

// vanish page map
PageMap* NEAR
EditPage::VanishPageMap(PageMap* pm)
{
  // now the time to kill this page-map.
  PageMap* prev_pm = pm->GetPrevPageMap();
  PageMap* next_pm = pm->GetNextPageMap();
  delete pm;
  doc->GetDocumentContent()->RemovePageMap(pm);
  
  // concat prev and next page-map check
  if ((prev_pm != 0) &&
      (next_pm != 0) &&
      prev_pm->IsIdenticalTwins(next_pm))
  {
    // concat twins pagemap
    uword num = next_pm->GetPageNum();
    delete next_pm;
    doc->GetDocumentContent()->RemovePageMap(next_pm);
    prev_pm->GenerateNPage(num);
  }
  return prev_pm;
}


// ------------------------------------------------------------
// layout menu

void NEAR
EditPage::ReplaceLayout()
{
  uword ref_gate_num = c_pm->GetGateSize();
  uword empty = c_pm->GetErasableFlowNumber();
  ChangeLayoutDialog lld(c_li->GetLayoutTemplate(),
			 ref_gate_num - empty,
			 ref_gate_num);
  if (lld.Go())
  {
    if (lld.ReplaceOnePageP())
    {
      Replace1Page(lld.GetLayoutID());
    }
    else
    {
      ReplaceLayout(lld.GetLayoutID());
    }
  }
}

// replace layout
void NEAR
EditPage::ReplaceLayout(uword l_num)
{
  if (c_li == 0)
  {
    return;
  }
  DocumentContent* dc = doc->GetDocumentContent();
  bool resize_flag = !LayoutManager::CanApplyLayout(dc, l_num);
  LayoutTemplate* lt = LayoutManager::GetApplyLayout(dc, l_num);
  c_pm->ReportChangeFirstFrame();
  
  //
  // create replacement page-map and page
  // remove old page-map and page
  //
  PageMap* pm = dc->GetPageMap(1);
  while (pm != 0)
  {
    PageMap* next = pm->GetNextPageMap();
    if ((pm != c_pm) && 
	pm->IsIdenticalTwins(c_pm))
    {
      PageMap* new_pm = pm->MakeReplacePageMap(lt);
      dc->InsertPageMap(pm, new_pm);
      uword page_num = pm->GetPageNum();
      new_pm->GenerateNPage(page_num);
      pm->VanishNPage(page_num);
      delete pm;
      dc->RemovePageMap(pm);
    }
    pm = next;
  }
  
  {
    // replace current
    pm = c_pm;
    PageMap* new_pm = pm->MakeReplacePageMap(lt);
    dc->InsertPageMap(pm, new_pm);      uword page_num = pm->GetPageNum();
    new_pm->GenerateNPage(page_num);
    pm->VanishNPage(page_num);
    delete pm;
    dc->RemovePageMap(pm);
  }
  
  //
  // concat same page-map
  //
  pm = dc->GetPageMap(1);
  while (pm != 0)
  {
    PageMap* next = pm->GetNextPageMap();
    if (next == 0)
    {
      break;
    }
    if (pm->IsIdenticalTwins(next))
    {
      uword page_num = next->GetPageNum();
      pm->GenerateNPage(page_num);
      next->VanishNPage(page_num);
      delete next;
      dc->RemovePageMap(next);
    }
    else
    {
      pm = next;
    }
  }
  
  if (resize_flag)
  {
    // resize request
    dc->GetPageSize()->ChangeSize();
  }
  
  RedrawWindows();
  DocumentWindow::touch_caret();
  SetDirty();
}

// replace 1 page
void NEAR
EditPage::Replace1Page(uword l_num)
{
  if (c_li == 0)
  {
    return;
  }
  
  DocumentContent* dc = doc->GetDocumentContent();
  bool resize_flag = !LayoutManager::CanApplyLayout(dc, l_num);
  LayoutTemplate* lt = LayoutManager::GetApplyLayout(dc, l_num);
  if (c_pm->GetLayoutTemplate() == lt)
  {
    return;
  }
  c_pm->ReportChangeFirstFrame();
  
  //
  // check prev page 
  //
  LayoutInstance* prev_li = c_li->GetPrevLayout();
  if ((prev_li != 0) &&
      (prev_li->GetPageMap() != c_pm) &&
      (prev_li->GetLayoutTemplate() == lt))
  {
    
    // expand prev page-map
    PageMap* prev_pm = prev_li->GetPageMap();
    if (prev_pm->IsIdenticalGate(c_pm))
    {
      // expand prev page
      LayoutInstance* new_li = prev_pm->GenerateNPage(1);
      // close replace page
      c_pm->VanishNPage(1);
      if (c_pm->GetPageNum() == 0)
      {
	prev_pm = VanishPageMap(c_pm);
      }
      InvalidateToEnd(prev_pm);
      SetZeroMappedLayout(new_li);
      DocumentWindow::touch_caret();
      SetDirty();
      return;
    }
  }
  
  //
  // check next page
  //
  LayoutInstance* next_li = c_li->GetNextLayout();
  if ((next_li != 0) &&
      (next_li->GetPageMap() != c_pm) &&
      (next_li->GetLayoutTemplate() == lt))
  {
    
    // expand next page-map
    PageMap* next_pm = next_li->GetPageMap();
    if (next_pm->IsIdenticalGate(c_pm))
    {
      // expand next page
      LayoutInstance* new_li = next_pm->GenerateNPage(1);
      // close replace page
      c_pm->VanishNPage(1);
      if (c_pm->GetPageNum() == 0)
      {
	next_pm = VanishPageMap(c_pm);
      }
      InvalidateToEnd(next_pm);
      SetZeroMappedLayout(new_li);
      DocumentWindow::touch_caret();
      SetDirty();
      return;
    }
  }
  
  //
  // make new page-map
  //
  PageMap* new_pm = 0;
  PageMap* next_pm = c_pm;
  if (c_pm->GetPageNum() == 1)
  {
    new_pm = c_pm->MakeReplacePageMap(lt);
    dc->InsertPageMap(c_pm, new_pm);
  }
  else if (c_pm->GetFirstLayout() != c_li)
  {
    // It's second or more layout-instance of this page map
    new_pm = c_pm->MakeReplacePageMap(lt);
    next_pm = c_pm->Divide(c_li);
    dc->InsertPageMap(c_pm, next_pm);
    dc->InsertPageMap(c_pm, new_pm);
  }
  else
  { 
    // It's first layout-instance of this page-map
    PageMap* prev_pm = c_pm->GetPrevPageMap();
    new_pm = c_pm->MakeReplacePageMap(lt);
    dc->InsertPageMap(prev_pm, new_pm);
  }
  LayoutInstance* new_li = new_pm->GenerateNPage(1);
  next_pm->VanishNPage(1);
  if (next_pm->GetPageNum() == 0)
  {
    VanishPageMap(next_pm);
  }
  
  if (resize_flag)
  {
    // resize request
    dc->GetPageSize()->ChangeSize();
  }
  
  InvalidateToEnd(new_pm);
  SetZeroMappedLayout(new_li);
  DocumentWindow::touch_caret();
  SetDirty();
}

void NEAR
EditPage::NewSection()
{
  NewSectionDialog nsd;
  if (nsd.Go())
  {
    NewSection(!nsd.GetNextPage());
    SetDirty();
  }
}

void NEAR
EditPage::NewSection(bool prev_ins_flag)
{
  c_pm->ReportChangeFirstFrame();
  DocumentContent* dc = doc->GetDocumentContent();
  //bool resize_flag = !LayoutManager::CanApplyLayout(dc, l_num);
  //LayoutTemplate* lt = LayoutManager::GetApplyLayout(dc, l_num);
  LayoutTemplate* lt = c_pm->GetLayoutTemplate();
  
  // make new page-map
  PageMap* new_pm = new PageMap(dc, lt);
  
  // create flow
  uword gate_size = new_pm->GetGateSize();
  for (uword i = 1; i <= gate_size; i++)
  {
    TextFlow* tf = new TextFlow(dc);
    new_pm->Replace(i, tf);
    tf->SeedParagraph();
  }
  
  // insert page-map
  PageMap* next_pm = c_pm;
  if (prev_ins_flag)
  {
    // insert previous page
    if (c_pm->GetFirstLayout() != c_li)
    {
      next_pm = c_pm->Divide(c_li);
      dc->InsertPageMap(c_pm, next_pm);
      dc->InsertPageMap(c_pm, new_pm);
    }
    else
    {
      PageMap* prev_pm = c_pm->GetPrevPageMap();
      dc->InsertPageMap(prev_pm, new_pm);
    }
  }
  else
  {
    // insert after
    LayoutInstance* li = c_li->GetNextPageMapLayout();
    if (li != 0)
    {
      next_pm = c_pm->Divide(li);
      dc->InsertPageMap(c_pm, next_pm);
      dc->InsertPageMap(c_pm, new_pm);
    }
    else
    {
      dc->InsertPageMap(c_pm, new_pm);
    }
  }
  
  // generate page
  c_li = new_pm->GenerateNPage(1);
  
  // misc.
  InvalidateToEnd(new_pm);
  DocumentWindow::touch_caret();
  SetDirty();
  
  if (Selected_Window)
  {
    TextFlow* tf = new_pm->GetGateTF(1);
    if (tf != 0)
    {
      Selected_Window->GetEditor()
      ->GetSelectionStack()
      ->InstallSelection(new IntervalList(new Interval(tf)));
    }
  }
}

// open page
void NEAR
EditPage::OpenPage()
{
  // generate another one page
  c_li = c_pm->GenerateNPage(1);
  InvalidateToEnd(c_pm->GetNextPageMap());
  DocumentWindow::touch_caret();
  SetDirty();
}

// check open page usable
bool NEAR
EditPage::CanOpenPage()
{
  return(c_pm != 0) ? c_pm->CanExpandPage() : False;
}

// close page
void NEAR
EditPage::ClosePage()
{
  c_pm->ReportChangeFirstFrame();
  InvalidateToEnd(c_pm);
  // vanish one page
  c_pm->VanishNPage(1);
  // vanish page-map check
  if (c_pm->GetPageNum() == 0)
  {
    c_pm = VanishPageMap(c_pm);
  }
  DocumentWindow::touch_caret();
  SetDirty();
}

// check close page usable
bool NEAR
EditPage::CanClosePage()
{
  return(c_pm != 0) ? c_pm->CanCondensePage() : False;
}

// set first page
void NEAR
EditPage::SetFirstPage()
{
  if (Selected_Window)
  
  {
    DocumentContent* conte = doc->GetDocumentContent();
    int start_page = conte->GetPageSize() ->GetFirstPageNumber();
    int old_page = start_page;
    
    {
      PageNoDialog dlg(start_page);
      if (dlg.Go())
      
      {
	dlg.GetValues(start_page);
      }
    }
    if (old_page != start_page)
    
    {
      conte->SetFirstPageNumber(start_page);
      conte->VariableTextUpdatePageNo();
      PWordPresentation::GetPageBox() ->Show();
      this->RedrawWindows();
      this->SetDirty();
    }
  }
}

// private method
void NEAR
EditPage::InteractiveSizeChanged()
{
  this->RedrawWindows();
  this->SetDirty();
  for (DocumentWindow* w = this->doc->GetFirstDocWindow();
       w; w = w->GetNextDocWindow())
  {
    w->SetView(0, 0);
  }
}

// change page size
void NEAR
EditPage::ChangePageSize(PageSize::Kind kind, PageSize::Orientation orn)
{
  doc->GetDocumentContent()
  ->GetPageSize()
  ->ChangeSize(kind, orn);
  this->InteractiveSizeChanged();
}

// change page size
void NEAR
EditPage::ChangePageSize()
{
  PageSize* ps = doc->GetDocumentContent()->GetPageSize();
  Vector size = ps->GetSize();
  Margin mgn = ps->GetMargin();
  PageSizeDialog dlg(ps->GetKind(), 
		      size.y, 
		      size.x, 
		      mgn.GetTop(), 
		      mgn.GetBottom(), 
		      mgn.GetRight(), 
		      mgn.GetLeft(), 
		      ps->GetOrientation());
  if (!dlg.Go())
  {
    // cancel
    return;
  }
  
  // change page size
  PageSize::Kind        k = dlg.GetName();
  PageSize::Orientation o = dlg.GetOrient();
  size.x = dlg.GetHoriz();
  size.y = dlg.GetVert();
  mgn.SetTop(dlg.GetTop());
  mgn.SetBottom(dlg.GetBottom());
  mgn.SetLeft(dlg.GetLeft());
  mgn.SetRight(dlg.GetRight());
  
  ps->ChangeSize(k, o, size, mgn);
  this->InteractiveSizeChanged();
}

// define new layout
void NEAR
EditPage::DefineNewLayout(char* name)
{
  // make new page-map
  DocumentContent* dc = doc->GetDocumentContent();
  PageMap* new_pm = c_pm->DuplicatePageMap(name);
  PageMap* next_pm = c_pm;
  c_pm->ReportChangeFirstFrame();
  if (c_pm->GetFirstLayout() != c_li)
  {
    // It's second or more layout-instance of this page map
    next_pm = c_pm->Divide(c_li);
    dc->InsertPageMap(c_pm, next_pm);
    dc->InsertPageMap(c_pm, new_pm);
  }
  else
  {
    // It's first layout-instance of this page-map.
    PageMap* prev_pm = c_pm->GetPrevPageMap();
    dc->InsertPageMap(prev_pm, new_pm);
  }
  c_li = new_pm->GenerateNPage(1);
  next_pm->VanishNPage(1);
  if (next_pm->GetPageNum() == 0)
  {
    VanishPageMap(next_pm);
  }
  InvalidateToEnd(new_pm);
  SetZeroMappedLayout(c_li);
  DocumentWindow::touch_caret();
  SetDirty();
}

// header setting
void NEAR
EditPage::HeaderSetting()
{
  LayoutInstance* zero = doc->GetDocumentContent()->GetZeroLayout();
  word all = !!zero->VisibleZeroPage();
  word cur = !!c_li->VisibleZeroPage();
  word new_all = all;
  word new_cur = cur;
  word start_page = doc->GetDocumentContent()->GetZeroDisplayStartPage();
  word new_start_page = start_page;
  
  { // control dialog's life
    HeaderDialog dlg(all, cur, start_page);
    if (dlg.Go())
    {
      dlg.GetVal(new_all, new_cur, new_start_page);
      new_all = !!new_all;
      new_cur = !!new_cur;
    }
  }
  if (new_start_page != start_page)
  {
    doc->GetDocumentContent()->SetZeroDisplayStartPage(new_start_page);
    RedrawWindows();
    SetDirty();
  }
  if (new_all != all)
  {
    zero->SetVisibleZeroPage(new_all != 0);
    RedrawWindows();
    SetDirty();
  }
  if (new_cur != cur)
  {
    c_li->SetVisibleZeroPage(new_cur != 0);
    c_li->Invalidate();
    SetDirty();
  }
}

void NEAR
EditPage::DefineNewLayout()
{
  DefLayoutDialog deflayout_dlg;
  if (deflayout_dlg.Go())
  {
    DefineNewLayout(deflayout_dlg.GetLayoutName());
  }
}

void NEAR
EditPage::RenameLayout()
{
  ChangeLayoutNameDialog clnd;
  if (clnd.Go())
  {
    // update-name
    LayoutManager::ChangeEntryName(clnd.GetLayoutID(), 
				    clnd.GetLayoutName());
    SetDirty();
  }
}

// gray check
long NEAR
EditPage::GetLayoutMenuState(int command)
{
  bool gray = True;
  switch (command)
  {
   case IDM_Page_Size:
   case IDM_Page_PageNumber:
    gray = (Selected_Window == 0);
    break;
    
   case IDM_Page_Header:
   case IDM_Page_NewLayout:
   case IDM_Page_ReplaceLayout:
   case IDM_Page_NewSection:
    gray = (c_li == 0);
    break;
    
   case IDM_Page_RenameLayout:
    gray = False;
    break;
    
   case IDM_Page_Open:
    gray = !CanOpenPage();
    break;
    
   case IDM_Page_Close:
    gray = !CanClosePage();
    break;
  }
  return gray ? MF_GRAYED : MF_ENABLED;
}

// layout menu dispatch
#ifdef BW3_DISPATCH
LRESULT_T
EditPage::DispatchLayoutMenu(WORD command, WORD notify_code, HWND hwnd)
#else /* BW3_DISPATCH */
long 
EditPage::DispatchLayoutMenu(int command, long lParam)
#endif /* BW3_DISPATCH */
{
  SetCurrent();
  long state = GetLayoutMenuState(command);
#ifdef BW3_DISPATCH
  if (MENU_STATE_P(notify_code))
#else /* BW3_DISPATCH */
  IF_MENU_STATE
#endif /* BW3_DISPATCH */
  {
    return state;
  }
  if (state & MF_GRAYED)
  {
    return 0;
  }
  
  switch (command)
  {
   case IDM_Page_Size:
    ChangePageSize();
    break;
    
   case IDM_Page_Header:
    HeaderSetting();
    break;
    
   case IDM_Page_PageNumber:
    SetFirstPage();
    break;
    
   case IDM_Page_NewLayout:
    DefineNewLayout();
    break;
    
   case IDM_Page_ReplaceLayout:
    ReplaceLayout();
    break;
    
   case IDM_Page_NewSection:
    NewSection();
    break;
    
   case IDM_Page_RenameLayout:
    RenameLayout();
    break;
    
   case IDM_Page_Open:
    OpenPage();
    break;
    
   case IDM_Page_Close:
    ClosePage();
    break;
  }
  return 0;
}


// ------------------------------------------------------------
// frame menu

EditFrame* NEAR
EditPage::GetEditFrame()
{
  return doc->GetEditFrame();
}

bool NEAR
EditPage::CheckRemoveableFrame()
{
  EditFrame* ef = GetEditFrame();
  if (!ef->IsRemoveableFrameSelectionObject())
  {
    // can't clear these objects.
    Issue(S_CantDeleteFrameMsg, MB_OK | MB_ICONEXCLAMATION);
    return False;
  }
  return True;
}

bool NEAR
EditPage::CanMakeTable()
{
  return Selected_Window != 0;
}

void NEAR
EditPage::MakeTable()
{
  MakeTableDialog mtd;
  if (mtd.Go())
  {
    uword column = mtd.GetHDiv();
    uword row    = mtd.GetVDiv();
    Iunit width  = mtd.GetHSize();
    Iunit height = mtd.GetVSize();
    TablePanel* pnl = 0;
    {
      Inserter inserter(Selected_Window->GetEditor(), 
			 PUndo::UD_InsertTable);
      do
      {
	inserter.Before();
	Interval* i = inserter.GetInterval();
	
	Table* table = new Table(doc->GetDocumentContent(),
				  width, height, column, row);
	pnl = new TablePanel(doc->GetDocumentContent(), 
			      i->GetBP0(), 
			      table->GetLayoutTemplate(),
			      table);
	table->SetPanel(pnl);
	
	Selected_Window->GetEditor()->InsertPanel(pnl, i);
	inserter.After();
      }
      while (inserter.Next());
    }
    if (pnl != 0)
    {
      PageMap* pm = pnl->GetLayout()->GetPageMap();
      TextFlow* tf = pm->GetGateTF(1);
      if (tf != 0) 
      {
	Selected_Window
	->GetEditor()
	->GetSelectionStack()
	->InstallSelection(new IntervalList(new Interval(tf)));
      }
      SetDirty();
    }
  }
}

bool NEAR
EditPage::CanSetFrameMargin()
{
  return GetEditFrame()->ExistFrameSelection();
}

void NEAR
EditPage::SetFrameMargin()
{
  EditFrame* ef = GetEditFrame();
  CPListIterator cpi(ef->GetMultiFrameSelection());
  FrameObject* fo = 0;
  CrossPoint* cp;
  while ((cp = cpi()) != 0)
  {
    fo = cp->GetFrameObject();
    if (fo != 0)
    {
      break;
    }
  }
  if (fo == 0)
  {
    return;
  }
  
  FrameMarginDialog fmgn(fo->GetTopMargin(), fo->GetBottomMargin(),
			  fo->GetLeftMargin(), fo->GetRightMargin());

  if (!fmgn.Go())
  {
    Again::CantDoAgain();
    return;
  }
  
  Margin m(fmgn.GetTop(), fmgn.GetBottom(), 
	    fmgn.GetLeft(), fmgn.GetRight());
  cpi.Revert();
  while ((cp = cpi()) != 0) 
  {
    FrameObject* fo = cp->GetFrameObject();
    if (fo)
    {
      fo->SetMargin(m);
    }
  }
  RedrawWindows();
  DocumentWindow::touch_caret();
  SetDirty();
}

static FrameTemplate* NEAR
next_frame_template(CPListIterator* cpi)
{
  if (cpi != NULL)
  {
    CrossPoint* cp;
    while ((cp = (*cpi) ()) != NULL)
    {
      FrameObject* fo = cp->GetFrameObject();
      if (fo->GetObjectID() == IDTextObject)
      {
	return((FrameTemplate*) fo);
      }
    }
  }
  return(NULL);
}

static void NEAR
kill_frame_iter(CPListIterator* cpi)
{
  if (cpi != NULL)
  {
    delete cpi;
  }
}

static CPListIterator* NEAR
make_frame_iter(EditPage* e)
{
  CPListIterator* cpi = NULL;
  EditFrame* ef = e->get_document() ->GetEditFrame();
  cpi = new CPListIterator(ef->GetMultiFrameSelection());
  return(cpi);
}

long NEAR
EditPage::GetFrameAlignMenuState(enum VerticalAlignment align)
{
  CPListIterator* cpi = make_frame_iter(this);
  FrameTemplate* ft = next_frame_template(cpi);
  long result = 0;
  result = (ft == NULL ? MF_GRAYED
	    : ft->frame_align() == align ? (MF_ENABLED | MF_CHECKED)
	    : MF_ENABLED);
  kill_frame_iter(cpi);
  return result;
}

// This method is called by `EditPage::Dispatch' only.
// private method
void NEAR
EditPage::handle_frame_align(enum VerticalAlignment align)
{
  CPListIterator* cpi = make_frame_iter(this);
  FrameTemplate* ft = next_frame_template(cpi);
  if (ft != NULL)
  {
    int changed = False;
    for (;;)
    {
      if (ft->frame_align() != align)
      {
	changed = True;
	ft->set_frame_align(align);
	ft->GetLayoutTemplate() ->DelayFormatFrame(ft);
      }
      ft = next_frame_template(cpi);
      if (ft == NULL)
      {
	break;
      }
    }
    if (changed)
    {
      DocumentWindow::touch_caret();
      this->SetDirty();
    }
  }
  kill_frame_iter(cpi);
}

// check selected Frame Border
bool NEAR
EditPage::CheckSelectedFrameBorder()
{
  EditFrame* ef = GetEditFrame();
  return(ef->ExistLineSelection() || ef->ExistFrameSelection())
  ? True : False;
}

// set selected frame or line border line
void NEAR
EditPage::SetSelectedBorderLine()
{
  EditFrame* ef = GetEditFrame();
  if (ef->ExistLineSelection())
  {
    //
    // set border line
    //
    uword new_index;
    if (Again::GetDoingAgain() && Again::GetOtherInfo(0) == 1)
    {		// again check
      new_index = (uword)Again::GetOtherInfo(1);
    }
    else
    {
      LineBorderDialog ldlg(ef->GetLineSelectionBorderLine(), 
			     LineBorderDialog::SPECIFIC_LINE);
      if (ldlg.Go() == 0)
      {
	// cancel
	Again::CantDoAgain();
	return;
      }
      new_index = ldlg.GetValue();
      Again::SetOtherInfo(1, 0);
      Again::SetOtherInfo((int)new_index, 1);
    }
    ef->SetLineSelectionBorderLine(new_index);
    RedrawWindows();
  }
  else if (ef->ExistFrameSelection())
  {
    //
    // set frame border line
    //
    uword top    = 0;
    uword bottom = 0;
    uword left   = 0;
    uword right  = 0;
    uword inter  = 0;
    EditFrame::TargetLine target = EditFrame::AllLines;
    if ((Again::GetDoingAgain()) &&
	 (Again::GetOtherInfo(0) == 2))
    {		// again check
      top    = Again::GetOtherInfo(1);
      bottom = Again::GetOtherInfo(2);
      left   = Again::GetOtherInfo(3);
      right  = Again::GetOtherInfo(4);
      inter  = Again::GetOtherInfo(5);
      target = (EditFrame::TargetLine)Again::GetOtherInfo(6);
    }
    else
    {
      ef->GetFrameSelectionBorderLine(top, bottom, left, right);
#ifdef _WIN32
      // TODO:
      // Fission system border linex index is 'uword', but
      // attribute system border line index seems to be
      // 'unsigned int'. So I should fix this confusion. (kudou)
      unsigned int top_x    = 0;
      unsigned int bottom_x = 0;
      unsigned int left_x   = 0;
      unsigned int right_x  = 0;
      unsigned int inter_x  = 0;
      FrameBorderDialog fdlg(top_x, left_x, right_x, bottom_x);
      if (fdlg.Go() == 0)
      {
	// cancel
	Again::CantDoAgain();
	return;
      }
      fdlg.GetValues(top_x, left_x, right_x, bottom_x, inter_x, target);
      Again::SetOtherInfo(2, 0);
      Again::SetOtherInfo(top_x, 1);
      Again::SetOtherInfo(bottom_x, 2);
      Again::SetOtherInfo(left_x, 3);
      Again::SetOtherInfo(right_x, 4);
      Again::SetOtherInfo(inter_x, 5);
      Again::SetOtherInfo(target, 6);
      top = (uword)top_x;
      bottom = (uword)bottom_x;
      left   = (uword)left_x;
      right  = (uword)right_x;
      inter  = (uword)inter_x;
#else /* _WIN32 */
      FrameBorderDialog fdlg(top, left, right, bottom);
      if (fdlg.Go() == 0)
      {
	// cancel
	Again::CantDoAgain();
	return;
      }
      fdlg.GetValues(top, left, right, bottom, inter, target);
      Again::SetOtherInfo(2, 0);
      Again::SetOtherInfo(top, 1);
      Again::SetOtherInfo(bottom, 2);
      Again::SetOtherInfo(left, 3);
      Again::SetOtherInfo(right, 4);
      Again::SetOtherInfo(inter, 5);
      Again::SetOtherInfo(target, 6);
#endif /* _WIN32 */
    }
    ef->SetFrameSelectionBorderLine(top, bottom, left, right, inter, target);
    RedrawWindows();
  }
  DocumentWindow::touch_caret();
  SetDirty();
}

// set frame border line
void NEAR
EditPage::SetDefaultFrameBorderLine()
{
  LineBorderDialog ldlg(BorderLine::GetDefaultFrameIndex(),
			 LineBorderDialog::DEFAULT_LINE);
  if (!ldlg.Go())
  {
    // cancel
    Again::CantDoAgain();
    return;
  }
  BorderLine::SetDefaultFrameIndex(ldlg.GetValue());
}

// set table frame border line
void NEAR
EditPage::SetDefaultTableFrameBorderLine()
{
  LineBorderDialog ldlg(BorderLine::GetDefaultTableIndex(),
			 LineBorderDialog::DEFAULT_TABLE);
  if (!ldlg.Go())
  {
    Again::CantDoAgain();
    return;
  }
  BorderLine::SetDefaultTableIndex(ldlg.GetValue());
}

bool NEAR
EditPage::CanCut()
{
  EditFrame* ef = GetEditFrame();
  return(ef->ExistFrameSelection() &&
	  ef->IsSingleFrameSelection());
}

void NEAR
EditPage::Cut()
{
  if (!CheckRemoveableFrame())
  {
    return;
  }
  EditFrame* ef = GetEditFrame();
  MouseCursor::StartLongActivity();
  GetEditFrame()->CopyFrameSelectionToClipboard();
  CPListIterator cpi(ef->GetMultiFrameSelection());
  CrossPoint* cp;
  while ((cp = cpi()) != 0) 
  {
    FrameObject* fo = cp->GetFrameObject();
    if (fo) 
    {
      delete fo;
    }
    FillObject* fl = new FillObject(cp, FillObject::White);
    fl->SetFrameSelected(True);
    cp->CreateFrameObject(fl);
  }
  doc->GetDocumentPresentation()->RedrawWindows();
  this->SetDirty();
  MouseCursor::EndLongActivity();
}

bool NEAR
EditPage::CanCopy()
{
  return GetEditFrame()->ExistCopyAbleFrameSelection();
}

void NEAR
EditPage::Copy()
{
  MouseCursor::StartLongActivity();
  GetEditFrame()->CopyFrameSelectionToClipboard();
  MouseCursor::EndLongActivity();
}

static struct clip_board_format
{
  uword format;
  void(EditPage::*func) (HANDLE);
} formats[] =
{
  { CF_METAFILEPICT, 	&EditPage::PasteMetafile },
  { CF_DIB, 		&EditPage::PasteDib },
  { CF_BITMAP, 		&EditPage::PasteBitmap },
  { 0, }
};

bool NEAR
EditPage::CanPaste()
{
  EditFrame* ef = GetEditFrame();
  if (!ef->ExistFrameSelection())
  {
    return False;
  }
  for (clip_board_format* cbf = formats;
       cbf->format != 0;
       cbf ++)
  {
    if (::IsClipboardFormatAvailable(cbf->format))
    {
      return True;
    }
  }
  return False;
}

void NEAR
EditPage::Paste()
{
  if (!CheckRemoveableFrame())
  {
    return;
  }
  clip_board_format* cbf;
  for (cbf = formats;
       cbf->format != 0;
       cbf ++)
  {
    if (::IsClipboardFormatAvailable(cbf->format))
    {
      break;
    }
  }
  if (cbf->format != 0)
  {
    if (::OpenClipboard(main_window_handle))
    {
      PClipboard::SetOpenFlag(True);
      HANDLE h = ::GetClipboardData(cbf->format);
      if (h)
      {
	MouseCursor::StartLongActivity();
	 (this->* (cbf->func)) (h);
	doc->GetDocumentPresentation()->RedrawWindows();
	this->SetDirty();
	DocumentWindow::unforce_touch_caret();
	MouseCursor::EndLongActivity();
      }
    }
    ::CloseClipboard();
    PClipboard::SetOpenFlag(False);
  }
}

void 
EditPage::PasteMetafile(HANDLE hmeta)
{
  EditFrame* ef = GetEditFrame();
  CPListIterator cpi(ef->GetMultiFrameSelection());
  CrossPoint* cp;
  while ((cp = cpi()) != 0) 
  {
    FrameObject* fo = cp->GetFrameObject();
    METAFILEPICT* mp = Metafile::CopyClipBoardData(hmeta);
    if (mp != 0)
    {
      Metafile* mf = new Metafile(mp);
      delete fo;
      MetafileObject* mo = new MetafileObject(cp, mf);
      mo->SetFrameSelected(True);
      cp->CreateFrameObject(mo);
    }
  }
}

void 
EditPage::PasteDib(HANDLE hdib)
{
  EditFrame* ef = GetEditFrame();
  CPListIterator cpi(ef->GetMultiFrameSelection());
  CrossPoint* cp;
  while ((cp = cpi()) != 0) 
  {
    FrameObject* fo = cp->GetFrameObject();
    Picture* pic = new Picture(hdib, CF_DIB);
    if (pic->IsValid())
    {
      delete fo;
      GraphicObject* gr = new GraphicObject(cp, pic);
      gr->SetFrameSelected(True);
      cp->CreateFrameObject(gr);
    }
    else
    {
      // memory trouble
      delete pic;
    }   
  }
}

void 
EditPage::PasteBitmap(HANDLE hBitmap)
{
  EditFrame* ef = GetEditFrame();
  CPListIterator cpi(ef->GetMultiFrameSelection());
  CrossPoint* cp;
  while ((cp = cpi()) != 0) 
  {
    FrameObject* fo = cp->GetFrameObject();
    Picture* pic = new Picture(hBitmap, CF_BITMAP);
    if (pic->IsValid()) 
    {
      delete fo;
      GraphicObject* gr = new GraphicObject(cp, pic);
      gr->SetFrameSelected(True);
      cp->CreateFrameObject(gr);
    }
    else
    {
      // memory trouble
      delete pic;
    }
  }
}

bool NEAR
EditPage::CanNewFlow()
{
  return GetEditFrame()->ExistFrameSelection();
}

void NEAR
EditPage::NewFlow()
{
  if (!CheckRemoveableFrame())
  {
    return;
  }
  EditFrame* ef = GetEditFrame();
  CPListIterator cpi(ef->GetMultiFrameSelection());
  CrossPoint* cp;
  FrameObject* fo = 0;
  while ((cp = cpi()) != 0) 
  {
    fo = cp->GetFrameObject();
    delete fo;
    FrameOwner* fown = cp->GetFissionFrame()->GetFrameOwner();
    fo = fown->CreateNewFlow(cp);
    if (((LayoutTemplate*)fown)->GetKind() == LayoutTemplate::TableTemplate)
    {
      Margin m = Table::GetDefaultFrameMargin();
      fo->SetMargin(m);
    }
    else
    {
      Margin m = PageSize::GetDefaultFrameMargin();
      fo->SetMargin(m);
    }
    fo->SetFrameSelected(True);
  }
  if (fo != 0)
  {
    // set up caret position
    LayoutTemplate* lt = ((FrameTemplate*)fo)->GetLayoutTemplate();
    LayoutInstance* li = doc->GetDocumentContent()->FindFirstLayout(lt);
    if (li != 0)
    {    
      uword gate = lt->WhichGateFT((FrameTemplate*)fo);
      TextFlow* tf = li->GetPageMap()->GetGateTF(gate);
      if (Selected_Window != 0)
      {
	Selected_Window->GetEditor()
	->GetSelectionStack()
	->InstallSelection(new IntervalList(new Interval(tf)));
	DocumentWindow::unforce_touch_caret();
      }
      RedrawWindows();
      SetDirty();
    }
  }
}

bool NEAR
EditPage::CanFillFrame()
{
  return GetEditFrame()->ExistFrameSelection();
}

#undef BUILD_IN_META_TEST

void NEAR
EditPage::FillFrame()
{
  if (!CheckRemoveableFrame())
  {
    return;
  }
  
  // FillPatternDialog dialog or again
  EditFrame* ef = GetEditFrame();
  FillObject::FillType typ;
  if ((Again::GetDoingAgain()) &&
      (Again::GetOtherInfo(0) == 2))
  {
    typ = (FillObject::FillType)Again::GetOtherInfo(1);
  }
  else
  {
    FillPatternDialog fill_dialog(FillObject::GetDefaultFillType());
    if (!fill_dialog.Go())
    {
      // cancel
      Again::CantDoAgain();
      return;
    }
    typ = fill_dialog.GetValue();
    Again::SetOtherInfo(2, 0);
    Again::SetOtherInfo((int)typ, 1);
    FillObject::SetDefaultFillType(typ); 
  }
  
#ifdef BUILD_IN_METAFILE_TEST
  Metafile::BuiltInMetafile bim;
  switch (typ)
  {
   case FillObject::White:
    bim = Metafile::LeftSlantLine;
    break;
   case FillObject::LtGray:
    bim = Metafile::LeftSlantDotted;
    break;
   case FillObject::Gray:
    bim = Metafile::RightSlantLine;
    break;
   case FillObject::DkGray:
    bim = Metafile::RightSlantDotted;
    break;
   case FillObject::Black:
    bim = Metafile::CrossLine;
    break;
   case FillObject::HorizontalHatch:
    bim = Metafile::CrossDotted;
    break;
   case FillObject::VerticalHatch:
    bim = Metafile::RingLine;
    break;
   case FillObject::FDiagonalHatch:
    bim = Metafile::Circle;
    break;
   case FillObject::DiagcrossHatch:
    bim = Metafile::FillCircle;
    break;
   case FillObject::CrossHatch:
    bim = Metafile::GrayCircle;
    break;
   case FillObject::BDiagonalHatch:
    bim = Metafile::Root;
    break;
  }
#endif
  CPListIterator cpi(ef->GetMultiFrameSelection());
  CrossPoint* cp;
  while ((cp = cpi()) != 0)
  {
    FrameObject* fo = cp->GetFrameObject();
    bool frame_sel = fo->FrameSelectedP();
    delete fo;
#ifdef BUILD_IN_METAFILE_TEST
    Metafile* mf = new Metafile(bim);
    fo = new MetafileObject(cp, mf);
#else
    fo = new FillObject(cp, typ);
#endif
    fo->SetFrameSelected(frame_sel);
    cp->CreateFrameObject(fo);
  }
  // re-paint
  RedrawWindows();
  DocumentWindow::touch_caret();
  SetDirty();
}

bool NEAR
EditPage::CanReadFile()
{
  return CanNewFlow();
}

void NEAR
EditPage::ReadFile()
{
  if (!CheckRemoveableFrame())
  {
    return;
  }
#ifdef BW3_FILEDLG
  char filename[MAX_PATH + 1];
  strcpy(filename, S_BmpWildCard);
  FileOpenDialog fod(filename, S_BmpWildCard2, true);
#else /* BW3_FILEDLG */
  FileOpenDialog fod(S_BmpWildCard, True);
#endif /* BW3_FILEDLG */
  if (fod.Go())
  {
    char* file_name = fod.GetResult();
    
    // make picture
    Picture::FileCheck fc = Picture::CheckFileConsistency(Picture::BMP, file_name);
    if (fc != Picture::FileOk)
    {
      ::MessageBeep(0);
      return;
    }
    
    Picture* org_pic = new Picture(file_name);
    
    if (!org_pic->IsValid()) 
    {
      // error
      ::MessageBeep(0);
      return;
    }
    {
      EditFrame* ef = GetEditFrame();
      CPListIterator cpi(ef->GetMultiFrameSelection());
      CrossPoint* cp;
      while ((cp = cpi()) != 0) 
      {
	FrameObject* fo = cp->GetFrameObject();
	Picture* pic = new Picture(org_pic);
	if (pic->IsValid()) 
	{
	  delete fo;
	  GraphicObject* gr = new GraphicObject(cp, pic);
	  gr->SetFrameSelected(True);
	  cp->CreateFrameObject(gr);
	}
	else
	{
	  // memory trouble
	  delete pic;
	}
      }
    }
    delete org_pic;
    RedrawWindows();
    DocumentWindow::touch_caret();
    SetDirty();
  }
}

bool NEAR
EditPage::CanInsertFrame()
{
  return GetEditFrame()->ExistInsertableFrameSel();
}

void NEAR
EditPage::InsertFrame()
{
  EditFrame* ef = GetEditFrame();
  if (ef->ZeroPageSelectedP())
  {
    // can't insert
    Issue(S_CantInsertFrameOnZeroPage, MB_OK | MB_ICONSTOP);
    return;
  }
  InsertFrameDialog ifdlg(ef->PosibleInsertLine(),
			   ef->PosibleInsertColumn(),
			   ef->TableSelectedP());
  if (!ifdlg.Go())
  {
    Again::CantDoAgain();
    return;
  }
  ef->InsertFrameSelection(!ifdlg.ExpandSizeP(),
			    ifdlg.PostInsertP(),
			    ifdlg.InsertLineP(),
			    ifdlg.GetCopyNum());
}

bool NEAR
EditPage::CanRemoveFrame()
{
  return GetEditFrame()->ExistDeletableFrameSel();
}

void NEAR
EditPage::RemoveFrame()
{
  EditFrame* ef = GetEditFrame();
  if (ef->ZeroPageSelectedP())
  {
    // can't insert
    Issue(S_CantRemoveFrameOnZeroPage, MB_OK | MB_ICONSTOP);
    return;
  }

  RemoveFrameDialog rfdlg(ef->PosibleDeleteLine(),
			   ef->PosibleDeleteColumn(),
			   ef->TableSelectedP());
  if (!rfdlg.Go())
  {
    Again::CantDoAgain();
    return;
  }
  ef->DeleteFrameSelection(!rfdlg.ExpandSizeP(),
			    rfdlg.RemoveLineP());
}

bool NEAR
EditPage::CanSplitFrame()
{
  return GetEditFrame()->IsSingleFrameSelection();
}

void NEAR
EditPage::SplitFrame()
{
  SplitFrameDialog dlg;
  if (!dlg.Go())
  {
    Again::CantDoAgain();
    return;
  }
  uword column = dlg.GetValue();
  uword row = dlg.GetValue2();
  
  // split
  GetEditFrame()->SplitSelectedFrame(column, row);
  RedrawWindows();
  DocumentWindow::touch_caret();
  SetDirty();
}

bool NEAR
EditPage::CanCombineFrame()
{
  return GetEditFrame()->CanCombineFrame();
}

void NEAR
EditPage::CombineFrame()
{
  if (GetEditFrame()->ZeroPageSelectedP())
  {
    // can't insert
    Issue(S_CantCombineFrameOnZeroPage, MB_OK | MB_ICONSTOP);
    return;
  }
  CombineFrameDialog cfg;
  if (cfg.Go())
  {
    GetEditFrame()->CombineFrame(cfg.CombineVerticalP(),
				   cfg.CombineHorizontalP());
  }
}

void NEAR
EditPage::AlignFrame()
{
  if (GetEditFrame()->ZeroPageSelectedP())
  {
    // can't align
    Issue(S_CantAlignFrameOnZeroPage, MB_OK | MB_ICONSTOP);
    return;
  }
  AlignFrameDialog afd;
  if (afd.Go())
  {
    GetEditFrame()->AlignFrame(afd.AlignVerticalP(),
				 afd.AlignHorizontalP());
  }
}

bool NEAR
EditPage::CanAlignFrame()
{
  return GetEditFrame()->CanAlignFrame();
}

long NEAR 
EditPage::GetFrameMenuState(int command)
{
  bool enable = False;
  switch (command)
  {
   case IDM_Frame_MakeTable:
    enable = CanMakeTable();
    break;

   case IDM_Frame_Margin:
    enable = CanSetFrameMargin();
    break;
    
   case IDM_Frame_AlignTop:
    return GetFrameAlignMenuState(AL_vertical_up);
    
   case IDM_Frame_AlignMiddle:
    return GetFrameAlignMenuState(AL_vertical_center);
    
   case IDM_Frame_AlignBottom:
    return GetFrameAlignMenuState(AL_vertical_down);
    
   case IDM_Frame_AlignVerticalAdjust:
    return GetFrameAlignMenuState(AL_vertical_adjust);
    
   case IDM_Frame_Border:
    enable = CheckSelectedFrameBorder();
    break;
    
   case IDM_Frame_DefaultBorder:
   case IDM_Frame_DefaultTableBorder:
    enable = True;
    break;
    
   case IDM_Frame_Cut:
    enable = CanCut();
    break;

   case IDM_Frame_Copy:
    enable = CanCopy();
    break;
    
   case IDM_Frame_Paste:
    enable = CanPaste();
    break;
    
   case IDM_Frame_NewFlow:
    enable = CanNewFlow();
    break;
    
   case IDM_Frame_Fill:
    enable = CanFillFrame();
    break;
    
   case IDM_Frame_ReadFile:
    enable = CanReadFile();
    break;
    
   case IDM_Frame_Insert:
    enable = CanInsertFrame();
    break;

   case IDM_Frame_Delete:
    enable = CanRemoveFrame();
    break;
    
   case IDM_Frame_Split:
    enable = CanSplitFrame();
    break;
    
   case IDM_Frame_Combine:
    enable = CanCombineFrame();
    break;
    
   case IDM_Frame_Align:
    enable = CanAlignFrame();
    break;
  }
  return enable ? MF_ENABLED : MF_GRAYED;
}

// frame menu dispatch
#ifdef BW3_DISPATCH
LRESULT_T
EditPage::DispatchFrameMenu(WORD command, WORD notify_code, HWND hwnd)
#else /* BW3_DISPATCH */
long 
EditPage::DispatchFrameMenu(int command, long lParam)
#endif /* BW3_DISPATCH */
{
  SetCurrent();
  long state = GetFrameMenuState(command);
#ifdef BW3_DISPATCH
  if (MENU_STATE_P(notify_code))
#else /* BW3_DISPATCH */
  IF_MENU_STATE
#endif /* BW3_DISPATCH */
  {
    return state;
  }
  if (state & MF_GRAYED)
  {
    ::MessageBeep(0);
    return 0;
  }
  
  switch (command)
  {
   case IDM_Frame_MakeTable:
    MakeTable();
    break;
    
   case IDM_Frame_Margin:
    SetFrameMargin();
    break;
    
   case IDM_Frame_AlignTop:
    handle_frame_align(AL_vertical_up);
    break;
    
   case IDM_Frame_AlignMiddle:
    handle_frame_align(AL_vertical_center);
    break;
    
   case IDM_Frame_AlignBottom:
    handle_frame_align(AL_vertical_down);
    break;
    
   case IDM_Frame_AlignVerticalAdjust:
    handle_frame_align(AL_vertical_adjust);
    break;
    
   case IDM_Frame_Border:
    SetSelectedBorderLine();
    break;
    
   case IDM_Frame_DefaultBorder:
    SetDefaultFrameBorderLine();
    break;
    
   case IDM_Frame_DefaultTableBorder:
    SetDefaultTableFrameBorderLine();
    break;
    
   case IDM_Frame_Cut:
    Cut();
    break;

   case IDM_Frame_Copy:
    Copy();
    break;
    
   case IDM_Frame_Paste:
    Paste();
    break;
    
   case IDM_Frame_NewFlow:
    NewFlow();
    break;
    
   case IDM_Frame_Fill:
    FillFrame();
    break;
    
   case IDM_Frame_ReadFile:
    ReadFile();
    break;
    
   case IDM_Frame_Insert:
    InsertFrame();
    break;

   case IDM_Frame_Delete:
    RemoveFrame();
    break;
    
   case IDM_Frame_Split:
    SplitFrame();
    break;
    
   case IDM_Frame_Combine:
    CombineFrame();
    break;
    
   case IDM_Frame_Align:
    AlignFrame();
    break;
  }
  
  return 0;
}
