// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: exchange.cpp,v 3.4 2000/05/13 16:28:59 kudou Exp $
// class EditFrame
// t[GfB^̌c[̋Lq

#include "pword.h"
#include "editfram.h"
#include "docwindo.h"
#include "frameown.h"
#include "mcursor.h"
#include "vdisplay.h"

void NEAR 
EditFrame::ExchFlow_LDWN(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  //
  // start fix
  //
  exch.Reset();
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  FrameObject* fo = 0;
  if ((LockLayout(mpos) == 0) || 
      ((fo = FindFrameObjectW(mpos)) == 0)) 
  {
    CancelExchFlow();
    return;
  }
  VectL mpos_vl = WtoLv(mpos);
  Vector mpos_v = WtoIv(mpos);
  exch.SetStart(fo->GetCrossPoint(), mpos_vl, mpos_v);
  RedisplayExchange();
  MouseCursor::ExchangeToOff();
}

void NEAR 
EditFrame::ExchFlow_MV(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  if (exch.IsFixed() == False) 
  {
    //
    // idle
    //
    exch.Reset();
    VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
    if ((LockLayout(mpos) == 0) || 
	(FindFrameObjectW(mpos) == 0)) 
    {
      MouseCursor::ExchangeOff();
    }
    else 
    {
      MouseCursor::Exchange();
    }
  }
  else 
  {
    //
    // move
    //
    VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
    RedisplayExchange();		// vanish
    VectL mpos_vl = WtoLv(mpos);
    exch.SetEndPos(mpos_vl);
    RedisplayExchange();		// draw
    CrossPoint* cp = 0;
    if ((FindLayoutW(mpos) != GetEditLI()) ||
	((cp = FindCrossPointW(mpos)) == 0) ||
	(cp == exch.GetSource())) 
    {
      exch.SetDestination(0);
      MouseCursor::ExchangeToOff();
    }
    else 
    {
      exch.SetDestination(cp);
      MouseCursor::ExchangeFromTo();
    }
  }
}

void NEAR 
EditFrame::ExchFlow_LUP(WPARAM_T wParam, LPARAM_T lParam)
{
  if (exch.IsFixed() == False) 
  {
    CancelExchFlow(False);
    return;
  }
  
  ExchFlow_MV(wParam, lParam);
  
  CrossPoint* cp = exch.GetDestination();
  if (cp == 0) 
  {
    CancelExchFlow();
    return;
  }
  
  RedisplayExchange();		// vanish
  MouseCursor::Exchange();
  edit_ff->ExchangeFrameObject(exch.GetSource(), cp);
  exch.Reset();
  UnforceTouchCaret();
  RedrawWindows();
  SetDirty();
}

// exchange flow mode
void
EditFrame::WndProcExchFlow(DocumentWindow* window, 
			    MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  EditFrame::window = window;
  switch (Msg) 
  {
   case WM_LBUTTONDOWN:
    ExchFlow_LDWN(wParam, lParam);
    break;
    
   case WM_MOUSEMOVE:
    ExchFlow_MV(wParam, lParam);
    break;
    
   case WM_LBUTTONUP:
    ExchFlow_LUP(wParam, lParam);
    break;
    
   case WM_RBUTTONDOWN:
    CancelExchFlow(False);
    break;
  }
}

void 
EditFrame::CancelExchFlow(bool beep)
{
  if (exch.IsFixed()) 
  {
    RedisplayExchange();		// vanish
  }
  MouseCursor::Exchange();
  exch.Reset();
  if (beep) 
  {
    ::MessageBeep(0);
  }
}

// display set-flow object
void 
EditFrame::RedisplayExchange()
{
  HWND hWnd = window->GetHandle();
  HDC hDC = GetDC(hWnd);
  RedisplayExchange(hDC);
  ReleaseDC(hWnd, hDC);
}

// display set-flow object
void 
EditFrame::RedisplayExchange(VDisplay* vdsp)
{
  if (exch.IsFixed()) 
  {
    RedisplayExchange(vdsp->GetDC());
  }
}

// display set-flow object
void 
EditFrame::RedisplayExchange(HDC hDC)
{
  SetROP2(hDC, R2_NOT);
#ifdef _WIN32
  MoveToEx(hDC, ItoWx(exch.GetFromX()), ItoWy(exch.GetFromY()), NULL);
#else /* _WIN32 */
  MoveTo(hDC, ItoWx(exch.GetFromX()), ItoWy(exch.GetFromY()));
#endif /* _WIN32 */
  LineTo(hDC, LtoWx(exch.GetToLX()), LtoWy(exch.GetToLY()));
}
