// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: file.cpp,v 3.10 2000/05/13 16:28:59 kudou Exp $
// file operations on documents

#include "pword.h"
#include <errno.h>
#ifdef _WIN32
#else /* _WIN32 */
#include <dos.h>
#endif /* _WIN32 */
#ifdef __CYGWIN32__
#include <unistd.h>
#endif /* __CYGWIN32__ */
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include "attribut.h"
#include "dialogs.h"
#include "docconte.h"
#include "docprese.h"
#include "document.h"
#include "docwindo.h"
#include "fileutil.h"
#include "interval.h"
#include "marks.h"
#include "mcursor.h"
#include "mwindow.h"
#include "pmenus.h"
#include "pref.h"
#include "pstreams.h"
#include "textflow.h"
#include "textindl.h"
#include "xstr.h"

#if (C_SYSTEM == C_SYSTEM_MSC7)
#define tempnam _tempnam
#endif

void
Document::NewFile()
{
  NewBufSetup();
  StatusOut("");
}


// ------------------------------------------------------------
// HEADERS

const word version = 0x0002;
const int reserved_len = 0x0040;

void
Document::WriteHeader(PStream* stream)
{
  stream->StartBlockOut(PStream::HDR_PWORD, version);
  {
    int len = reserved_len;
    char* reserved = new char[ reserved_len ];
    if (reserved)
    {
      char* res = reserved;
      for (int i=0; i<reserved_len; i++)
      {
	*res++ = '\0';
      }
#ifdef BW3_FILEVERSIONSAVE
      dword* p = (dword*)reserved;
      *p++ = BW_FILE_SAVE_VERSION;
      *p++ = BW_FILE_SAVE_MINER_VERSION;
      *p++ = BW_FILE_SAVE_BETA_VERSION;
      *p++ = BW_FILE_SAVE_MINER_BETA_VERSION;
#endif /* BW3_FILEVERSIONSAVE */
      stream->Out((void*)reserved, len);
      delete reserved;
    }
  }
}

void
Document::ReadHeader(PStream* stream, word& version)
{
  stream->StartTypedBlockIn(PStream::HDR_PWORD, version);
  CHECK;
  
  if (version != ::version)
  {
    stream->SetError(SE_BADVERSION);
    return;
  }
  
  char* reserved = new char[ reserved_len ];
  if (reserved)
  {
    stream->In((void*) reserved, reserved_len);
#ifdef BW3_FILEVERSIONSAVE
    dword* p = (dword*)reserved;
    file_version = *p++;
    file_miner_version = *p++;
    file_beta_version = *p++;
    file_miner_beta_version = *p++;
#endif /* BW3_FILEVERSIONSAVE */
    delete reserved;
  }
}

// ------------------------------------------------------------
// top level file readers and writers

// ReadInFile, ReadInFile0 -- generic file reader.  We don't know
// whether this is an ASCII or pWord file yet -- have to read the
// header to find out.

// private method
void NEAR
Document::ReadInFile0(bool revert)
{
  error = 0;
  
  if (!::CheckFileAccess(path_name, True))
  {
    error = 1;
  }
  
  int handle;
  if (!error)
  {
#ifdef _WIN32
    handle = open(path_name, O_RDONLY | O_BINARY);
#else /* _WIN32 */
    OFSTRUCT open_buff;
    handle = OpenFile(path_name, &open_buff, 
		       OF_READ | OF_SHARE_DENY_WRITE);
#endif /* _WIN32 */
    if (handle == -1)
    {
      ::MessageBeep(0);
      ReportOpenError(path_name);
      error = 1;
    }
  }
  
  FILE* f = 0;
  
  if (!error)
  {
    f = fdopen(handle, "rb");
    if (!f)
    {
      ::MessageBeep(0);
      ReportOpenError(path_name);
      error = 1;
    }
    else
    {
      PStream astream(f, PStream::WW_FILE);
      PStream* stream = &astream;
      stream->InitIn();
      
      if (stream->GetError() == SE_NOERROR) 
      {
	::ShowFileName(name, S_Reading);
	word vers;
	ReadHeader(stream, vers);
	if (stream->GetError() == SE_BADVERSION)
	{
	  this->ReportVersionError(vers);
	  stream->TermIn();
	}
	else 
	{
	  if (stream->GetError() == SE_NOERROR) 
	  {
	    this->ReadFormattedFromStream(stream);
	  }
	  stream->TermIn();
	  if (stream->GetError() != SE_NOERROR)
	  {
	    ReportReadError();
	    error = 1;
	  }
	}
      }
      else
      {
	if (!revert)
	{
	  OpenTextAsBeatWordDialog();
	}
	if (!error)
	{
	  fseek(f, 0, 0); // reset to beginning 
	  {
	    ::ShowFileName(name, S_Reading);
	    
	    BufStream astream(f), *stream=&astream;
	    ReadASCIIFromStream(stream);
	    stream->TermIn();
	    if (stream->GetError() != SE_NOERROR)
	    {
	      ReportReadError();
	      error = 1;
	    }
	    else if (!text_format)
	    {
	      this->SetUntitledName();
	    }
	  }
	}
      } // unblocked file
    }
  } // if !error
  
  if (f)
  {
    fclose(f);
  }
  else if (handle != -1)
  {
#ifdef _WIN32
    close(handle);
#else /* _WIN32 */
    _lclose(handle);
#endif /* _WIN32 */
  }
  StatusOut("");  
}

void
Document::ReadInFile(bool revert)
{
  MouseCursor::StartLongActivity();
  this->ReadInFile0(revert);
  MouseCursor::EndLongActivity();
}

// OpenTextAsBeatWordDialog -- ask the user if he would like to open the
// document as text, a BeatWord document, or cancel.  If he says text, we
// maintain this information and save as text by default next time.
void
Document::OpenTextAsBeatWordDialog()
{
  // Set default type.
  this->crtype = IDD_TextConvert_OneCRasPar;
  
  int result;
  {
    char buf[256];
    {
      wsprintf(buf, S_OpenTextMsg, this->name);
    }
    TextInDialog dlg(buf);
    result = dlg.Go();
  }
  this->error = !result;
  
  if (result)
  {
    // I fixed following line. (konno)
    this->text_format = (result != IDD_TextConvert_AsBW);
    if (!this->text_format)
    {
      TextFormDialog dlg2;
      this->crtype = dlg2.Go();
      this->error = !this->crtype;
    }
  }
  main_window->Update();
  MouseCursor::WMSetCursor();
}

void
Document::ReadInFileUntilMemo() 
{
  MouseCursor::StartLongActivity();
  
#ifdef _WIN32
  int handle = open(path_name, O_RDONLY | O_BINARY);
#else /* _WIN32 */
  OFSTRUCT open_buff;
  int handle = OpenFile(path_name, &open_buff, OF_READ | OF_SHARE_DENY_WRITE);
#endif /* _WIN32 */
  if (handle == -1)
  {
    ReportOpenError(path_name);
    error = 1;
  }
  
  FILE* f = 0;
  if (!error)
  {
    f = fdopen(handle, "rb");
    if (!f)
    {
      ::MessageBeep(0);
      ReportOpenError(path_name);
      error = 1;
    }
    else
    {
      PStream astream(f, PStream::WW_FILE), *stream =&astream;
      stream->InitIn();
      word vers;
      if (stream->GetError() == SE_NOERROR) 
      {
	ReadHeader(stream, vers);
      }
      if (stream->GetError() == SE_NOERROR) 
      {
	this->ReadFormattedUntilMemo(stream);
	stream->TermIn();
      }
      else 
      {
	//MessageBeep(0);
	error = 1;
      }
    }
    if (f != NULL)
    {
      fclose(f);
    }
    else if (handle != -1)
    {
#ifdef _WIN32
      close(handle);
#else
      _lclose(handle);
#endif /* _WIN32 */
    }
  }
  MouseCursor::EndLongActivity();
  ::StatusOut("");
}

void
ReportReadError()
{
  Issue(S_FileReadErrorText, MB_OK | MB_ICONSTOP);
}

void
Document::ReportVersionError(int vers)
{
  IssueVA(S_BadVersionMsg, MB_OK | MB_ICONSTOP, vers);
  error = 1;      
}

void
ReportOpenError(char* path_name, bool save)
{
  ::MessageBeep(0);
  IssueVA(save ? S_SaveErrorMsg : S_OpenErrorMsg,
	   MB_ICONEXCLAMATION | MB_OK, path_name);
}

void
ShowFileName(char* name,  char* str)
{
  char buf[ MAX_PATH+64 ];
  wsprintf(buf, str, name);
  StatusOutPermanent(buf);
}

bool
CheckFileAccess(char* path_name, bool can_continue)
{
  bool result = True;
  if (::access(path_name, 0x02 /* write permission */) == -1)
  {
    if (errno == EACCES)
    {
      int res = IssueVA(S_ReadOnlyMsg,
			 (can_continue ? (MB_OKCANCEL | MB_ICONEXCLAMATION)
			  : (MB_OK | MB_ICONEXCLAMATION)),
			 FileUtil::GetFileNameOnly(path_name));
      result = can_continue ? (res==IDOK) : False;
      MouseCursor::WMSetCursor();
    }
  }
  return result;
}

// WriteOutFile, WriteOutFile0 -- write out either pWord or text
// formatted file

// private method
void NEAR
Document::WriteOutFile0()
{
  error = 0;
  assert(*path_name);
  
  if (!::CheckFileAccess(path_name, False))
  {
    error = 1;
    return;
  }
  
  ShowFileName(name, S_Writing);
  
  bool text_format = this->text_format;
  
  char* tmp = new char[MAX_PATH + 1];
  
  FileUtil::GetPathNameOnly(tmp, path_name);
#ifdef __BORLANDC__
  // remove it, ok ?
  _fmode = O_BINARY;
#endif
  
  FILE* f;
  
#ifdef __BORLANDC__
  int handle;
  if ((handle = creattemp(tmp, 0)) < 0)
  {
    ::MessageBeep(0);
    ReportOpenError(path_name, True);
    error = 1;
  }
  else if ((f = fdopen(handle, "wb")) == NULL)
  {
    ::MessageBeep(0);
    ReportOpenError(path_name, True);
    error = 1;
    _lclose(handle);
  }
#else
  // hack: Remove environment variable named `TMP' to create exact
  // temporary path name.  (konno)
  while (getenv("TMP") != NULL)
  {
    putenv("TMP=");
  }
  
  char* new_tmp = tempnam(tmp, "bw");
  delete tmp;
  tmp = new_tmp;
  if (tmp == NULL)
  {
    ::MessageBeep(0);
    ReportOpenError(path_name, True);
    error = 1;
  }
  else if ((f = fopen(tmp, "wb")) == NULL)
  {
    ::MessageBeep(0);
    ReportOpenError(path_name, True);
    error = 1;
  }
#endif
  else
  {
    StreamError err;
    if (text_format)
    {
      BufStream stream(f);
      this->WriteASCIIToStream(&stream);
      stream.TermOut();
      err = stream.GetError();
    }
    else
    {
      PStream stream(f, PStream::WW_FILE);
      stream.InitOut();
      this->WriteFormattedToStream(&stream);
      err = stream.GetError();
      stream.TermOut();
    }
    fclose(f);
    
    char* error_message = 0;
    char* error_file = this->path_name;
    
    if (err != SE_NOERROR)
    {
      remove(tmp);
      error_message = S_FileWriteErrorMsg;
    }
    else
    {
      // rename the current file to a temporary name
      char* tmp2 = new char [MAX_PATH + 1];
      copy_string(tmp2, path_name, MAX_PATH);
      FileUtil::ChangeExtension(tmp2, S_BackupExtension);
      remove(tmp2);
      
      // make a backup copy
      int rename_result = rename(path_name, tmp2);
      if ((rename_result != 0) && (errno != ENOENT))
      {
	error_message = S_CantMakeBackupMsg;
	remove(path_name);
      }
      
      if (rename(tmp, path_name))
      {
	error_message = S_FileRenameErrorMsg;
	error_file = tmp;
      }
      else
      {
	if (!Pref_make_backup)
	{
	  remove(tmp2);
	}
      }
      delete tmp2;
    }
    
    if (error_message)
    {
      IssueVA(error_message, MB_OK | MB_ICONSTOP, error_file);
      this->error = 1;
    }
  }
  StatusOut("");
#ifdef __BORLANDC__
  delete tmp;
#else
  if (tmp != NULL)
  {
    free(tmp);
  }
#endif
}

void
Document::WriteOutFile()
{
  if (!this->error)
  {
    MouseCursor::StartLongActivity();
    this->WriteOutFile0();
    MouseCursor::EndLongActivity();
  }
}

// reading and writing pWord formatted files
void
Document::ReadFormattedFromStream(PStream* stream) 
{
  ::StartAttributeImport();
  {
    content.ReadFormattedFromStream(stream);
    CHECK;
    presentation.ReadFormattedFromStream(stream);
    CHECK;
  }
  ::EndAttributeImport();
}

void
Document::ReadFormattedUntilMemo(PStream* stream) 
{
  content.ReadFormattedUntilMemo(stream);
}

void
Document::WriteFormattedToStream(PStream* stream)
{
  ::StartAttributeExport();
  {
    WriteHeader(stream);
    CHECK;
    content.WriteFormattedToStream(stream);
    CHECK;
    presentation.WriteFormattedToStream(stream);
    CHECK;
    stream->EndBlockOut(); // pword block
  }
  ::EndAttributeExport();
}

// reading and writing ASCII files

void
Document::ReadASCIIFromStream(BufStream* stream)
{
  content.DefaultFrameSetup();
  content.ReadASCIIFromStream(stream, crtype);
}

void
Document::WriteASCIIToStream(BufStream* stream)
{
  content.WriteASCIIToStream(stream);
}
