// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: filedlg.cpp,v 3.12 2000/05/13 16:29:00 kudou Exp $
// Superclass for classes to get a filename from a dialog box

#include "pword.h"
#include "pwordpre.h"
#include <stdlib.h>
#ifndef __CYGWIN32__
#include <direct.h>
#endif /* __CYGWIN32__ */
#include <malloc.h>
#include <ctype.h>
#ifndef BW3_FILEDLG
#include <sys/types.h>
#include <sys/stat.h>
#endif /* BW3_FILEDLG */
#include "fileutil.h"
#include "dialogs.h"
#include "sjis.h"
#include "pref.h"
#include "xstr.h"
#include "filedlg.h"

#ifdef __CYGWIN32__
// cygwin commdlg.h doesn't have OFN_ENABLESIZING
#define OFN_ENABLESIZING	0x00800000
#endif /* __CYGWIN32__ */

#ifdef BW3_FILEDLG

FileDialog::FileDialog (char* ini_file_name, char* _filter_str)
 : filter_str(_filter_str),
   title_str(0)
{
  multiple_file_p = false;
  strncpy (file_name, ini_file_name, sizeof(file_name));
}

bool
FileDialog::Go (bool save)
{
  OPENFILENAME ofn;
  memset (&ofn, 0, sizeof (OPENFILENAME));
  ofn.lStructSize = sizeof (OPENFILENAME);
  ofn.hwndOwner = main_window_handle;
  ofn.hInstance = PWordPresentation::hInstance;
  ofn.lpstrFilter = filter_str;
  ofn.nFilterIndex = 1;
  ofn.lpstrFile = file_name;
  ofn.nMaxFile = sizeof (file_name);
  ofn.lpstrTitle = title_str;
  ofn.lpstrInitialDir = Pref_document_directory;
  if (multiple_file_p)
  {
    ofn.Flags = (OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_ENABLESIZING |
		 OFN_ALLOWMULTISELECT);
  }
  else
  {
    ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_ENABLESIZING;
  }
  if (save)
  {
    ofn.Flags |= OFN_OVERWRITEPROMPT;
    OpenfilenameSetupHook(ofn);
    return ::GetSaveFileName (&ofn) != 0;
  }
  else
  {
    OpenfilenameSetupHook(ofn);
    return ::GetOpenFileName (&ofn) != 0;
  }
}

void
FileDialog::OpenfilenameSetupHook(OPENFILENAME& ofn)
{
  // do nothing
}

bool
FileDialog::AddExtention(char* path, size_t path_buf_size, char* ext)
{
  char* basename = path;
  char* p;
  for (p = basename; *p; p = ::AnsiNext(p))
  {
    if (*p == '\\')	// path delimitter char
    {
      basename = p + 1;
    }
  }
  char* ext_p = 0;
  for (p = basename; *p ; p = ::AnsiNext(p))
  {
    if (*p == '.')
    {
      ext_p = p;
    }
  }
  if (!ext_p)
  {
    // add .bw extention
    size_t l = strlen(path);
    size_t ext_l = strlen(ext);
    if (l + ext_l + 1 < path_buf_size)
    {
      p = path + l;
      while (*ext)
      {
	*p++ = *ext++;
      }
      *p = '\0';
    }
    return true;
  }
  return false;
}

char*
FileDialog::GetResult()
{
  char* bw_ext = S_WildCard + 1;
  AddExtention(file_name, MAX_PATH + 1, bw_ext);
  return file_name;
}

#else /* BW3_FILEDLG */

void
FileDialog::FileList(char* WildCards, int ListBox)
{
  char Name[MAX_PATH + 1],* x;

  SendItemMessage(ListBox, WM_SETREDRAW);
  SendItemMessage(ListBox, LB_RESETCONTENT);

  while (*WildCards)
  {
    while (*WildCards == ' ') {
      WildCards++;
    }

    for (x = Name; *WildCards != 0 && *WildCards != ' ';) {
      *x++ = *WildCards++;
    }

    *x = 0;

    SendItemMessage(ListBox, LB_DIR, 0, Ptr2Long(Name));
  }
  
  SendItemMessage(ListBox, WM_SETREDRAW, 1);
  
  ::InvalidateRect(GetItem(ListBox), NULL, 1);
}

void
FileDialog::Update()
{
  GetItemText(ID_FILENAME, current_name, MAX_PATH);
	  
  char* first_char = 0;
  {
    char char1 = 0, char2 = 0;
    // the incredibly stupid design of DlgDirList 
    // requires a wild card or it won't
    // do anything at all.  We have to fool it.
    if (!FileUtil::IsWild(current_name)) {
      first_char = FileUtil::GetFileNameOnly(current_name);
      if (first_char && *first_char)
      {
	char1 = *first_char;
	if (iskanji(*first_char)) {
	  char2 = *(first_char+1);
	  *(first_char+1) = '?';
	}
	else 
	{
	  char1 = toupper(char1);
	}
	*first_char = '?';
      }
      else
      {
	strcat(current_name, S_AllWildCard);
      }
    }
    
    // this thing does all sorts of wizardry we didn't really want it to.
    // look it up in the manual.
    int dirlist_result = ::DlgDirList(this->GetHandle(),
				       current_name,
				       ID_DIRS,
				       ID_PATH,
				       (0x8000 /*excl*/
					| 0x4000 /*drives*/
					| 0x0010 /*dirs*/));
    
    // if that didn't work maybe the current drive is unreadable.  list
    // drives only
    if (!dirlist_result)
    {
      dirlist_result = ::DlgDirList(this->GetHandle(),
				     current_name,
				     ID_DIRS,
				     ID_PATH,
				     0x8000 /*excl*/ | 0x4000 /*drives*/);
    }

    if (!dirlist_result)
    {
      MessageBeep(0);
    }

    else if (first_char)
    {
      first_char = current_name; // dirlist changes current_name; the
      				 // filename is now at the beginning
    }
    if (first_char)
    {
      *first_char = char1;
      if (char2) *(first_char+1) = char2 ;
      AnsiUpper(current_name);
    }
  }
  
  FileList(FileUtil::GetFileNameOnly(current_name), ID_FILES);
  SetItemText(ID_FILENAME, FileUtil::GetFileNameOnly(current_name));
}

void
FileDialog::SelectFile()
{
  GetItemText(ID_FILENAME, current_name, MAX_PATH);
  int len = strlen(current_name);

  if (len <= 0)
  {
    strcpy(current_name, wildcard_spec);
  }
  
  // see if the thing is a directory.  Windows is too stupid to do this.

  else if (!FileUtil::IsWild(current_name))
  {
    struct stat statbuf;
    
    char work [MAX_PATH+1];
    FileUtil::GetDir(work);
    FileUtil::ConcatPathAndFileName(work, current_name);
    if (::stat(work, &statbuf) == 0 /*success*/)
    {
      if ((statbuf.st_mode & S_IFMT) == S_IFDIR)
      {
	char* last = current_name + strlen(current_name) - 1;
	if ((*last != '\\') && (*last != '/'))
	{
	  *++last = '\\';
	  *++last = '\0';
	  SetItemText(ID_FILENAME, current_name);
	  Update();
	  return;
	}
      }
    }
  }
  
  if ((!FileUtil::IsFileName(current_name)) || (!Select())) 
  {
    Update();
  }
  else
  {
    // Dave, this doesn't work at all.  
    // 'Cuz Windows sometimes puts an ellipsis in the
    // middle of a long path!!
    // GetItemText(ID_PATH, result_name, MAX_PATH);
    FileUtil::GetDir(result_name);
    FileUtil::ConcatPathAndFileName(result_name, current_name);
    
    // eat last '.'
    char* last = result_name + strlen(result_name) - 1;
    if ((last != result_name) &&
        (*last == '.'))
    {
      *last = '\0';
    }
    
    AddString(result_name);
    End(1);
  }
}

// private method
void NEAR
FileDialog::set_wild_card(char* s)
{
  SetItemText(ID_FILENAME, s);
  this->Update();
}

LRESULT_T
FileDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  char PathName[MAX_PATH + 1];

  switch (Msg)
  {
   case WM_INITDIALOG:
    LoadStrings();
    SendItemMessage(ID_FILENAME, EM_LIMITTEXT, MAX_PATH - 1);

    strcpy(wildcard_spec, FileUtil::GetFileNameOnly(initial_name));
    SetItemText(ID_FILENAME, initial_name);
    GetItemText(ID_FILENAME, current_name, MAX_PATH);
    Update();

    return 1;

   case WM_COMMAND:
    GetItemText(ID_FILENAME, current_name, MAX_PATH);
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case ID_FILE_STAR_STAR:
      this->set_wild_card(S_AllWildCard);
      break;
      
     case ID_FILE_STAR_BW:
      if (ReadPicP())
      {
	this->set_wild_card(S_BmpWildCard);
      }
      else
      {
	this->set_wild_card(S_WildCard);
      }
      break;
      
     case ID_FILENAME:
      // Enable the OK button if the edit control has text.
      EnableWindow(GetItem(IDOK), current_name[ 0 ]);
      break;

     case ID_FILES:
      // The files listbox. If file selection has changed, 
      // fill the new filename into the property list buffer 
      // and set text in the edit control.

#ifdef _WIN32
      switch (HIWORD(wParam))
#else /* _WIN32 */
      switch (HIWORD(lParam))
#endif /* _WIN32 */
      {
       case LBN_KILLFOCUS:
	SendItemMessage(ID_FILES, LB_SETCURSEL, -1);
	break;

       case LBN_SELCHANGE:
#ifdef _WIN32
	::DlgDirSelectEx(this->GetHandle(), current_name, sizeof(current_name), ID_FILES);
#else /* _WIN32 */
	::DlgDirSelect(this->GetHandle(), current_name, ID_FILES);
#endif /* _WIN32 */
	// dir select leaves a period on the end of filenames with no
	// extension!!
	{
	  int len = strlen(current_name);
	  if (0 < --len && current_name[len] == '.')
	  {
	    current_name[len] = '\0';
	  }
	}
	EnableWindow(GetItem(IDOK), current_name[ 0 ]);
	SetItemText(ID_FILENAME, current_name);
	break;

       case LBN_DBLCLK:
	SelectFile();
      }
      break;

     case ID_DIRS:
      // The directories listbox. Append current filename in edit control
      // (stripped of the path prefix) to the name from the property list
      // and set the new string in the edit control.

#ifdef _WIN32
      switch (HIWORD(wParam))
#else /* _WIN32 */
      switch (HIWORD(lParam))
#endif /* _WIN32 */      
      {
       case LBN_SELCHANGE:
	// see what's in the file name field, and get the file name
	GetItemText(ID_FILENAME, current_name, MAX_PATH);
	{
	  char* p = FileUtil::GetFileNameOnly(current_name);
	  // if no file name, add wild card
	  if (p == NULL)
	  {
	    p = wildcard_spec;
	  }
	  char* q = current_name;
	  while ((*q++ = *p++) != '\0')
	  {
	  }
	}
#ifdef _WIN32
	::DlgDirSelectEx(this->GetHandle(), PathName, sizeof(PathName), ID_DIRS);
#else /* _WIN32 */
	::DlgDirSelect(this->GetHandle(), PathName, ID_DIRS);
#endif /* _WIN32 */
	strcat(PathName, current_name);
	SetItemText(ID_FILENAME, PathName);
	EnableWindow(GetItem(IDOK), PathName[ 0 ]);
	break;

       case LBN_KILLFOCUS:
	SendItemMessage(ID_DIRS, LB_SETCURSEL, -1);
	break;

       case LBN_DBLCLK:
	SelectFile();
      }
      break;

     case IDOK:
      if (FileUtil::IsWild(current_name))  {
	strcpy(wildcard_spec, FileUtil::GetFileNameOnly(current_name));
      }
      SelectFile();
      break;

     case IDCANCEL:
      End(0);
      return(1);
      
     default:
      break;
    }
    break;

   case WM_CLOSE:
    End(0);
    return(1);

   default:
    break;
  }

  return 0;
}

void
FileDialog::Init(bool read_pic)
{
  read_pic_p = read_pic;
}

FileDialog::FileDialog(char* _initial_name, bool read_pic)
  : initial_name(_initial_name)
{
  Init(read_pic);
}

FileDialog::FileDialog()
{
  Init();
}

void
FileDialog::SetInitialName(char* _name)
{
  initial_name = _name;
}

char*
FileDialog::GetResult()
{
  ::AnsiUpper(result_name);
  ::AnsiToOem(result_name, result_name);
  return result_name;
}

void
FileDialog::AddString(char* string)
{
  ::AnsiUpper(string);
  if (ReadPicP())
  {
    Pref_picture_file_string10.add_string(string);
  }
  else
  {
    Pref_file_string10.add_string(string);
  }
}

void
FileDialog::LoadStrings()
{
  SendItemMessage(ID_FILENAME, CB_RESETCONTENT);
  if (ReadPicP())
  {
    Pref::set_item_string10(this->GetHandle(),
			     ID_FILENAME, &Pref_picture_file_string10);
  }
  else
  {
    Pref::set_item_string10(this->GetHandle(),
			     ID_FILENAME, &Pref_file_string10);
  }
}

#endif /* BW3_FILEDLG */
