// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: filedlg.h,v 3.7 2000/05/04 13:44:05 kudou Exp $
// Define a "class" for handling file dialog boxes, for opening
// and saving files.

#ifndef FILEDIALOG_H
#define FILEDIALOG_H

#include "dlg.h"

#ifdef BW3_FILEDLG
class FileDialog
{
  char file_name [MAX_PATH + 1];
  char* filter_str;
  char* title_str;
  bool multiple_file_p;
protected:
  void SetTitleString(char* _title_str) { title_str = _title_str; }
  virtual void OpenfilenameSetupHook(OPENFILENAME& ofn);
  char* GetFileName() { return file_name; }
public:
  FileDialog (char* ini_file_name, char* filter_str);
  bool Go (bool save = false);
  char* GetResult();
  void SetMultipleFileP(bool p) { multiple_file_p = p; }
  static bool AddExtention(char* path, size_t path_buf_size, char* ext);
};

#else /* BW3_FILEDLG */
class FileDialog
  : public PModalDialog
{
private:
  // picture file read
  bool read_pic_p;
  
protected:
  char current_name[MAX_PATH + 1];
  char result_name[MAX_PATH + 1];

private:
  // name passed by user
  char* initial_name;
  char wildcard_spec[MAX_PATH + 1];

  // internal routines
  void FileList(char* WildCards, int ListBox);
  void SelectFile();

  // current mechanism by which subclasses distinguish themselves ^^
  // behavior right before a filename is to be confirmed

  virtual int Select() = 0;
  void Update();
  void NEAR set_wild_card(char* s);
  void Init(bool read_pic = False);
  
public:
  FileDialog(char* _initial_name, bool read_pic_p = False);
  FileDialog();
  void SetInitialName(char*);

  char* GetResult();
  LRESULT_T WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);
  
  // Add a recent file name to the list.  This is called both when
  // a file is selected to be opened, and when "saved as"
  void AddString(char* string);
  
  // Place the recent filenames into the list box in the dialog
  void LoadStrings();
  
protected:
  bool ReadPicP() { return read_pic_p; }
};
#endif /* BW3_FILEDLG */

#endif /* FILEDIALOG_H */
