// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: fissioni.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Fission iterators
// class HFissionIterator
// class VFissionIterator
// class FissionIterator
// class RectRgnFissionIterator
// class RectRgnVFissionIterator
// class RectRgnHFissionIterator

#ifndef FISSIONI_H
#define FISSIONI_H

#include "fission.h"

class CrossPoint;
class Fission;
class VFission;
class HFission;

// ------------------------------------------------------------
// horizontal fission iterator, for internal use

class HFissionIterator 
{
  // fission
  HFission* f;
  
  // current crosspoint
  CrossPoint* cp;
  
  // end fission
  VFission* end;
  
  // end position
  Iunit y;
  
private:
  // get downward trace point
  CrossPoint* DownWard();
  
  // get rightward trace point
  CrossPoint* RightWard();
  
public:
  // constructor
  HFissionIterator(HFission* f);
  
  // iterator
  VFission* operator() ();
};

// ------------------------------------------------------------
// vertical fission iterator, for internal use

class VFissionIterator
{
  // fission
  VFission* f;
  
  // current crosspoint
  CrossPoint* cp;
  
  // end fission
  HFission* end;
  
  // position
  Iunit x;
  
private:
  // get downward trace point
  CrossPoint* DownWard();
  
  // get rightward trace point
  CrossPoint* RightWard();
  
public:
  // constructor
  VFissionIterator(VFission* f);
  
  // iterator
  HFission* operator() ();
};

// ------------------------------------------------------------
// fission iterator, iterate all descendant

class FissionIterator
{
private:
  // current fisison
  Fission* f;
  
public:
  // constructor
  FissionIterator(FissionFrame* ff);
  
  // iterator
  Fission* operator() ();
};

inline 
FissionIterator::FissionIterator(FissionFrame* ff)
{
  f = ff->GetFirstFission();
}

inline 
Fission* FissionIterator::operator() ()
{
  Fission* ret = f;
  if (ret != 0) 
  {
    f = f->GetNext();
  }
  return ret;
}

// ------------------------------------------------------------
// fission iterator, iterate frame-rect-region internal fission

class RectRgnFissionIterator
  : private FissionIterator
{
protected:
  FrameRectRgn rgn;
  Iunit x1;
  Iunit x2;
  Iunit y1;
  Iunit y2;

protected:
  Fission* GetNext() 
  {
    return FissionIterator::operator() ();
  }
  
public:
  RectRgnFissionIterator(FrameRectRgn& rgn);
  Fission* operator() ();
};

class RectRgnVFissionIterator
  : private RectRgnFissionIterator
{
public:
  RectRgnVFissionIterator(FrameRectRgn& rgn)
  : RectRgnFissionIterator(rgn) { ; }
  
  VFission* operator() ();
};

class RectRgnHFissionIterator
  : private RectRgnFissionIterator
{
public:
  RectRgnHFissionIterator(FrameRectRgn& rgn)
  : RectRgnFissionIterator(rgn) { ; }
  
  HFission* operator() ();
};

#endif /* FISSIONI_H */
