// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: foiterat.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class CPIterator     : crosspoint iterator
// class CellCPIterator : cell crosspoint iterator
// class FOIterator     : frame object iterator

#include "pword.h"
#include "fission.h"
#include "fissioni.h"
#include "foiterat.h"

// ------------------------------------------------------------
// cross point iterator

// constructor
CPIterator::CPIterator(FissionFrame* ff)
  : fi(ff)
{
  f = 0;
  cp = 0;
}

// destructor
CPIterator::~CPIterator()
{
  // do nothing. this function is important for program size
}

// iterator
CrossPoint*
CPIterator::operator() ()
{
  if ((f == 0) && (cp == 0)) 
  {
    cp = NextFission();
  }
  else 
  {
    cp = cp->GetHNext();
    if (cp == 0) 
    {
      cp = NextFission();
    }
  }
  return cp;
}

// next fission
CrossPoint*
CPIterator::NextFission()
{
  do 
  {
    f = fi();
    if (f == 0) 
    {
      return 0;
    }
  } while (f->GetDir() == Fission::Vertical);
  return f->GetStartCrossPoint();
}

// ------------------------------------------------------------
// cell crosspoint iterator

// constructor
CellCPIterator::CellCPIterator(FissionFrame* ff)
  : CPIterator(ff)
{
  ;
}

// destructor
CellCPIterator::~CellCPIterator()
{
  // do nothing. this function is important for program size
}

// iterator
CrossPoint*
CellCPIterator::operator() ()
{
  CrossPoint* cp = 0;
  do 
  {
    cp = CPIterator::operator() ();
    if (cp == 0) 
    {
      return 0;
    }
  } while (cp->HaveCell() == False);
  return cp;
}

// ------------------------------------------------------------
// frame object iterator

// constructor
FOIterator::FOIterator(FissionFrame* ff)
  : CellCPIterator(ff)
{
  ;
}

// desutructor
FOIterator::~FOIterator()
{
  // do nothing. this function is important for program size
}

// iterator
FrameObject*
FOIterator::operator() ()
{
  FrameObject* fo = 0;
  do 
  {
    CrossPoint* cp = CellCPIterator::operator() ();
    if (cp == 0) 
    {
      return 0;
    }
    fo = cp->GetFrameObject();
  } while (fo == 0);
  return fo;
}
