// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: foiterat.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class CPIterator     ; crosspoint iterator
// class CellCPIterator : cell crosspoint iterator
// class FOIterator     : frame object iterator

#ifndef FOITERAT_H
#define FOITERAT_H

#include "fissioni.h"

class FissionFrame;	// forword ref.
class Fission;		// forword ref.
class CrossPoint;	// forword ref.
class FrameObject;	// forword ref.

// cross point iterator
class CPIterator
{
  // fission iterator
  FissionIterator fi;
  
  // current iterate fission
  Fission* f;
  
  // current iterate cross-point
  CrossPoint* cp;
  
private:
  // next fission
  CrossPoint* NextFission();
  
public:
  // constructor
  CPIterator(FissionFrame* ff);
  
  // destructor
  ~CPIterator();
  
  // iterator
  CrossPoint* operator() ();
};

// cell crosspoint iterator
class CellCPIterator
  : private CPIterator
{
public:
  // constructor
  CellCPIterator(FissionFrame* ff);
  
  // destructor
  ~CellCPIterator();
  
  // iterator
  CrossPoint* operator() ();
};

// frame object iterator
class FOIterator
  : private CellCPIterator
{
public:
  // constructor
  FOIterator(FissionFrame* ff);
  
  // desutructor
  ~FOIterator();
  
  // iterator
  FrameObject* operator() ();
};

#endif /* FOITERAT_H */
