// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: fonts.h,v 3.3 2000/05/04 13:44:05 kudou Exp $
// define FontTable and FontEntry classes to hold font information

#ifndef FONTS_H
#define FONTS_H

#include "generics.h"

class FontEntry
  : public DeadableEntry
{
  friend class BaseFontTable;
  friend class FontTable;
  
private:
#ifdef _WIN32
  DWORD font_type;
#else /* _WIN32 */
  short font_type;
#endif /* _WIN32 */
  LOGFONT logfont;
  // BW2 new spec. Values are:
  // NO_VIRTUAL_FONT, VIRTUAL_MINCHO_FONT, VIRTUAL_GOTHIC_FONT.
  char virtual_font_type;
  
public:
  FontEntry();
#ifdef _WIN32
  FontEntry(LPLOGFONT logfont, DWORD font_type);
#else /* _WIN32 */
  FontEntry(LPLOGFONT logfont, short font_type);
#endif /* _WIN32 */
  FontEntry(FontEntry& e, int virtual_font_type);
  
private:
  unsigned char NEAR GetHash();
  void SetDead();
public:
  LOGFONT& GetLOGFONT();
  friend int operator == (const FontEntry& fte1, const FontEntry& fte2);
  int IsShiftJISFont();
#ifdef _WIN32
  DWORD GetFontType();
#else /* _WIN32 */
  short GetFontType();
#endif /* _WIN32 */
  unsigned int Enter();
  void AddToInterface(unsigned int i, void*);
  void ReadFromStream(PStream*);
  void RemoveFromInterface(unsigned int i);
  void RemoveIfUnmarked(unsigned int, void*);
  void WriteToStream(PStream*);
#ifndef NDEBUG
  void Dump(unsigned int i, void*);
  static void DumpHeader(FILE* f);
#endif
  
};

inline LOGFONT&
FontEntry::GetLOGFONT()
{
  return(this->logfont);
}

#ifdef _WIN32
inline DWORD
FontEntry::GetFontType()
#else /* _WIN32 */
inline short
FontEntry::GetFontType()
#endif /* _WIN32 */
{
  return(this->font_type);
}

inline int
FontEntry::IsShiftJISFont()
{
  return(this->logfont.lfCharSet == SHIFTJIS_CHARSET);
}

#define T FontEntry
#define TABLE BaseFontTable
#define SEG BaseFontTableSeg
#define DEADABLE_ENTRY
#define DO_READ_WRITE
#include "tabletem.h"

class FontTable
  : public BaseFontTable
{
#ifdef _WIN32
  friend int FAR PASCAL EnumAllFaces_(LPLOGFONT lplf, LPTEXTMETRIC lptm, DWORD nFontType, LPARAM lp);
#else /* _WIN32 */
  friend int FAR PASCAL EnumAllFaces_(LPLOGFONT lplf, LPTEXTMETRIC lptm, short nFontType, FontTable* lpef);
#endif /* _WIN32 */

  
private:
  FontEntry* table;
  
public:
  short ansi_default;
  short kanji_default;
  
public:
  FontTable();
  
public:
  void Fill(HDC dc);
  void RemoveUnmarkedEntries();
  
public:
  static void register_static_menus();
};

extern FontTable STATIC_NEAR GlobalFontTable;

#ifdef _WIN32
int CALLBACK EnumAllFaces(LPLOGFONT lplf, LPTEXTMETRIC lptm, DWORD nFontType, LPARAM lp);
#else /* _WIN32 */
int FAR PASCAL _export EnumAllFaces(LPLOGFONT lplf, LPTEXTMETRIC lptm, short nFontType, FontTable* lpef);
#endif /* _WIN32 */

#endif /* FONTS_H */
