// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: frameins.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// FrameInstance class
// A FrameInstance is an element of both a TextFlow and a LayoutInstance.
// It defines a specific place in the conceptual and formatted document
// where the two concepts codefine each other's objects.

#ifndef FRAMEINS_H
#define FRAMEINS_H

// for inline functions
#include "frametem.h"
#include "line.h"

class FrameInstance
{
private:
  // in text-flow's sequence.
  FrameInstance* prev_tfi;
  FrameInstance* next_tfi;
  
  // in layout sequence, single thread.
  FrameInstance* next_lfi;
  
  // frame template
  FrameTemplate* ft;
  
  // which layout instance belongs to
  LayoutInstance* layout_instance;
  
  // dual linked line
  Line* lines;
  
  // `first_bp' points to first character in frame.
  BufferPointer* first_bp;
  
  // `next_bp' points to next character of filled frame.
  BufferPointer* next_bp;
  
  // `next_shadow_bp' points to next character of maximum filled frame.
  BufferPointer* next_shadow_bp;
  
  // Killed flag for vanishing layout-instance
  // When this flag set, it meens this frame-instance is alredy
  // unlinked from text-flow pipe. So destructor don't have to
  // manage the text-flow pipe.
  int broken_pipe : 1;
  
  // some bit-fielded flags for formatter, and visible control
  int virginp : 1;
  int format_needed_p : 1;
  int maybe_format_needed_p : 1;
  int prev_end_of_text_p : 1;
  int end_of_text_p : 1;
  int has_page_no_p : 1;
  
  int primary_background : 1;
  int secondary_background : 1;
  
private:
  // common initializer, called from constructor only
  void InitializeForConstructor(FrameTemplate* ft, LayoutInstance* li);
  
public:
  // constructor(insert after)
  // ft	: frame-template
  // prev	: previous frame-instance
  // li	: layout-instance
  FrameInstance(FrameTemplate* ft, FrameInstance* prev, LayoutInstance* li);
  
  // constructor(insert befor)
  // ft	: frame-template
  // li	: layout-instance
  // next	: next frame-instance
  FrameInstance(FrameTemplate* ft, LayoutInstance* li, FrameInstance* next);
  
  // destructor
  ~FrameInstance();
  
  // get prev frame-instance on it's text-flow pipe
  FrameInstance* GetPrevTextFrame();
  
  // get next frame-instance on it's text-flow pipe
  FrameInstance* GetNextTextFrame();
  
  FrameInstance* GetFirstFrame();
  FrameInstance* GetTopLevelFirstFrame();
  
  // rebind text-flow link
  void RebindLink(FrameInstance* next);
  
  // which flow ?
  TextFlow* GetAssignedTextFlow();
  TextFlow* GetFastTextFlow();
  
  // simple name method, ok ? > kudou
  TextFlow* 
  GetTextFlow()
  {
    return(this->GetAssignedTextFlow());
  }
  
  // layout sequence
  FrameInstance* GetNextLFI() 
  {
    return next_lfi;
  }
  
  // get frame-template
  FrameTemplate* GetFrameTemplate() 
  {
    return ft;
  }
  
  FrameTemplate* GetTemplate() 
  {
    return(this->GetFrameTemplate());
  }
  
  // get layout-instance
  LayoutInstance* GetLayoutInstance() 
  {
    return layout_instance;
  }
  
  LayoutInstance* GetLayout() 
  {
    return layout_instance;
  }
  
  bool EraseableFrameP();

  // ------------------------------
  // frame dimension interface
#ifdef __LAYOUT_FRAMETEMPLATE_H
  
  // get x position
  Iunit GetCX() 
  {
    return ft->GetCX();
  }
  
  // get y position
  Iunit GetCY() 
  {
    return ft->GetCY();
  }
  
  // get width
  Iunit GetWidth() 
  {
    return ft->GetWidth();
  }
  
  // get height
  Iunit GetHeight() 
  {
    return ft->GetHeight();
  }
#endif

  // ------------------------------
  // for frame editor

  // set prev text-flow frame instance
  void SetPrevTFI(FrameInstance* prev) 
  {
    prev_tfi = prev;
  }
  
  // set and get next text-flow frame instance
  void SetNextTFI(FrameInstance* next) 
  {
    next_tfi = next;
  }
  
  FrameInstance* GetNextTFI() 
  {
    return(next_tfi);
  }
  
  // Break pipe, once this method is called, this frame-instance
  // is no more active.
  // There are no any methods to reset break pipe.
  void BreakPipe() 
  {
    broken_pipe = True;
  }
  
public:
  // This method returns True, when this frame is the first frame
  // on page in it's text-flow.
  bool
  PageAlignedP();
  
  Iunit
  GetTopMargin();
  
  Iunit
  GetBottomMargin();
  
  Iunit
  GetLeftMargin();
  
  Iunit
  GetRightMargin();
  
  // ------------------------------
  // formatter's methods

private:
  void NEAR Format0(bool do_invalidate);
  void NEAR Format1(bool do_invalidate);
  
public:
  
  FrameInstance* EnsureNextTFI();
  
  bool
  FormatNeededP()
  {
    return format_needed_p != 0;
  }
  
  bool
  MaybeFormatNeededP()
  {
    return maybe_format_needed_p != 0;
  }
  
  bool
  EndOfTextP()
  {
    return end_of_text_p != 0;
  }
  
  bool
  VirginP()
  {
    return virginp != 0;
  }
  
  void
  SetVirginP(bool virginp)
  {
    this->virginp = virginp;
  }
  
  bool
  HasPageNoP()
  {
    return has_page_no_p != 0;
  }
  
  bool
  PrimaryBackgroundP()
  {
    return primary_background != 0;
  }
  
  void
  SetPrimaryBackground(bool p)
  {
    this->primary_background = p;
  }
  
  bool
  SecondaryBackgroundP()
  {
    return secondary_background != 0;
  }
  
  void
  SetSecondaryBackground(bool p)
  {
    this->secondary_background = p;
  }
  
  // This method returns `Nil' line.
  Line* 
  GetLines()
  {
    return(this->lines);
  }
  
  BufferPointer* 
  GetFirstBP()
  {
    return(this->first_bp);
  }
  
  BufferPointer* 
  GetNextBP()
  {
    return(this->next_bp);
  }
  
  BufferPointer* 
  GetNextShadowBP()
  {
    return(this->next_shadow_bp);
  }
  
  // sorted
  Iunit ix_to_line_unit(Iunit ix);
  Iunit iy_to_line_unit(Iunit iy);
  Iunit line_x_to_iunit(Iunit x);
  Iunit line_y_to_iunit(Iunit y);
  Line* GetFirstLine();
  Line* GetLastLine();
  Line* GetNearestLine(Lunit ly);
  Line* navigate_line1(Lpoint* lp);
  bool EmptyLinesP();
  int GetNumLines();
  void DelayFormat();
  void DeleteForFormatter();
  void EmptyLines();
  void Format(bool do_invalidate);
  void Invalidate();
  void Invalidate(Irect* r);
  void MaybeFormat();
  void PrepareToChangeFlow();
  void Redisplay(View* view, HRGN region);
  void RedisplayFrameMargin(View* view);
  void RedisplayParagraphMargin(View* view);
  void ReportLast();
  void ReportTextFlow();
  void SetFormatNeededP(bool format_needed_p);
  void get_drawing_irect(Irect* r);
  void get_drawing_lrect(Lrect* r);
  void get_irect(Irect* r);
  void get_lpoint(Lpoint* lp);
  void get_lrect(Lrect* lr);
  void ipoint_to_line_point(Ipoint* ip);
  void line_point_to_ipoint(Ipoint* ip);
};

#endif /* FRAMEINS_H */
