// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: framemgn.cpp,v 3.4 2000/05/13 16:29:01 kudou Exp $
// class EditFrame
// t[GfB^̃t[][h

#include "pword.h"
#include "editfram.h"
#include "docwindo.h"
#include "fission.h"
#include "frameins.h"
#include "frametem.h"
#include "mcursor.h"
#include "vdisplay.h"
#include "view.h"

void NEAR
EditFrame::FrameMargin_GetLimit(uword m, FrameObject* fo,
				 bool move_together_p,
				 Iunit& l_limit, Iunit& u_limit)
{
  Rect r = fo->GetInternalRect();
  Margin mgn = GetEffectiveFrameMargin(fo);

  if (m <= 2) 
  {
    // horizontal
    l_limit = r.y1;
    u_limit = r.y2;
  }
  else 
  {
    // vertical
    l_limit = r.x1;
    u_limit = r.x2;
  }
  Iunit pos;
  switch (m) 
  {
   case 1:		// top
    pos = r.y1 + mgn.GetTop();
    u_limit = r.y2 - mgn.GetBottom();
    if (move_together_p)
    {
      u_limit = (pos + u_limit) / 2;
    }
    break;
   case 2:		// bottom
    pos = r.y2 - mgn.GetBottom();
    l_limit = r.y1 + mgn.GetTop();
    if (move_together_p) 
    {
      l_limit = (pos + l_limit) / 2;
    }
    break;
   case 3:		// left
    pos = r.x1 + mgn.GetLeft();
    u_limit = r.x2 - mgn.GetRight();
    if (move_together_p)
    {
      u_limit = (pos + u_limit) / 2;
    }
    break;
   case 4:		// right
    pos = r.x2 - mgn.GetRight();
    l_limit = r.x1 + mgn.GetLeft();
    if (move_together_p)
    {
      l_limit = (pos + l_limit) / 2;
    }
    break;
  }
}

void NEAR
EditFrame::FrameMargin_FixLimit(uword m, Iunit l_limit, Iunit u_limit,
				 Vector& pos)
{
  if (m <= 2)
  {
    if (pos.y < l_limit)
    {
      pos.y = l_limit;
    }
    if (pos.y > u_limit)
    {
      pos.y = u_limit;
    }
  }
  else 
  {
    if (pos.x < l_limit)
    {
      pos.x = l_limit;
    }
    if (pos.x > u_limit)
    {
      pos.x = u_limit;
    }
  }
}

void NEAR 
EditFrame::FrameMargin_LDWN(WPARAM_T wParam, LPARAM_T lParam)
{
  // fix start position
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  CrossPoint* cp;
  FrameObject* fo;
  uword m;
  Dunit offset = 0;
  if ((LockLayout(mpos) == 0) ||
      ((cp = FindCrossPointW(mpos)) == 0) ||
      ((fo = cp->GetFrameObject()) == 0) ||
      ((m = FindFrameMarginW(mpos, cp, offset)) == 0)) 
  {
    CancelFrameMargin();
    return;
  }
  bool move_together_p = !(wParam & MK_SHIFT);  
  ClearMouseOffset();
  if (m <= 2) 
  {
    // horizontal
    SetMouseYOffset(offset);
  }
  else 
  {
    // vertical
    SetMouseXOffset(offset);
  }
  Iunit l_limit;
  Iunit u_limit;
  FrameMargin_GetLimit(m, fo, move_together_p, l_limit, u_limit);
  Iunit pos;
  Rect r = fo->GetInternalRect();
  Margin mgn = GetEffectiveFrameMargin(fo);
  switch (m) 
  {
   case 1:		// top
    pos = r.y1 + mgn.GetTop();
    break;
   case 2:		// bottom
    pos = r.y2 - mgn.GetBottom();
    break;
   case 3:		// left
    pos = r.x1 + mgn.GetLeft();
    break;
   case 4:		// right
    pos = r.x2 - mgn.GetRight();
    break;
  }
  if (move_together_p) 
  {
    // move together with oposite margin
    fmgn.Start(cp, m, pos, l_limit, u_limit, True);
  }
  else 
  {
    // only one margin
    fmgn.Start(cp, m, pos, l_limit, u_limit);
  }
  ClearEffective();
  if (m <= 2) 
  {
    MouseCursor::FrameMarginH();
  }
  else 
  {
    MouseCursor::FrameMargin();
  }
  RedisplayFrameMargin();	// draw
  AdaptOffset(mpos);
  Vector posi = WtoIv(mpos);
  FrameMargin_FixLimit(m, l_limit, u_limit, posi);
  ShowMoveFrameLinePos(posi);
}

void NEAR 
EditFrame::FrameMargin_MV(WPARAM_T wParam, LPARAM_T lParam)
{
  if (fmgn.IsFixed() == False) 
  {
    // idle
    VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
    CrossPoint* cp;
    FrameObject* fo;
    Dunit offset = 0;
    uword m_num;
    if ((LockLayout(mpos) == 0) ||
	((cp = FindCrossPointW(mpos)) == 0) ||
	((fo = cp->GetFrameObject()) == 0) ||
	((m_num = FindFrameMarginW(mpos, cp, offset)) == 0)) 
    {
      MouseCursor::FrameMarginOff();
      ClearPosition(); 
      return;
    }
    ClearMouseOffset();
    bool move_together_p = !(wParam & MK_SHIFT);  
    Iunit l_limit;
    Iunit u_limit;
    FrameMargin_GetLimit(m_num, fo, move_together_p, l_limit, u_limit);
    if (m_num <= 2) 
    {
      MouseCursor::FrameMarginH();
      SetMouseYOffset(offset);
    }
    else 
    {
      MouseCursor::FrameMargin();
      SetMouseXOffset(offset);
    }
    AdaptOffset(mpos);
    Vector pos = WtoIv(mpos);
    FrameMargin_FixLimit(m_num, l_limit, u_limit, pos);
    ShowMoveFrameLinePos(pos, m_num, cp);
  }
  else 
  {
    // move
    VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
    AdaptOffset(mpos);
    Vector pos = WtoIv(mpos);
    FrameMargin_FixLimit(fmgn.GetMarginNumber(),  fmgn.GetLowerLimit(),
			  fmgn.GetUpperLimit(), pos);
    if (fmgn.GetMovePos() != 
	(fmgn.IsHorizontal() ? pos.y : pos.x)) 
    {
      RedisplayFrameMargin();		// vanish
      fmgn.SetMovePos(fmgn.IsHorizontal() ? pos.y : pos.x);
      RedisplayFrameMargin();		// draw
      if (fmgn.IsHorizontal()) 
      {
	MouseCursor::FrameMarginH();
      }
      else 
      {
	MouseCursor::FrameMargin();
      }
      ShowMoveFrameLinePos(pos);
      SetEffective();
    }
  }
}

void NEAR 
EditFrame::FrameMargin_LUP(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  if (!fmgn.IsFixed() || !IsEffective()) 
  {
    CancelFrameMargin(False);
    return;
  }
  // set
  RedisplayFrameMargin();		// vanish
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  AdaptOffset(mpos);
  Vector pos = WtoIv(mpos);
  if (fmgn.IsHorizontal()) 
  {
    if (pos.y < fmgn.GetLowerLimit()) 
    {
      pos.y = fmgn.GetLowerLimit();
    }
    if (pos.y > fmgn.GetUpperLimit()) 
    {
      pos.y = fmgn.GetUpperLimit();
    }
  }
  else 
  {
    if (pos.x < fmgn.GetLowerLimit()) 
    {
      pos.x = fmgn.GetLowerLimit();
    }
    if (pos.x > fmgn.GetUpperLimit()) 
    {
      pos.x = fmgn.GetUpperLimit();
    }
  }
  
  MouseCursor::FrameMarginOff();
  CrossPoint* cp = fmgn.GetCrossPoint();
  FrameObject* fo = cp->GetFrameObject();
  Margin m = GetEffectiveFrameMargin(fo);
  Rect r = fo->GetInternalRect();
  
  switch (fmgn.GetMarginNumber()) 
  {
   case 1:				// top margin
    if (fmgn.GetWorkTogether()) 
    {
      Iunit m_bottom = pos.y - r.y1 - m.GetTop() + m.GetBottom();
      if (m_bottom < 0) 
      {
	m_bottom = 0;
      }
      if (m_bottom > r.y2 - pos.y) 
      {
	m_bottom = r.y2 - pos.y;
      }
      fo->SetBottomMargin(m_bottom);
    }
    else if (m.GetBottom() != fo->GetBottomMargin()) 
    {
      fo->SetBottomMargin(m.GetBottom());
    }
    fo->SetTopMargin(pos.y - r.y1);
    break;
    
   case 2:				// bottom margin
    if (fmgn.GetWorkTogether()) 
    {
      Iunit m_top = r.y2 - pos.y - m.GetBottom() + m.GetTop();
      if (m_top < 0) 
      {
	m_top = 0;
      }
      if (m_top > pos.y - r.y1) 
      {
	m_top = pos.y - r.y1;
      }
      fo->SetTopMargin(m_top);
    }
    else if (m.GetTop() != fo->GetTopMargin()) 
    {
      fo->SetTopMargin(m.GetTop());
    }
    fo->SetBottomMargin(r.y2 - pos.y);
    break;
    
   case 3:				// left margin
    if (fmgn.GetWorkTogether()) 
    {
      Iunit m_right = pos.x - r.x1 - m.GetLeft() + m.GetRight();
      if (m_right < 0) 
      {
	m_right = 0;
      }
      if (m_right > r.x2 - pos.x) 
      {
	m_right = r.x2 - pos.x;
      }
      fo->SetRightMargin(m_right);
    }
    else if (m.GetRight() != fo->GetRightMargin()) 
    {
      fo->SetRightMargin(m.GetRight());
    }
    fo->SetLeftMargin(pos.x - r.x1);
    break;
    
   case 4:				// right margin
    if (fmgn.GetWorkTogether()) 
    {
      Iunit m_left = r.x2 - pos.x - m.GetRight() + m.GetLeft();
      if (m_left < 0) 
      {
	m_left = 0;
      }
      if (m_left > pos.x - r.x1) 
      {
	m_left = pos.x - r.x1;
      }
      fo->SetLeftMargin(m_left);
    }
    else if (m.GetLeft() != fo->GetLeftMargin()) 
    {
      fo->SetLeftMargin(m.GetLeft());
    }
    fo->SetRightMargin(r.x2 - pos.x);
    break;
  }
  ShowMoveFrameLinePos(pos);
  fmgn.Reset();
  ClearMouseOffset();
  UnforceTouchCaret();
  SetDirty();
}

// frame margin mode
void
EditFrame::WndProcFrameMargin(DocumentWindow* wd, 
			       MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  EditFrame::window = wd;
  switch (Msg) 
  {
   case WM_LBUTTONDOWN:
    FrameMargin_LDWN(wParam, lParam);
    break;
    
   case WM_MOUSEMOVE:
    FrameMargin_MV(wParam, lParam);
    break;
    
   case WM_LBUTTONUP:
    FrameMargin_LUP(wParam, lParam);
    break;

   case WM_RBUTTONDOWN:
    CancelFrameMargin(False);
    break;
  }
}

void 
EditFrame::CancelFrameMargin(bool beep)
{
  if (fmgn.IsFixed()) 
  {
    RedisplayFrameMargin();		// vanish
  }
  MouseCursor::FrameMarginOff();
  fmgn.Reset();
  ClearMouseOffset();
  if (beep) 
  {
    ::MessageBeep(0);
  }
}

// display frame margin object
void 
EditFrame::RedisplayFrameMargin()
{
  HWND hWnd = window->GetHandle();
  HDC hDC = GetDC(hWnd);
  RedisplayFrameMargin(hDC);
  ReleaseDC(hWnd, hDC);
}

void 
EditFrame::RedisplayFrameMargin(VDisplay* vdsp)
{
  RedisplayFrameMargin(vdsp->GetDC());
}

void 
EditFrame::RedisplayFrameMargin(HDC hDC)
{
  if (fmgn.IsFixed() == False) 
  {
    return;
  }
  CrossPoint* cp = fmgn.GetCrossPoint();
  Iunit y1 = cp->GetCellTopFission()->Y();
  Iunit y2 = cp->GetCellBottomFission()->Y();
  Iunit x1 = cp->GetCellLeftFission()->X();
  Iunit x2 = cp->GetCellRightFission()->X();
  
  Vector from;
  Vector to;
  switch (fmgn.GetMarginNumber()) 
  {
   case 1:		// top
   case 2:		// bottom
    from.x = x1;
    to.x = x2;
    from.y = to.y = fmgn.GetMovePos();
    break;
   case 3:		// left
   case 4:		// right
    from.y = y1;
    to.y = y2;
    from.x = to.x = fmgn.GetMovePos();
    break;
  }
  VectW from_vw = ItoWv(from);
  VectW to_vw = ItoWv(to);
  DisplaySelectedLine(hDC, from_vw, to_vw);
  
  if (!fmgn.GetWorkTogether()) 
  {
    return;
  }
  
  FrameObject* fo = cp->GetFrameObject();
  Rect r = fo->GetInternalRect();
  Iunit offset;
  switch (fmgn.GetMarginNumber()) 
  {
   case 1:		// top
    offset = fmgn.GetMovePos() - (r.y1 + fo->GetTopMargin());
    from.y = to.y = (r.y2 - fo->GetBottomMargin()) - offset;
    if (from.y > r.y2) 
    {
      from.y = to.y = r.y2;
    }
    if (from.y <= fmgn.GetMovePos()) 
    {
      return;
    }
    break;
   case 2:		// bottom
    offset = fmgn.GetMovePos() - (r.y2 - fo->GetBottomMargin());
    from.y = to.y = (r.y1 + fo->GetTopMargin()) - offset;
    if (from.y < r.y1) 
    {
      from.y = to.y = r.y1;
    }
    if (from.y >= fmgn.GetMovePos()) 
    {
      return;
    }
    break;
   case 3:		// left
    offset = fmgn.GetMovePos() - (r.x1 + fo->GetLeftMargin());
    from.x = to.x = (r.x2 - fo->GetRightMargin()) - offset;
    if (from.x > r.x2) 
    {
      from.x = to.x = r.x2;
    }
    if (from.x <= fmgn.GetMovePos()) 
    {
      return;
    }
    break;
   case 4:		// right
    offset = fmgn.GetMovePos() - (r.x2 - fo->GetRightMargin());
    from.x = to.x = (r.x1 + fo->GetLeftMargin()) - offset;
    if (from.x < r.x1) 
    {
      from.x = to.x = r.x1;
    }
    if (from.x >= fmgn.GetMovePos()) 
    {
      return;
    }
    break;
  }
  from_vw = ItoWv(from);
  to_vw = ItoWv(to);
  DisplaySelectedLine(hDC, from_vw, to_vw);
}
