// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: frametem.cpp,v 3.3 2000/05/03 12:18:34 kudou Exp $
// FrameTemplate class
// eLXg̗ꍞޗ̈NXBev[gƂĎg

#include "pword.h"
#include "fission.h"
#include "ftlist.h"
#include "frametem.h"
#include "frameins.h"
#include "layoutte.h"
#include "layoutin.h"
#include "blueprin.h"
#include "objectid.h"
#include "editfram.h"
#ifndef NDEBUG
#include "ddisplay.h"
#endif

// initiator(real constructor)
void
FrameTemplate::Initiator(LayoutTemplate* lt, FrameTemplate* prev)
{
  this->set_frame_align(AL_vertical_adjust);
  layout = lt;
  
  // size set
  Rect rec = GetInternalRect();
  cx = rec.x1;
  cy = rec.y1;
  width = rec.GetXSize();
  height = rec.GetYSize();
  
  // link next_ft
  next_ft = lt->AddFrameTemplate(this);
  
  // set flowing
  if (prev != 0) 
  {
    next_tfft = prev->next_tfft;
    prev->next_tfft = this;
  }
  else 
  {
    next_tfft = 0;
    
    // create new gate
    layout->AddGate(this);
  }
}

// constructor, create new flow
FrameTemplate::FrameTemplate(LayoutTemplate* lt, CrossPoint* cp)
  : FrameObject(cp)
{
  Initiator(lt);
}

// constructor
FrameTemplate::FrameTemplate(LayoutTemplate* lt, FrameTemplate* prev,
			      CrossPoint* cp)
  : FrameObject(cp)
{
  Initiator(lt, prev);
}

// destructor
FrameTemplate::~FrameTemplate()
{
  layout->FI_ChangedNext(this);
  layout->FI_VanishFrameTemplate(this);
  layout->RemoveFrameTemplate(this);
}

// display function
void
FrameTemplate::DisplayObject(VDisplay*)
{
  // do nothing
}

// get freme object ID
uword 
FrameTemplate::GetObjectID()
{
  return IDTextObject;
}

// duplicator
FrameObject* 
FrameTemplate::Duplicator(CrossPoint* cp)
{
  FrameTemplate* prev = (layout->IsTable() && !BluePrint::NowProduce() 
			 && !EditFrame::NowSetFlow())
  ? 0 : this;
  FrameTemplate* ft = new FrameTemplate(layout, prev, cp);
  Margin m = GetMargin();
  ft->SetMargin(m);
  layout->FI_CreateFrameTemplate(prev, ft);
  return ft;
}

// size change
void 
FrameTemplate::ChangeSize()
{
  // update size infomation
  Rect rec = GetInternalRect();
  cx = rec.x1;
  cy = rec.y1;
  width = rec.GetXSize();
  height = rec.GetYSize();
  layout->DelayFormatFrame(this);
}

// change flow
FrameObject* 
FrameTemplate::ChangeFlow(FrameObject* fo)
{
  assert(fo->GetObjectID() == GetObjectID());
  
  FrameTemplate* next = (FrameTemplate*)fo;
  Margin mgn = fo->GetMargin();
  CrossPoint* cp = fo->GetCrossPoint();
  delete next;
  FrameTemplate* ft = new FrameTemplate(layout, this, cp);
  ft->SetMargin(mgn);
  layout->FI_CreateFrameTemplate(this, ft);
  return(FrameObject*)ft;
}

// check vanish
bool 
FrameTemplate::CheckVanish()
{
  // check frame-template vanishable or not
  if (next_tfft != 0) 
  {
    // there are next frames.
    return True;
  }
  
  if (layout->GetGateNumber(this) == 0) 
  {
    // it isn't gate frame
    return True;
  }
  
  // It's the only frame in this layout.
  return layout->FI_CheckVanishFrameTemplate(this);
}

// check first flow object
bool 
FrameTemplate::IsFirstObject()
{
  return(this == layout->GetGateFT(1));
}

// get next frame object
FrameObject* 
FrameTemplate::GetNextFrameObject()
{
  return GetNextTFFT();
}

// get next link object
FrameObject* 
FrameTemplate::GetNextLinkObject()
{
  uword gate = layout->WhichGateFT(this);
  return layout->GetGateFT(gate + 1);
}
