// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: frametem.h,v 3.3 2000/05/04 13:44:05 kudou Exp $
// FrameTemplate class
// text flowed frame.
// A FrameTemplate talks about a "generic Frame", i.e., one position
// in one layout, describing its position in that layout

#ifndef FRAMETEM_H
#define FRAMETEM_H

#include "attribut.h"
#include "frameown.h"

class FrameTemplate 
  : public FrameObject
{
private:
  // Back pointer to that layout-template.
  LayoutTemplate* layout;
  
  // single-threaded list of these in layout
  FrameTemplate* next_ft;
  
  // stl of templates of a flow.
  // Order is critical, but never have to traverse bidirectionally.
  FrameTemplate* next_tfft;
  
  // position in Layout, from top left corner.
  Iunit cx, cy;
  
  // size
  Iunit width, height;
  
  enum VerticalAlignment frame_align_;

  // ------------------------------
  // internal use methods
private:
  // initiator
  void Initiator(LayoutTemplate* lt, FrameTemplate* prev = 0);
  
  // ------------------------------
  // object interface(virtual function)
public:
  // display function.
  void DisplayObject(VDisplay* dsp);
  
  // get freme object ID
  uword GetObjectID();
  
  // generate duplicate object
  FrameObject* Duplicator(CrossPoint* cp);
  
  // size change
  void ChangeSize();
  
  // change flow
  FrameObject* ChangeFlow(FrameObject* next);
  
  // check vanish
  bool CheckVanish();
  
  // check first flow
  bool IsFirstObject();
  
  // get next frame object
  FrameObject* GetNextFrameObject();
  
  // get next link object
  FrameObject* GetNextLinkObject();
  
  // constructor, create new flow
  FrameTemplate(LayoutTemplate* lt, CrossPoint* cp);
  
  // constructor
  FrameTemplate(LayoutTemplate* lt, FrameTemplate* prev, CrossPoint* cp);
  
  // destructor
  ~FrameTemplate();
  
  // get layout template
  LayoutTemplate* GetLayoutTemplate() 
  {
    return layout;
  }
  
  // next text-flow frame
  FrameTemplate* GetNextTFFT() 
  {
    return next_tfft;
  }
  
  // set next text-flow frame
  void SetNextTFFT(FrameTemplate* ft) 
  {
    next_tfft = ft;
  }
  
  // next frame
  FrameTemplate* GetNextFT() 
  {
    return next_ft;
  }
  
  // set next frame
  void SetNextFT(FrameTemplate* ft) 
  {
    next_ft = ft;
  }

  // ------------------------------
  // dimensional info.
  // x position
  Iunit GetCX() 
  {
    return cx;
  }
  
  // y position
  Iunit GetCY() 
  {
    return cy;
  }
  
  // width
  Iunit GetWidth() 
  {
    return width;
  }
  
  // heghit
  Iunit GetHeight() 
  {
    return height;
  }
  
  enum VerticalAlignment frame_align();
  void set_frame_align(VerticalAlignment align);
};

inline enum VerticalAlignment
FrameTemplate::frame_align()
{
  return(this->frame_align_);
}

inline void
FrameTemplate::set_frame_align(VerticalAlignment align)
{
  this->frame_align_ = align;
}

#endif /* FRAMETEM_H */
