// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: gslist.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// generic single list class

#ifndef GSLIST_H
#define GSLIST_H

#include "slist.h"

// class name definition
#define GSList(T) GSList ## T
#define GSListIterator(T) GSListIterator ## T

// generic class declaration
#define GSListDeclare(T)						\
class GSList(T)								\
  : public SingleList {							\
public:									\
   GSList(T)() { ; }			/* constructor */		\
   ~GSList(T)() { ; }			/* destructor */		\
   void Push(T* data);			/* push data */			\
   T* Pop();				/* pop data */			\
   void Inject(T* data);		/* push data to last */		\
   T* Eject();				/* pop last data */		\
   uword Number();			/* number */			\
   T* GetTopData();			/* get top data */		\
   uword Search(T* data);		/* search data */		\
   void Delete(T* data);		/* delete */			\
   void Delete(uword n);		/* delete with index */		\
   T* Access(uword n);			/* access with index(1~) */	\
   T* operator [] (uword n);		/* access with index - 1(0~) */\
   void Replace(uword n, T* data);	/* replace data with index */	\
   void Insert(uword prev, T* data);	/* insert data with index */	\
   void Insert(T* prev, T* data);	/* insert data */		\
   void Clear();			/* clear list */		\
};									\
									\
class GSListIterator(T) : private SingleListIterator {			\
public:									\
   GSListIterator(T)(GSList(T)* slist);					\
   GSListIterator(T)(GSList(T)& slist);					\
   					/* constructor */		\
   T* operator() ();			/* iterator */			\
   /* bool IsEnd(); */			/* iteration end check */	\
   SingleListIterator::IsEnd;						\
   /* void Revert(); */			/* revert to initial */		\
   SingleListIterator::Revert;						\
};									\
									\
inline void GSList(T)::Push(T* data) { SingleList::Push(data); }	\
inline T* GSList(T)::Pop() { return(T*)SingleList::Pop(); }		\
inline void GSList(T)::Inject(T* data) { SingleList::Inject(data); }	\
inline T* GSList(T)::Eject() { return(T*)SingleList::Eject(); }	\
inline void GSList(T)::Delete(T* data) { SingleList::Delete(data); }	\
inline void GSList(T)::Delete(uword n) { SingleList::Delete(n); }	\
inline uword GSList(T)::Number() { return SingleList::Number(); }	\
inline T* GSList(T)::GetTopData() { return(T*)SingleList::GetTopData(); } \
inline uword GSList(T)::Search(T* data) { return SingleList::Search(data); } \
inline T* GSList(T)::Access(uword n) { return(T*)SingleList::Access(n); } \
inline T* GSList(T)::operator [] (uword n)				\
	{ return(T*)SingleList::operator [] (n); }			\
inline void GSList(T)::Replace(uword n, T* data) 			\
	{ SingleList::Replace(n, data); }				\
inline void GSList(T)::Insert(uword prev, T* data) 			\
	{ SingleList::Insert(prev, data); }				\
inline void GSList(T)::Insert(T* prev, T* data) 			\
	{ SingleList::Insert(prev, data); }				\
inline void GSList(T)::Clear() { SingleList::Clear(); }			\
									\
inline GSListIterator(T)::GSListIterator(T)(GSList(T)* slist)		\
  : SingleListIterator((SingleList*)slist) { ; } 			\
inline GSListIterator(T)::GSListIterator(T)(GSList(T)& slist) 		\
  : SingleListIterator((SingleList&)slist) { ; } 			\
inline T* GSListIterator(T)::operator() () {				\
   return(T*)SingleListIterator::operator() (); }			\

#endif /* GSLIST_H */
