// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: huge.cpp,v 3.3 2000/05/04 13:44:06 kudou Exp $
// huge memory management

#include "pword.h"

#ifdef _WIN32
#  include <stdio.h>
#else /* _WIN32 */
#  include <memory.h>
#  include <dos.h>
#endif /* _WIN32 */

#ifdef _WIN32
#ifdef huge
#  undef huge
#endif
#define huge
#endif

void
huge_memcpy(void* dest, long dest_offset, void* src, long src_offset, udword n)
{
#ifdef _WIN32
  memcpy((void*)((char*)dest + dest_offset), (void*)((char*)src + src_offset), n);
#else /* _WIN32 */
  if (n != 0)
  {
    char huge* d = (char huge*) dest + dest_offset;
    char huge* s = (char huge*) src + src_offset;
    do
    {
      *d++ = *s++;
    } while (--n != 0);
  }
#endif /* _WIN32 */
}

#define MAX_READ_WRITE 0x4000

udword
huge_fread(FILE* stream, void far* mem, udword count)
{
#ifdef _WIN32
  return (udword)fread(mem, 1, count, stream);
#else /* _WIN32 */
  udword total_read = 0;
  while (0 < count)
  {
    unsigned int nread = (unsigned int) MIN(count, MAX_READ_WRITE);
    unsigned int limit = (unsigned int) -((int) FP_OFF(mem));
    if (limit != 0)
    {
      SET_MIN(nread, limit);
    }
    nread = fread(mem, 1, nread, stream);
    if ((int) nread <= 0)
    {
      if ((int) nread < 0)
      {
	return((udword) -1);
      }
      break;
    }
    total_read += nread;
    count -= nread;
    mem = (void far*) ((char huge*) mem + nread);
  }
  return(total_read);
#endif /* _WIN32 */
}

udword
huge_fwrite(FILE* stream, void far* mem, udword count)
{
#ifdef _WIN32
  return (udword)fwrite(mem, 1, count, stream);
#else /* _WIN32 */
  udword total_write = 0;
  while (0 < count)
  {
    unsigned int nwrite = (unsigned int) MIN(count, MAX_READ_WRITE);
    unsigned int limit = (unsigned int) -((int) FP_OFF(mem));
    if (limit != 0)
    {
      SET_MIN(nwrite, limit);
    }
    nwrite = fwrite(mem, 1, nwrite, stream);
    if ((int) nwrite <= 0)
    {
      if ((int) nwrite < 0)
      {
	return((udword) -1);
      }
      break;
    }
    total_write += nwrite;
    count -= nwrite;
    mem = (void far*) ((char huge*) mem + nwrite);
  }
  return(total_write);
#endif /* _WIN32 */
}

void* 
huge_add(void far* base, udword offset)
{
  return((char huge*)base + offset);
}
