// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: intlist.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// implement IntervalList class

#include "pword.h"
#include "intlist.h"
#include "attribut.h"
#include "bound.h"
#include "bufnew.h"
#include "docconte.h"
#include "frameins.h"
#include "interval.h"
#include "layoutin.h"
#include "panel.h"
#include "pstreams.h"
#include "table.h"
#include "textflow.h"

IntervalList::IntervalList()
{
  Init();
}

IntervalList::IntervalList(Interval* i)
  : BaseIntervalList(i)
{
  Init();
}

IntervalList::IntervalList(IntervalList* il)
{
  Init();
  Copy(il);
}

IntervalList::IntervalList(DocumentContent* dc)
{
  Init();
  TextFlow* first = dc->GetNonHeaderTextFlow();
  AddIntervalAtTail(new Interval(first));
  for (TextFlow* tf=dc->GetFirstTextFlow(); tf; tf=tf->GetNext()) 
  {
    if (tf != first)
    {
      AddIntervalAtTail(new Interval(tf));
    }
  }
}

IntervalList::IntervalList(BoundIntervalList* bil, DocumentContent* dc)
{
  BaseInterval** plug = &head;
  
  for (BaseInterval* i = bil->head; i; i=i->next)
  {
    Interval* copy = new Interval(* (BoundInterval*) i, dc);
    *plug = copy;
    plug = & (copy->next);
  }
  *plug = 0;
}

IntervalList::~IntervalList()
{
}

void
IntervalList::Init()
{
}

BaseInterval*
IntervalList::NewMember(BaseInterval* i)
{
  return new Interval((Interval*) i);
}

// static method
IntervalList* 
IntervalList::Concat(IntervalList* a, IntervalList* b)
{
  if (a == NULL)
  {
    return(b);
  }
  if (b == NULL)
  {
    return(a);
  }
  
  BaseInterval** place = &a->head;
  BaseInterval* tail;
  while ((tail = *place) != NULL)
  {
    place = &tail->next;
  }
  *place = b->head;
  b->head = NULL;
  delete b;
  return(a);
}

Interval*
IntervalList::FindIntervalContaining(BPP bpp)
{
  THIS_CHECK;
  BaseIntervalListTraversor ilt(this);
  while (1)
  {
    Interval* i = (Interval*)++ilt;
    if (!i)
    {
      break;
    }
    if (i->BPcmp(bpp) == Interval::BC_INSIDE)
    {
      return i;
    }
  }
  return 0;
}

void
IntervalList::TurnOn()
{
  THIS_CHECK;
  BaseIntervalListTraversor ilt(this);
  void(Interval::*func) () = &Interval::TurnOn;
  Interval* i;
  
  while ((i = (Interval*) ilt.GetNext()) != 0)
  {
    (i->*func) ();
    func = &Interval::TurnOnSub;
  }
}

void
IntervalList::TurnOff()
{
  Apply(&Interval::TurnOff);
}

// Cycle() implements the "Next Selection" command, NOT the
// "Previous Location" command.  It puts the currently first
// selection down at the bottom of the list.
void
IntervalList::Cycle(int direction)
{
  THIS_CHECK;
  Interval* h = (Interval*) GetHead();
  if (!h) return;
  h->TurnOnSub();
  BaseIntervalList::Cycle(direction);
  h = (Interval*) GetHead();
  h->TurnOn();
}

// PointP() reports if any of the elements on the interval list
// are real selections, with contents that can be e.g. copied to the
// clipboard
bool
IntervalList::PointP()
{
  THIS_CHECK;
  BaseIntervalListTraversor ilt(this);
  Interval* i;
  while ((i= (Interval*) ilt.GetNext()) != 0)
  {
    if (! i->PointP())
    {
      return False;
    }
  }
  return True;
}

void
IntervalList::DeleteInterval(Interval* i)
{
  THIS_CHECK;
  if (!i) return;
  i->TurnOff();
  BaseIntervalList::DeleteInterval(i);
}

bool
IntervalList::DeleteIntervalContaining(BPP bpp)
{
  // can't delete the only interval
  
  THIS_CHECK;
  
  if (SingleP())
  return False;
  
  
  Interval* i = FindIntervalContaining(bpp);
  
  if (!i)
  {
    return False;
  }
  
  bool first = i == GetHead();
  DeleteInterval(i);
  if (first)
  {
    ((Interval*) GetHead())->TurnOn();
  }
  return True;
}

// WeedDeadTextFlow -- remove all intervals belonging to a text flow

void
IntervalList::WeedDeadTextFlow(TextFlow* tf)
{
  Interval* i;
  Interval** place = (Interval**) &this->head;
  while ((i = *place) != NULL)
  {
    Interval** old_place = place;
    place = (Interval **) &i->next;
    if (i->GetTextFlow() == tf)
    {
      place = old_place;
      *place = (Interval *) i->next;
      delete i;
    }
  }
  // if no intervals left, outside must deal with it
}

// RemoveNested -- remove all intervals nested in panels in other ones
void
IntervalList::RemoveNested()
{
  Interval* i;
  
  if (this->SingleP())
  {
    return;
  }
  
  {
    for (i = this->GetHead(); i; i = i->GetNext())
    {
      i->TurnOnOff(0, IV_MASK, False);
    }
  }
  
  Interval** place = (Interval **) &this->head;
  while ((i = *place) != NULL)
  {
    Interval** old_place = place;
    place = (Interval **) &i->next;
    TextFlow* flow = i->GetTextFlow();
    while (flow->OnTableP())
    {
      Panel* panel = flow->GetFirstFrame() ->GetLayout() ->GetPanel();
      assert(panel);
      // safe code for sale version
      if (panel == NULL)
      {
	break;
      }
      BufferPointer* right_bp = panel->GetRightBP();
      flow = right_bp->GetTextFlow();
      if (right_bp->GetEditor() ->GetFlags(right_bp->GetLogicalOffset()
					     - 1))
      {
	place = old_place;
	*place = (Interval *) i->next;
	delete i;
	break;
      }
    }
  }
}

// AddInterval -- add an interval to the BEGINNING of the list.
// Note: this routine EATS the interval provided to it.
void
IntervalList::AddInterval(Interval* i)
{
  Interval* h = (Interval*) GetHead();
  if (h)
  {
    h->TurnOnSub();
  }
  AddIntervalAtHead(i);
  h = (Interval*) GetHead();
  assert(h);
  h->TurnOn();
}

void
IntervalList::AddInterval(BPP b1, BPP b2)
{
  AddInterval(new Interval(b1, b2));
}

// Collapse deletes all selections BUT THE FIRST
void
IntervalList::Collapse()
{
  TurnOff();
  CutOffTail();
  Interval* h= (Interval*) GetHead();
  if (!h) return;
  h->GotoBeginningPoint();
}

void
IntervalList::CutOffHead()
{
  GetHead()->TurnOff();
  BaseIntervalList::CutOffHead();
  GetHead()->TurnOn();
}

void
IntervalList::DeleteSecondaryIntervals()
{
  if (!SingleP())
  {
    TurnOff();
    CutOffTail();
    TurnOn();
  }
}

void
IntervalList::InsertText(sjis* stuff, uword count)
{
  THIS_CHECK;
  Interval* i;
  BaseIntervalListTraversor ilt(this);
  while ((i= (Interval*) ilt.GetNext()) != 0)
  {
    i->InsertText(stuff, count);
  }
}

void
IntervalList::InsertASCII(char* stuff, uword count)
{
  int foo_len;
  sjis* foo = jis_spread(stuff, count, &foo_len);
  InsertText(foo, foo_len);
  delete foo;
}

BPP
IntervalList::PointForCaret(bool& selection)
{
  THIS_CHECK;
  Interval* i = (Interval*) GetHead();
  if (!i) return 0;
  selection = i->PointP() == 0;
  return(i->GetBP1());
}

void
IntervalList::Cut()
{
  Apply(&Interval::Delete);
}

void
IntervalList::GotoEndPoint()
{
  Apply(&Interval::GotoEndPoint);
}

// Apply() -- apply a function on intervals to all intervals

void
IntervalList::Apply(void(Interval::*func) ())
{
  THIS_CHECK;
  for (Interval* i = this->GetHead(); i != NULL; i = i->GetNext())
  {
    (i->*func) ();
  }
}

// MergeWithFirst() -- merge overlapping intervals on the list with the first
void
IntervalList::MergeWithFirst()
{
  THIS_CHECK;
  if (this->PointP())
  {
    return;
  }
  
  bool merged = False;
  Interval* i = this->GetHead();
  Interval* i2 = i->GetNext();
  while (i2 != NULL)
  {
    Interval* next_i2 = i2->GetNext();
    if (i->Merge(i2))
    {
      merged=True;
      BaseIntervalList::DeleteInterval(i2); // on/off
    }
    i2 = next_i2;
  }
  
  // if the yellow interval sucked blue intervals, they need
  // to be redrawn
  if (merged)
  {
    i->TurnOn();
  }
}

// MergePoints() -- merge points at same location
// needs optimization

void
IntervalList::MergePoints()
{
  THIS_CHECK;
  assert(this->PointP());
  
  for (Interval* i = this->GetHead(); i != NULL; i = i->GetNext())
  {
    Interval* i2 = i->GetNext();
    while (i2 != NULL)
    {
      Interval* next_i2 = i2->GetNext();
      if (* (i->GetBP0()) == * (i2->GetBP0()))
      {
	BaseIntervalList::DeleteInterval(i2); // on/off
      }
      i2 = next_i2;
    }
  }
}

void
IntervalList::WriteFormattedToStream(PStream* stream)
{
  Interval* i;
  
  stream->StartBlockOut(PStream::HDR_INTLIST); CHECK;
  stream->OutUWord(Count()); CHECK;
  
  BaseIntervalListTraversor ilt(this);
  while ((i= (Interval*) ilt.GetNext()) != 0)
  {
    i->WriteFormattedToStream(stream); CHECK;
  }
  
  stream->EndBlockOut(); CHECK;
}

void
IntervalList::WriteASCIIToStream(BufStream* stream)
{
  for (Interval* i = GetHead(); i != NULL; i = i->GetNext())
  {
    i->WriteASCIIToStream(stream); CHECK;
  }
}

void
IntervalList::DelayFormat()
{
  this->Apply(&Interval::DelayFormat);
}

// make an intervallist containing all characters in all paragraphs in the interval
// this is used when applying paragraph character attributes
IntervalList*
IntervalList::AllChars()
{
  IntervalList* result = new IntervalList;
  
  BaseIntervalListTraversor ilt(this);
  Interval* i;
  while ((i= (Interval*) ilt.GetNext()) != 0)
  {
    BufferPointer* start = new BufferPointer(i->GetLeft());
    BufferPointer* end = new BufferPointer(i->GetRight());
    
    start->BeginningOfBuffer();
    end->EndOfBuffer();
    
    result->AddIntervalAtHead(new Interval(start, end));
    
    delete start;
    delete end;
  }
  return result;
}

void
IntervalList::InferAttributes()
{
  THIS_CHECK;
  for (Interval* i = this->GetHead(); i != NULL; i = i->GetNext())
  {
    (void) (i->InferAttributes());
  }
}

// an interval list is "big" if it has more than one interval, OR spans paragraphs
bool
IntervalList::BigP()
{
  Interval* head = this->GetHead();
  return(((head != NULL) && (head->GetNext() != NULL)) ||
	  head->GetBP0()->GetBuffer() != head->GetBP1()->GetBuffer());
}
