// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: layoutdl.cpp,v 3.4 1999/07/19 09:52:59 kudou Exp $
// class PageSizeDialog
// class HeaderDialog
// class PageNoDialog
// class LayoutDialog
// class DefLayoutDialog 
// class RedefLayoutDialog
// class ChangeLayoutDialog 
// class NewSectionDialog
// class ChangeLayoutNameDialog
// layout menu dialogs

#include "pword.h"
#include "dialogs.h"
#include "pmenus.h"
#include "layoutdl.h"
#include "pagesize.h"
#include "pref.h"
#include "lman.h"

// ------------------------------------------------------------
// class PageSizeDialog

PageSizeDialog::PageSizeDialog(PageSize::Kind initname, 
				Iunit initvert, 
				Iunit inithoriz, 
				Iunit inittop, 
				Iunit initbottom, 
				Iunit initright, 
				Iunit initleft, 
				PageSize::Orientation initorient)
{
  this->class_name = "PageSizeDialog";
  if (initname >= PageSize::UserSize)
  {
    paper_name = PageSize::UserSize;
  }
  else
  {
    paper_name = initname;
  }
  vert   = iu_to_mm0(initvert);
  horiz  = iu_to_mm0(inithoriz);
  top    = iu_to_mm0(inittop);
  bottom = iu_to_mm0(initbottom);
  right  = iu_to_mm0(initright);
  left   = iu_to_mm0(initleft);
  orient = initorient;
  done_updating = True;
}

LRESULT_T
PageSizeDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    InitCombo();
    ChangeKind(paper_name, True);
    return 1;
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDD_PageSize_Type:
      {
#ifdef _WIN32
	switch (HIWORD(wParam))
#else /* _WIN32 */
	switch (HIWORD(lParam))
#endif /* _WIN32 */
	{
	 case CBN_SELCHANGE:
	  {
	    PageSize::Kind newkind;
	    
	    done_updating = False;
	    newkind = ((PageSize::Kind)
		       SendItemMessage(IDD_PageSize_Type, CB_GETCURSEL));
	    if (newkind != CB_ERR)
	    {    // Lets get & set the new values!
	      ChangeKind(newkind, False);
	    }
	    done_updating = True;
	    break;
	  }
	  
	 default:
	  break;
	}
	
	break;
      }
      
      // change paper size
     case IDD_PageSize_Vert:
      {
	ResetName(IDD_PageSize_Vert);
	SetValue(IDD_PageSize_Vert, vert);
	EnableWindow(GetItem(IDOK), IsGood());
	break;
      }
      
     case IDD_PageSize_Horiz:
      {
	ResetName(IDD_PageSize_Horiz);
	SetValue(IDD_PageSize_Horiz, horiz);
	EnableWindow(GetItem(IDOK), IsGood());
	break;
      }
      
      // change margin
     case IDD_PageSize_Top:
      {
	ResetName(IDD_PageSize_Top);
	SetValue(IDD_PageSize_Top, top);
	EnableWindow(GetItem(IDOK), IsGood());
	break;
      }
      
     case IDD_PageSize_Bottom:
      {
	ResetName(IDD_PageSize_Bottom);
	SetValue(IDD_PageSize_Bottom, bottom);
	EnableWindow(GetItem(IDOK), IsGood());
	break;
      }
      
     case IDD_PageSize_Right:
      {
	ResetName(IDD_PageSize_Right);
	SetValue(IDD_PageSize_Right, right);
	EnableWindow(GetItem(IDOK), IsGood());
	break;
      }
      
     case IDD_PageSize_Left:
      {
	ResetName(IDD_PageSize_Left);
	SetValue(IDD_PageSize_Left, left);
	EnableWindow(GetItem(IDOK), IsGood());
	break;
      }
      
      // change orientation
     case IDD_PageSize_VO:
      {
	if (orient != PageSize::Portrait)
	{
	  SwapVH();
	  orient = PageSize::Portrait;
	  EnableWindow(GetItem(IDOK), IsGood());
	}
	break;
      }
      
     case IDD_PageSize_HO:
      {
	if (orient != PageSize::Landscape)
	{
	  SwapVH();
	  orient = PageSize::Landscape;
	  EnableWindow(GetItem(IDOK), IsGood());
	}
	break;
      }
      
     case IDOK:
      End(1);
      return 1;
      
     case IDCANCEL:
      End(0);
      return 1;
      
     default:
      break;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    return(1);
    
   default: 
    return 0;
  }
  return 0;
}

void 
PageSizeDialog::InitCombo()
{
  for (int index=0; index <= PageSize::KindNumber ; index++)
  {
    extern Enum_Desc paper_size_desc[];
    SendItemMessage(IDD_PageSize_Type,
		     CB_ADDSTRING,
		     0,
		     Ptr2Long(Pref::enum_to_string(paper_size_desc, index)));
  }
  SendItemMessage(IDD_PageSize_Type, CB_SETCURSEL, paper_name);
}

int max_paper_size = iu_to_mm0(PageSize::GetMaxPaperSize());
int min_paper_size = iu_to_mm0(PageSize::GetMinPaperSize());
int min_regular_size = iu_to_mm0(PageSize::GetMinRegularSize());

void 
PageSizeDialog::SetValue(int ID, int& value)
{
  get_item_mm0(this->GetHandle(), ID, &value);
}

BOOL 
PageSizeDialog::IsGood()
{
  static int id_table [] = 
  {
    IDD_PageSize_Vert,
    IDD_PageSize_Horiz,
    IDD_PageSize_Top,
    IDD_PageSize_Bottom,
    IDD_PageSize_Left,
    IDD_PageSize_Right,
  };
  static uword id_table_size = 6;
  
  for (uword id_index = 0; id_index < id_table_size; id_index++)
  {
    switch (id_table[id_index]) 
    {
     case IDD_PageSize_Vert:
      if ((vert < min_paper_size) ||
          (vert > max_paper_size) ||
          (vert < (top + bottom + min_regular_size)))
      {
        return False;
      }
      break;
     case IDD_PageSize_Horiz:
      if ((horiz < min_paper_size) ||
          (horiz > max_paper_size) ||
          (horiz < (left + right + min_regular_size)))
      {
        return False;
      }
      break;
     case IDD_PageSize_Top:
      if ((top < 0) ||
          ((top + bottom + min_regular_size) > vert))
      {
        return False;
      }
      break;
     case IDD_PageSize_Bottom:
      if ((bottom < 0) ||
          ((bottom + top + min_regular_size) > vert))
      {
        return False;
      }
      break;
     case IDD_PageSize_Left:
      if ((left < 0) ||
          ((left + right + min_regular_size) > horiz))
      {
        return False;
      }
      break;
     case IDD_PageSize_Right:
      if ((right < 0) ||
          ((right + left + min_regular_size) > horiz))
      {
        return False;
      }
      break;
     default:
      break;
    }
  }
  return True;
}

void 
PageSizeDialog::SwapVH()
{
  int const lenv=32;
  int const lenh=32;
  char bufv[lenv+1];
  char bufh[lenh+1];
  
  done_updating = False;
  bufv[lenv] = '\0';
  bufh[lenh] = '\0';
  GetItemText(IDD_PageSize_Vert, bufv, lenv);
  GetItemText(IDD_PageSize_Horiz, bufh, lenh);
  SetItemText(IDD_PageSize_Vert, bufh);
  SetItemText(IDD_PageSize_Horiz, bufv);
  done_updating = True;
}

void 
PageSizeDialog::ResetName(int ID)
{
  if (SendItemMessage(ID, EM_GETMODIFY) && (done_updating == True))
  {
    if ((ID == IDD_PageSize_Vert) || 
        (ID == IDD_PageSize_Horiz))
    {
      SendItemMessage(IDD_PageSize_Type, CB_SETCURSEL ,PageSize::UserSize);
      paper_name = PageSize::UserSize;
    }
  }
}

void 
PageSizeDialog::ChangeKind(PageSize::Kind newkind, bool init)
{
  int const len=32;
  char buf[len+1];
  buf[len] = '\0';
  
  if (newkind <= PageSize::UserSize) 
  {
    if (init == False) 
    {
      Vector size = PageSize::GetSize(newkind, orient);
      vert  = iu_to_mm0(size.y);
      horiz = iu_to_mm0(size.x);
      if (::GetKeyState(VK_SHIFT) & 0x8000)
      {
        top    = iu_to_mm0(PageSize::GetTopMargin(newkind, orient));
        bottom = iu_to_mm0(PageSize::GetBottomMargin(newkind, orient));
        left   = iu_to_mm0(PageSize::GetLeftMargin(newkind, orient));
        right  = iu_to_mm0(PageSize::GetRightMargin(newkind, orient));
      }
      else
      {
        Margin m(mm0_to_iu(top), mm0_to_iu(bottom), 
		  mm0_to_iu(left), mm0_to_iu(right));
        PageSize::GetProperMargin(m, size);
        top    = iu_to_mm0(m.GetTop());
        bottom = iu_to_mm0(m.GetBottom());
        left   = iu_to_mm0(m.GetLeft());
        right  = iu_to_mm0(m.GetRight());
      }
    }
  }
  
  set_item_mm0(this->GetHandle(), IDD_PageSize_Vert, vert);
  set_item_mm0(this->GetHandle(), IDD_PageSize_Horiz, horiz);
  set_item_mm0(this->GetHandle(), IDD_PageSize_Top, top);
  set_item_mm0(this->GetHandle(), IDD_PageSize_Bottom, bottom);
  set_item_mm0(this->GetHandle(), IDD_PageSize_Left, left);
  set_item_mm0(this->GetHandle(), IDD_PageSize_Right, right);
  if (orient == PageSize::Portrait)
  {
    set_item_check(IDD_PageSize_VO);
  }
  else
  {
    set_item_check(IDD_PageSize_HO);
  }
  paper_name = newkind;
}

Iunit PageSizeDialog::GetHoriz()  { return mm0_to_iu(horiz); }
Iunit PageSizeDialog::GetVert()   { return mm0_to_iu(vert); }
Iunit PageSizeDialog::GetTop()    { return mm0_to_iu(top); }
Iunit PageSizeDialog::GetBottom() { return mm0_to_iu(bottom); }
Iunit PageSizeDialog::GetLeft()   { return mm0_to_iu(left); }
Iunit PageSizeDialog::GetRight()  { return mm0_to_iu(right); }

// ------------------------------------------------------------
// class HeaderDialog

HeaderDialog::HeaderDialog(word all, word cur, word start_page)
{
  this->class_name = "HeaderDialog";
  HeaderDialog::all = all;
  HeaderDialog::cur = cur;
  HeaderDialog::start_page = start_page;
}

LRESULT_T
HeaderDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    SendItemMessage(IDD_Value + 0, BM_SETCHECK, all);
    SendItemMessage(IDD_Value + 1, BM_SETCHECK, !all);
    SendItemMessage(IDD_Value + 2, BM_SETCHECK, cur);
    SendItemMessage(IDD_Value + 3, BM_SETCHECK, !cur);
    EnableWindow(GetItem(IDD_Value + 2), all);
    EnableWindow(GetItem(IDD_Value + 3), all);
    EnableWindow(GetItem(IDD_Value + 4), all);
    EnableWindow(GetItem(IDD_Value + 5), all);
    set_item_int(GetHandle(), IDD_Value + 4, start_page);
    break;
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case(IDD_Value):
     case(IDD_Value + 1):
      all = (word)get_item_check(IDD_Value);
      EnableWindow(GetItem(IDD_Value + 2), all);
      EnableWindow(GetItem(IDD_Value + 3), all);
      EnableWindow(GetItem(IDD_Value + 4), all);
      EnableWindow(GetItem(IDD_Value + 5), all);
      break;
      
     case(IDD_Value + 4):
      all = (word)get_item_check(IDD_Value);
      if (all)
      {
	int p;
	if (get_item_int(GetHandle(), IDD_Value + 4, &p))
	{
	  EnableWindow(GetItem(IDOK), True);
	}
	else
	{
	  EnableWindow(GetItem(IDOK), False);
	}
	start_page = (word)p;
      }
      break;

     case IDOK:
      all = (word)get_item_check(IDD_Value);
      cur = (word)get_item_check(IDD_Value + 2);
      if (all)
      {
	int p;
	if (get_item_int(GetHandle(), IDD_Value + 4, &p))
	{
	  End(1);
	}
	else
	{
	  End(0);
	}
	start_page = p;
      }
      else
      {
	End(1);
      }
      break;
			
     case IDCANCEL:
      End(0);
      break;
      
     default:
      return 0;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    break;
				
   default: 
    return 0;
  }
  return 1;
}

// ------------------------------------------------------------
// class PageNoDialog

PageNoDialog::PageNoDialog(int initial)
{
  this->class_name = "PageNoDialog";
  start_page = initial;
}

LRESULT_T
PageNoDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    SendItemMessage(IDD_Value, EM_LIMITTEXT, 3);
    SetItemInt(IDD_Value, start_page);
    
    return 1;
    
    // WM_CLOSE comes when the user closes the box with the Close
    // command from the control menu
    
   case WM_CLOSE:
    End(0);
    return 1;
    
   case WM_COMMAND:		// OK button
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDD_Value:
      EnableWindow(GetItem(IDOK), IsGood(IDD_Value, start_page));
      break;
      
     case IDOK: 
      RetrieveValue();
      End(1);
      break;
      
     case IDCANCEL:
      // on Cancel, do not save new settings
      End(0);
      return 1;
      
     default:
      break;
    }
  }
  return 0;
}


bool 
PageNoDialog::IsGood(unsigned int ID, int& result)
{
  bool ok;
  BOOL translated;
  const int buflen = 64;
  char test_string[buflen+1];
  
  result=GetItemInt(ID, &translated);
  if (!translated)
  {
    GetItemText(ID, test_string, buflen);
    if (!*test_string) 
    {
      ok = true;
    }	
    else
    {
      ok = false;
    }
  }
  else
  {
    ok = true;
  }
  return ok;
}

void 
PageNoDialog::RetrieveValue()
{
  IsGood(IDD_Value, start_page);
}

void 
PageNoDialog::GetValues(int& start_p)
{
  start_p = start_page;
}

// ------------------------------------------------------------
// class DefLayoutDialog

DefLayoutDialog::DefLayoutDialog()
{
  this->class_name = "DefLayoutDialog";
  LayoutName[0] = '\0';
}

LRESULT_T
DefLayoutDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    SendItemMessage(IDD_LayoutName, EM_LIMITTEXT, LAYOUTNAMELEN);
    SetItemText(IDD_LayoutName, LayoutName);
    return(1);
    
    // WM_CLOSE comes when the user closes the box with the Close
    // command from the control menu
   case WM_CLOSE:
    End(0);
    break;
    
   case WM_COMMAND:		// OK button
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
      GetItemText(IDD_LayoutName, LayoutName, LAYOUTNAMELEN + 1);
      End(1);
      break;
      
     case IDD_LayoutName:
      {
#ifdef _WIN32
	switch (HIWORD(wParam))
#else /* _WIN32 */
	switch (HIWORD(lParam))
#endif /* _WIN32 */
	{
	 case EN_UPDATE:
	 case EN_CHANGE:
	  {
	    EnableWindow(GetItem(IDOK),
			  GetItemText(IDD_LayoutName
				       , LayoutName, LAYOUTNAMELEN + 1));
	  }
	  break;
	 default:
	  break;
	}
      }
      break;
      
     case IDCANCEL:
      End(0);
      break;
    }
    break;
  }
  return(0);
}

// ------------------------------------------------------------
// class ChangeLayoutDialog

ChangeLayoutDialog::ChangeLayoutDialog(LayoutTemplate* current_lt,
					uword min_gate_num,
					uword current_gate_num)
{
  this->class_name = "ChangeLayoutDialog";
  ChangeLayoutDialog::current_lt = current_lt;
  ChangeLayoutDialog::min_gate_num = min_gate_num;
  ChangeLayoutDialog::current_gate_num = current_gate_num;
  replace_one_page = False;
}

void 
ChangeLayoutDialog::InitDialog()
{
  // initialize list box
  // Tell the listbox NOT to update its display & empty it.
  SendItemMessage(IDD_ChangeLayout_List, WM_SETREDRAW);
  SendItemMessage(IDD_ChangeLayout_List, LB_RESETCONTENT);
  
  // set layout name list
  {
    GetLayoutEntry gle;
    char* layout_name;
    uword cursel = 0;
    uword n = 0;
    while ((layout_name = gle.GetNextEntryName()) != 0)
    {
      SendItemMessage(IDD_ChangeLayout_List, LB_INSERTSTRING, -1, 
		       Ptr2Long(layout_name));
      if (gle.GetLayoutTemplate() == current_lt)
      {
	cursel = n;
      }
      n++;
    }
    SendItemMessage(IDD_ChangeLayout_List, LB_SETCURSEL, cursel);
  }
  
  // Tell the listbox that it is now OK to update its display.
  SendItemMessage(IDD_ChangeLayout_List, WM_SETREDRAW, TRUE);
  // Force the listbox to be completely redrawn.
  ::InvalidateRect(GetItem(IDD_ChangeLayout_List), NULL, TRUE);
  
  // set flow num
  SetFlowNum(0);
  
  // set current layout name
  uword lt_num = LayoutManager::GetLayoutID(current_lt);
  SetItemText(IDD_ChangeLayout_CLayout,
	       LayoutManager::GetEntryName(lt_num));
  
  char buf[10];
  wsprintf(buf, "%d", current_gate_num);
  SetItemText(IDD_ChangeLayout_CFlowNum, buf);
  wsprintf(buf, "%d", min_gate_num);
  SetItemText(IDD_ChangeLayout_CFlowNum2, buf);
}

LRESULT_T
ChangeLayoutDialog::WndProc(MSG_T wMsg, WPARAM_T wParam, LPARAM_T lParam) 
{
  switch (wMsg) 
  {
   case WM_INITDIALOG:
    InitDialog();
    break;
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam) 
#endif /* _WIN32 */
    {
     case IDD_ChangeLayout_1PageCheck:
      break;
      
     case IDD_ChangeLayout_List:
      {
#ifdef _WIN32
	if (HIWORD(wParam) != LBN_DBLCLK)
#else /* _WIN32 */
	if (HIWORD(lParam) != LBN_DBLCLK)
#endif /* _WIN32 */
	{
	  if (CheckItem())
	  {
	    EnableWindow(GetItem(IDOK), True);
	  }
	  else
	  {
	    EnableWindow(GetItem(IDOK), False);
	  }
  	  break;
	}
      }    
      // fall through    
     case IDOK:
      {
	if (CheckItem())
	{
	  replace_one_page = !!get_item_check(IDD_ChangeLayout_1PageCheck);
	  EnableWindow(GetItem(IDOK), True);
	  End(1);  
	}
	else
	{
	  EnableWindow(GetItem(IDOK), False);
	  End(0);
	}
      }
      break;
      
     case IDCANCEL:
      End(0);
      break;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    break;
    
   default: 
    return 0;
  }
  return 1;
}

void NEAR
ChangeLayoutDialog::SetFlowNum(uword layout_id)
{
  uword n = LayoutManager::GetGateSize(layout_id);
  char buf[5];
  wsprintf(buf, "%4d", n);
  SetItemText(IDD_ChangeLayout_FlowNum, buf);
  SendItemMessage(IDD_ChangeLayout_FlowNum, WM_SETREDRAW, TRUE);
  ::InvalidateRect(GetItem(IDD_ChangeLayout_FlowNum), NULL, TRUE);
  
  SetItemText(IDD_ChangeLayout_DocName, 
	       LayoutManager::GetEntryDocName(layout_id));
  SendItemMessage(IDD_ChangeLayout_DocName, WM_SETREDRAW, TRUE);
  ::InvalidateRect(GetItem(IDD_ChangeLayout_DocName), NULL, TRUE);
}

bool NEAR
ChangeLayoutDialog::CheckItem()
{
  layout_id = (uword) SendItemMessage(IDD_ChangeLayout_List, LB_GETCURSEL);
  SetFlowNum(layout_id);
  uword flow_num = LayoutManager::GetGateSize(layout_id);
  return flow_num >= min_gate_num;
}

// ------------------------------------------------------------
// class NewSectionDialog

NewSectionDialog::NewSectionDialog()
{
  this->class_name = "NewSectionDialog";
  next_page = True;
}

LRESULT_T 
NewSectionDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    set_item_check(IDD_Value);
    SendItemMessage(IDD_Value2, BM_SETCHECK);
    break;
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDD_Value:
      break;
      
     case IDOK: 
      next_page = (bool)(get_item_check(IDD_Value) != 0);
      End(1);
      break;
      
     case IDCANCEL:
      End(0);
      break;
      
     default:
      return 0;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    break;
    
   default:
    return 0;
  }
  return 1;
}

// ------------------------------------------------------------
// class ChangeLayoutNameDialog

ChangeLayoutNameDialog::ChangeLayoutNameDialog()
{
  this->class_name = "ChangeLayoutNameDialog";
  layout_id = 0;
}

LRESULT_T 
ChangeLayoutNameDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    {
      SendItemMessage(IDD_Value, WM_SETREDRAW);
      SendItemMessage(IDD_Value, LB_RESETCONTENT);
      GetLayoutEntry gle;
      char* layout_name;
      while ((layout_name = gle.GetNextEntryName()) != 0)
      {
	SendItemMessage(IDD_Value, LB_INSERTSTRING, -1, 
			 Ptr2Long(layout_name));
      }
      SendItemMessage(IDD_Value, LB_SETCURSEL);
      SendItemMessage(IDD_Value, WM_SETREDRAW, TRUE);
      ::InvalidateRect(GetItem(IDD_Value), NULL, TRUE);
      
      SetItemText(IDD_Value2, LayoutManager::GetEntryName(0));
    }
    break;
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDD_Value:
#ifdef _WIN32
      if (HIWORD(wParam) == LBN_SELCHANGE)
#else /* _WIN32 */
      if (HIWORD(lParam) == LBN_SELCHANGE)
#endif /* _WIN32 */
      {
	layout_id = (uword)SendItemMessage(IDD_Value, LB_GETCURSEL);
	SetItemText(IDD_Value2, LayoutManager::GetEntryName(layout_id));
      }
      break;
      
     case IDD_Value2:
      GetItemText(IDD_Value2, name, LAYOUTNAMELEN + 1);
      if (strlen(name) == 0)
      {
	EnableWindow(GetItem(IDOK), False);
      }
      else
      {
	EnableWindow(GetItem(IDOK), True);
      }
      break;
      
     case IDOK: 
      layout_id = (uword)SendItemMessage(IDD_Value, LB_GETCURSEL);
      GetItemText(IDD_Value2, name, LAYOUTNAMELEN + 1);
      End(strlen(name) == 0 ? 0 : 1);
      break;
      
     case IDCANCEL:
      End(0);
      break;
      
     default:
      return 0;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    break;
    
   default:
    return 0;
  }
  return 1;
}
