// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: layoutte.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// LayoutTemplate class
// A LayoutTemplate talks about how a certain kind of page or
// page-group is laid out, that is, what Frame(Templates) it contains.

#ifndef LAYOUTTE_H
#define LAYOUTTE_H

#include "frameown.h"

class FrameScriptRep;
class FrameTemplate;
class LayoutScript;
class VDisplay;
class Document;
class BluePrint;
class DocumentContent;

#ifndef FTLIST_DEFINED
class FTList;				// forword ref.
#endif

class LayoutTemplate 
  : public FrameOwner
{
public:
  enum 
  {
    OldLayoutNameSize = 20,		// layout name buffer size
    LayoutNameSize = 32,		// layout name buffer size
  };
  
  // layout kind
  enum Kind 
  {
    RegularTemplate  = 0,		// for plane page
    PageSizeTemplate = 1,		// for pagesize
    TableTemplate    = 2,		// for table
  };
  
private:
  
  // document
  DocumentContent* doc;
  
  // layout width
  Iunit width;
  
  // layout height
  Iunit height;
  
  // single-threaded list of my ft's.
  FrameTemplate* first_ft;
  
  // list of flow gate
  FTList* gate_list;
  
  // template kind
  Kind kind;
  
  // reference count
  uword ref_count;
  
  // layout name
  char layout_name[LayoutNameSize + 1];
  
  // document name flag
  bool doc_name;
  
  // file save version
  enum 
  { 
    old_namelen_save_version = 1,
    save_version = 2
  };

  // ------------------------------
  // frame-template update functions
  // These methods calls are requested by fission.
protected:
  
  // update frame
  void UpDate();
  
  // object create
  // FrameObject* CreateFrameObject(FrameObject* src , CrossPoint* cp);
  
  // retion change
  // void ChangeFrameObject(FrameObject* fo);
  
  // object vanished
  // void VanishFrameObject(FrameObject* fo);
  
  // create new flow gate
  FrameObject* CreateNewGate(CrossPoint* cp);
  
  // cange flow
  // void ChangeFlow(FrameObject* from, FrameObject* to);
  
  // create new flow
  FrameObject* CreateNewFlow(CrossPoint* cp);
  
  // update fission frame size
  void UpdateSize();
  
  // get proper virtical border
  uword GetProperVBorder(CrossPoint* cp, uword index);
  
  // get proper horizontal border
  uword GetProperHBorder(CrossPoint* cp, uword index);
  
private:
  
  // remove from pipe
  void RemoveFromPipe(FrameTemplate* ft);

  // ------------------------------

public:	
  // copy constructor, for layout definition
  LayoutTemplate(DocumentContent* doc, LayoutTemplate* lt, char* name);
  
  // constructor for new file load
  LayoutTemplate(DocumentContent* doc, BluePrint* bp, Kind k, char* name = 0);
  
  // destructor
  ~LayoutTemplate();
  
  // kill all frames
  void KillAllFrames();
  
  // get document content
  DocumentContent* GetDocumentContent() 
  {
    return doc;
  }
  
  // get reference count
  uword GetRefCount() 
  {
    return ref_count;
  }
  
  // increment reference count
  void IncRefCount() 
  {
    ref_count++;
  }
  
  // decrement reference count
  void DecRefCount();
  
  // get template kind
  Kind GetKind() 
  {
    return kind;
  }
  
  // check table template
  bool IsTable()
  {
    return kind == TableTemplate;
  }
  
  // check zeropage
  bool IsZeroPage()
  {
    return kind == PageSizeTemplate;
  }
  
  // check regular
  bool IsRegular()
  {
    return kind == RegularTemplate;
  }
  
  // ------------------------------
  // frame-instance updater
  
  // update all frame-instance when create frame-template
  void FI_CreateFrameTemplate(FrameTemplate* prev, FrameTemplate* ft);
  
  // update all frame-instance when vanish frame-template
  void FI_VanishFrameTemplate(FrameTemplate* vanish_ft);
  
private:
  // remove instance
  // remove frame-instance, text-flow and page-map gate
  void RemoveInstance(PageMap* pm, FrameTemplate* vanish_ft);
  
public:
  // check vanish frame
  // if the vanish_ft is the only one frame-template of the document
  // return False
  bool FI_CheckVanishFrameTemplate(FrameTemplate* vanish_ft);
  
  // update all frame-instance(when size changed, ...)
  void DelayFormatFrame(FrameTemplate* ft);
  
  // update changed next frame
  // changed	: changed frame
  void FI_ChangedNext(FrameTemplate* changed);
  
public:
  // ------------------------------
  // gate interface

  // gate size
  uword GetGateSize();
  
  // gate index(search)
  uword GetGateNumber(FrameTemplate* ft);
  
  // which gate frame-template
  uword WhichGateFT(FrameTemplate* ft);
  
  // check gate frame
  bool IsGateFT(FrameTemplate* ft);
  
  // get gate frame template
  FrameTemplate* GetGateFT(uword n);
  
  // add
  void AddGate(FrameTemplate* ft);
  
  // remove by index
  void RemoveGate(uword n);
  
  // replace gate
  void ReplaceGate(uword index, FrameTemplate* new_ft);
  
  // list of flow gate
  // don't change gate_list contents
  FTList* GetGateList() 
  { return gate_list; }

  // ------------------------------
  // frame template interface

  // get first frame-template
  FrameTemplate* GetFirstFT() 
  { return first_ft; }
  
  // add frame template
  FrameTemplate* AddFrameTemplate(FrameTemplate* ft);
  // return		: previous first_ft
  
  // remove frame template
  void RemoveFrameTemplate(FrameTemplate* ft);
  
  // ------------------------------
  // size interface

  // get width
  Iunit GetWidth() 
  {
    return width;
  }
  
  // get height
  Iunit GetHeight() 
  {
    return height;
  }

  // ------------------------------
  // layout name interface

  // get layout name
  char* GetLayoutName();
  
  // set layout name
  void SetLayoutName(char* name);
  
  // check document name flag
  bool IsDocumentName() 
  { return doc_name; }
  
  // ------------------------------
  // file save & read
  
  // save
  // ps		: stream
  void WriteToStream(PStream* ps);
  
  // load
  // ps		: stream
  // result		: error
  static LayoutTemplate* ReadFromStream(PStream* ps, DocumentContent* doc);
  
  // confirm read all
  // when this function returns False, 
  // this layout has unreadable frame object.
  // because of the less memory. 
  bool ConfirmReadAll();
};

#endif /* LAYOUTTE_H */
