// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: linesele.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class LineSelection
// line selection management class for frame editor

#ifndef LINESEL_H
#define LINESEL_H

class Fission;
class CrossPoint;
class LayoutTemplate;

// line-selection data
class LineSelection 
{
  // which layout-template
  LayoutTemplate* lt;
  
  // which fission
  Fission* f;
  
  // start crosspoint
  CrossPoint* start;
  
  // end crosspoint
  CrossPoint* end;
  
public:
  // constructor
  // when the start and end crosspoint is 0, it meens that selection 
  // is the hole of the fission.
  // lt	: layout-template
  // f		: fission
  // start	: start crosspoint
  // end	: end crosspoint
  LineSelection(LayoutTemplate* lt, Fission* f, 
                 CrossPoint* start = 0, CrossPoint* end = 0);
  
  // destructor
  ~LineSelection() 
  { ; }
  
  // get layout template
  LayoutTemplate* GetLayoutTemplate() 
  {
    return lt;
  }
  
  // get selected fission
  Fission* GetFission() 
  {
    return f;
  }
  
  // get start crosspoint
  CrossPoint* GetStartCrossPoint() 
  {
    return start;
  }
  
  // get end crosspoint
  CrossPoint* GetEndCrossPoint() 
  {
    return end;
  }
  
  // get border line index
  uword GetBorderLineIndex();
  
  // set border line index
  void SetBorderLineIndex(uword index);
  
  // clear selection
  // this method clear the crosspoint's selection bit
  void ClearSelection();
  
  // set selection
  // this method set the crosspoint's selection bit
  void SetSelection();
};

#endif /* LINESEL_H */
