// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: lman.cpp,v 3.3 1999/06/20 21:51:26 kudou Exp $
// LayoutManager class
// CAEg̊ǗNXB̃NXׂ͕̂ẴCAEg
// XgĂB̃CAEĝ LayoutEntry NX
// ̃IuWFNggpB

#include "pword.h"
#include "pmenus.h"
#include "gslist.h"
class LayoutEntry;
GSListDeclare(LayoutEntry);
typedef GSList(LayoutEntry)            LEList;
typedef GSListIterator(LayoutEntry)    LEListIterator;
#define LELIST_DEFINED
#include "lman.h"
#include "layoutte.h"
#include "blueprin.h"
#include "docconte.h"
#include "document.h"
#include "xstr.h"

// ------------------------------------------------------------
// layout entry

class LayoutEntry
{
  // doccument
  DocumentContent* doc;
  
  // active layout entry
  LayoutTemplate* lt;
  
  // inactive layout entry
  BluePrint* bp;
  
  // layout name
  char* layout_name;
  
  // blue print gate size
  uword gate_size;
  
public:
  // constructor
  LayoutEntry(LayoutTemplate* lt);
  
  // destructor
  ~LayoutEntry();
  
  // inactivate entry
  void Inactivate();
  
  // check active
  bool IsActive() 
  {
    return bp == 0;
  }
  
  // activate
  void Activate();
  
  // get document content
  DocumentContent* GetDocumentContent() 
  {
    return doc;
  }
  
  // get layout template
  LayoutTemplate* GetLayoutTemplate() 
  {
    return lt;
  }
  
  // get bule print
  BluePrint* GetBluePrint() 
  {
    return bp;
  }
  
  // get layout name
  char* GetName() 
  {
    return layout_name;
  }
  
  // change name
  void ChangeName(char* name);
  
  // get gate size
  uword GetGateSize();
};

// constructor
LayoutEntry::LayoutEntry(LayoutTemplate* lt)
{
  doc = lt->GetDocumentContent();
  LayoutEntry::lt = lt;
  bp = 0;
  layout_name = lt->GetLayoutName();
  gate_size = 0;
}

// destructor
LayoutEntry::~LayoutEntry()
{
  delete bp;
}

// inactivate entry
void 
LayoutEntry::Inactivate()
{
  uword len = strlen(layout_name);
  char* name = new char[len + 1];
  strcpy(name, layout_name);
  layout_name = name;
  bp = new BluePrint(lt->GetFissionFrame());
  gate_size = lt->GetGateSize();
  lt = 0;
}

// activate
void 
LayoutEntry::Activate()
{
  lt = new LayoutTemplate(doc, bp, 
                           LayoutTemplate::RegularTemplate, layout_name);
  delete bp;
  bp = 0;
  delete layout_name;
  layout_name = lt->GetLayoutName();
  gate_size = 0;
}

// change name
void 
LayoutEntry::ChangeName(char* name)
{
  if (IsActive() == False) 
  {
    // name entry change
    delete layout_name;
    uword len = strlen(name);
    layout_name = new char[len + 1];
    strcpy(layout_name, name);
  }
  else 
  {
    // layout templagte name change
    lt->SetLayoutName(name);
  }
}

// get gate size
uword 
LayoutEntry::GetGateSize()
{
  return IsActive() ? lt->GetGateSize() : gate_size;
}

// ------------------------------------------------------------
// get layout enntry

GetLayoutEntry::GetLayoutEntry()
{
  leli = new LEListIterator(LayoutManager::entrys);
  n = 0;
  lt = 0;
}

GetLayoutEntry::~GetLayoutEntry()
{
  delete leli;
}

char* 
GetLayoutEntry::GetNextEntryName()
{
  LayoutEntry* le = (*leli) ();
  if (le == 0)
  {
    return 0;
  }  
  lt = le->GetLayoutTemplate();
  n++;
  LEListIterator leli2(LayoutManager::entrys);
  uword n2 = 0;
  uword same_name = 1;
  LayoutEntry* le2;
  while ((le2 = leli2()) != 0)
  {
    if (++n2 >= n) 
    {
      break;
    }
    if ((le->GetDocumentContent() == le2->GetDocumentContent()) &&
	!strcmp(le->GetName(), le2->GetName())) 
    {
      same_name++;
    }
  }
  
  char* make_name = entry_name;
  wsprintf(make_name, "%s", le->GetName());
  make_name += strlen(make_name);
  
  if (same_name != 1) 
  {
    wsprintf(make_name, " (%d)", same_name);
    make_name += strlen(make_name);
  }
  
//  if (le->IsActive() == False) 
//  {
//    wsprintf(make_name, "*");
//    make_name += 1;
//  }
  
  wsprintf(make_name, S_ExtDocName, 
	    le->GetDocumentContent()->GetDocument()->GetName());
  make_name += strlen(make_name);
  return entry_name;
}

// ------------------------------------------------------------
// layout manager class

LEList* LayoutManager::entrys = new LEList();
bool LayoutManager::add_lock = False;

// all coresspond layouts are removed
void 
LayoutManager::DocumentRemoved(DocumentContent* doc)
{
  bool done_flag;
  do 
  {
    done_flag = False;
    LEListIterator leli(entrys);
    LayoutEntry* le = leli();
    while (le != 0) 
    {
      LayoutEntry* next = leli();
      if (le->GetDocumentContent() == doc) 
      {
	entrys->Delete(le);
	delete le;
	done_flag = True;
	break;
      }
      le = next;
    }
  } while (done_flag);
}

// add layout entry
void 
LayoutManager::AddLayout(LayoutTemplate* lt)
{
  if (add_lock == False) 
  {
    entrys->Inject(new LayoutEntry(lt));
  }
}

// change bulue print entry
void 
LayoutManager::ReportInactiveLayout(LayoutTemplate* lt)
{
  LEListIterator leli(entrys);
  for (LayoutEntry* le = leli(); le != 0; le = leli()) 
  {
    if (le->GetLayoutTemplate() == lt) 
    {
      le->Inactivate();
      break;
    }
  }
}

// get blue print from entry
BluePrint* 
LayoutManager::GetBluePrintEntry(uword layout_id)
{
  LayoutEntry* le = entrys->Access(layout_id + 1);
  return(le == 0) ? 0 : le->GetBluePrint();
}

// get entry layout
LayoutTemplate* 
LayoutManager::GetEntryLayout(uword layout_id)
{
  LayoutEntry* le = entrys->Access(layout_id + 1);
  return(le == 0) ? 0 : le->GetLayoutTemplate();
}

// get entry document
DocumentContent* 
LayoutManager::GetEntryDocumentContent(uword layout_id)
{
  LayoutEntry* le = entrys->Access(layout_id + 1);
  return(le == 0) ? 0 : le->GetDocumentContent();
}

// apply layout check 
// check same document layout and blue print entry
bool 
LayoutManager::CanApplyLayout(DocumentContent* doc, uword layout_id)
{
  LayoutEntry* le = entrys->Access(layout_id + 1);
  if (le == 0) 
  {
    return False;
  }
  if ((le->GetDocumentContent() == doc) && (le->IsActive())) 
  {
    return True;
  }
  return False;
}

// get apply layout
LayoutTemplate* 
LayoutManager::GetApplyLayout(DocumentContent* doc, 
					       uword layout_id)
{
  LayoutTemplate* lt = 0;
  LayoutEntry* le = entrys->Access(layout_id + 1);
  if (le == 0) 
  {
    // layout_id error
    return 0;
  }
  if (le->GetDocumentContent() == doc) 
  {
    // same document
    if (le->IsActive() == False) 
    {
      // apply inactive layout
      add_lock = True;
      le->Activate();
      add_lock = False;
    }
    lt = le->GetLayoutTemplate();
  }
  else 
  {
    // different document
    // generate new layout for this document
    if (le->IsActive()) 
    {
      lt = new LayoutTemplate(doc, le->GetLayoutTemplate(), le->GetName());
    }
    else 
    {
      lt = new LayoutTemplate(doc, le->GetBluePrint(),
			       LayoutTemplate::RegularTemplate,
			       le->GetName());
    }
  }
  return lt;
}

// get entry name
char* 
LayoutManager::GetEntryName(uword layout_id)
{
  LayoutEntry* le = entrys->Access(layout_id + 1);
  return(le == 0) ? 0 : le->GetName();
}

// get entry document name
char*
LayoutManager::GetEntryDocName(uword layout_id)
{
  LayoutEntry* le = entrys->Access(layout_id + 1);
  return(le == 0) ? 0 : le->GetDocumentContent()->GetDocument()->GetName();
}


// change entry name
void 
LayoutManager::ChangeEntryName(uword layout_id, char* name)
{
  LayoutEntry* le = entrys->Access(layout_id + 1);
  if (le != 0) 
  {
    le->ChangeName(name);
  }
}

// how many document
uword 
LayoutManager::GetDocumentNumber()
{
  uword uniq_doc_num = 0;
  LEListIterator leli(entrys);
  uword n = 1;
  LayoutEntry* le;
  while ((le = leli()) != 0)
  {
    DocumentContent* doc = le->GetDocumentContent();
    uword n2 = 1;
    bool uniq = True;
    LEListIterator leli2(entrys);
    for (LayoutEntry* le2 = leli2(); le2 != 0; le2 = leli2()) 
    {
      if (n2 >= n) 
      {
	break;
      }
      if (doc == le2->GetDocumentContent()) 
      {
	// not uniq
	uniq = False;
	break;
      }
      n2++;
    }
    if (uniq == True) 
    {
      uniq_doc_num ++;
    }
    n++;
  }
  return uniq_doc_num;
}

// get gate size
uword 
LayoutManager::GetGateSize(uword layout_id)
{
  LayoutEntry* le = entrys->Access(layout_id + 1);
  return(le != 0) ? le->GetGateSize() : 0;
}

// get layout number
uword
LayoutManager::GetLayoutNumber()
{
  return entrys->Number();
}

// get layout id
uword
LayoutManager::GetLayoutID(LayoutTemplate* lt)
{
  LEListIterator leli(entrys);
  uword n = 0;
  LayoutEntry* le;
  while ((le = leli()) != 0)
  {
    if (le->GetLayoutTemplate() == lt)
    {
      break;
    }
    n++;
  }
  return n;
}
