// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: lman.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// LayoutManager class
// Layout mananement class. This class has list of all layout.
// LayoutEntry class object is used for showing one layout.

#ifndef LMAN_H
#define LMAN_H

class BluePrint;
#ifndef LELIST_DEFINED
class LEList;
class LEListIterator;
#endif

class GetLayoutEntry
{
  LEListIterator* leli;
  LayoutTemplate* lt;
  uword n;
  enum { name_size = 256, };
  char entry_name[name_size];
public:
  GetLayoutEntry();
  ~GetLayoutEntry();
  char* GetNextEntryName();
  LayoutTemplate* GetLayoutTemplate()
  {
    return lt;
  }
};

// hole document's layout management class
class LayoutManager
{
  friend class GetLayoutEntry;
  
  // layout entry
  static LEList* entrys;
  
  // layout add lock
  static bool add_lock;
  
public:
  // all coresspond layouts are removed
  static void DocumentRemoved(DocumentContent* doc);
  
  // add layout entry
  static void AddLayout(LayoutTemplate* lt);
  
  // change bulue print entry
  static void ReportInactiveLayout(LayoutTemplate* lt);
  
  // apply layout check 
  // check same document layout and blue print entry
  // layout_id : 0~
  static bool CanApplyLayout(DocumentContent* doc, uword layout_id);
  
  // get blue print from entry
  static BluePrint* GetBluePrintEntry(uword layout_id);
  
  // get entry layout
  static LayoutTemplate* GetEntryLayout(uword layout_id);
  
  // get entry document
  static DocumentContent* GetEntryDocumentContent(uword layout_id);
  
  // get apply layout
  static LayoutTemplate* GetApplyLayout(DocumentContent* doc, 
					 uword layout_id);
  
  // get entry name
  static char* GetEntryName(uword layout_id);
  
  // get entry document name
  static char* GetEntryDocName(uword layout_id);
  
  // change entry name
  static void ChangeEntryName(uword layout_id, char* name);
  
  // get gate size
  static uword GetGateSize(uword layout_id);
  
  // get layout number
  static uword GetLayoutNumber();
  
  // get layout id
  static uword GetLayoutID(LayoutTemplate* lt);

private:
  // how many document
  static uword GetDocumentNumber();
};

#endif /* LMAN_H */
