// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: maketabl.cpp,v 3.4 2000/05/13 16:29:02 kudou Exp $
// class EditFrame
// t[GfB^̃e[u쐬[h

#include "pword.h"
#include "editfram.h"
#include "bufnew.h"
#include "docedit.h"
#include "docsel.h"
#include "document.h"
#include "docwindo.h"
#include "framedlg.h"
#include "frameown.h"
#include "interval.h"
#include "intlist.h"
#include "layoutin.h"
#include "layoutte.h"
#include "mcursor.h"
#include "mwindow.h"
#include "objectid.h"
#include "panel.h"
#include "picture.h"
#include "pmenus.h"
#include "pwordpre.h"
#include "table.h"
#include "tablepnl.h"
#include "vdisplay.h"
#include "xstr.h"

void NEAR 
EditFrame::MakeTable_LDWN(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  //
  // fix start position
  //
  if (!CheckPanelNumMax()) 
  {
    // panel code over flow
    ::MessageBeep(0);
    CancelMakeTable();
    return;
  }
  
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  FrameObject* fo = 0;
  BufferPointer* bp = 0;
  if ((LockLayout(mpos) == 0) || 
      ((fo = FindFrameObjectW(mpos)) == 0) ||
      (fo->GetObjectID() != IDTextObject) ||
      ((bp = FindBufferPointerW(mpos)) == 0)) 
  {
    CancelMakeTable();
    return;
  }
  MouseCursor::Table();
  Vector mpos_v = WtoIv(mpos);
  mktbl.Start(fo, bp, mpos_v);
  RedisplayMakeTable();		// draw
}

void NEAR 
EditFrame::MakeTable_MV(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  if (mktbl.IsFixed() == False) 
  {
    // idle
    mktbl.Reset();
    VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
    FrameObject* fo = 0;
    BufferPointer* bp = 0;
    if ((LockLayout(mpos) == 0) || 
	((fo = FindFrameObjectW(mpos)) == 0) ||
	(fo->GetObjectID() != IDTextObject) ||
	((bp = FindBufferPointerW(mpos)) == 0)) 
    {
      MouseCursor::TableOff();
    }
    else 
    {
      MouseCursor::Table();
      if (bp != 0) 
      {
	delete bp;
      }
    }
  }
  else 
  {
    // size change
    VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
    MouseCursor::Table();
    RedisplayMakeTable();		// vanish
    Vector mpos_v = WtoIv(mpos);
    mktbl.Move(mpos_v);
    RedisplayMakeTable();		// display
    ShowTableSize(mktbl.GetFromPos(), mktbl.GetToPos());
  }
}

void NEAR 
EditFrame::MakeTable_LUP(WPARAM_T wParam, LPARAM_T lParam)
{
  if (mktbl.IsFixed() == False)
  {
    CancelMakeTable(False);
    return;
  }
  // make table
  WndProcMakeTable(window, WM_MOUSEMOVE, wParam, lParam);
  
  FrameTemplate* ft = (FrameTemplate*)mktbl.GetFrameObject();
  FrameInstance* fi = GetEditLI()->FindFIByFT(ft);
  if (fi == 0) 
  {
    // can't find frame
    CancelMakeTable();
    return;
  }
  Vector i_from = mktbl.GetFromPos();
  Vector i_to   = mktbl.GetToPos();
  
  Iunit width = (i_from.x < i_to.x) ? (i_to.x - i_from.x) :
  (i_from.x - i_to.x);
  Iunit height = (i_from.y < i_to.y) ? (i_to.y - i_from.y) :
  (i_from.y - i_to.y);
  
  if ((width < TablePanel::GetMinTableSize()) || 
      (height < TablePanel::GetMinTableSize()) ||
      (width > TablePanel::GetMaxTableSize()) ||
      (height > TablePanel::GetMaxTableSize())) 
  {
    // too small or big
    CancelMakeTable();
    return;
  }
  
  DocumentContent* doc_conte = doc->GetDocumentContent();
  BufferPointer* bp = mktbl.GetBufferPointer();
  mktbl.Reset();
  if ((wParam & MK_CONTROL) || (wParam & MK_SHIFT)) 
  {
    // create graphic
    Picture* pic = Picture::GetClipBoardPicture();
    
    // create graphic object
    if (pic) 
    {
      RedisplayMakeTable();		// vanish
      // create table
      TablePanel* pnl = 
      new TablePanel(doc_conte, bp, width, height, pic);
      pnl->InsertPanel();
      SetDirty();
    }
    else 
    {
      PWordPresentation::StatusOut(S_NoBitmapInClipboard);
      CancelMakeTable();
    }
  }
  else 
  {
    SplitFrameDialog tablemake_dialog(1 /*dummy*/);
    RedisplayMakeTable();		// vanish
    if (tablemake_dialog.Go()) 
    {
      // run dialog box
      // clear dialog region
      main_window->Update();
      // create table
      uword column = tablemake_dialog.GetValue();
      uword row = tablemake_dialog.GetValue2();
      bool wait_cursor = ((column * row) >= 10) ? True : False;
      if (wait_cursor) 
      {
	MouseCursor::StartLongActivity();
      }
      TablePanel* tp = 
      new TablePanel(doc_conte, bp, width, height, column, row);
      if (wait_cursor) 
      {
	MouseCursor::EndLongActivity();
      }
      PWordPresentation::StatusOut(S_TableCreated);
      PageMap* pm = tp->GetLayout()->GetPageMap();
      TextFlow* tf = pm->GetGateTF(1);
      if (tf != 0) 
      {
	window->GetEditor()
	->GetSelectionStack()
	->InstallSelection(new IntervalList(new Interval(tf)));
      }
      PWordPresentation::ChangeEditMode(InputText_MODE);
      SetDirty();
    }
  }
  delete bp;
  MouseCursor::Table();
  mktbl.Reset();
}

void
EditFrame::WndProcMakeTable(DocumentWindow* window, 
			     MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  EditFrame::window = window;
  switch (Msg) 
  {
   case WM_LBUTTONDOWN:
    MakeTable_LDWN(wParam, lParam);
    break;
    
   case WM_MOUSEMOVE:
    MakeTable_MV(wParam, lParam);
    break;
    
   case WM_LBUTTONUP:
    MakeTable_LUP(wParam, lParam);
    break;
    
   case WM_RBUTTONDOWN:
    CancelMakeTable(False);
    break;
  }
}

void 
EditFrame::CancelMakeTable(bool beep)
{
  if (mktbl.IsFixed()) 
  {
    RedisplayMakeTable();		// vanish
  }
  MouseCursor::TableOff();
  delete mktbl.GetBufferPointer();
  mktbl.Reset();
  if (beep) 
  {
    ::MessageBeep(0);
  }
}

// display draw-line object
void 
EditFrame::RedisplayMakeTable()
{
  HWND hWnd = window->GetHandle();
  HDC hDC = GetDC(hWnd);
  RedisplayMakeTable(hDC);
  ReleaseDC(hWnd, hDC);
}

// display drawing line
void 
EditFrame::RedisplayMakeTable(VDisplay* vdsp)
{
  if (mktbl.IsFixed()) 
  {
    RedisplayMakeTable(vdsp->GetDC());
  }
}

// display draw-line object
void 
EditFrame::RedisplayMakeTable(HDC hDC)
{
  //
  // [1]            [2]
  //  O--------------O
  //  |              |
  //  |              |
  //  |              |
  //  O--------------O
  // [3]            [4]
  //
  VectW p1 = ItoWv(mktbl.GetFromPos());
  VectW p4 = ItoWv(mktbl.GetToPos());
  SetROP2(hDC, R2_NOT);
  // [1] - [2]
#ifdef _WIN32
  MoveToEx(hDC, p1.x, p1.y, NULL);
#else /* _WIN32 */
  MoveTo(hDC, p1.x, p1.y);
#endif /* _WIN32 */
  LineTo(hDC, p4.x, p1.y);
  // [2] - [4]
  LineTo(hDC, p4.x, p4.y);
  // [4] - [3]
  LineTo(hDC, p1.x, p4.y);
  // [3] - [1]
  LineTo(hDC, p1.x, p1.y);
}

// find buffer pointer
BP* 
EditFrame::FindBufferPointerW(VectW& vw)
{
  DocumentWindow* window = this->window;
  Dpoint dp[1];
  Lpoint lp[1];
  SET_POINT(dp, vw.x, vw.y);
  window->dpoint_to_lpoint(dp, lp);
  return(window->navigate_bp(lp, NULL, NULL));
}
