// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: margin.cpp,v 3.5 2000/05/13 16:29:02 kudou Exp $
// class EditFrame
// t[GfB^̒i]ҏW[h

#include "pword.h"
#include "editfram.h"
#include "attribut.h"
#include "bufnew.h"
#include "docedit.h"
#include "docwindo.h"
#include "epa.h"
#include "frameins.h"
#include "frametem.h"
#include "layoutin.h"
#include "layoutte.h"
#include "line.h"
#include "mcursor.h"
#include "pmenus.h"
#include "rect.h"
#include "vdisplay.h"

// Aliases for tategaki
#define index_top index_x
#define index_bot index_y
#define index_width index_x
#define index_height index_y
#define index_horizontal index_x
#define index_vertical index_y

#define TOP_X(r) RECT_UNIT(r, INDEX_TOP, index_x)
#define BOT_X(r) RECT_UNIT(r, INDEX_BOT, index_x)
#define TOP_Y(r) RECT_UNIT(r, index_top, index_y)
#define BOT_Y(r) RECT_UNIT(r, index_bot, index_y)

class NavPMargin
{
  Paragraph* ph;
  FrameInstance* fi;
  Line* ln;
  Vector from;
  Vector to;
  Dunit offset;
  EMSetMargin::LockMargin lm;
  bool tate_p;
  
public:
  // constructor
  NavPMargin();
  
  // accessor
  Paragraph* GetParagraph() { return ph; }
  FrameInstance* GetFrameInstance() { return fi; }
  Line* GetLine() { return ln; }
  Vector& GetFromVector() { return from; }
  Vector& GetToVector() { return to; }
  Dunit GetOffset() { return offset; }
  EMSetMargin::LockMargin GetSetMargin() { return lm; }
  bool GetTateP() { return tate_p; }
  
  // mutator
  void SetParagraph(Paragraph* _ph) { ph = _ph; }
  void SetFrameInstance(FrameInstance* _fi) { fi = _fi; }
  void SetLine(Line* _ln) { ln = _ln; }
  void SetFromVector(Vector& v) { from = v; }
  void SetToVector(Vector& v) { to = v; }
  void SetOffset(Dunit d) { offset = d; }
  void SetSetMargin(EMSetMargin::LockMargin m) { lm = m; }
  void SetTateP(bool p) { tate_p = p; }
};

NavPMargin::NavPMargin()
{
  ph = 0;
  fi = 0;
  ln = 0;
  offset = 0;
  lm = EMSetMargin::Idle;
  tate_p = False;
};

void
EditFrame::WndProcSetMargin(DocumentWindow* window, 
			     MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  EditFrame::window = window;
  switch (Msg) 
  {
   case WM_LBUTTONDOWN:
    SetMargin_LDWN(wParam, lParam);
    break;
    
   case WM_MOUSEMOVE:
    SetMargin_MV(wParam, lParam);
    break;
    
   case WM_LBUTTONUP:
    SetMargin_LUP(wParam, lParam);
    break;
    
   case WM_RBUTTONDOWN:
    CancelMargin(False);
    break;
  }
}

void NEAR 
EditFrame::SetMargin_LDWN(WPARAM_T wParam, LPARAM_T lParam)
{
  // start margin set
  setmgn.Reset();
  ClearMouseOffset();
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  NavPMargin nav;
  if ((LockLayout(mpos) == 0) || 
      !FindParagraphMarginW(mpos, nav))
  {
    CancelMargin();
    return;
  }
  bool tate_p = nav.GetTateP();
  setmgn.Start(nav.GetSetMargin(), 
		nav.GetParagraph(), 
		nav.GetFrameInstance(), 
		nav.GetLine(),
		nav.GetFromVector(),
		nav.GetToVector(),
		tate_p);
  if (tate_p)
  {
    SetMouseYOffset(nav.GetOffset());
  }
  else
  {
    SetMouseXOffset(nav.GetOffset());
  }
  ClearEffective();
  
  // sift
  if (!(wParam & MK_SHIFT)) 
  {
    switch (nav.GetSetMargin())
    {
     case EMSetMargin::FirstMargin:
#ifdef MARGIN_SET_WITH_LEFT
      setmgn.SetWithLeft();
#endif
      break;
      
     case EMSetMargin::LeftMargin:
      setmgn.SetWithFirst();
      break;
      
     case EMSetMargin::RightMargin:
      setmgn.SetWithAll();
      break;
    }
  }
  
  int xy_idx = tate_p ? INDEX_Y : INDEX_X;
  Iunit l_limit, u_limit;
  Irect rec;
  nav.GetFrameInstance()->get_drawing_irect(&rec);
  Iunit first_left_mgn = 0;
  Iunit left_mgn = 0;
  Iunit right_mgn = 0;
  GetParagraphMargin(first_left_mgn, left_mgn, right_mgn);
  switch (nav.GetSetMargin())
  {
   case EMSetMargin::FirstMargin:
    {
      l_limit = RECT_UNIT(&rec, INDEX_TOP, xy_idx);
      u_limit = RECT_UNIT(&rec, INDEX_BOT, xy_idx) - 1 - right_mgn;
#ifdef MARGIN_SET_WITH_LEFT
      if (setmgn.GetWithLeft())
      {
	if (first_left_mgn >= 0)
	{
	  l_limit += first_left_mgn;
	}
	else
	{
	  u_limit -= first_left_mgn;
	}
      }
#endif
    }
    break;
    
   case EMSetMargin::LeftMargin:
    {
      l_limit = RECT_UNIT(&rec, INDEX_TOP, xy_idx);
      u_limit = RECT_UNIT(&rec, INDEX_BOT, xy_idx) - 1 - right_mgn;
      if (setmgn.GetWithFirst()) 
      {
	if (first_left_mgn >= 0) 
	{
	  u_limit -= first_left_mgn;
	}
	else 
	{
	  l_limit -= first_left_mgn;
	}
      }
    }
    break;
    
   case EMSetMargin::RightMargin:
    {
      if (setmgn.GetWithAll()) 
      {
	l_limit = ((RECT_UNIT(&rec, INDEX_TOP, xy_idx)
		    + RECT_UNIT(&rec, INDEX_BOT, xy_idx) 
		    + left_mgn - right_mgn)
		   / 2);
      }
      else 
      {
	l_limit = (RECT_UNIT(&rec, INDEX_TOP, xy_idx)
		   + left_mgn + MAX(0, first_left_mgn));
      }
      u_limit = RECT_UNIT(&rec, INDEX_BOT, xy_idx) - 1;
    }
    break;
  }
  setmgn.SetLimit(l_limit, u_limit);
  RedisplayMargin();		// draw
  MouseCursor::Margin();
  
  Vector posi = WtoIv(mpos);
  Iunit& fix = tate_p ? posi.y : posi.x;
  if (fix < setmgn.GetLowerLimit()) 
  {
    fix = setmgn.GetLowerLimit();
  }
  else if (fix > setmgn.GetUpperLimit()) 
  {
    fix = setmgn.GetUpperLimit();
  }
  ShowMoveParagraphMarginPos(posi);
}

void NEAR 
EditFrame::SetMargin_MV(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  if (setmgn.IsFixed() == False) 
  {
    // idle
    setmgn.Reset();
    ClearMouseOffset();
    VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
    NavPMargin nav;
    if ((LockLayout(mpos) == 0) || 
	!FindParagraphMarginW(mpos, nav))
    {
      MouseCursor::MarginOff();
    }
    else 
    {
      MouseCursor::Margin();
    }
  }
  else 
  {
    // margin move
    bool tate_p = setmgn.GetTateP();
    VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
    AdaptOffset(mpos);
    Vector pos = WtoIv(mpos);
    Iunit& fix = tate_p ? pos.y : pos.x;
    if (fix < setmgn.GetLowerLimit()) 
    {
      fix = setmgn.GetLowerLimit();
    }
    else if (fix > setmgn.GetUpperLimit()) 
    {
      fix = setmgn.GetUpperLimit();
    }
    
    Vector from = setmgn.GetFromPos();
    Vector to   = setmgn.GetToPos();
    Iunit& fix_to = tate_p ? to.y : to.x;
    if (fix_to != fix) 
    {
      if (tate_p)
      {
	to.y = from.y = pos.y;
      }
      else
      {
	to.x = from.x = pos.x;
      }
      RedisplayMargin();		// vanish
      setmgn.Move(from, to);
      RedisplayMargin();		// draw
      ShowMoveParagraphMarginPos(pos);
      SetEffective();
    }
  }
}

void NEAR 
EditFrame::SetMargin_LUP(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  // margin change
  if (!setmgn.IsFixed() || !IsEffective()) 
  {
    CancelMargin(False);
    return;
  }
  RedisplayMargin();		// vanish
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  AdaptOffset(mpos);
  Vector pos = WtoIv(mpos);
  bool tate_p = setmgn.GetTateP();
  Iunit& fix = tate_p ? pos.y : pos.x;
  if (fix < setmgn.GetLowerLimit()) 
  {
    fix = setmgn.GetLowerLimit();
  }
  else if (fix > setmgn.GetUpperLimit()) 
  {
    fix = setmgn.GetUpperLimit();
  }
  ShowMoveParagraphMarginPos(pos);
  
  // change margin
  FrameInstance* fi = setmgn.GetFrame();
  Paragraph* ph = setmgn.GetParagraph();
  EditParAtts* epa = window->GetEditor()->GetParAtts();
  Iunit first_left_mgn = 0;
  Iunit left_mgn = 0;
  Iunit right_mgn = 0;
  GetParagraphMargin(first_left_mgn, left_mgn, right_mgn);
  Irect rec;
  fi->get_drawing_irect(&rec);
  int xy_idx = tate_p ? INDEX_Y : INDEX_X;
  switch (setmgn.GetLockMargin()) 
  {
   case EMSetMargin::FirstMargin:
    {
#ifdef MARGIN_SET_WITH_LEFT
      if (setmgn.GetWithLeft())
      {
	Iunit left_ind = (fix - RECT_UNIT(&rec, INDEX_TOP, xy_idx)
			  - first_left_mgn);
	left_ind = (left_ind < 0) ? 0 : left_ind;
	epa->ChangeIndent(ph, False, 0, True, left_ind, False, 0);
      }
      else
      {
	Iunit first_ind = (fix - RECT_UNIT(&rec, INDEX_TOP, xy_idx) 
			   - left_mgn);
	epa->ChangeIndent(ph, True, first_ind, False, 0, False, 0);
      }
#else
      Iunit first_ind = (fix - RECT_UNIT(&rec, INDEX_TOP, xy_idx) 
			 - left_mgn);
      epa->ChangeIndent(ph, True, first_ind, False, 0, False, 0);
#endif
    }
    break;
    
   case EMSetMargin::LeftMargin:
    {
      Iunit abs_f_ind = left_mgn + first_left_mgn;
      Iunit left_ind = fix - RECT_UNIT(&rec, INDEX_TOP, xy_idx);
      left_ind = (left_ind < 0) ? 0 : left_ind;
      if (setmgn.GetWithFirst()) 
      {
	epa->ChangeIndent(ph, False, 0, True, left_ind, False, 0);
      }
      else 
      {
	Iunit first_ind = abs_f_ind - left_ind;
	epa->ChangeIndent(ph, True, first_ind, True, left_ind, False, 0);
      }
    }
    break;
    
   case EMSetMargin::RightMargin:
    {
      Iunit right_ind = RECT_UNIT(&rec, INDEX_BOT, xy_idx) - fix;
      if (setmgn.GetWithAll()) 
      {
	Iunit diffs = (RECT_UNIT(&rec, INDEX_BOT, xy_idx) - right_mgn 
		       - (tate_p ? pos.y : pos.x));
	Iunit left_ind = left_mgn + diffs;
	left_ind = (left_ind < 0) ? 0 : left_ind;
	if (left_ind > 
	    setmgn.GetLowerLimit() - RECT_UNIT(&rec, INDEX_TOP, xy_idx)) 
	{
	  left_ind = (setmgn.GetLowerLimit() 
		      - RECT_UNIT(&rec, INDEX_TOP, xy_idx));
	}
	Iunit first_ind = left_mgn + first_left_mgn + diffs;
	first_ind = (first_ind < 0) ? 0 : first_ind;
	if (first_ind > 
	    setmgn.GetLowerLimit() - RECT_UNIT(&rec, INDEX_TOP, xy_idx)) 
	{
	  first_ind = (setmgn.GetLowerLimit() 
		       - RECT_UNIT(&rec, INDEX_TOP, xy_idx));
	}
	first_ind -= left_ind;
	epa->ChangeIndent(ph, 
			   True, first_ind,
			   True, left_ind,
			   True, right_ind);
      }
      else 
      {
	epa->ChangeIndent(ph, False, 0, False, 0, True, right_ind);
      }
    }
    break;
  }
  setmgn.Reset();
  ClearMouseOffset();
  UnforceTouchCaret();
  SetDirty();
}

void 
EditFrame::CancelMargin(bool beep)
{
  if (setmgn.IsFixed()) 
  {
    RedisplayMargin();		// vanish
  }
  MouseCursor::MarginOff();
  setmgn.Reset();
  ClearMouseOffset();
  if (beep) 
  {
    ::MessageBeep(0);
  }
}

void 
EditFrame::RedisplayMargin()
{
  HWND hWnd = window->GetHandle();
  HDC hDC = GetDC(hWnd);
  RedisplayMargin(hDC);
  ReleaseDC(hWnd, hDC);
}

void 
EditFrame::RedisplayMargin(VDisplay* vdsp)
{
  if (setmgn.IsFixed()) 
  {
    RedisplayMargin(vdsp->GetDC());
  }
}

void 
EditFrame::RedisplayMargin(HDC hDC)
{
  VectW from_w = ItoWv(setmgn.GetFromPos());
  VectW to_w = ItoWv(setmgn.GetToPos());
  DisplaySelectedLine(hDC, from_w, to_w);
  
#ifdef MARGIN_SET_WITH_LEFT
  if (!setmgn.GetWithLeft() &&
      !setmgn.GetWithFirst() && 
      !setmgn.GetWithAll())
#else
  if (!setmgn.GetWithFirst() && 
      !setmgn.GetWithAll()) 
#endif
  {
    return;
  }
  
  // check line
  Paragraph* ph = setmgn.GetParagraph();
  bool tate_p = setmgn.GetTateP();
  FrameInstance* fi = setmgn.GetFrame();
  Irect rec;
  fi->get_drawing_irect(&rec);
  Line* ln;
  for (ln = fi->GetFirstLine();
       ln != 0;
       ln = ln->GetNext()) 
  {
    BufferPointer* first_bp = ln->GetFirstBP();
    if (ph == first_bp->GetParagraph()) 
    {
      break;
    }
  }
  if (ln == 0) 
  {
    return;
  }
  
  Iunit ln_pos = fi->line_y_to_iunit(ln->GetY());
  Vector from;
  Vector to;
  if (tate_p)
  {
    from.x = ln_pos;
    to.x = ln_pos - ln->GetHeight();
  }
  else
  {
    from.y = ln_pos;
    to.y = ln_pos + ln->GetHeight();
  }

  // get margin
  Iunit left_mgn;
  Iunit right_mgn;
  Iunit first_mgn;
  if (ph->GetFirstFrame() == fi) 
  {
    ln->GetMarginPosOnIunits(&first_mgn, &right_mgn);
    ln = ln->GetNext();
    if (ln == 0) 
    {
      left_mgn = first_mgn;
    }
    else 
    {
      ln->GetMarginPosOnIunits(&left_mgn, &right_mgn);
    }
  }
  else 
  {
    ln->GetMarginPosOnIunits(&left_mgn, &right_mgn);
    first_mgn = left_mgn;
  }
  
  Iunit mouse_pos = tate_p ? setmgn.GetFromPos().y : setmgn.GetFromPos().x;
#ifdef MARGIN_SET_WITH_LEFT
  Iunit diffs = 0;
  switch (setmgn.GetLockMargin())
  {
   case EMSetMargin::FirstMargin:
    diffs = mouse_pos - first_mgn;
    break;
    
   case EMSetMargin::LeftMargin:
    diffs = mouse_pos - left_mgn;
    break;
    
   case EMSetMargin::RightMargin:
    diffs = right_mgn - mouse_pos;
    break;
  }
#else
  Iunit diffs = ((setmgn.GetLockMargin() == EMSetMargin::LeftMargin) ?
		 mouse_pos - left_mgn :
		 right_mgn - mouse_pos);
#endif
  if (tate_p)
  {
#ifdef MARGIN_SET_WITH_LEFT
    to.y = from.y = (setmgn.GetWithLeft() ? left_mgn + diffs :
		     first_mgn + diffs);
    if (setmgn.GetWithLeft())
    {
      Iunit dummy;
      FindParagraphPos(setmgn.GetFrame(), setmgn.GetParagraph(), 
			dummy, from.x, to.x);
    }
#else
    to.y = from.y = first_mgn + diffs;
#endif

    if (from.y < RECT_TOP_Y(&rec)) 
    {
      to.y = from.y = RECT_TOP_Y(&rec);
    }
    if (setmgn.GetWithAll() &&
	setmgn.GetLowerLimit() < from.y)
    {
      to.y = from.y = setmgn.GetLowerLimit();
    }
  }
  else
  {
#ifdef MARGIN_SET_WITH_LEFT
    to.x = from.x = (setmgn.GetWithLeft() ? left_mgn + diffs :
		     first_mgn + diffs);
    if (setmgn.GetWithLeft())
    {
      Iunit dummy;
      FindParagraphPos(setmgn.GetFrame(), setmgn.GetParagraph(), 
			dummy, from.y, to.y);
    }
#else
    to.x = from.x = first_mgn + diffs;
#endif
    if (from.x < RECT_TOP_X(&rec)) 
    {
      to.x = from.x = RECT_TOP_X(&rec);
    }
    if (setmgn.GetWithAll() &&
	setmgn.GetLowerLimit() < from.x)
    {
      to.x = from.x = setmgn.GetLowerLimit();
    }
  }
  
  if (ph->GetFirstFrame() == fi) 
  {
    from_w = ItoWv(from);
    to_w = ItoWv(to);
    DisplaySelectedLine(hDC, from_w, to_w);
  }
  else 
  {
    if (tate_p)
    {
      to.x = from.x;
    }
    else
    {
      to.y = from.y;
    }
  }
  
  if (setmgn.GetWithAll()) 
  {
    if (tate_p)
    {
      from.x = to.x;
      to.x = setmgn.GetToPos().x;
      to.y = from.y = left_mgn + diffs;
      if (from.y < RECT_TOP_Y(&rec)) 
      {
	to.y = from.y = RECT_TOP_Y(&rec);
      }
      if (from.y > setmgn.GetLowerLimit()) 
      {
	to.y = from.y = setmgn.GetLowerLimit();
      }
    }
    else
    {
      from.y = to.y;
      to.y = setmgn.GetToPos().y;
      to.x = from.x = left_mgn + diffs;
      if (from.x < RECT_TOP_X(&rec)) 
      {
	to.x = from.x = RECT_TOP_X(&rec);
      }
      if (from.x > setmgn.GetLowerLimit()) 
      {
	to.x = from.x = setmgn.GetLowerLimit();
      }
    }
    from_w = ItoWv(from);
    to_w = ItoWv(to);
    DisplaySelectedLine(hDC, from_w, to_w);
  }
}

// get paragraph margin
void 
EditFrame::GetParagraphMargin(Iunit& first, Iunit& left, Iunit& right)
{
  FrameInstance* fi = setmgn.GetFrame();
  Paragraph* ph = setmgn.GetParagraph();
  int xy_idx = setmgn.GetTateP() ? INDEX_Y : INDEX_X;
  Irect rec;
  fi->get_drawing_irect(&rec);
  int* atts = get_atts(ph->GetAtts());
  Iunit top_mgn = RECT_UNIT(&rec, INDEX_TOP, xy_idx);
  Iunit bot_mgn = RECT_UNIT(&rec, INDEX_BOT, xy_idx);
  Iunit top = top_mgn + atts[PA_secondleftmargin];
  Iunit bot = bot_mgn - atts[PA_rightmargin];
  top = MAX(top, top_mgn);
  top = MIN(top, bot_mgn);
  bot = MAX(bot, top_mgn);
  bot = MIN(bot, bot_mgn);
  if (bot < top) 
  {
    top = bot = (top + bot) / 2;
  }
  Iunit first_l = top;
  first_l += atts[PA_firstleftmargin];
  first_l = MAX(first_l, top_mgn);
  first_l = MIN(first_l, bot);
  first = first_l - top;
  left = top - top_mgn;
  right = bot_mgn - bot;
}

inline Iunit 
diff(Iunit a, Iunit b)
{
  return((a - b) > 0) ? (a - b) : (b - a);
}

bool NEAR 
EditFrame::FindParagraphMarginW(VectW& vw, NavPMargin& nav)
{
  Dpoint dp[1];
  SET_POINT(dp, vw.x, vw.y);
  Lpoint lp[1];
  window->dpoint_to_lpoint(dp, lp);
  Line* ln = window->navigate_line(lp);
  if (ln == NULL)
  {
    return False;
  }
  Paragraph* ph = ln->GetFirstBP()->GetParagraph();
  FrameInstance* fi = ln->GetFrame();
  bool tate_p = ph->GetTextFlow()->tategaki_flow_p();
  nav.SetParagraph(ph);
  nav.SetFrameInstance(fi);
  nav.SetLine(ln);
  nav.SetTateP(tate_p);
  
  Ipoint ip[1];
  fi->GetLayout() ->lpoint_to_ipoint(lp, ip);
  Iunit top_mgn;
  Iunit bot_mgn;
  ln->GetMarginPosOnIunits(&top_mgn, &bot_mgn);
  Iunit mouse_error = GetMouseErrorLength();
  uword cond = 0;
  Iunit top_bot_diff = diff(top_mgn, bot_mgn);
  int xy_idx = tate_p ? INDEX_Y : INDEX_X;
  if (top_bot_diff <= mouse_error) 
  {
    if (POINT_UNIT(ip, xy_idx) <= top_mgn) 
    {
      if (diff(top_mgn, POINT_X(ip)) <= mouse_error) 
      {
	cond = 1;
      }
    }
    else if (POINT_UNIT(ip, xy_idx) >= bot_mgn) 
    {
      if (diff(bot_mgn, POINT_UNIT(ip, xy_idx)) <= mouse_error) 
      {
	cond = 2;
      }
    }
    else 
    {
      Iunit diff_top = diff(POINT_UNIT(ip, xy_idx), top_mgn);
      Iunit diff_bot = diff(POINT_UNIT(ip, xy_idx), bot_mgn);
      if (diff_top > diff_bot) 
      {
	cond = 1;
      }
      else 
      {
	cond = 2;
      }
    }
  }
  else if ((POINT_UNIT(ip, xy_idx) >= top_mgn - mouse_error) &&
	   (POINT_UNIT(ip, xy_idx) <= top_mgn + mouse_error)) 
  {
    cond = 1;
  }
  else if ((POINT_UNIT(ip, xy_idx) >= bot_mgn - mouse_error) &&
	   (POINT_UNIT(ip, xy_idx) <= bot_mgn + mouse_error)) 
  {
    cond = 2;
  }
  switch (cond) 
  {
   case 1:
    {
      Vector _from;
      Vector _to;
      Iunit ln_pos = fi->line_y_to_iunit(ln->GetY());
      if (tate_p)
      {
	nav.SetOffset(vw.y - ItoWy(top_mgn));
	_from.Set(ln_pos, top_mgn);
	_to.Set(ln_pos - ln->GetHeight(), top_mgn);
      }
      else
      {
	nav.SetOffset(vw.x - ItoWx(top_mgn));
	_from.Set(top_mgn, ln_pos);
	_to.Set(top_mgn, ln_pos + ln->GetHeight());
      }
      if (ln->GetFirstBP()->BeginningOfBufferP()) 
      {
	nav.SetSetMargin(EMSetMargin::FirstMargin);
	nav.SetFromVector(_from);
	nav.SetToVector(_to);
	return True;
      }
      Iunit dummy;
      if (tate_p)
      {
	FindParagraphPos(fi, ph, dummy, _from.x, _to.x);
      }
      else
      {
	FindParagraphPos(fi, ph, dummy, _from.y, _to.y);
      }
      nav.SetSetMargin(EMSetMargin::LeftMargin);
      nav.SetFromVector(_from);
      nav.SetToVector(_to);
      return True;
    }
   case 2:
    {
      Vector _from;
      Vector _to;
      Iunit dummy;
      if (tate_p)
      {
	nav.SetOffset(vw.y - ItoWy(bot_mgn));
	_from.y = _to.y = bot_mgn;
	FindParagraphPos(fi, ph, _from.x, dummy, _to.x);
      }
      else
      {
	nav.SetOffset(vw.x - ItoWx(bot_mgn));
	_from.x = _to.x = bot_mgn;
	FindParagraphPos(fi, ph, _from.y, dummy, _to.y);
      }
      nav.SetSetMargin(EMSetMargin::RightMargin);
      nav.SetFromVector(_from);
      nav.SetToVector(_to);
      return True;
    }
   default:
    break;
  }
  nav.SetSetMargin(EMSetMargin::Idle);
  return False;
}

void 
EditFrame::FindParagraphPos(FrameInstance* fi,
			     Paragraph* fph, 
			     Iunit& p1,
			     Iunit& p2,
			     Iunit& p3)
{
  bool tate_p = fph->GetTextFlow()->tategaki_flow_p();
  for (Line* ln = fi->GetLines()->GetNext();
       (ln != NULL) && (ln->GetFrame() == fi);
       ln = ln->GetNext()) 
  {
    Paragraph* ph = ln->GetFirstBP()->GetParagraph();
    Iunit ln_pos = fi->line_y_to_iunit(ln->GetY());
    if (ph == fph) 
    {
      if (ln->GetFirstBP()->BeginningOfBufferP()) 
      {
	// this line is the first paragraph line.
	p1 = ln_pos;
	p2 = p1 + ((tate_p ? -1 : 1) * ln->GetHeight());
      }
      else 
      {
	p1 = p2 = ln_pos;
      }
    }
    
    Line* last = ln;
    for (Line* l = ln; 
	 ((l != NULL) &&
	  (l->GetFirstBP()->GetParagraph() == ph) && 
	  (l->GetFrame() == fi));
	 l = l->GetNext()) 
    {
      last = l;
    }
    
    if (ph == fph) 
    {
      p3 = (fi->line_y_to_iunit(last->GetY()) 
	    + ((tate_p ? - 1 : 1) * last->GetHeight()));
      return;
    }
    ln = last;
  }
}
