// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: marks.cpp,v 3.4 2000/05/04 13:44:06 kudou Exp $
// implement MarkTable and MarkEntry classes for mark info

#include "pword.h"
#include "marks.h"
#include "bound.h"
#include "docconte.h"
#include "document.h"
#include "interval.h"
#include "intlist.h"
#include "menu.h"
#include "pstreams.h"
#include "textflow.h"
#ifndef _WIN32
#  include <memory.h>
#endif

#define T MarkEntry
#define TABLE BaseMarkTable
#define SEG BaseMarkTableSeg
#define DEADABLE_ENTRY
#define FORCE_MAKE_ENTRY
#include "tabletem.cpp"

MarkTable STATIC_NEAR GlobalMarkTable;


// ------------------------------------------------------------
// EXTERNALLY VISIBLE ROUTINES FOR OUTSIDE WORLD

void
MarkTable::GetMarkData(int mark, Document* &doc, IntervalList*& ints)
{
  MarkEntry& mt_entry = ::get_mark_entry(mark);
  doc = mt_entry.GetDocument();
  ints = (IntervalList*) (mt_entry.GetIntervals());
}

void
MarkTable::MakeMark(char* name, Document* doc, IntervalList* ints)
{
  MarkEntry mt_entry(name, doc, ints);
  MakeEntry(mt_entry);
}

int
MarkTable::GetMarkByName(char* name, Document* doc)
{
  unsigned int limit = this->GetNEntries();
  unsigned int a = 0;
  while (++a != limit)
  {
    MarkEntry& e = ::get_mark_entry(a);
    if (!e.GetDead() &&
	(strcmp(e.name, name) == 0) &&
	(e.GetDocument() == doc))
    {
      return(a);
    }
  }
  return(0);
}

void
MarkTable::RemoveMarksInDocument(Document* doc)
{
  Apply(&MarkEntry::RemoveIfInDocument, (void*)doc);
}

void
MarkTable::WriteMarksInDocument(PStream* stream, Document* doc)
{
  stream->StartBlockOut(PStream::HDR_MTABLE);
  CHECK;
  
  // count number of marks on this document
  {
    unsigned int n = 0;
    unsigned int a = this->GetNEntries();
    while (--a)
    {
      MarkEntry& e = ::get_mark_entry(a);
      if ((!e.GetDead()) && (e.GetDocument() == doc))
      {
	n++;
      }
    }
    stream->OutUWord(n);
    CHECK;
  }
  
  // write out marks on this document
  {
    unsigned int limit = this->GetNEntries();
    unsigned int a = 0;
    while (++a != limit)
    {
      MarkEntry& e = ::get_mark_entry(a);
      if ((!e.GetDead()) && (e.GetDocument() == doc))
      {
	e.WriteToStream(stream);
	CHECK;
      }
    }
  }
  
  stream->EndBlockOut();
}

void
MarkTable::ReadMarksInDocument(PStream* stream, Document* doc)
{
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_MTABLE, vers);
  CHECK;
  
  int n = stream->InUWord();
  CHECK;
  
  while (n--)
  {
    MarkEntry e;
    e.ReadFromStream(stream, doc);
    CHECK;
    this->MakeEntry(e);
  }
  
  stream->EndBlockIn();
}

void
MarkTable::RemoveMark(uword index)
{
  MarkEntry& entry = ::get_mark_entry(index);
  entry.SetDead();
  entry.RemoveFromInterface(index);
}

void
MarkTable::ReportDeadTextFlow(TextFlow* tf)
{
  Apply(&MarkEntry::ReportDeadTextFlow, (void*) tf);
}

void
MarkTable::NewDocumentName(Document* doc)
{
  Apply(&MarkEntry::NewDocumentName, doc);
}

void
MarkEntry::NewDocumentName(unsigned int i, void* vdoc)
{
  Document* doc = (Document*)vdoc;
  if ((!GetDead()) && (GetDocument() == doc))
  {
    RemoveFromInterface(i);
    AddToInterface(i, 0);
  }
}

void
MarkEntry::Init()
{
  *name = '\0';
  intervals = NULL;
  document = 0;
}

MarkEntry::MarkEntry()
{
  Init();
}

// construct from name and interval list

MarkEntry::MarkEntry(char* _name, Document* d, IntervalList* i)
{
  Init();
  copy_string(name, _name, MARK_LEN+1);
  document = d;
  intervals = i;
}

void
MarkEntry::Destroy()
{
  delete intervals;
  Init();
}

void
MarkEntry::SetDead()
{
  if (!this->GetDead())
  {
    this->ImmediateSetDead();
    GlobalMarkTable.RemoveHash(this);
  }
}

// private method
unsigned char NEAR
MarkEntry::GetHash()
{
  assert(sizeof(Document*) == 4);
  
  unsigned char* s = (unsigned char*) &this->document;
  unsigned char x = s[0] ^ s[1] ^ s[2] ^ s[3];
  
  s = (unsigned char*) this->name;
  unsigned char c;
  while ((c = *s++) != '\0')
  {
    x = x ^ (x << 3) ^ c;
  }
  return(x);
}

int
operator == (MarkEntry& MTe1, MarkEntry& MTe2)
{
  return(MTe1.document == MTe2.document
	  && lstrcmp(MTe1.name, MTe2.name) == 0);
}

unsigned int
MarkEntry::Enter()
{
  return GlobalMarkTable.MakeEntry(*this);
}

void
MarkEntry::WriteToStream(PStream* stream)
{
  stream->StartBlockOut(PStream::HDR_MARKENTRY);
  CHECK;
  
  stream->OutString(name);
  CHECK;
  
  BoundIntervalList bil;
  bil.Copy(GetIntervals());
  bil.WriteToStream(stream); CHECK;
  
  stream->EndBlockOut(); CHECK;
}

void
MarkEntry::ReadFromStream(PStream* stream, Document* d)
{
  word vers;
  stream->StartTypedBlockIn(PStream::HDR_MARKENTRY, vers);
  CHECK;
  
  char* s = stream->InString();
  CHECK;
  copy_string(name, s, MARK_LEN+1);
  delete s;
  
  SetDocument(d);
  BoundIntervalList* bil = new BoundIntervalList;
  bil->ReadFromStream(stream); CHECK;
  IntervalList* il = bil->Unbind(d->GetDocumentContent());
  delete bil;
  SetIntervals(il);
  
  stream->EndBlockIn();
}

void
MarkEntry::RemoveIfInDocument(unsigned int i, void* v)
{
  Document* doc = (Document*) v;
  if (GetDocument() == doc)
  {
    SetDead();
    RemoveFromInterface(i);
  }
}

void
MarkEntry::ReportDeadTextFlow(unsigned int i, void* vtf)
{
  TextFlow* tf = (TextFlow*) vtf;
  if (GetDocument() == tf->GetDocContent()->GetDocument())
  {
    IntervalList* il = (IntervalList*) GetIntervals();
    il->WeedDeadTextFlow(tf);
    if (!il->GetHead())
    {
      SetDead();
      RemoveFromInterface(i);
    }
  }
}

void
MarkEntry::RemoveFromInterface(unsigned int i)
{
  Menu::delete_menu(Menu_Type_MARK, i);
}

void
MarkEntry::AddToInterface(unsigned int i, void*)
{
  if (!this->GetDead())
  {
    char buf[MARK_LEN + MAX_PATH];
    wsprintf(buf, "[%s] %s", this->document->GetName(), this->name);
    Menu::add_menu(Menu_Type_MARK, i, buf);
  }
}

#ifndef NDEBUG
void
MarkEntry::DumpHeader(FILE* f)
{
  fprintf(f, 
	   "\nMark Table\n\n"
	   "NNNN Name\n"
	 );
}

void
MarkEntry::Dump(unsigned int i, void* v)
{
  FILE* f = (FILE*) v;
  fprintf(f, "%4d %s\n", i, name);
}
#endif
