// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: marks.h,v 3.3 2000/05/04 13:44:06 kudou Exp $
// define MarkTable and MarkEntry class to hold mark information

#ifndef MARKS_H
#define MARKS_H

#include "generics.h"

class BaseIntervalList;

class MarkEntry
  : public DeadableEntry
{
  friend class BaseMarkTable;
  friend class MarkTable;

private:
  enum { MARK_LEN = 32 };
  char name[ MARK_LEN+1 ];
  BaseIntervalList* intervals;
  Document* document;

public:
  MarkEntry();
  MarkEntry(char* name, Document* d, IntervalList* i);

private:
  unsigned char NEAR GetHash();

public:
  void Destroy();
  void Init();
  void SetDead();
  BaseIntervalList* GetIntervals() const
  {
    return intervals;
  }
  void SetIntervals(BaseIntervalList* il)
  {
    intervals = il;
  }
  
  Document* GetDocument() const
  {
    return document;
  }
 
  void SetDocument(Document* d)
  {
    document=d;
  }
  
  friend int operator == (MarkEntry&, MarkEntry&);

  void WriteToStream(PStream*);
  void ReadFromStream(PStream* , Document*);
  void ReadFromStream(PStream*) {} // not used
  unsigned int Enter();

  // functions called through "apply"
  void RemoveIfInDocument(unsigned int, void*);
  void ReportDeadTextFlow(unsigned int, void* textflow);
  void NewDocumentName(unsigned int, void* vdoc);
  void AddToInterface(unsigned int i, void*);
  void RemoveFromInterface(unsigned int i);
#ifndef NDEBUG
  void Dump(unsigned int i, void* f);
  static void DumpHeader(FILE* f);
#endif
};

#define T MarkEntry
#define TABLE BaseMarkTable
#define SEG BaseMarkTableSeg
#define DEADABLE_ENTRY
#include "tabletem.h"

class MarkTable
  : public BaseMarkTable
{
public:
  void GetMarkData(int mark, Document* &doc, IntervalList*& ints);
  void MakeMark(char* name, Document* doc, IntervalList* ints);
  int GetMarkByName(char* name, Document* doc);
  void RemoveMark(uword index);
  void RemoveMarksInDocument(Document* doc);
  void ReportDeadTextFlow(TextFlow* doc);
  void WriteMarksInDocument(PStream* , Document* doc); 
  void ReadMarksInDocument(PStream* , Document* doc); 
  void NewDocumentName(Document* doc);
};

extern MarkTable STATIC_NEAR GlobalMarkTable;

#endif /* MARKS_H */
