// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: memo.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implementation of Memo class for dialog boxes
// where you enter a single number

#include "pword.h"
#include "pwordpre.h"
#include "dialogs.h"
#include "pmenus.h"
#include "mwindow.h"
#include "memo.h"

MemoDialog::MemoDialog
(
  char* initial, 
  int initial_set
)
  : value(initial)
, value_set(initial_set)
{
}

// ------------------------------------------------------------
// MemoEdit -- editable case

LONG MemoEditDialog::old_wndproc;

MemoEditDialog::MemoEditDialog(char* initial)
  : MemoDialog(initial, 1 /* set */)
{
  this->class_name = "MemoEdit";
}

LRESULT_T
MemoEditDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    SendItemMessage(IDD_SaveAs_Memo, EM_LIMITTEXT, MAX_MEMO_SIZE);
    if (!value_set) {
      SetItemText(IDD_SaveAs_Memo, "");
    }
    else {
      SetItemText(IDD_SaveAs_Memo, value);
    }
    {
      HWND memo_handle=GetItem(IDD_SaveAs_Memo);
      old_wndproc=GetWindowLong(memo_handle, GWL_WNDPROC);
      SetWindowLong(memo_handle, GWL_WNDPROC, (LONG) MemoEditDialog::OurWndProc);
    }
    return 1;

   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {

     case IDOK:
      {
#ifdef _WIN32
	switch (HIWORD(wParam))
#else /* _WIN32 */
	switch (HIWORD(lParam))
#endif /* _WIN32 */
	{
	 case BN_CLICKED:
	  {
	    value_set = 1;
	    unsigned int len = (int) SendItemMessage(IDD_SaveAs_Memo,
						      WM_GETTEXTLENGTH);
	    value = new char[len+1];
	    GetItemText(IDD_SaveAs_Memo, value, len+1);
	    End(1);
	    return 1;
	  }
	 default:
	  break;
	}
      }
      break;

     case IDCANCEL:
      {
#ifdef _WIN32
	switch (HIWORD(wParam))
#else /* _WIN32 */
	switch (HIWORD(lParam))
#endif /* _WIN32 */
	{
	 case BN_CLICKED:
	  {
	    End(0);
	    return 1;
	  }
	 default:
	  break;
	}
      }
      break;

     case IDD_SaveAs_Memo:
     {
#ifdef _win32
       switch (HIWORD(wParam))
#else /* _win32 */
       switch (HIWORD(lParam))
#endif /* _win32 */
       {
         case EN_SETFOCUS:
         {
           SendItemMessage(IDD_SaveAs_Memo, EM_SETSEL);
          }
          default:
          break;
       }
       break;
     }
     default:
      break;
    }
    
   default: 
    return 0;
  }
}

LRESULT_T
MemoEditDialog::OurWndProc_ (HWND h,
			     MSG_T msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (msg)
  {
    case WM_KEYDOWN:
    {
      if (wParam==VK_RETURN){
        ::SendMessage(h, WM_CHAR, '\n', 0);
        return 0;
      }
    }
    break;
    
    default:
    break;
  }
  return CallWindowProc((WNDPROC) old_wndproc, h, msg, wParam, lParam);
}

// ------------------------------------------------------------
// MemoNoEditDialog -- can't edit case(open)

LONG MemoNoEditDialog::old_wndproc = 0;

MemoNoEditDialog::MemoNoEditDialog(char* initial)
  : MemoDialog(initial, 1 /* set from file */)
{
  this->class_name = "MemoNoEdit";
}

LRESULT_T
MemoNoEditDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    if (!value_set) {
      SetItemText(IDD_FileOpen_Memo, "");
    }
    else {
      SetItemText(IDD_FileOpen_Memo, value);
    }
    SendItemMessage(IDD_FileOpen_Memo, EM_SETSEL);
    {
      HWND memo_handle=GetItem(IDD_FileOpen_Memo);
      old_wndproc=GetWindowLong(memo_handle, GWL_WNDPROC);
      SetWindowLong(memo_handle, GWL_WNDPROC, (LONG) MemoNoEditDialog::OurWndProc);
    }
    return 1;
  
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
      {
#ifdef _WIN32
	switch (HIWORD(wParam))
#else /* _WIN32 */
	switch (HIWORD(lParam))
#endif /* _WIN32 */
	{
	 case BN_CLICKED:
	  {
	    End(0);
	    return 1;
	  }

	 default:
	  break;
	}
      }
      break;
      
     default:
      break;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    return(1);
    
   default:
    return 0;
  }
  return 0;
}

LRESULT_T
MemoNoEditDialog::OurWndProc_ (HWND h,
			       MSG_T msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (msg)
  {
    case WM_KEYDOWN:
    case WM_CHAR:
    {
        return 0;
    }
    
    default:
    break;
  }
  return CallWindowProc((WNDPROC) old_wndproc, h, msg, wParam, lParam);
}
