// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: menu.cpp,v 3.7 2000/05/04 13:44:06 kudou Exp $
// menu

#include "pword.h"
#include "menu.h"
#include "again.h"
#include "attribut.h"
#include "dialogs.h"
#include "dlg.h"
#include "docedit.h"
#include "docwindo.h"
#include "eca.h"
#include "epa.h"
#include "mdiclien.h"
#include "mwindow.h"
#include "pmenus.h"
#include "pref.h"
#include "pwordbas.h"
#include "pwordpre.h"
#include "xstr.h"

struct Menu_Item
{
  Menu_Item* chain;
  char* name;
  int attrib_index;
};

struct Static_Menu_Item
{
  Static_Menu_Item* chain;
  char* name;
  int attrib_index;
  int idm;
};

#define Dynamic_Menu Dynamic_Menu_Rec STATIC_NEAR
struct Dynamic_Menu_Rec
{
  Menu_Type menu_type;
  char* dialog_title;
  int menu_pos;
  int sub_menu_pos;
  int idm_high;
  long(NEAR* fn) (int menu_state_p, int attrib_index);
  int initial_sub_menu_count;
  int dynamic_menu_count;
  Static_Menu_Item* static_items;
  Menu_Item* items;
};

static Dynamic_Menu* NEAR get_dynamic_menu(Menu_Type menu_type);

static long NEAR
japanese_font_fn(int menu_state_p, int attrib_index)
{
  return(Selected_Window
	  ->GetEditor()
	  ->GetEditCharAtts()
	  ->specific_value(menu_state_p, CA_facename2, attrib_index));
}

static long NEAR
english_font_fn(int menu_state_p, int attrib_index)
{
  return(Selected_Window
	  ->GetEditor()
	  ->GetEditCharAtts()
	  ->specific_value(menu_state_p, CA_facename, attrib_index));
}

static long NEAR
char_style_fn(int menu_state_p, int attrib_index)
{
  return(Selected_Window
	  ->GetEditor()
	  ->GetEditCharAtts() ->set_style(menu_state_p, attrib_index));
}

static long NEAR
para_style_fn(int menu_state_p, int attrib_index)
{
  return(Selected_Window
	  ->GetEditor()
	  ->GetParAtts() ->set_style(menu_state_p != 0, attrib_index));
}

#ifdef BW2_ABBREV
static long NEAR
abbrev_fn(int menu_state_p, int attrib_index)
{
  if (menu_state_p)
  {
    return(MF_ENABLED);
  }
  Selected_Window ->GetEditor()->InsertAbbrev(attrib_index);
  return(0);
}
#endif /* BW2_ABBREV */

#ifdef BW3_RECENTOPEN
static long NEAR
recent_open_fn(int menu_state_p, int attrib_index)
{
  if (menu_state_p)
  {
    return MF_ENABLED;
  }
  Dynamic_Menu* dm = get_dynamic_menu(Menu_Type_RECENTOPEN);
  for (Menu_Item* mi = dm->items; mi; mi = mi->chain)
  {
    if (mi->attrib_index == attrib_index)
    {
      PWordBase::OpenFile(mi->name);
      break;
    }
  }
  return 0;
}
#endif /* BW3_RECENTOPEN */

static long NEAR
mark_fn(int menu_state_p, int attrib_index)
{
  if (menu_state_p)
  {
    return(MF_ENABLED);
  }
  Again::CantDoAgain();
  PWordBase::GotoMark(attrib_index);
  return(0);
}

static Dynamic_Menu dynamic_menus[] =
{
  {
    Menu_Type_JAPANESE_FONT,
    S_japanese_font_title,
    IDM_FontMenu,
    IDM_FontJSubMenu,
    IDM_HIGH_FontJ,
    japanese_font_fn,
    0,
    0,
    NULL,
    NULL,
  },
  {
    Menu_Type_ENGLISH_FONT,
    S_english_font_title,
    IDM_FontMenu,
    IDM_FontESubMenu,
    IDM_HIGH_FontE,
    english_font_fn,
    0,
    0,
    NULL,
    NULL,
  },
  {
    Menu_Type_CHAR_STYLE,
    S_char_style_title,
    IDM_CharStyleMenu,
    IDM_CharStyleSubMenu,
    IDM_HIGH_CharStyle,
    char_style_fn,
    0,
    0,
    NULL,
    NULL,
  },
  {
    Menu_Type_PARA_STYLE,
    S_para_style_title,
    IDM_ParaStyleMenu,
    IDM_ParaStyleSubMenu,
    IDM_HIGH_ParaStyle,
    para_style_fn,
    0,
    0,
    NULL,
    NULL,
  },
  {
    Menu_Type_MARK,
    S_mark_title,
    IDM_MarkMenu,
    IDM_MarkSubMenu,
    IDM_HIGH_Mark,
    mark_fn,
    0,
    0,
    NULL,
    NULL,
  },
#ifdef BW2_ABBREV
  {
    Menu_Type_ABBREV,
    S_abbrev_title,
    IDM_AbbrevMenu,
    IDM_AbbrevSubMenu,
    IDM_HIGH_Abbrev,
    abbrev_fn,
    0,
    0,
    NULL,
    NULL,
  },
#endif /* BW2_ABBREV */
#ifdef BW3_RECENTOPEN
  {
    Menu_Type_RECENTOPEN,
    S_recentopen_title,
    IDM_RecentOpenMenu,
    IDM_RecentOpenSubMenu,
    IDM_HIGH_RecentOpen,
    recent_open_fn,
    0,
    0,
    NULL,
    NULL,
  },
#endif /* BW3_RECENTOPEN */
};

// TrueɂȂ
static int initedp = False;

// ------------------------------------------------------------
// MenuDialog class

class MenuDialog
  : public PModalDialog
{
public:
  int busy;
  Dynamic_Menu* dm;
  char* title;
  int listbox_index;
  
  // constructor, destructor
public:
  NEAR MenuDialog(Dynamic_Menu* dm);

  // virtual methods
public:
  LRESULT_T WndProc(MSG_T msg, WPARAM_T wParam, LPARAM_T lParam);

  // methods
private:
  void NEAR check_values();
  void NEAR set_item(char* name, int attrib_index);
public:
  int NEAR Go();
  void SetClassName(char* c);
};

#undef SUPER_CLASS
#define SUPER_CLASS PModalDialog

void NEAR
MenuDialog::check_values()
{
  int i = (int) SendItemMessage(IDD_MENUBOX, LB_GETCURSEL);
  if (i == LB_ERR)
  {
    i = -1;
  }
  this->listbox_index = i;
  EnableWindow(GetItem(IDOK), 0 <= i);
}

void NEAR
MenuDialog::set_item(char* name, int attrib_index)
{
  SendItemMessage(IDD_MENUBOX, LB_INSERTSTRING, -1, Ptr2Long(name));
  // check menu status
  if (((*this->dm->fn) (True, attrib_index) & MF_CHECKED) != 0)
  {
    SendItemMessage(IDD_MENUBOX,
		     LB_SETCURSEL,
		     (int) SendItemMessage(IDD_MENUBOX, LB_GETCOUNT) - 1);
  }
}

LRESULT_T
MenuDialog::WndProc(MSG_T msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (msg)
  {
   case WM_INITDIALOG:
    this->busy = True;
    // Tell the listbox NOT to update its display & empty it.
    SendItemMessage(IDD_MENUBOX, WM_SETREDRAW);
    SendItemMessage(IDD_MENUBOX, LB_RESETCONTENT);
    {
      for (Static_Menu_Item* item = dm->static_items;
	   item != NULL; item = item->chain)
      {
	this->set_item(item->name, item->attrib_index);
      }
      
    }
    {
      int idm = (dm->idm_high << 8);
      for (Menu_Item* item = dm->items; item != NULL; item = item->chain)
      {
	this->set_item(item->name, item->attrib_index);
	++idm;
      }
    }
    // Tell the listbox that it is now OK to update its display.
    SendItemMessage(IDD_MENUBOX, WM_SETREDRAW, TRUE);
    // Force the listbox to be completely redrawn.
    ::InvalidateRect(GetItem(IDD_MENUBOX), NULL, TRUE);
    SetText(this->title);
    this->check_values();
    this->busy = False;
    return(1);
    
   case WM_COMMAND:
    if (!this->busy)
    {
#ifdef _WIN32
      switch (LOWORD(wParam))
#else /* _WIN32 */
      switch (wParam)
#endif /* _WIN32 */
      {
       case IDD_MENUBOX:
	this->check_values();
#ifdef _WIN32
	if (HIWORD(wParam) != LBN_DBLCLK)
#else /* _WIN32 */
	if (HIWORD(lParam) != LBN_DBLCLK)
#endif /* _WIN32 */
	{
	  break;
	}
	wParam = IDOK;
	break;
      }
    }
    break;
  }
  return(SUPER_CLASS::WndProc(msg, wParam, lParam));
}

// public method
int NEAR
MenuDialog::Go()
{
  if (SUPER_CLASS::Go())
  {
    int i = this->listbox_index;
    {
      for (Static_Menu_Item* item = dm->static_items;
	   item != NULL; item = item->chain)
      {
	if (i == 0)
	{
	  return(item->attrib_index);
	}
	--i;
      }
      
    }
    {
      for (Menu_Item* item = dm->items; item != NULL; item = item->chain)
      {
	if (i == 0)
	{
	  return(item->attrib_index);
	}
	--i;
      }
    }
  }
  return(-1);
}

// public constructor
NEAR
MenuDialog::MenuDialog(Dynamic_Menu* dm)
{
  this->class_name = "Menu";
  this->dm = dm;
  this->title = dm->dialog_title;
  this->listbox_index = -1;
}

void
MenuDialog::SetClassName(char* c)
{
  this->class_name = c;
}


static HMENU NEAR
sub_menu(HMENU menu, int pos)
{
  return(::GetSubMenu(menu, pos));
}

static int NEAR
get_menu_item_count(HMENU menu)
{
  return(::GetMenuItemCount(menu));
}

// public interface
HMENU
Menu::get_menubar()
{
  HMENU menubar = 0;
  if (main_window_handle != 0)
  {
    menubar = ::GetMenu(main_window_handle);
  }
  return(menubar);
}

// public interface
HMENU
Menu::get_menu(int menu_pos)
{
  HMENU menu = Menu::get_menubar();
  if (menu != 0)
  {
    menu = sub_menu(menu,
		     ((main_window->CurrentActiveDocumentWindowMaximized()
		       ? 1 : 0)
		      + menu_pos));
  }
  return(menu);
}

// public interface
HMENU
Menu::get_sub_menu(int menu_pos, int sub_menu_pos)
{
  HMENU menu = Menu::get_menu(menu_pos);
  if (menu != 0)
  {
    menu = sub_menu(menu, sub_menu_pos);
  }
  return(menu);
}

// `menu_type'ɑΉDynamic_Menu\̂ԂBs͂ȂB
static Dynamic_Menu* NEAR
get_dynamic_menu(Menu_Type menu_type)
{
  Dynamic_Menu* dm = dynamic_menus;
  for (; dm->menu_type != menu_type; ++dm)
  {
    assert(dm - dynamic_menus < Menu_Type_UNUSED_MAX);
  }
  return(dm);
}

static void NEAR
load_dynamic_menu(Menu_Type menu_type)
{
  Dynamic_Menu* dm = get_dynamic_menu(menu_type);
  HMENU menu = Menu::get_sub_menu(dm->menu_pos, dm->sub_menu_pos);
  if (menu != 0)
  {
    int count = get_menu_item_count(menu);
    if (!initedp)
    {
      dm->initial_sub_menu_count = count;
    }
    while (dm->initial_sub_menu_count < count)
    {
      --count;
      ::DeleteMenu(menu, count, MF_BYPOSITION);
    }
    count = dm->dynamic_menu_count;
    if (0 < count)
    {
      int column = 0;
      int line = dm->initial_sub_menu_count;
      int idm = (dm->idm_high << 8);
      Menu_Item* item = dm->items;
      int max_columns = MAX(Pref_menu_columns, 1);
      int max_lines = MAX(line + 5, Pref_menu_lines);
      
      ::AppendMenu(menu, MF_SEPARATOR, -1, 0);
      ++line;
      
      char* format0 = "&%d %s";
      char* format1 = "%d&%d %s";
      char* format2 = "%d&%d %s";
      if (10 <= count)
      {
	format0 = " &%d %s";
	if (100 <= count)
	{
	  format0 = "  &%d %s";
	  format1 = " %d&%d %s";
	}
      }
      count = 1;
      for (; item != NULL && count <= 250;
	   item = item->chain, ++idm, ++count)
      {
	char buffer[100];
	if (count < 10)
	{
	  wsprintf(buffer, format0, count, item->name);
	}
	else
	{
	  wsprintf(buffer,
		    count < 100 ? format1 : format2, count / 10,
		    count % 10, item->name);
	}
	::AppendMenu(menu,
		      (line == 0 ? (MF_DISABLED | MF_GRAYED | MF_MENUBARBREAK)
		       : (MF_DISABLED | MF_GRAYED)),
		      idm, buffer);
	if (++line == max_lines)
	{
	  line = 0;
	  if (++column == max_columns)
	  {
	    break;
	  }
	}
      }
    }
  }
}

static void NEAR
load_dynamic_menus()
{
  for (int menu_type = 0; menu_type != Menu_Type_UNUSED_MAX; ++menu_type)
  {
    load_dynamic_menu((Menu_Type) menu_type);
  }
}

// public interface
void
Menu::load()
{
  if (initedp)
  {
    load_dynamic_menus();
  }
}

void NEAR
delete_menu_no_load(Menu_Type menu_type, int attrib_index)
{
  Dynamic_Menu* dm = get_dynamic_menu(menu_type);
  Menu_Item** place = &dm->items;
  Menu_Item* item;
  for (;;)
  {
    item = *place;
    if (item == NULL)
    {
      break;
    }
    if (item->attrib_index == attrib_index)
    {
      *place = item->chain;
      xfree(item->name);
      xfree(item);
      --dm->dynamic_menu_count;
      break;
    }
    place = &item->chain;
  }
}

// public interface
void
Menu::delete_menu(Menu_Type menu_type, int attrib_index)
{
  delete_menu_no_load(menu_type, attrib_index);
  if (initedp)
  {
    load_dynamic_menu(menu_type);
  }
}

// public interface
void
Menu::add_static_menu(Menu_Type menu_type,
		       int attrib_index, char* name, int idm)
{
  delete_menu_no_load(menu_type, attrib_index);
  Dynamic_Menu* dm = get_dynamic_menu(menu_type);
  Static_Menu_Item** place = &dm->static_items;
  Static_Menu_Item* item;
  for (;;)
  {
    item = *place;
    if (item == NULL)
    {
      break;
    }
    place = &item->chain;
  }
  item = (Static_Menu_Item*) xmalloc(sizeof(Static_Menu_Item));
  item->attrib_index = attrib_index;
  item->name = dup_string(name);
  item->idm = idm;
  item->chain = NULL;
  *place = item;
}

// public interface
void
Menu::add_menu(Menu_Type menu_type, int attrib_index, char* name)
{
  delete_menu_no_load(menu_type, attrib_index);
  Dynamic_Menu* dm = get_dynamic_menu(menu_type);
  for (Static_Menu_Item* si = dm->static_items; si != NULL; si = si->chain)
  {
    if (si->attrib_index == attrib_index)
    {
      return;
    }
  }
  Menu_Item** place = &dm->items;
  Menu_Item* item;
  for (;;)
  {
    item = *place;
    if (item == NULL || 0 < strcmp(item->name, name))
    {
      break;
    }
    place = &item->chain;
  }
  item = (Menu_Item*) xmalloc(sizeof(Menu_Item));
  item->attrib_index = attrib_index;
  item->name = dup_string(name);
  item->chain = *place;
  *place = item;
  ++dm->dynamic_menu_count;
  if (initedp)
  {
    load_dynamic_menu(menu_type);
  }
}

// public interface
int
Menu::go_dialog(Menu_Type menu_type, char* title)
{
  Dynamic_Menu* dm = get_dynamic_menu(menu_type);
  MenuDialog dialog(dm);
  if (menu_type == Menu_Type_RECENTOPEN)
  {
    // wide listbox dialog
    dialog.SetClassName("WIDEMENU");
  }
  if (title != NULL)
  {
    dialog.title = title;
  }
  return(dialog.Go());
}

// public interface
int
Menu::item_exists_p(Menu_Type menu_type)
{
  Dynamic_Menu* dm = get_dynamic_menu(menu_type);
  return(dm->static_items != NULL || dm->items != NULL);
}

static long NEAR
menu_dialog(int menu_state_p, Menu_Type menu_type)
{
  if (!Menu::item_exists_p(menu_type))
  {
    return(disabled_command(menu_state_p != 0));
  }
  if (menu_state_p)
  {
    return(MF_ENABLED);
  }
  int attrib_index = Menu::go_dialog(menu_type, NULL);
  if (0 <= attrib_index)
  {
    (*(get_dynamic_menu(menu_type) ->fn)) (False, attrib_index);
  }
  return(0);
}

// public interface
long
Menu::dispatch(int menu_state_p, int command)
{
  if (Selected_Window == NULL)
  {
    return(disabled_command(menu_state_p != 0));
  }
  return dispatch_anytime(menu_state_p, command);
}

long
Menu::dispatch_anytime(int menu_state_p, int command)
{
  Menu_Type menu_type = Menu_Type_UNUSED_MAX;
  switch (COMMAND_HIGH_CODE(command))
  {
   case IDM_HIGH_FontJ:
    menu_type = Menu_Type_JAPANESE_FONT;
    break;
    
   case IDM_HIGH_FontE:
    menu_type = Menu_Type_ENGLISH_FONT;
    break;
    
   case IDM_HIGH_CharStyle:
    menu_type = Menu_Type_CHAR_STYLE;
    break;
    
   case IDM_HIGH_ParaStyle:
    menu_type = Menu_Type_PARA_STYLE;
    break;
    
   case IDM_HIGH_Mark:
    menu_type = Menu_Type_MARK;
    break;
    
#ifdef BW2_ABBREV
   case IDM_HIGH_Abbrev:
    menu_type = Menu_Type_ABBREV;
    break;
#endif /* BW2_ABBREV */

#ifdef BW3_RECENTOPEN
   case IDM_HIGH_RecentOpen:
    menu_type = Menu_Type_RECENTOPEN;
    break;
#endif /* BW3_RECENTOPEN */

   default:
    switch (command)
    {
     case IDM_MoreFontsJ:
      return(menu_dialog(menu_state_p, Menu_Type_JAPANESE_FONT));
      
     case IDM_MoreFontsE:
      return(menu_dialog(menu_state_p, Menu_Type_ENGLISH_FONT));
      
     case IDM_MoreCharStyles:
      return(menu_dialog(menu_state_p, Menu_Type_CHAR_STYLE));
      
     case IDM_MoreParaStyles:
      return(menu_dialog(menu_state_p, Menu_Type_PARA_STYLE));
      
     case IDM_MoreMarks:
      return(menu_dialog(menu_state_p, Menu_Type_MARK));
      
#ifdef BW2_ABBREV
     case IDM_MoreAbbrevs:
      return(menu_dialog(menu_state_p, Menu_Type_ABBREV));
#endif /* BW2_ABBREV */

#ifdef BW3_RECENTOPEN
     case IDM_MoreRecentOpen:
      return(menu_dialog(menu_state_p, Menu_Type_RECENTOPEN));
#endif /* BW3_RECENTOPEN */

     default:
      {
	for (int menu_type = 0; menu_type != Menu_Type_UNUSED_MAX; ++menu_type)
	{
	  Dynamic_Menu* dm = get_dynamic_menu((Menu_Type) menu_type);
	  for (Static_Menu_Item* item = dm->static_items;
	       item != NULL; item = item->chain)
	  {
	    if (item->idm == command)
	    {
	      return((*dm->fn) (menu_state_p, item->attrib_index));
	    }
	  }
	}
      }
    }
  }

  if (menu_type != Menu_Type_UNUSED_MAX)
  {
    Dynamic_Menu* dm = get_dynamic_menu(menu_type);
    int idm = (dm->idm_high << 8);
    for (Menu_Item* item = dm->items; item != NULL; item = item->chain)
    {
      if (idm == command)
      {
	return((*dm->fn) (menu_state_p, item->attrib_index));
      }
      ++idm;
    }
  }
  return(0);
}

// public interface
void
Menu::set_undo_redo(int undop, char* string)
{
  char* item_accel;
  char* item_string;
  int item_id;
  int item_pos;
  if (undop)
  {
    item_pos = IDM_UndoPosition;
    item_id = IDM_Edit_UndoRun;
    item_string = S_undo;
    item_accel = S_undo_accel;
  }
  else
  {
    item_pos = IDM_RedoPosition;
    item_id = IDM_Edit_RedoRun;
    item_string = S_redo;
    item_accel = S_redo_accel;
  }
  
  char buf[64];
  char* loc = buf;
  
  // always put the item on the menu
  loc += wsprintf(buf, "%s", item_string);
  
  // put the name of the action to be done, if appropriate
  if (string[0] != '\0')
  {
    loc += wsprintf(loc, " (%s)", string);
  }
  
  // put the accelerator on, if appropriate
  if (Pref_show_shortcuts)
  {
    loc += wsprintf(loc, "\t%s", item_accel);
  }
  
  HMENU menu = Menu::get_menu(IDM_EditMenu);
  if (menu != 0)
  {
    ::ModifyMenu(menu, item_pos, MF_BYPOSITION | MF_STRING, item_id, buf);
  }
}

// public interface
void
Menu::init()
{
  FontTable::register_static_menus();
  StyleTable::register_static_menus();
#ifdef BW3_RECENTOPEN
  PWordBase::MakeUpRecentOpenMenu();
#endif /* BW3_RECENTOPEN */
  load_dynamic_menus();
  initedp = True;
}

// j[V[gJbg̃KCh菜BTuj[
// ΁BċAIɏB
static void NEAR
strip_shortcuts(HMENU menu)
{
  int count = get_menu_item_count(menu);
  for (int i = 0; i < count; ++i)
  {
    int id  = (int) ::GetMenuItemID(menu, i);
    switch (id)
    {
      // sub menu
     case -1:
      strip_shortcuts(sub_menu(menu, i));
      break;
      
      // separator
     case 0:
      break;
      
      // normal menu
     default:
      {
	char buffer[80];
	::GetMenuString(menu, i, buffer, 80, MF_BYPOSITION);
	char* p = strchr(buffer, '\t');
	if (p != NULL)
	{
	  *p = '\0';
	  ::ModifyMenu(menu, i, MF_BYPOSITION | MF_STRING, id, buffer);
	}
      }
      break;
    }
  }
}

// `Pref_show_shortcuts'̒lɂăj[č\B
// public interface
void
Menu::control_shortcuts()
{
  HMENU menu = ::LoadMenu(PWordPresentation::hInstance, S_menu_name);
  if (!Pref_show_shortcuts)
  {
    strip_shortcuts(menu);
  }
  ::DestroyMenu((HMENU)
#ifdef _WIN32
		 ::SendMessage(MainWindow::GetMDIClient() ->GetHandle(),
			       WM_MDISETMENU,
			       (WPARAM_T)menu,				// hmenuFrame
			       (LPARAM_T)sub_menu(menu, IDM_DispMenu))); // hmenuWindow
#else /* _WIN32 */
		 ::SendMessage(MainWindow::GetMDIClient() ->GetHandle(),
			       WM_MDISETMENU,
			       FALSE,
			       MAKELONG(menu,				// lo: hmenuFrame
					sub_menu(menu, IDM_DispMenu))));// hi: hmenuWindow
#endif /* _WIN32 */
  ::DrawMenuBar(main_window_handle);
  Menu::load();
}
