// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: menu.h,v 3.4 2000/05/04 13:44:07 kudou Exp $
// menu

#ifndef MENU_H
#define MENU_H

enum Menu_Type
{
  Menu_Type_JAPANESE_FONT,
  Menu_Type_ENGLISH_FONT,
  Menu_Type_CHAR_STYLE,
  Menu_Type_PARA_STYLE,
  Menu_Type_MARK,
#ifdef BW2_ABBREV
  Menu_Type_ABBREV,
#endif /* BW2_ABBREV */
#ifdef BW3_RECENTOPEN
  Menu_Type_RECENTOPEN,
#endif /* BW3_RECENTOPEN */
  Menu_Type_UNUSED_MAX,
};

// NX Menu ̓CX^XȂÃW[ł
class Menu
{
public:
  static HMENU get_menu(int menu_pos);
  static HMENU get_menubar();
  static HMENU get_sub_menu(int menu_pos, int sub_menu_pos);
  static int item_exists_p(Menu_Type menu_type);
  static int go_dialog(Menu_Type menu_type, char* title);
  static long dispatch(int menu_state_p, int command);
  static long dispatch_anytime(int menu_state_p, int command);
  static void add_menu(Menu_Type menu_type, int attrib_index, char* name);
  static void add_static_menu(Menu_Type menu_type, int attrib_index, char* name, int idm);
  static void control_shortcuts();
  static void delete_menu(Menu_Type menu_type, int attrib_index);
  static void init();
  static void load();
  static void set_undo_redo(int undop, char* string);
};

#endif /* MENU_H */
