// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: metafile.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class Metafile
// Metafile management classs, This class has windows metafile data.

#ifndef METAFILE_H
#define METAFILE_H

#undef BUILD_IN_METAFILE

#include "rect.h"

class Metafile 
{
  // metafile data
  HMETAFILE hmf;
  
  // clipboard format
  METAFILEPICT* mp;
  
public:
  enum DisplayMode 
  {
    DirectPlayMetafile = 0,	// direct play metafile
    WidthDIB           = 1,	// print with device size DIB
    Rough              = 2,	// print with default view size DIB
    WidthBitMap        = 3,	// display width bitmap
    MaxDisplayMode     = WidthBitMap,
  };
  
  // built in metafile
  enum BuiltInMetafile
  {
    // lines
    LeftSlantLine	= 0x01,
    LeftSlantDotted	= 0x02,
    RightSlantLine	= 0x03,
    RightSlantDotted	= 0x04,
    CrossLine		= 0x05,
    CrossDotted		= 0x06,
    RingLine		= 0x07,
    RingDotted		= 0x08,
    StrikeOut		= 0x09,
    StrikeOutDotted	= 0x0a,
    Circle		= 0x0b,
    FillCircle		= 0x0c,
    GrayCircle		= 0x0d,
    
    // mathematical metafiles
    Root		= 0x101,
    Integral		= 0x102,
    IntegralC		= 0x103,
    Sigma		= 0x104,
  };
  
  // built in metafile size
  enum
  {
    BuiltInMetafileX = 10000,
    BuiltInMetafileY = 10000,
  };
  
private:
  // get display mode
  DisplayMode GetDisplayMode(VDisplay* vdsp);
  
  // set mapping mode
  void SetMappingMode(HDC hDC, int width, int height);
  
#ifdef BUILD_IN_METAFILE
  // get built in metafile
  static HDC GetBuiltInMetafile(BuiltInMetafile bim);
#endif
public:
  // constructor
  Metafile(METAFILEPICT* mp);
  
  // constructor for duplicate
  Metafile(Metafile* mf);
  
#ifdef BUILD_IN_METAFILE
  // constructor for to get the built in metafile
  Metafile(BuiltInMetafile bim);
#endif
  
  // destructor
  ~Metafile();
  
  // display
  // rec		: Iunit position
  void Redisplay(VDisplay* vdsp, Rect& rec);
  
  // copy to clipboard
  void CopyToClipboard();
  
  // get METAFILEOICT
  METAFILEPICT* GetMetafilePict() 
  { return mp; }
  
  // check scalable metafile
  bool IsScalable();
  
  // valid check
  bool IsValid() 
  { return mp->hMF != 0; }
  
  // copy clipboard
  static METAFILEPICT* CopyClipBoard(HWND hWnd);
  
  // copy clipboard data
  static METAFILEPICT* CopyClipBoardData(HANDLE hmeta);
  
  // get width and height
  static void GetWidthAndHeight(METAFILEPICT* mp, 
                                 Iunit& width, Iunit& height);
private:
  // make sample metafile
  static METAFILEPICT* MakeSampleMetafile(char* name = 0);
  
  // make draw bitmap
  HBITMAP MakeDrawBitMap(HDC hDC, int width, int height);
};

#endif /* METAFILE_H */
